/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.apocalypse.common.entity;

import com.flansmod.common.guns.AttachmentType;
import com.flansmod.common.guns.GunType;
import com.flansmod.common.guns.ItemGun;
import com.flansmod.common.guns.ItemShootable;
import com.flansmod.common.guns.ShootableType;
import com.flansmod.common.network.PacketPlaySound;
import com.flansmod.common.vector.Vector3f;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackRangedBow;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntityFlansModShooter
extends EntityMob
implements IRangedAttackMob {
    private EntityAIAttackRangedBow aiArrowAttack = new EntityAIAttackRangedBow((EntityMob)this, 1.0, 20, 70.0f);
    public ItemStack[] ammoStacks = new ItemStack[0];
    public float shootDelay = 0.0f;
    public float minigunSpeed = 0.0f;
    public int loopedSoundDelay = 0;
    public boolean reloading = false;
    public boolean shouldPlayWarmupSound = true;
    private int soundDelay = 0;

    public EntityFlansModShooter(World world) {
        super(world);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityIronGolem.class, true));
        if (world != null && !world.field_72995_K) {
            this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.aiArrowAttack);
        }
        EntityFlansModShooter.func_184227_b((double)200.0);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.shootDelay > 0.0f) {
            this.shootDelay -= 1.0f;
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(80.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData data) {
        data = super.func_180482_a(difficulty, data);
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.aiArrowAttack);
        this.func_180481_a(difficulty);
        this.func_180483_b(difficulty);
        this.func_98053_h(this.field_70146_Z.nextFloat() < 0.55f * difficulty.func_180170_c());
        return data;
    }

    public void func_82196_d(EntityLivingBase entity, float range) {
        ItemStack stack = this.func_184614_ca();
        if (stack != null && stack.func_77973_b() instanceof ItemGun) {
            ItemGun item = (ItemGun)stack.func_77973_b();
            GunType type = item.GetType();
            boolean shouldShoot = false;
            switch (type.mode) {
                case MINIGUN: {
                    shouldShoot = this.minigunSpeed >= type.minigunStartSpeed && this.shootDelay <= 0.0f;
                    break;
                }
                case BURST: 
                case FULLAUTO: 
                case SEMIAUTO: {
                    boolean bl = shouldShoot = this.shootDelay <= 0.0f;
                }
            }
            if (type.useLoopingSounds && this.loopedSoundDelay <= 0 && this.minigunSpeed > 0.1f && !this.reloading) {
                this.loopedSoundDelay = this.shouldPlayWarmupSound ? type.warmupSoundLength : type.loopedSoundLength;
                PacketPlaySound.sendSoundPacket(this.field_70165_t, this.field_70163_u, this.field_70161_v, 50.0, this.field_71093_bK, this.shouldPlayWarmupSound ? type.warmupSound : type.loopedSound, false);
                this.shouldPlayWarmupSound = false;
            }
            if (shouldShoot) {
                int bulletID;
                int damage = 0;
                ItemStack bulletStack = ItemStack.field_190927_a.func_77946_l();
                for (bulletID = 0; bulletID < type.numAmmoItemsInGun; ++bulletID) {
                    ItemStack checkingStack = item.getBulletItemStack(stack, bulletID);
                    if (checkingStack == null || checkingStack.func_190926_b() || checkingStack.func_77952_i() >= checkingStack.func_77958_k()) continue;
                    bulletStack = checkingStack;
                    break;
                }
                if (bulletStack == null || bulletStack.func_190926_b()) {
                    if (this.reload(stack, type, this.field_70170_p, (Entity)this, false, false)) {
                        this.shootDelay = (int)type.getReloadTime(stack);
                        this.reloading = true;
                        if (type.reloadSound != null) {
                            PacketPlaySound.sendSoundPacket(this.field_70165_t, this.field_70163_u, this.field_70161_v, 50.0, this.field_71093_bK, type.reloadSound, true);
                        }
                    }
                } else if (bulletStack.func_77973_b() instanceof ItemShootable) {
                    this.shoot(stack, type, this.field_70170_p, bulletStack, (Entity)this, false, entity);
                    damage = bulletStack.func_77952_i() + 1;
                    bulletStack.func_77964_b(damage);
                    item.setBulletItemStack(stack, bulletStack, bulletID);
                }
                switch (type.mode) {
                    case MINIGUN: 
                    case FULLAUTO: {
                        this.shootDelay = type.GetShootDelay(stack);
                        break;
                    }
                    case SEMIAUTO: {
                        this.shootDelay = 2.0f * type.shootDelay;
                        break;
                    }
                    case BURST: {
                        this.shootDelay = damage % 3 == 0 ? 3.0f * this.shootDelay : this.shootDelay;
                    }
                }
            }
        }
    }

    public boolean reload(ItemStack gunStack, GunType gunType, World world, Entity entity, boolean creative, boolean forceReload) {
        ItemGun item = (ItemGun)gunType.item;
        if (gunType.deployable) {
            return false;
        }
        if (forceReload && !gunType.canForceReload) {
            return false;
        }
        boolean reloadedSomething = false;
        for (int i = 0; i < gunType.numAmmoItemsInGun; ++i) {
            ItemStack bulletStack = item.getBulletItemStack(gunStack, i);
            if (bulletStack != null && !bulletStack.func_190926_b() && bulletStack.func_77952_i() != bulletStack.func_77958_k() && !forceReload) continue;
            int bestSlot = -1;
            int bulletsInBestSlot = 0;
            for (int j = 0; j < this.ammoStacks.length; ++j) {
                int bulletsInThisSlot;
                ItemStack searchingStack = this.ammoStacks[j];
                if (searchingStack == null || !(searchingStack.func_77973_b() instanceof ItemShootable) || !gunType.isAmmo(((ItemShootable)searchingStack.func_77973_b()).type) || (bulletsInThisSlot = searchingStack.func_77958_k() - searchingStack.func_77952_i()) <= bulletsInBestSlot) continue;
                bestSlot = j;
                bulletsInBestSlot = bulletsInThisSlot;
            }
            if (bestSlot == -1) continue;
            ItemStack newBulletStack = this.ammoStacks[bestSlot];
            ShootableType newBulletType = ((ItemShootable)newBulletStack.func_77973_b()).type;
            if (bulletStack != null && bulletStack.func_77973_b() instanceof ItemShootable && ((ItemShootable)bulletStack.func_77973_b()).type.dropItemOnReload != null && !creative) {
                ItemGun.dropItem(world, (Entity)this, ((ItemShootable)bulletStack.func_77973_b()).type.dropItemOnReload);
            }
            ItemStack stackToLoad = newBulletStack.func_77946_l();
            stackToLoad.func_190920_e(1);
            item.setBulletItemStack(gunStack, stackToLoad, i);
            if (!creative) {
                newBulletStack.func_190920_e(newBulletStack.func_190916_E() - 1);
            }
            if (newBulletStack.func_190916_E() <= 0) {
                newBulletStack = null;
            }
            this.ammoStacks[bestSlot] = newBulletStack;
            reloadedSomething = true;
        }
        return reloadedSomething;
    }

    private void shoot(ItemStack stack, GunType gunType, World world, ItemStack bulletStack, Entity entity, boolean left, EntityLivingBase target) {
        ItemGun item = (ItemGun)gunType.item;
        ShootableType bullet = ((ItemShootable)bulletStack.func_77973_b()).type;
        if (this.soundDelay <= 0 && gunType.shootSound != null) {
            AttachmentType barrel = gunType.getBarrel(stack);
            boolean silenced = barrel != null && barrel.silencer;
            PacketPlaySound.sendSoundPacket(this.field_70165_t, this.field_70163_u, this.field_70161_v, 50.0, this.field_71093_bK, gunType.shootSound, gunType.distortSound, silenced);
            this.soundDelay = gunType.shootSoundLength;
        }
        if (!world.field_72995_K) {
            float inaccuracy = 0.5f;
            for (int k = 0; k < gunType.numBullets * bullet.numBullets; ++k) {
                Vector3f origin = new Vector3f(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v);
                Vector3f direction = new Vector3f(target.field_70165_t - this.field_70165_t, target.field_70163_u + (double)target.func_70047_e() - (this.field_70163_u + (double)this.func_70047_e()), target.field_70161_v - this.field_70161_v).normalise(null);
                Vector3f.add(direction, new Vector3f(this.field_70146_Z.nextFloat() * direction.x * inaccuracy, this.field_70146_Z.nextFloat() * direction.y * inaccuracy, this.field_70146_Z.nextFloat() * direction.z * inaccuracy), direction);
                ItemShootable shootableItem = (ItemShootable)bulletStack.func_77973_b();
                shootableItem.Shoot(world, origin, direction, gunType.getDamage(stack), gunType.getSpread(stack), gunType.getBulletSpeed(stack), gunType, (EntityLivingBase)this);
            }
            if (bullet.dropItemOnShoot != null) {
                ItemGun.dropItem(world, (Entity)this, bullet.dropItemOnShoot);
            }
            if (gunType.dropItemOnShoot != null) {
                ItemGun.dropItem(world, (Entity)this, gunType.dropItemOnShoot);
            }
        }
        this.shootDelay = gunType.GetShootDelay(stack);
    }

    protected boolean func_70692_ba() {
        return false;
    }

    protected boolean func_70814_o() {
        return true;
    }

    public boolean func_70601_bi() {
        return this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL;
    }

    public void func_184724_a(boolean swingingArms) {
    }
}

