/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.apocalypse.common.entity;

import com.flansmod.common.driveables.DriveableData;
import com.flansmod.common.driveables.EnumDriveablePart;
import com.flansmod.common.driveables.mechas.EntityMecha;
import com.flansmod.common.driveables.mechas.MechaType;
import com.flansmod.common.vector.Vector3f;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityAIMecha
extends EntityMecha {
    private Entity target;
    private float targetingRange = 20.0f;
    private int targetAcquireInterval = 40;
    private boolean usingLeft = false;

    public EntityAIMecha(World world) {
        super(world);
    }

    public EntityAIMecha(World world, double x, double y, double z, MechaType type, DriveableData data, NBTTagCompound tags) {
        super(world, x, y, z, type, data, tags);
    }

    @Override
    public void func_70071_h_() {
        this.throttle = 1.0f;
        super.func_70071_h_();
    }

    @Override
    public boolean func_184230_a(EntityPlayer entityplayer, EnumHand hand) {
        return false;
    }

    @Override
    protected void moveAI(Vector3f actualMotion) {
        MechaType type = this.getMechaType();
        DriveableData data = this.getDriveableData();
        if (this.target == null && (this.field_70173_aa + this.func_145782_y()) % this.targetAcquireInterval == 0) {
            double distToCurrentTarget = 999.0;
            for (Object obj : this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a((double)this.targetingRange, (double)this.targetingRange, (double)this.targetingRange))) {
                double distToPotentialTarget;
                if (!this.isBetterTarget(this.target, distToCurrentTarget, (Entity)obj, distToPotentialTarget = this.func_70068_e((Entity)obj))) continue;
                this.target = (Entity)obj;
                distToCurrentTarget = distToPotentialTarget;
            }
        }
        if (!this.field_70170_p.field_72995_K && this.target != null) {
            double blockHitZ;
            Vec3d rightArmOrigin = this.usingLeft ? this.axes.findLocalVectorGlobally(this.getMechaType().leftArmOrigin).toVec3().func_72441_c(this.field_70165_t, this.field_70163_u, this.field_70161_v) : this.axes.findLocalVectorGlobally(this.getMechaType().rightArmOrigin).toVec3().func_72441_c(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            Vec3d targetOrigin = new Vec3d(this.target.field_70165_t, this.target.field_70163_u + (double)this.target.func_70047_e() / 2.0, this.target.field_70161_v);
            double dX = targetOrigin.field_72450_a - rightArmOrigin.field_72450_a;
            double dY = targetOrigin.field_72448_b - rightArmOrigin.field_72448_b;
            double dZ = targetOrigin.field_72449_c - rightArmOrigin.field_72449_c;
            this.axes.setAngles((float)Math.atan2(dZ, dX) * 180.0f / 3.14159f, 0.0f, 0.0f);
            if (this.getSeat(0) != null) {
                this.getSeat((int)0).looking.setAngles(0.0f, -((float)Math.atan2(dY, Math.sqrt(dX * dX + dZ * dZ))) * 180.0f / 3.14159f, 0.0f);
                this.getSeat((int)0).prevLooking.setAngles(0.0f, -((float)Math.atan2(dY, Math.sqrt(dX * dX + dZ * dZ))) * 180.0f / 3.14159f, 0.0f);
            }
            RayTraceResult hit = this.field_70170_p.func_72901_a(rightArmOrigin, targetOrigin, false);
            if (this.field_70170_p.field_72995_K) {
                // empty if block
            }
            double blockHitX = hit == null ? 0.0 : hit.field_72307_f.field_72450_a - rightArmOrigin.field_72450_a;
            double blockHitY = hit == null ? 0.0 : hit.field_72307_f.field_72448_b - rightArmOrigin.field_72448_b;
            double d = blockHitZ = hit == null ? 0.0 : hit.field_72307_f.field_72449_c - rightArmOrigin.field_72449_c;
            if (hit == null || hit.field_72313_a != RayTraceResult.Type.BLOCK || dX * dX + dY * dY + dZ * dZ < blockHitX * blockHitX + blockHitY * blockHitY + blockHitZ * blockHitZ) {
                this.useItem(this.usingLeft);
                if (this.field_70146_Z.nextInt(5) == 0) {
                    this.usingLeft = !this.usingLeft;
                }
            } else {
                this.moveX = (float)(this.target.field_70165_t - this.field_70165_t);
                this.moveZ = (float)(this.target.field_70161_v - this.field_70161_v);
                float mag = (float)Math.sqrt(this.moveX * this.moveX + this.moveZ * this.moveZ);
                Vector3f intent = new Vector3f(this.moveX, 0.0f, this.moveZ);
                if ((double)Math.abs(intent.lengthSquared()) > 0.1) {
                    intent.normalise();
                    this.legSwing += 1.0f;
                    Vector3f intentOnLegAxes = this.legAxes.findGlobalVectorLocally(intent);
                    float intentAngle = (float)Math.atan2(intent.z, intent.x) * 180.0f / (float)Math.PI;
                    float angleBetween = intentAngle - this.legAxes.getYaw();
                    if (angleBetween > 180.0f) {
                        angleBetween -= 360.0f;
                    }
                    if (angleBetween < -180.0f) {
                        angleBetween += 360.0f;
                    }
                    float signBetween = Math.signum(angleBetween);
                    if ((double)(angleBetween = Math.abs(angleBetween)) > 0.1) {
                        this.legAxes.rotateGlobalYaw(Math.min(angleBetween, type.rotateSpeed) * signBetween);
                    }
                    intent.scale(type.moveSpeed * data.engine.engineSpeed * this.speedMultiplier() * 0.215f);
                    if (this.isPartIntact(EnumDriveablePart.hips)) {
                        Vector3f.add(actualMotion, intent, actualMotion);
                    }
                }
            }
        }
    }

    @Override
    protected boolean creative() {
        return false;
    }

    private boolean isBetterTarget(Entity currentTarget, double distToCurrentTarget, Entity potentialTarget, double distToPotentialTarget) {
        return potentialTarget instanceof EntityPlayer && distToPotentialTarget < distToCurrentTarget && distToPotentialTarget < (double)(this.targetingRange * this.targetingRange);
    }

    @Override
    public boolean hasFuel() {
        return true;
    }

    @Override
    public boolean hasEnoughFuel() {
        return true;
    }

    @Override
    public boolean func_70097_a(DamageSource damagesource, float i) {
        if (this.field_70170_p.field_72995_K || this.field_70128_L) {
            return true;
        }
        MechaType type = this.getMechaType();
        if (damagesource.field_76373_n.equals("player") && damagesource.func_76346_g().field_70122_E && (this.getSeat(0) == null || this.getSeat(0).func_184179_bs() == null)) {
            return false;
        }
        return super.func_70097_a(damagesource, i);
    }
}

