/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.apocalypse.common;

import com.flansmod.apocalypse.common.CommonProxyApocalypse;
import com.flansmod.apocalypse.common.FlansModLootGenerator;
import com.flansmod.apocalypse.common.blocks.BlockPowerCube;
import com.flansmod.apocalypse.common.blocks.BlockStatic;
import com.flansmod.apocalypse.common.blocks.BlockSulphur;
import com.flansmod.apocalypse.common.blocks.BlockSulphuricAcid;
import com.flansmod.apocalypse.common.blocks.TileEntityPowerCube;
import com.flansmod.apocalypse.common.world.BiomeApocalypse;
import com.flansmod.apocalypse.common.world.WorldProviderApocalypse;
import com.flansmod.common.BlockItemHolder;
import com.flansmod.common.CreativeTabFlan;
import com.flansmod.common.FlansMod;
import com.flansmod.common.ItemHolderType;
import com.flansmod.common.parts.PartType;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.DimensionType;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(modid="flansmodapocalypse", name="Flan's Mod: Apocalypse", version="1.0", acceptableRemoteVersions="[1.0, 1.1)", dependencies="required-after:flansmod", acceptedMinecraftVersions="[1.12.2]")
public class FlansModApocalypse {
    public static boolean DEBUG = false;
    public static final String MODID = "flansmodapocalypse";
    public static final String VERSION = "1.0";
    @Mod.Instance(value="flansmodapocalypse")
    public static FlansModApocalypse INSTANCE;
    @SidedProxy(clientSide="com.flansmod.apocalypse.client.ClientProxyApocalypse", serverSide="com.flansmod.apocalypse.common.CommonProxyApocalypse")
    public static CommonProxyApocalypse proxy;
    public static Configuration configFile;
    public static int apocalypseCountdownLength;
    public static int SURVIVOR_RARITY;
    public static int WANDERING_SURVIVOR_RARITY;
    public static int SKELETON_RARITY;
    public static int DEAD_TREE_RARITY;
    public static int VEHICLE_RARITY;
    public static int AIRPORT_RARITY;
    public static int DYE_FACTORY_RARITY;
    public static int LAB_RARITY;
    public static int RETURN_RADIUS;
    public static int SPAWN_RADIUS;
    public static TeleportOption OPTION;
    public static int dimensionID;
    public static DimensionType APOCALYPSE_DIM;
    public static FlansModLootGenerator lootGenerator;
    public static Item sulphur;
    public static Block blockSulphur;
    public static Fluid sulphuricAcid;
    public static Block blockSulphuricAcid;
    public static ResourceLocation sulphuricAcidStill;
    public static ResourceLocation sulphuricAcidFlowing;
    public static Block blockLabStone;
    public static Block blockPowerCube;
    public static Item itemBlockPowerCube;
    public static Item itemBlockLabStone;
    public static Item itemBlockSulphur;
    public static CreativeTabFlan tabApocalypse;
    public static BlockItemHolder skeleton;
    public static BlockItemHolder slumpedSkeleton;
    public static BlockItemHolder gunRack;

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        event.getRegistry().register((IForgeRegistryEntry)sulphur);
        event.getRegistry().register((IForgeRegistryEntry)itemBlockLabStone);
        event.getRegistry().register((IForgeRegistryEntry)itemBlockSulphur);
        event.getRegistry().register((IForgeRegistryEntry)itemBlockPowerCube);
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        event.getRegistry().register((IForgeRegistryEntry)blockSulphur);
        event.getRegistry().register((IForgeRegistryEntry)blockSulphuricAcid);
        event.getRegistry().register((IForgeRegistryEntry)blockLabStone);
        event.getRegistry().register((IForgeRegistryEntry)blockPowerCube);
    }

    @SubscribeEvent
    public void registerBiomes(RegistryEvent.Register<Biome> event) {
        BiomeApocalypse.registerBiomes();
        event.getRegistry().register((IForgeRegistryEntry)BiomeApocalypse.deepCanyon);
        event.getRegistry().register((IForgeRegistryEntry)BiomeApocalypse.canyon);
        event.getRegistry().register((IForgeRegistryEntry)BiomeApocalypse.desert);
        event.getRegistry().register((IForgeRegistryEntry)BiomeApocalypse.plateau);
        event.getRegistry().register((IForgeRegistryEntry)BiomeApocalypse.highPlateau);
        event.getRegistry().register((IForgeRegistryEntry)BiomeApocalypse.sulphurPits);
    }

    @SubscribeEvent
    public void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        NonNullList ingredients = NonNullList.func_191196_a();
        ingredients.add((Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((Block)Blocks.field_150354_m)}));
        ingredients.add((Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(sulphur)}));
        event.getRegistry().register(new ShapelessRecipes("FlansModApocalypse", new ItemStack(Items.field_151016_H), ingredients).setRegistryName("GunpowderFromSulphur"));
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
        configFile = new Configuration(event.getSuggestedConfigurationFile());
        FlansModApocalypse.syncConfig();
        blockSulphur = ((Block)new BlockSulphur().func_149663_c("blockSulphur").setRegistryName("blockSulphur")).func_149647_a((CreativeTabs)tabApocalypse);
        sulphur = ((Item)new Item().func_77655_b("flanSulphur").setRegistryName("flanSulphur")).func_77637_a((CreativeTabs)tabApocalypse);
        itemBlockSulphur = ((Item)new ItemBlock(blockSulphur).func_77655_b("blockSulphur").setRegistryName("itemBlockSulphur")).func_77637_a((CreativeTabs)tabApocalypse);
        sulphuricAcid = new Fluid("sulphuricAcid", sulphuricAcidStill, sulphuricAcidFlowing).setTemperature(300).setViscosity(800);
        if (FluidRegistry.registerFluid((Fluid)sulphuricAcid)) {
            blockSulphuricAcid = ((Block)new BlockSulphuricAcid(sulphuricAcid, Material.field_151586_h).func_149663_c("blockSulphuricAcid").setRegistryName("blockSulphuricAcid")).func_149647_a((CreativeTabs)tabApocalypse);
            sulphuricAcid.setBlock(blockSulphuricAcid);
            sulphuricAcid.setUnlocalizedName(blockSulphuricAcid.func_149739_a());
            FluidRegistry.addBucketForFluid((Fluid)sulphuricAcid);
        } else {
            sulphuricAcid = FluidRegistry.getFluid((String)"sulphuricAcid");
            blockSulphuricAcid = sulphuricAcid.getBlock();
        }
        blockLabStone = ((Block)new BlockStatic(Material.field_151576_e).func_149711_c(3.0f).func_149752_b(5.0f).func_149663_c("labStone").setRegistryName("labStone")).func_149647_a((CreativeTabs)tabApocalypse);
        itemBlockLabStone = ((Item)new ItemBlock(blockLabStone).func_77655_b("labStone").setRegistryName("itemBlockLabStone")).func_77637_a((CreativeTabs)tabApocalypse);
        blockPowerCube = ((Block)new BlockPowerCube(Material.field_151594_q).func_149663_c("powerCube").setRegistryName("powerCube")).func_149711_c(3.0f).func_149752_b(5.0f).func_149647_a((CreativeTabs)tabApocalypse);
        itemBlockPowerCube = ((Item)new ItemBlock(blockPowerCube).func_77655_b("powerCube").setRegistryName("itemBlockPowerCube")).func_77637_a((CreativeTabs)tabApocalypse);
        GameRegistry.registerTileEntity(TileEntityPowerCube.class, (String)"powerCube");
        proxy.preInit(event);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init(event);
        dimensionID = DimensionManager.getNextFreeDimId();
        APOCALYPSE_DIM = DimensionType.register((String)"Apocalypse", (String)"_apocalypse", (int)dimensionID, WorldProviderApocalypse.class, (boolean)false);
        DimensionManager.registerDimension((int)dimensionID, (DimensionType)APOCALYPSE_DIM);
        if (ItemHolderType.getItemHolder("flanSkeleton") != null) {
            skeleton = ItemHolderType.getItemHolder((String)"flanSkeleton").block;
            skeleton.func_149647_a(tabApocalypse);
        } else {
            FlansMod.log("Could not find skeleton item holder!");
        }
        if (ItemHolderType.getItemHolder("flanSkeleton2") != null) {
            slumpedSkeleton = ItemHolderType.getItemHolder((String)"flanSkeleton2").block;
            slumpedSkeleton.func_149647_a(tabApocalypse);
        } else {
            FlansMod.log("Could not find skeleton2 item holder!");
        }
        if (ItemHolderType.getItemHolder("flanGunRack") != null) {
            gunRack = ItemHolderType.getItemHolder((String)"flanGunRack").block;
            gunRack.func_149647_a(tabApocalypse);
        } else {
            FlansMod.log("Could not find gun rack item holder!");
        }
        if (PartType.getPart("aiChip") != null) {
            PartType.getPart((String)"aiChip").item.func_77637_a((CreativeTabs)tabApocalypse);
        }
        if (PartType.getPart("complicatedCircuit") != null) {
            PartType.getPart((String)"complicatedCircuit").item.func_77637_a((CreativeTabs)tabApocalypse);
        }
        if (PartType.getPart("nuclearPowerCore") != null) {
            PartType.getPart((String)"nuclearPowerCore").item.func_77637_a((CreativeTabs)tabApocalypse);
        }
        lootGenerator = new FlansModLootGenerator();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit(event);
    }

    public static FlansModLootGenerator getLootGenerator() {
        return lootGenerator;
    }

    public static void syncConfig() {
        apocalypseCountdownLength = configFile.getInt("Apocalypse Countdown Length", "general", apocalypseCountdownLength, 19, Integer.MAX_VALUE, "Time between placing an AI mecha and going to the apocalypse");
        SURVIVOR_RARITY = configFile.getInt("Survivor Rarity", "general", SURVIVOR_RARITY, 1, Integer.MAX_VALUE, "Rarity of survivor entities spawned during world creation");
        WANDERING_SURVIVOR_RARITY = configFile.getInt("Wandering Survivor Rarity", "general", WANDERING_SURVIVOR_RARITY, 1, Integer.MAX_VALUE, "Rarity of survivor entities spawned at night");
        SKELETON_RARITY = configFile.getInt("Skeleton Rarity", "general", SKELETON_RARITY, 1, Integer.MAX_VALUE, "Rarity of buried skeletons");
        DEAD_TREE_RARITY = configFile.getInt("Dead Tree Rarity", "general", DEAD_TREE_RARITY, 1, Integer.MAX_VALUE, "Rarity of dead trees");
        VEHICLE_RARITY = configFile.getInt("Vehicle Rarity", "general", VEHICLE_RARITY, 1, Integer.MAX_VALUE, "Rarity of broken vehicles");
        AIRPORT_RARITY = configFile.getInt("Airport Rarity", "general", AIRPORT_RARITY, 1, Integer.MAX_VALUE, "Rarity of airstrips");
        DYE_FACTORY_RARITY = configFile.getInt("Dye Factory Rarity", "general", DYE_FACTORY_RARITY, 1, Integer.MAX_VALUE, "Rarity of dye factories");
        LAB_RARITY = configFile.getInt("Lab Rarity", "general", LAB_RARITY, 1, Integer.MAX_VALUE, "Rarity of the research lab");
        RETURN_RADIUS = configFile.getInt("Return Radius", "general", RETURN_RADIUS, 1, Integer.MAX_VALUE, "The distance away from your initial AI mecha that your return portal appears");
        SPAWN_RADIUS = configFile.getInt("Spawn Radius", "general", SPAWN_RADIUS, 1, Integer.MAX_VALUE, "The distance from your deathpoint that you respawn in the apocalypse");
        OPTION = TeleportOption.getOption(configFile.getString("Option", "general", OPTION.toString(), "Who gets teleported to the apocalypse with a player (One of PLACER_ONLY, DIM, DIM_OPT_IN, NEARBY, NEARBY_OPT_IN)"));
        if (configFile.hasChanged()) {
            configFile.save();
        }
    }

    static {
        apocalypseCountdownLength = 469;
        SURVIVOR_RARITY = 450;
        WANDERING_SURVIVOR_RARITY = 2500;
        SKELETON_RARITY = 50;
        DEAD_TREE_RARITY = 100;
        VEHICLE_RARITY = 2000;
        AIRPORT_RARITY = 125;
        DYE_FACTORY_RARITY = 800;
        LAB_RARITY = 100;
        RETURN_RADIUS = 100;
        SPAWN_RADIUS = 100;
        OPTION = TeleportOption.PLACER_ONLY;
        APOCALYPSE_DIM = null;
        sulphuricAcidStill = new ResourceLocation(MODID, "blocks/sulphuricAcidStill");
        sulphuricAcidFlowing = new ResourceLocation(MODID, "blocks/sulphuricAcidFlowing");
        tabApocalypse = new CreativeTabFlan(5);
        FluidRegistry.enableUniversalBucket();
    }

    public static enum TeleportOption {
        PLACER_ONLY,
        DIM,
        DIM_OPT_IN,
        NEARBY,
        NEARBY_OPT_IN;


        public static TeleportOption getOption(String s) {
            if (s.equals("PLACER_ONLY")) {
                return PLACER_ONLY;
            }
            if (s.equals("DIM")) {
                return DIM;
            }
            if (s.equals("DIM_OPT_IN")) {
                return DIM_OPT_IN;
            }
            if (s.equals("NEARBY")) {
                return NEARBY;
            }
            if (s.equals("NEARBY_OPT_IN")) {
                return NEARBY_OPT_IN;
            }
            return PLACER_ONLY;
        }
    }
}

