/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.apocalypse.common;

import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ApocalypseData {
    public HashMap<UUID, BlockPos> entryPoints = new HashMap();

    @SubscribeEvent
    public void worldData(WorldEvent event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        if (event instanceof WorldEvent.Load) {
            this.loadPerWorldData(event, event.getWorld());
            this.savePerWorldData(event, event.getWorld());
        }
        if (event instanceof WorldEvent.Save) {
            this.savePerWorldData(event, event.getWorld());
        }
    }

    private void savePerWorldData(WorldEvent event, World world) {
        if (world.field_73011_w.getDimension() == 0) {
            try {
                File dir = new File(world.func_72860_G().func_75765_b(), "apocalypse");
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                File file = new File(dir, "apocalypse.dat");
                NBTTagCompound tags = new NBTTagCompound();
                if (!file.exists()) {
                    file.createNewFile();
                }
                CompressedStreamTools.func_74800_a((NBTTagCompound)tags, (DataOutput)new DataOutputStream(new FileOutputStream(file)));
                Iterator<Map.Entry<UUID, BlockPos>> iterator = this.entryPoints.entrySet().iterator();
                while (iterator.hasNext()) {
                    UUID uuid = iterator.next().getKey();
                    File playerFile = new File(dir, uuid.toString() + ".dat");
                    NBTTagCompound playerTags = new NBTTagCompound();
                    if (!playerFile.exists()) {
                        playerFile.createNewFile();
                    }
                    BlockPos pos = this.entryPoints.get(uuid);
                    playerTags.func_74783_a("EntryPoint", new int[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()});
                    CompressedStreamTools.func_74800_a((NBTTagCompound)playerTags, (DataOutput)new DataOutputStream(new FileOutputStream(playerFile)));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void loadPerWorldData(WorldEvent event, World world) {
        if (world.field_73011_w.getDimension() == 0) {
            try {
                File dir = new File(world.func_72860_G().func_75765_b(), "apocalypse");
                if (!dir.exists()) {
                    return;
                }
                File file = new File(world.func_72860_G().func_75765_b(), "apocalypse/apocalypse.dat");
                if (!file.exists()) {
                    file.createNewFile();
                }
                NBTTagCompound tags = CompressedStreamTools.func_74794_a((DataInputStream)new DataInputStream(new FileInputStream(file)));
                for (File playerFile : dir.listFiles()) {
                    if (playerFile.getName().equals("apocalypse.dat")) continue;
                    UUID uuid = UUID.fromString(playerFile.getName().split("\\.")[0]);
                    NBTTagCompound playerTags = CompressedStreamTools.func_74794_a((DataInputStream)new DataInputStream(new FileInputStream(playerFile)));
                    int[] entryPoint = playerTags.func_74759_k("EntryPoint");
                    this.entryPoints.put(uuid, new BlockPos(entryPoint[0], entryPoint[1], entryPoint[2]));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

