/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.teams;

import com.flansmod.common.FlansMod;
import com.flansmod.common.teams.ITeamBase;
import com.flansmod.common.teams.ITeamObject;
import com.flansmod.common.teams.PermanentBaseData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;

public class TeamsMap {
    public String shortName;
    public String name;
    public ForgeChunkManager.Ticket chunkLoadingTicket;
    public ArrayList<ITeamBase> bases = new ArrayList();
    public int minPlayers = 0;
    public int maxPlayers = 1000000;
    public ArrayList<PermanentBaseData> permanentBaseData = new ArrayList();

    public TeamsMap(World world, String sn, String n) {
        this.shortName = sn;
        this.name = n;
    }

    public ArrayList<ITeamBase> getBasesPerTeam(int teamID) {
        ArrayList<ITeamBase> basesForThisTeam = new ArrayList<ITeamBase>();
        for (ITeamBase base : this.bases) {
            if (base.getOwnerID() != teamID) continue;
            basesForThisTeam.add(base);
        }
        return basesForThisTeam;
    }

    public void getValidSpawnPoints(int teamID, List<BlockPos> validSpawnPoints) {
        for (PermanentBaseData data : this.permanentBaseData) {
            if (data.teamID != teamID) continue;
            validSpawnPoints.addAll(data.spawnPoints);
        }
    }

    public void addBase(ITeamBase base) {
        this.bases.add(base);
        PermanentBaseData data = this.getPermanentData(base);
        if (data == null) {
            data = new PermanentBaseData();
            this.permanentBaseData.add(data);
        }
        data.baseID = base.getBaseID();
        data.teamID = base.getDefaultOwnerID();
        data.spawnPoints.clear();
        for (ITeamObject object : base.getObjects()) {
            if (!object.isSpawnPoint()) continue;
            data.spawnPoints.add(new BlockPos(object.getPosX(), object.getPosY(), object.getPosZ()));
        }
    }

    private PermanentBaseData getPermanentData(ITeamBase base) {
        for (PermanentBaseData data : this.permanentBaseData) {
            if (data.baseID != base.getBaseID()) continue;
            return data;
        }
        return null;
    }

    public void addBaseFirstTime(ITeamBase base) {
        this.addBase(base);
    }

    public void removeBase(ITeamBase base) {
        if (this.bases == null) {
            FlansMod.log("Base array for map " + this.name + " null");
            return;
        }
        this.bases.remove(base);
        for (int i = this.permanentBaseData.size() - 1; i >= 0; --i) {
            if (this.permanentBaseData.get((int)i).baseID != base.getBaseID()) continue;
            this.permanentBaseData.remove(i);
            return;
        }
    }

    public void addObject(ITeamBase base, ITeamObject object) {
        PermanentBaseData data;
        if (object.isSpawnPoint() && (data = this.getPermanentData(base)) != null) {
            data.addObject(object);
        }
    }

    public void addObjectFirstTime(ITeamBase base, ITeamObject object) {
    }

    public TeamsMap(World world, NBTTagCompound tags) {
        this.shortName = tags.func_74779_i("ShortName");
        this.name = tags.func_74779_i("Name");
        this.minPlayers = tags.func_74762_e("MinPlayers");
        this.maxPlayers = tags.func_74762_e("MaxPlayers");
        int iNumBases = tags.func_74762_e("NumBases");
        for (int i = 0; i < iNumBases; ++i) {
            PermanentBaseData data = new PermanentBaseData();
            data.readBaseFromNBT(tags.func_74775_l("Base_" + i));
            this.permanentBaseData.add(data);
        }
    }

    public void writeToNBT(NBTTagCompound tags) {
        tags.func_74778_a("ShortName", this.shortName);
        tags.func_74778_a("Name", this.name);
        tags.func_74768_a("MinPlayers", this.minPlayers);
        tags.func_74768_a("MaxPlayers", this.maxPlayers);
        tags.func_74768_a("NumBases", this.permanentBaseData.size());
        for (int i = 0; i < this.permanentBaseData.size(); ++i) {
            NBTTagCompound baseTags = new NBTTagCompound();
            this.permanentBaseData.get(i).writeBaseToNBT(baseTags);
            tags.func_74782_a("Base_" + i, (NBTBase)baseTags);
        }
    }
}

