/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.teams;

import com.flansmod.common.FlansMod;
import com.flansmod.common.PlayerData;
import com.flansmod.common.PlayerHandler;
import com.flansmod.common.driveables.ItemPlane;
import com.flansmod.common.driveables.ItemVehicle;
import com.flansmod.common.guns.GunType;
import com.flansmod.common.guns.ItemAAGun;
import com.flansmod.common.guns.ItemBullet;
import com.flansmod.common.guns.ItemGun;
import com.flansmod.common.guns.ItemShootable;
import com.flansmod.common.guns.ShootableType;
import com.flansmod.common.network.PacketBase;
import com.flansmod.common.network.PacketTeamInfo;
import com.flansmod.common.network.PacketTeamSelect;
import com.flansmod.common.teams.EntityGunItem;
import com.flansmod.common.teams.Gametype;
import com.flansmod.common.teams.GametypeCTF;
import com.flansmod.common.teams.GametypeDM;
import com.flansmod.common.teams.GametypeTDM;
import com.flansmod.common.teams.GametypeZombies;
import com.flansmod.common.teams.IPlayerClass;
import com.flansmod.common.teams.ITeamBase;
import com.flansmod.common.teams.ITeamObject;
import com.flansmod.common.teams.ItemOpStick;
import com.flansmod.common.teams.ItemTeamArmour;
import com.flansmod.common.teams.PlayerClass;
import com.flansmod.common.teams.Team;
import com.flansmod.common.teams.TeamsMap;
import com.flansmod.common.teams.TeamsRound;
import com.flansmod.common.types.InfoType;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.play.server.SPacketPlayerPosLook;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class TeamsManager {
    public static boolean enabled = true;
    public static TeamsManager instance;
    public static boolean voting;
    public static boolean explosions;
    public static boolean driveablesBreakBlocks;
    public static boolean bombsEnabled;
    public static boolean shellsEnabled;
    public static boolean missilesEnabled;
    public static boolean bulletsEnabled;
    public static boolean forceAdventureMode;
    public static boolean canBreakGuns;
    public static boolean canBreakGlass;
    public static boolean armourDrops;
    public static boolean vehiclesNeedFuel;
    public static boolean overrideHunger;
    public static int weaponDrops;
    public static int mgLife;
    public static int planeLife;
    public static int vehicleLife;
    public static int mechaLove;
    public static int aaLife;
    public static int scoreDisplayTime;
    public static int votingTime;
    public static int rankUpdateTime;
    public TeamsRound currentRound;
    public ArrayList<TeamsRound> rounds;
    public HashMap<String, TeamsMap> maps;
    private int nextBaseID = 1;
    public ArrayList<ITeamBase> bases;
    public ArrayList<ITeamObject> objects;
    protected long time;
    public int roundTimeLeft;
    public int interRoundTimeLeft;
    public TeamsRound[] voteOptions;
    public TeamsRound nextRound;
    public static boolean autoBalance;
    public static int autoBalanceInterval;
    public String motd = "Welcome to the Teams server";

    public TeamsManager() {
        instance = this;
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
        this.bases = new ArrayList();
        this.objects = new ArrayList();
        this.maps = new HashMap();
        this.rounds = new ArrayList();
        new GametypeTDM();
        new GametypeZombies();
        new GametypeDM();
        new GametypeCTF();
    }

    public void reset() {
        this.currentRound = null;
        this.bases = new ArrayList();
        this.objects = new ArrayList();
        this.maps = new HashMap();
        this.rounds = new ArrayList();
    }

    public static TeamsManager getInstance() {
        return instance;
    }

    /*
     * WARNING - void declaration
     */
    public void tick() {
        if (this.time % 40L == 0L) {
            FlansMod.INSTANCE.getPacketHandler().sendToAll(new PacketTeamInfo());
            this.showTeamsMenuToAll(true);
        }
        if (!enabled) {
            return;
        }
        if (this.currentRound != null) {
            this.currentRound.gametype.tick();
        }
        ++this.time;
        for (ITeamBase base : this.bases) {
            base.tick();
        }
        for (ITeamObject object : this.objects) {
            object.tick();
        }
        if (overrideHunger && this.currentRound != null) {
            for (Iterator<Object> iterator : FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c) {
                for (Object player : ((World)iterator).field_73010_i) {
                    ((EntityPlayer)player).func_71024_bL().func_75122_a(20, 10.0f);
                }
            }
        }
        if (this.interRoundTimeLeft > 0) {
            --this.interRoundTimeLeft;
            if (voting) {
                if (this.nextRound != null) {
                    this.startNextRound();
                    this.interRoundTimeLeft = 0;
                    return;
                }
                if (this.interRoundTimeLeft <= votingTime) {
                    if (this.voteOptions == null) {
                        this.pickVoteOptions();
                    }
                    this.displayVotingGUI();
                }
            }
            if (this.interRoundTimeLeft == 0) {
                this.startNextRound();
            }
        }
        if (this.currentRound != null && this.roundTimeLeft > 0) {
            void var4_9;
            boolean roundEnded;
            if (this.autoBalance() && this.time % (long)autoBalanceInterval == (long)(autoBalanceInterval - 200) && this.needAutobalance()) {
                TeamsManager.messageAll("\u00a7fAutobalancing teams...");
            }
            if (this.autoBalance() && this.time % (long)autoBalanceInterval == 0L && this.needAutobalance()) {
                this.autobalance();
            }
            --this.roundTimeLeft;
            boolean bl = roundEnded = this.roundTimeLeft == 0;
            if (roundEnded) {
                TeamsManager.messageAll(this.randomTimeOutString());
            }
            Team[] teamArray = this.currentRound.teams;
            int n = teamArray.length;
            boolean bl2 = false;
            while (var4_9 < n) {
                Team team = teamArray[var4_9];
                if (this.currentRound.gametype.teamHasWon(team)) {
                    roundEnded = true;
                    TeamsManager.messageAll(team.name + " won the round!");
                }
                ++var4_9;
            }
            if (roundEnded) {
                this.OnRoundEnded();
            }
        }
    }

    protected void OnRoundEnded() {
        this.roundTimeLeft = 0;
        this.interRoundTimeLeft = scoreDisplayTime + rankUpdateTime;
        if (voting) {
            this.interRoundTimeLeft += votingTime;
        }
        this.displayScoreboardGUI();
        this.currentRound.gametype.roundEnd();
        PlayerHandler.roundEnded();
    }

    public boolean needAutobalance() {
        int membersTeamB;
        if (!this.autoBalance() || this.currentRound == null || this.currentRound.teams.length != 2) {
            return false;
        }
        int membersTeamA = this.currentRound.teams[0].members.size();
        return Math.abs(membersTeamA - (membersTeamB = this.currentRound.teams[1].members.size())) > 1;
    }

    public void autobalance() {
        EntityPlayerMP playerToKick;
        int i;
        int membersTeamB;
        if (!this.autoBalance() || this.currentRound == null || this.currentRound.teams.length != 2) {
            return;
        }
        int membersTeamA = this.currentRound.teams[0].members.size();
        if (membersTeamA - (membersTeamB = this.currentRound.teams[1].members.size()) > 1) {
            for (i = 0; i < (membersTeamA - membersTeamB) / 2; ++i) {
                playerToKick = TeamsManager.getPlayer(this.currentRound.teams[1].addPlayer(this.currentRound.teams[0].removeWorstPlayer()));
                TeamsManager.messagePlayer(playerToKick, "You were moved to the other team by the autobalancer.");
                this.sendClassMenuToPlayer(playerToKick);
            }
        }
        if (membersTeamB - membersTeamA > 1) {
            for (i = 0; i < (membersTeamB - membersTeamA) / 2; ++i) {
                playerToKick = TeamsManager.getPlayer(this.currentRound.teams[0].addPlayer(this.currentRound.teams[1].removeWorstPlayer()));
                TeamsManager.messagePlayer(playerToKick, "You were moved to the other team by the autobalancer.");
                this.sendClassMenuToPlayer(playerToKick);
            }
        }
    }

    public String randomTimeOutString() {
        switch (Gametype.rand.nextInt(4)) {
            case 0: {
                return "That's time!";
            }
            case 1: {
                return "How dull; a tie...";
            }
            case 2: {
                return "Everybody's a loser but the clock.";
            }
        }
        return "Time up.";
    }

    public void displayScoreboardGUI() {
    }

    public void displayVotingGUI() {
    }

    public void pickVoteOptions() {
        Collections.sort(this.rounds);
        this.voteOptions = new TeamsRound[Math.min(5, this.rounds.size())];
        for (int i = 0; i < this.voteOptions.length; ++i) {
            this.voteOptions[i] = this.rounds.get(i);
        }
        this.voteOptions[Gametype.rand.nextInt((int)this.voteOptions.length)] = this.rounds.get(Gametype.rand.nextInt(this.rounds.size()));
    }

    public void start() {
        if (!enabled || this.rounds.size() == 0) {
            return;
        }
        if (this.currentRound != null) {
            this.currentRound.gametype.roundCleanup();
            this.resetScores();
        }
        this.currentRound = this.rounds.get(0);
        this.startRound();
    }

    public void startNextRound() {
        if (!enabled || this.rounds.size() == 0) {
            return;
        }
        if (this.nextRound == null) {
            if (voting) {
                int winner = 0;
                int mostVotes = 0;
                int[] numVotes = new int[this.voteOptions.length];
                for (PlayerData data : PlayerHandler.serverSideData.values()) {
                    if (data.vote <= 0) continue;
                    int n = data.vote - 1;
                    numVotes[n] = numVotes[n] + 1;
                }
                for (int i = 0; i < this.voteOptions.length; ++i) {
                    if (numVotes[i] <= mostVotes) continue;
                    mostVotes = numVotes[i];
                    winner = i;
                }
                this.nextRound = this.voteOptions[winner];
                for (TeamsRound round : this.rounds) {
                    ++round.roundsSincePlayed;
                }
                for (int i = 0; i < this.voteOptions.length; ++i) {
                    if (i == winner) {
                        this.voteOptions[i].popularity = 1.0f - (1.0f - this.voteOptions[i].popularity) * 0.8f;
                        this.voteOptions[i].roundsSincePlayed = 0;
                        continue;
                    }
                    this.voteOptions[i].popularity *= 0.9f;
                    this.voteOptions[i].popularity += 0.01f;
                }
                for (PlayerData data : PlayerHandler.serverSideData.values()) {
                    data.vote = 0;
                }
            } else {
                int lastRoundID = this.rounds.indexOf(this.currentRound);
                int nextRoundID = ++lastRoundID % this.rounds.size();
                this.nextRound = this.rounds.get(nextRoundID);
            }
        }
        if (this.currentRound != null) {
            for (ITeamBase base : this.currentRound.map.bases) {
                base.roundCleanup();
            }
            this.currentRound.gametype.roundCleanup();
        }
        this.resetScores();
        if (this.nextRound != null) {
            this.currentRound = this.nextRound;
        }
        this.startRound();
        this.nextRound = null;
    }

    public void startRound() {
        this.currentRound.gametype.roundStart();
        this.roundTimeLeft = this.currentRound.timeLimit * 60 * 20;
        for (ITeamBase iTeamBase : this.bases) {
            iTeamBase.startRound();
        }
        for (EntityPlayer entityPlayer : TeamsManager.getPlayers()) {
            this.forceRespawn((EntityPlayerMP)entityPlayer);
        }
        this.showTeamsMenuToAll();
        TeamsManager.messageAll("\u00a7fA new round has started!");
    }

    public void showTeamsMenuToAll() {
        this.showTeamsMenuToAll(false);
    }

    public void showTeamsMenuToAll(boolean info) {
        for (EntityPlayer entityPlayer : TeamsManager.getPlayers()) {
            PlayerData data = PlayerHandler.getPlayerData(entityPlayer);
            if (data == null || data.builder && this.playerIsOp(entityPlayer)) continue;
            this.sendTeamsMenuToPlayer((EntityPlayerMP)entityPlayer, info);
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.EntityInteract event) {
        if (event.getEntityPlayer().field_71071_by.func_70448_g() != null && event.getEntityPlayer().field_71071_by.func_70448_g().func_77973_b() instanceof ItemOpStick) {
            ((ItemOpStick)event.getEntityPlayer().field_71071_by.func_70448_g().func_77973_b()).clickedEntity(event.getEntityPlayer().field_70170_p, event.getEntityPlayer(), event.getTarget());
        }
    }

    @SubscribeEvent
    public void onEntityHurt(LivingAttackEvent event) {
        if (!enabled || this.currentRound == null) {
            return;
        }
        if (event.getEntity() instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)event.getEntity();
            PlayerData data = PlayerHandler.getPlayerData((EntityPlayer)player);
            DamageSource source = event.getSource();
            if (data.team == Team.spectators && source != DamageSource.field_76377_j) {
                event.setCanceled(true);
                return;
            }
            if (source instanceof EntityDamageSource && source.func_76364_f() instanceof EntityPlayerMP) {
                EntityPlayerMP attacker = (EntityPlayerMP)source.func_76364_f();
                PlayerData attackerData = PlayerHandler.getPlayerData((EntityPlayer)attacker);
                if (attackerData == null) {
                    return;
                }
                if (attacker == player) {
                    return;
                }
                if (attackerData.team == Team.spectators) {
                    event.setCanceled(true);
                    return;
                }
                if (attackerData.team == null && data.team != null || attackerData.team != null && data.team == null) {
                    event.setCanceled(true);
                    return;
                }
                if (attackerData.team != null && data.team != null && this.roundTimeLeft > 0 && !this.currentRound.gametype.playerCanAttack(attacker, attackerData.team, player, data.team)) {
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public void onEntityKilled(LivingDeathEvent event) {
        if (!enabled) {
            return;
        }
        if (this.currentRound != null) {
            this.currentRound.gametype.entityKilled(event.getEntity(), event.getSource());
        }
        if (event.getEntity() instanceof EntityPlayerMP) {
            this.OnPlayerKilled((EntityPlayerMP)event.getEntity(), event.getSource());
        }
    }

    public void OnPlayerKilled(EntityPlayerMP player, DamageSource source) {
        if (this.currentRound != null) {
            this.currentRound.gametype.playerKilled(player, source);
        }
    }

    @SubscribeEvent
    public void entityJoinedWorld(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof ITeamBase) {
            this.registerBase((ITeamBase)event.getEntity());
        }
        if (event.getEntity() instanceof ITeamObject) {
            this.objects.add((ITeamObject)event.getEntity());
        }
    }

    @SubscribeEvent
    public void playerUseEntity(PlayerInteractEvent.EntityInteract event) {
        if (!enabled) {
            return;
        }
        if (event.getEntityPlayer().field_70170_p.field_72995_K) {
            return;
        }
        ItemStack currentItem = event.getEntityPlayer().func_184614_ca();
        if (!(currentItem != null && currentItem.func_77973_b() != null && currentItem.func_77973_b() instanceof ItemOpStick || this.currentRound == null)) {
            if (event.getTarget() instanceof ITeamObject) {
                this.currentRound.gametype.objectClickedByPlayer((ITeamObject)event.getTarget(), (EntityPlayerMP)event.getEntityPlayer());
            }
            if (event.getTarget() instanceof ITeamBase) {
                this.currentRound.gametype.baseClickedByPlayer((ITeamBase)event.getTarget(), (EntityPlayerMP)event.getEntityPlayer());
            }
        }
    }

    @SubscribeEvent
    public void playerInteracted(PlayerInteractEvent event) {
        if (!enabled) {
            return;
        }
        if (event.getHand() == EnumHand.MAIN_HAND && event.getEntityPlayer().func_184614_ca() != null && event.getEntityPlayer().func_184614_ca().func_77973_b() instanceof ItemGun) {
            return;
        }
        if (event.getEntityPlayer().field_70170_p.field_72995_K) {
            return;
        }
        TileEntity te = event.getEntityPlayer().field_70170_p.func_175625_s(event.getPos());
        if (te != null) {
            ItemStack currentItem = event.getEntityPlayer().func_184614_ca();
            if (currentItem != null && currentItem.func_77973_b() != null && currentItem.func_77973_b() instanceof ItemOpStick) {
                if (te instanceof ITeamObject) {
                    ((ItemOpStick)currentItem.func_77973_b()).clickedObject(event.getEntityPlayer().field_70170_p, (EntityPlayerMP)event.getEntityPlayer(), (ITeamObject)te);
                }
                if (te instanceof ITeamBase) {
                    ((ItemOpStick)currentItem.func_77973_b()).clickedBase(event.getEntityPlayer().field_70170_p, (EntityPlayerMP)event.getEntityPlayer(), (ITeamBase)te);
                }
            } else if (this.currentRound != null) {
                if (te instanceof ITeamObject) {
                    this.currentRound.gametype.objectClickedByPlayer((ITeamObject)te, (EntityPlayerMP)event.getEntityPlayer());
                }
                if (te instanceof ITeamBase) {
                    this.currentRound.gametype.baseClickedByPlayer((ITeamBase)te, (EntityPlayerMP)event.getEntityPlayer());
                }
            }
        }
    }

    @SubscribeEvent
    public void playerDrops(PlayerDropsEvent event) {
        ItemStack stack;
        ArrayList<EntityItem> dropsToThrow = new ArrayList<EntityItem>();
        if (weaponDrops == 2) {
            for (EntityItem entity : event.getDrops()) {
                stack = entity.func_92059_d();
                if (stack == null || stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemGun)) continue;
                EntityGunItem gunEntity = new EntityGunItem(entity);
                stack.func_190920_e(0);
                boolean alreadyAdded = false;
                for (EntityItem check : dropsToThrow) {
                    if (((ItemGun)stack.func_77973_b()).GetType() != ((ItemGun)check.func_92059_d().func_77973_b()).GetType()) continue;
                    alreadyAdded = true;
                }
                if (alreadyAdded) continue;
                event.getEntityPlayer().field_70170_p.func_72838_d((Entity)gunEntity);
                dropsToThrow.add(gunEntity);
            }
        }
        for (EntityItem entity : dropsToThrow) {
            EntityGunItem gunEntity = (EntityGunItem)entity;
            GunType gunType = ((ItemGun)gunEntity.func_92059_d().func_77973_b()).GetType();
            for (EntityItem ammoEntity : event.getDrops()) {
                ShootableType bulletType;
                ItemStack ammoItemstack = ammoEntity.func_92059_d();
                if (ammoItemstack == null || !(ammoItemstack.func_77973_b() instanceof ItemShootable) || !gunType.isAmmo(bulletType = ((ItemShootable)ammoItemstack.func_77973_b()).type)) continue;
                gunEntity.ammoStacks.add(ammoItemstack.func_77946_l());
                ammoItemstack.func_190920_e(0);
            }
        }
        for (EntityItem entity : event.getDrops()) {
            stack = entity.func_92059_d();
            if (stack == null || stack.func_190926_b()) continue;
            if (stack.func_77973_b() instanceof ItemGun || stack.func_77973_b() instanceof ItemPlane || stack.func_77973_b() instanceof ItemVehicle || stack.func_77973_b() instanceof ItemAAGun || stack.func_77973_b() instanceof ItemBullet) {
                if (weaponDrops == 1) continue;
                dropsToThrow.add(entity);
                continue;
            }
            if (!(stack.func_77973_b() instanceof ItemTeamArmour) || armourDrops) continue;
            dropsToThrow.add(entity);
        }
        event.getDrops().removeAll(dropsToThrow);
    }

    @SubscribeEvent
    public void playerLoot(EntityItemPickupEvent event) {
        if (event.getEntity() instanceof EntityPlayer) {
            ItemStack itemStack = event.getItem().func_92059_d();
            PlayerData data = PlayerHandler.getPlayerData(event.getEntityPlayer());
            if (enabled && this.currentRound != null && data != null && (data.team == Team.spectators || !this.currentRound.gametype.playerCanLoot(itemStack, InfoType.getType(itemStack), event.getEntityPlayer(), data.team))) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent event) {
        if (event instanceof PlayerEvent.PlayerRespawnEvent) {
            this.respawnPlayer(event.player, false);
        }
        if (event instanceof PlayerEvent.PlayerLoggedOutEvent) {
            this.onPlayerLogout(event.player);
        }
        if (event instanceof PlayerEvent.PlayerLoggedInEvent) {
            this.onPlayerLogin(event.player);
        }
    }

    public void onPlayerLogin(EntityPlayer player) {
        if (!enabled || this.currentRound == null) {
            return;
        }
        if (player instanceof EntityPlayerMP) {
            EntityPlayerMP playerMP = (EntityPlayerMP)player;
            this.sendTeamsMenuToPlayer(playerMP);
            this.currentRound.gametype.playerJoined(playerMP);
        }
    }

    public void onPlayerLogout(EntityPlayer player) {
        for (Team team : Team.teams) {
            team.removePlayer(player);
        }
    }

    public void respawnPlayer(EntityPlayer player, boolean firstSpawn) {
        Vec3d spawnPoint;
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        if (!enabled || this.currentRound == null) {
            return;
        }
        EntityPlayerMP playerMP = (EntityPlayerMP)player;
        PlayerData data = PlayerHandler.getPlayerData((EntityPlayer)playerMP);
        if (data == null || data.builder && this.playerIsOp((EntityPlayer)playerMP)) {
            return;
        }
        if (firstSpawn && (spawnPoint = this.currentRound.gametype.getSpawnPoint(playerMP)) != null) {
            playerMP.func_184210_p();
            EnumSet<SPacketPlayerPosLook.EnumFlags> enumset = EnumSet.noneOf(SPacketPlayerPosLook.EnumFlags.class);
            playerMP.field_71135_a.func_175089_a(spawnPoint.field_72450_a, spawnPoint.field_72448_b, spawnPoint.field_72449_c, 0.0f, 0.0f, enumset);
        }
        this.setPlayersNextSpawnpoint(playerMP);
        if (forceAdventureMode) {
            player.func_71033_a(GameType.ADVENTURE);
        }
        this.resetInventory(player);
        this.currentRound.gametype.playerRespawned((EntityPlayerMP)player);
    }

    private void setPlayersNextSpawnpoint(EntityPlayerMP player, BlockPos pos, int dimension) {
        player.setSpawnChunk(pos, true, dimension);
    }

    private void setPlayersNextSpawnpoint(EntityPlayerMP player) {
        if (!enabled || this.currentRound == null) {
            return;
        }
        PlayerData data = PlayerHandler.getPlayerData((EntityPlayer)player);
        Vec3d spawnPoint = this.currentRound.gametype.getSpawnPoint(player);
        if (spawnPoint != null) {
            this.setPlayersNextSpawnpoint(player, new BlockPos(MathHelper.func_76128_c((double)spawnPoint.field_72450_a), MathHelper.func_76128_c((double)spawnPoint.field_72448_b) + 1, MathHelper.func_76128_c((double)spawnPoint.field_72449_c)), 0);
        } else {
            FlansMod.log("Could not find spawn point for " + player.func_145748_c_() + " on team " + (data.newTeam == null ? "null" : data.newTeam.name));
        }
    }

    public void forceRespawn(EntityPlayerMP player) {
        if (this.playerIsOp((EntityPlayer)player) && PlayerHandler.getPlayerData((EntityPlayer)player).builder) {
            return;
        }
        player.field_71071_by.func_174888_l();
        player.func_70691_i(9001.0f);
        if (forceAdventureMode) {
            player.func_71033_a(GameType.ADVENTURE);
        }
        this.respawnPlayer((EntityPlayer)player, true);
    }

    public void sendTeamsMenuToPlayer(EntityPlayerMP player) {
        this.sendTeamsMenuToPlayer(player, false);
    }

    public void sendTeamsMenuToPlayer(EntityPlayerMP player, boolean info) {
        if (!enabled || this.currentRound == null || this.currentRound.teams == null) {
            return;
        }
        Team[] availableTeams = this.currentRound.gametype.getTeamsCanSpawnAs(this.currentRound, (EntityPlayer)player);
        boolean playerIsOp = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152596_g(player.func_146103_bH());
        Team[] allAvailableTeams = new Team[availableTeams.length + (playerIsOp ? 2 : 1)];
        System.arraycopy(availableTeams, 0, allAvailableTeams, 0, availableTeams.length);
        allAvailableTeams[availableTeams.length] = Team.spectators;
        TeamsManager.sendPacketToPlayer(new PacketTeamSelect(allAvailableTeams, info), player);
    }

    public void sendClassMenuToPlayer(EntityPlayerMP player) {
        Team team = PlayerHandler.getPlayerData((EntityPlayer)player).newTeam;
        if (team == null) {
            this.sendTeamsMenuToPlayer(player);
        } else if (team != Team.spectators && team.classes.size() > 0) {
            TeamsManager.sendPacketToPlayer(new PacketTeamSelect(team.classes.toArray(new PlayerClass[team.classes.size()])), player);
        }
    }

    public boolean playerIsOp(EntityPlayer player) {
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152596_g(player.func_146103_bH());
    }

    public boolean autoBalance() {
        return (this.currentRound == null || this.currentRound.gametype.shouldAutobalance()) && autoBalance;
    }

    public void playerSelectedTeam(EntityPlayerMP player, String teamName) {
        Team[] validTeams;
        Team selectedTeam;
        if (!enabled || this.currentRound == null) {
            return;
        }
        PlayerData data = PlayerHandler.getPlayerData((EntityPlayer)player);
        data.builder = false;
        if (teamName.equals("null")) {
            if (this.playerIsOp((EntityPlayer)player)) {
                data.team = null;
                data.builder = true;
                return;
            }
            teamName = "spectators";
        }
        if ((selectedTeam = Team.getTeam(teamName)) == null) {
            selectedTeam = Team.spectators;
        }
        boolean isValid = selectedTeam == Team.spectators;
        for (Team validTeam : validTeams = this.currentRound.gametype.getTeamsCanSpawnAs(this.currentRound, (EntityPlayer)player)) {
            if (selectedTeam != validTeam) continue;
            isValid = true;
        }
        if (!isValid) {
            player.func_145747_a((ITextComponent)new TextComponentString("You may not join " + selectedTeam.name + " for it is invalid. Please try again"));
            FlansMod.log(player.func_70005_c_() + " tried to spawn on an invalid team : " + selectedTeam.name);
            selectedTeam = Team.spectators;
        }
        if (selectedTeam == Team.spectators) {
            TeamsManager.messageAll(player.func_70005_c_() + " joined \u00a7" + selectedTeam.textColour + selectedTeam.name);
            if (data.team != null) {
                data.team.removePlayer((EntityPlayer)player);
            }
            data.newTeam = data.team = Team.spectators;
            player.field_71071_by.func_174888_l();
            data.team.addPlayer((EntityPlayer)player);
            player.func_70691_i(9001.0f);
            this.respawnPlayer((EntityPlayer)player, true);
        } else {
            Team otherTeam = this.currentRound.getOtherTeam(selectedTeam);
            if (this.autoBalance() && selectedTeam.members.size() > otherTeam.members.size() + 1) {
                player.func_145747_a((ITextComponent)new TextComponentString("You may not join " + selectedTeam.name + " due to imbalance. Please try again"));
                this.sendTeamsMenuToPlayer(player);
                return;
            }
            data.newTeam = selectedTeam;
            this.sendClassMenuToPlayer(player);
        }
        this.currentRound.gametype.playerChoseTeam(player, data.team, selectedTeam);
    }

    public void playerSelectedClass(EntityPlayerMP player, String className) {
        if (!enabled || this.currentRound == null) {
            return;
        }
        PlayerClass playerClass = PlayerClass.getClass(className);
        PlayerData data = PlayerHandler.getPlayerData((EntityPlayer)player);
        if (!data.newTeam.classes.contains(playerClass)) {
            player.func_145747_a((ITextComponent)new TextComponentString("You may not select " + playerClass.name + ". Please try again"));
            FlansMod.log(player.func_70005_c_() + " tried to pick an invalid class : " + playerClass.name);
            return;
        }
        this.playerSelectedClass(player, playerClass);
    }

    public void playerSelectedClass(EntityPlayerMP player, IPlayerClass playerClass) {
        if (playerClass == null) {
            FlansMod.log("Error in class selection");
            return;
        }
        PlayerData data = PlayerHandler.getPlayerData((EntityPlayer)player);
        if (data.team == data.newTeam && data.playerClass != null && !data.playerClass.GetShortName().equals(playerClass.GetShortName())) {
            this.currentRound.gametype.playerChoseNewClass(player, playerClass);
            data.newPlayerClass = playerClass;
            player.func_145747_a((ITextComponent)new TextComponentString("You will respawn with the " + playerClass.GetName() + " class"));
        } else if (data.team != null && data.team != data.newTeam) {
            TeamsManager.messageAll(player.func_70005_c_() + " switched to \u00a7" + data.newTeam.textColour + data.newTeam.name);
            this.currentRound.gametype.playerDefected(player, data.team, data.newTeam);
            this.setPlayersNextSpawnpoint(player);
            player.func_70097_a(DamageSource.field_76377_j, 10000.0f);
            if (data.team != null) {
                data.team.removePlayer((EntityPlayer)player);
            }
            data.newTeam.addPlayer((EntityPlayer)player);
            data.team = data.newTeam;
            data.newPlayerClass = playerClass;
        } else if (data.team == null) {
            if (data.newTeam == null) {
                FlansMod.Assert(false, "NULL TEAM");
            } else {
                TeamsManager.messageAll(player.func_70005_c_() + " joined \u00a7" + data.newTeam.textColour + data.newTeam.name);
                this.currentRound.gametype.playerEnteredTheGame(player, data.newTeam, playerClass);
                data.newTeam.addPlayer((EntityPlayer)player);
                data.team = data.newTeam;
                data.newPlayerClass = playerClass;
                this.currentRound.gametype.playerChoseNewClass(player, playerClass);
                this.respawnPlayer((EntityPlayer)player, true);
            }
        }
    }

    public void resetInventory(EntityPlayer player) {
        Team team = PlayerHandler.getPlayerData((EntityPlayer)player).team;
        IPlayerClass playerClass = PlayerHandler.getPlayerData(player).getPlayerClass();
        if (team == null) {
            return;
        }
        player.field_71071_by.func_174888_l();
        if (team.hat != null) {
            player.func_184201_a(EntityEquipmentSlot.HEAD, team.hat.func_77946_l());
        }
        if (team.chest != null) {
            player.func_184201_a(EntityEquipmentSlot.CHEST, team.chest.func_77946_l());
        }
        if (team.legs != null) {
            player.func_184201_a(EntityEquipmentSlot.LEGS, team.legs.func_77946_l());
        }
        if (team.shoes != null) {
            player.func_184201_a(EntityEquipmentSlot.FEET, team.shoes.func_77946_l());
        }
        if (playerClass == null) {
            return;
        }
        if (playerClass.GetHat() != null) {
            player.func_184201_a(EntityEquipmentSlot.HEAD, playerClass.GetHat().func_77946_l());
        }
        if (playerClass.GetChest() != null) {
            player.func_184201_a(EntityEquipmentSlot.CHEST, playerClass.GetChest().func_77946_l());
        }
        if (playerClass.GetLegs() != null) {
            player.func_184201_a(EntityEquipmentSlot.LEGS, playerClass.GetLegs().func_77946_l());
        }
        if (playerClass.GetShoes() != null) {
            player.func_184201_a(EntityEquipmentSlot.FEET, playerClass.GetShoes().func_77946_l());
        }
        for (ItemStack stack : playerClass.GetStartingItems()) {
            player.field_71071_by.func_70441_a(stack.func_77946_l());
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack;
            stack = player.field_71071_by.func_70301_a(i);
            if (stack == null || !(stack.func_77973_b() instanceof ItemGun)) continue;
            ((ItemGun)stack.func_77973_b()).Reload(stack, player.field_70170_p, (Entity)player, (IInventory)player.field_71071_by, EnumHand.MAIN_HAND, false, true, false);
        }
    }

    @SubscribeEvent
    public void chunkLoaded(ChunkDataEvent event) {
        Chunk chunk = event.getChunk();
        for (ClassInheritanceMultiMap list : chunk.func_177429_s()) {
            for (Entity entity : list) {
                if (entity instanceof ITeamBase) {
                    this.bases.add((ITeamBase)entity);
                    if (((ITeamBase)entity).getBaseID() > this.nextBaseID) {
                        FlansMod.log("Loaded base with ID higher than the supposed highest ID. Adjusted highest ID");
                        this.nextBaseID = ((ITeamBase)entity).getBaseID();
                    }
                }
                if (!(entity instanceof ITeamObject)) continue;
                this.objects.add((ITeamObject)entity);
            }
        }
    }

    @SubscribeEvent
    public void worldData(WorldEvent event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        if (event instanceof WorldEvent.Load) {
            this.loadPerWorldData((Event)event, event.getWorld());
            this.savePerWorldData((Event)event, event.getWorld());
        }
        if (event instanceof WorldEvent.Save) {
            this.savePerWorldData((Event)event, event.getWorld());
        }
    }

    private void loadPerWorldData(Event event, World world) {
        this.reset();
        File file = new File(world.func_72860_G().func_75765_b(), "teams_" + world.field_73011_w.func_186058_p().func_186065_b() + ".dat");
        if (!this.checkFileExists(file)) {
            return;
        }
        try {
            NBTTagCompound tags = CompressedStreamTools.func_74794_a((DataInputStream)new DataInputStream(new FileInputStream(file)));
            this.ReadFromNBT(tags, world);
            if (enabled && this.rounds.size() > 0) {
                this.start();
            }
        }
        catch (Exception e) {
            FlansMod.log("Failed to load from teams.dat");
            e.printStackTrace();
        }
        for (InfoType type : InfoType.infoTypes.values()) {
            type.onWorldLoad(world);
        }
    }

    private void savePerWorldData(Event event, World world) {
        File file = new File(world.func_72860_G().func_75765_b(), "teams_" + world.field_73011_w.func_186058_p().func_186065_b() + ".dat");
        this.checkFileExists(file);
        try {
            NBTTagCompound tags = new NBTTagCompound();
            this.WriteToNBT(tags);
            CompressedStreamTools.func_74800_a((NBTTagCompound)tags, (DataOutput)new DataOutputStream(new FileOutputStream(file)));
        }
        catch (Exception e) {
            FlansMod.log("Failed to save to teams.dat");
            e.printStackTrace();
        }
    }

    protected void ReadFromNBT(NBTTagCompound tags, World world) {
        this.nextBaseID = tags.func_74762_e("NextBaseID");
        for (int i = 0; i < tags.func_74762_e("NumberOfMaps"); ++i) {
            TeamsMap map = new TeamsMap(world, tags.func_74775_l("Map_" + i));
            this.maps.put(map.shortName, map);
        }
        int dimension = 0;
        if (this.maps.size() == 0) {
            this.maps.put("default" + dimension, new TeamsMap(world, "default" + dimension, "Default " + world.func_72912_H().func_76065_j()));
        }
        for (int i = 0; i < tags.func_74762_e("RoundsSize"); ++i) {
            TeamsRound round = new TeamsRound(tags.func_74775_l("Round_" + i));
            this.rounds.add(round);
        }
        enabled = tags.func_74767_n("Enabled");
        voting = tags.func_74767_n("Voting");
        votingTime = tags.func_74762_e("VotingTime");
        scoreDisplayTime = tags.func_74762_e("ScoreTime");
        rankUpdateTime = tags.func_74762_e("RankUpdateTime");
        bombsEnabled = tags.func_74767_n("Bombs");
        bulletsEnabled = tags.func_74767_n("Bullets");
        explosions = tags.func_74767_n("Explosions");
        forceAdventureMode = tags.func_74767_n("ForceAdventure");
        canBreakGuns = tags.func_74767_n("CanBreakGuns");
        canBreakGlass = tags.func_74767_n("CanBreakGlass");
        armourDrops = tags.func_74767_n("ArmourDrops");
        weaponDrops = tags.func_74762_e("WeaponDrops");
        vehiclesNeedFuel = tags.func_74767_n("NeedFuel");
        mgLife = tags.func_74762_e("MGLife");
        aaLife = tags.func_74762_e("AALife");
        vehicleLife = tags.func_74762_e("VehicleLife");
        mechaLove = tags.func_74762_e("MechaLove");
        planeLife = tags.func_74762_e("PlaneLife");
        driveablesBreakBlocks = tags.func_74767_n("BreakBlocks");
    }

    protected void WriteToNBT(NBTTagCompound tags) {
        int i;
        tags.func_74768_a("NextBaseID", this.nextBaseID);
        tags.func_74768_a("NumberOfMaps", this.maps.size());
        if (this.maps != null) {
            i = 0;
            for (TeamsMap map : this.maps.values()) {
                NBTTagCompound mapTags = new NBTTagCompound();
                map.writeToNBT(mapTags);
                tags.func_74782_a("Map_" + i, (NBTBase)mapTags);
                ++i;
            }
        }
        if (this.rounds != null) {
            tags.func_74768_a("RoundsSize", this.rounds.size());
            for (i = 0; i < this.rounds.size(); ++i) {
                TeamsRound entry = this.rounds.get(i);
                if (entry == null) continue;
                NBTTagCompound roundTags = new NBTTagCompound();
                entry.writeToNBT(roundTags);
                tags.func_74782_a("Round_" + i, (NBTBase)roundTags);
            }
        } else {
            tags.func_74768_a("RoundsSize", 0);
        }
        if (this.currentRound != null) {
            tags.func_74768_a("CurrentRound", this.rounds.indexOf(this.currentRound));
        }
        for (Gametype gametype : Gametype.gametypes.values()) {
            gametype.saveToNBT(tags);
        }
        tags.func_74757_a("Enabled", enabled);
        tags.func_74757_a("Voting", voting);
        tags.func_74768_a("VotingTime", votingTime);
        tags.func_74768_a("ScoreTime", scoreDisplayTime);
        tags.func_74768_a("RankUpdateTime", rankUpdateTime);
        tags.func_74757_a("Bombs", bombsEnabled);
        tags.func_74757_a("Bullets", bulletsEnabled);
        tags.func_74757_a("Explosions", explosions);
        tags.func_74757_a("ForceAdventure", forceAdventureMode);
        tags.func_74757_a("CanBreakGuns", canBreakGuns);
        tags.func_74757_a("CanBreakGlass", canBreakGlass);
        tags.func_74757_a("ArmourDrops", armourDrops);
        tags.func_74768_a("WeaponDrops", weaponDrops);
        tags.func_74757_a("NeedFuel", vehiclesNeedFuel);
        tags.func_74768_a("MGLife", mgLife);
        tags.func_74768_a("AALife", aaLife);
        tags.func_74768_a("VehicleLife", vehicleLife);
        tags.func_74768_a("MechaLove", mechaLove);
        tags.func_74768_a("PlaneLife", planeLife);
        tags.func_74757_a("BreakBlocks", driveablesBreakBlocks);
    }

    private boolean checkFileExists(File file) {
        if (!file.exists()) {
            try {
                file.createNewFile();
                FlansMod.log("Created new file");
            }
            catch (Exception e) {
                FlansMod.log("Failed to create file");
                FlansMod.log(file.getAbsolutePath());
                e.printStackTrace();
            }
            return false;
        }
        return true;
    }

    public void resetScores() {
        for (Team team : Team.teams) {
            team.score = 0;
            team.members.clear();
        }
        for (EntityPlayer entityPlayer : TeamsManager.getPlayers()) {
            if (PlayerHandler.getPlayerData(entityPlayer) == null) continue;
            PlayerHandler.getPlayerData(entityPlayer).resetScore();
        }
    }

    public ITeamBase getBase(int ID) {
        for (ITeamBase base : this.bases) {
            if (base.getBaseID() != ID) continue;
            return base;
        }
        return null;
    }

    public void registerBase(ITeamBase base) {
        if (base.getBaseID() == 0) {
            base.setBaseID(this.nextBaseID++);
        }
        this.bases.add(base);
    }

    public void registerObject(ITeamObject obj) {
        this.objects.add(obj);
    }

    public static EntityPlayerMP getPlayer(String username) {
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152612_a(username);
    }

    public static void log(String s) {
        FlansMod.log("Teams Info : " + s);
    }

    public static void messagePlayer(EntityPlayerMP player, String s) {
        player.func_145747_a((ITextComponent)new TextComponentString(s));
    }

    public static void messageAll(String s) {
        FlansMod.log("Teams Announcement : " + s);
        for (EntityPlayerMP player : TeamsManager.getPlayers()) {
            player.func_145747_a((ITextComponent)new TextComponentString(s));
        }
    }

    public static void sendPacketToPlayer(PacketBase packet, EntityPlayerMP player) {
        FlansMod.getPacketHandler().sendTo(packet, player);
    }

    public static List<EntityPlayerMP> getPlayers() {
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v();
    }

    public Team getTeam(int spawnerTeamID) {
        if (!enabled || this.currentRound == null || spawnerTeamID == 0) {
            return null;
        }
        if (spawnerTeamID == 1) {
            return Team.spectators;
        }
        return this.currentRound.teams[spawnerTeamID - 2];
    }

    public TeamsMap getMapFromFullName(String string) {
        for (TeamsMap map : this.maps.values()) {
            if (!map.name.equals(string)) continue;
            return map;
        }
        return null;
    }

    public void SelectTeam(Team team) {
        FlansMod.getPacketHandler().sendToServer(new PacketTeamSelect(team == null ? "null" : team.shortName, false));
        Minecraft.func_71410_x().func_147108_a(null);
    }

    static {
        voting = false;
        explosions = true;
        driveablesBreakBlocks = true;
        bombsEnabled = true;
        shellsEnabled = true;
        missilesEnabled = true;
        bulletsEnabled = true;
        forceAdventureMode = true;
        canBreakGuns = true;
        canBreakGlass = true;
        armourDrops = true;
        vehiclesNeedFuel = true;
        overrideHunger = true;
        weaponDrops = 1;
        mgLife = 0;
        planeLife = 0;
        vehicleLife = 0;
        mechaLove = 0;
        aaLife = 0;
        scoreDisplayTime = 200;
        votingTime = 200;
        rankUpdateTime = 200;
    }
}

