/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.network;

import com.flansmod.client.FlansModClient;
import com.flansmod.common.FlansMod;
import com.flansmod.common.PlayerData;
import com.flansmod.common.PlayerHandler;
import com.flansmod.common.network.PacketBase;
import com.flansmod.common.teams.PlayerClass;
import com.flansmod.common.teams.PlayerRankData;
import com.flansmod.common.teams.Team;
import com.flansmod.common.teams.TeamsManager;
import com.flansmod.common.teams.TeamsManagerRanked;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketTeamInfo
extends PacketBase {
    public String mapShortName;
    public String map;
    public String gametype;
    public boolean showZombieScore;
    public int numTeams;
    public TeamData[] teamData;
    public boolean sortedByTeam;
    public int timeLeft;
    public int scoreLimit;
    public int numLines;

    public static PlayerScoreData getPlayerScoreData(String username) {
        if (FlansModClient.teamInfo.teamData == null) {
            return null;
        }
        for (TeamData team : FlansModClient.teamInfo.teamData) {
            if (team == null || team.playerData == null) {
                return null;
            }
            for (PlayerScoreData player : team.playerData) {
                if (player == null || player.username == null || !player.username.equals(username)) continue;
                return player;
            }
        }
        return null;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf data) {
        data.writeBoolean(TeamsManager.canBreakGlass);
        data.writeBoolean(TeamsManager.vehiclesNeedFuel);
        data.writeBoolean(TeamsManager.driveablesBreakBlocks);
        if (TeamsManager.getInstance().currentRound == null) {
            PacketTeamInfo.writeUTF(data, "No Gametype");
            data.writeInt(0);
        } else {
            PacketTeamInfo.writeUTF(data, TeamsManager.getInstance().currentRound.gametype.name);
            data.writeBoolean(TeamsManager.getInstance().currentRound.gametype.showZombieScore());
            PacketTeamInfo.writeUTF(data, TeamsManager.getInstance().currentRound.map.name);
            PacketTeamInfo.writeUTF(data, TeamsManager.getInstance().currentRound.map.shortName);
            data.writeInt(TeamsManager.getInstance().roundTimeLeft);
            data.writeInt(TeamsManager.getInstance().currentRound.scoreLimit);
            if (TeamsManager.getInstance().currentRound.gametype.sortScoreboardByTeam()) {
                data.writeBoolean(true);
                if (TeamsManager.getInstance().currentRound.teams == null) {
                    data.writeInt(0);
                } else {
                    data.writeInt(TeamsManager.getInstance().currentRound.teams.length);
                    for (int i = 0; i < TeamsManager.getInstance().currentRound.teams.length; ++i) {
                        Team team = TeamsManager.getInstance().currentRound.teams[i];
                        if (team == null) {
                            PacketTeamInfo.writeUTF(data, "none");
                            continue;
                        }
                        PacketTeamInfo.writeUTF(data, team.shortName);
                        data.writeInt(team.score);
                        data.writeBoolean(TeamsManager.getInstance().currentRound.gametype.teamHasWon(team));
                        team.sortPlayers();
                        data.writeInt(team.members.size());
                        for (int j = 0; j < team.members.size(); ++j) {
                            String username = team.members.get(j);
                            PlayerData playerData = PlayerHandler.getPlayerData(username, Side.SERVER);
                            PacketTeamInfo.writeUTF(data, username);
                            PlayerRankData rankData = TeamsManagerRanked.GetRankData((EntityPlayer)TeamsManager.getPlayer(username));
                            if (rankData == null) {
                                data.writeInt(0);
                            } else {
                                data.writeInt(rankData.currentLevel);
                            }
                            if (playerData == null) {
                                data.writeInt(0);
                                data.writeInt(0);
                                data.writeInt(0);
                                PacketTeamInfo.writeUTF(data, "");
                                continue;
                            }
                            data.writeInt(playerData.score);
                            data.writeInt(playerData.zombieScore);
                            data.writeInt(playerData.kills);
                            data.writeInt(playerData.deaths);
                            PacketTeamInfo.writeUTF(data, playerData.playerClass.GetShortName());
                        }
                    }
                }
            } else {
                data.writeBoolean(false);
                ArrayList<String> playerNames = new ArrayList<String>();
                for (int i = 0; i < TeamsManager.getInstance().currentRound.teams.length; ++i) {
                    Team team = TeamsManager.getInstance().currentRound.teams[i];
                    if (team == null || team.members == null) continue;
                    playerNames.addAll(team.members);
                }
                Collections.sort(playerNames, new Team.ComparatorScore());
                data.writeInt(playerNames.size());
                for (String username : playerNames) {
                    PlayerData playerData = PlayerHandler.getPlayerData(username, Side.SERVER);
                    PacketTeamInfo.writeUTF(data, username);
                    PlayerRankData rankData = TeamsManagerRanked.GetRankData((EntityPlayer)TeamsManager.getPlayer(username));
                    if (rankData == null) {
                        data.writeInt(0);
                    } else {
                        data.writeInt(rankData.currentLevel);
                    }
                    if (playerData == null) {
                        data.writeInt(0);
                        data.writeInt(0);
                        data.writeInt(0);
                        PacketTeamInfo.writeUTF(data, "");
                        continue;
                    }
                    data.writeInt(playerData.score);
                    data.writeInt(playerData.kills);
                    data.writeInt(playerData.deaths);
                    PacketTeamInfo.writeUTF(data, playerData.playerClass.GetShortName());
                }
            }
        }
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf data) {
        try {
            TeamsManager.canBreakGlass = data.readBoolean();
            TeamsManager.vehiclesNeedFuel = data.readBoolean();
            TeamsManager.driveablesBreakBlocks = data.readBoolean();
            this.gametype = PacketTeamInfo.readUTF(data);
            if (this.gametype.equals("No Gametype")) {
                this.numTeams = 0;
                this.teamData = new TeamData[0];
            } else {
                this.showZombieScore = data.readBoolean();
                this.map = PacketTeamInfo.readUTF(data);
                this.mapShortName = PacketTeamInfo.readUTF(data);
                this.timeLeft = data.readInt();
                this.scoreLimit = data.readInt();
                this.sortedByTeam = data.readBoolean();
                if (this.sortedByTeam) {
                    this.numTeams = data.readInt();
                    this.numLines = 1;
                    if (this.numTeams == 0) {
                        return;
                    }
                    this.teamData = new TeamData[this.numTeams];
                    for (int i = 0; i < this.numTeams; ++i) {
                        this.teamData[i] = new TeamData();
                        String teamName = PacketTeamInfo.readUTF(data);
                        if (teamName.equals("none")) continue;
                        this.teamData[i].team = Team.getTeam(teamName);
                        this.teamData[i].score = data.readInt();
                        this.teamData[i].winner = data.readBoolean();
                        this.teamData[i].numPlayers = data.readInt();
                        this.teamData[i].playerData = new PlayerScoreData[this.teamData[i].numPlayers];
                        if (this.teamData[i].numPlayers > this.numLines) {
                            this.numLines = this.teamData[i].numPlayers;
                        }
                        for (int j = 0; j < this.teamData[i].numPlayers; ++j) {
                            this.teamData[i].playerData[j] = new PlayerScoreData();
                            this.teamData[i].playerData[j].team = this.teamData[i];
                            this.teamData[i].playerData[j].username = PacketTeamInfo.readUTF(data);
                            this.teamData[i].playerData[j].level = data.readInt();
                            this.teamData[i].playerData[j].score = data.readInt();
                            this.teamData[i].playerData[j].zombieScore = data.readInt();
                            this.teamData[i].playerData[j].kills = data.readInt();
                            this.teamData[i].playerData[j].deaths = data.readInt();
                            this.teamData[i].playerData[j].playerClass = PlayerClass.getClass(PacketTeamInfo.readUTF(data));
                        }
                    }
                } else {
                    this.numLines = 0;
                    this.teamData = new TeamData[]{new TeamData()};
                    this.teamData[0].team = null;
                    this.teamData[0].score = 0;
                    this.teamData[0].numPlayers = data.readInt();
                    this.teamData[0].playerData = new PlayerScoreData[this.teamData[0].numPlayers];
                    this.numLines += this.teamData[0].numPlayers;
                    for (int j = 0; j < this.teamData[0].numPlayers; ++j) {
                        this.teamData[0].playerData[j] = new PlayerScoreData();
                        this.teamData[0].playerData[j].team = this.teamData[0];
                        this.teamData[0].playerData[j].username = PacketTeamInfo.readUTF(data);
                        this.teamData[0].playerData[j].level = data.readInt();
                        this.teamData[0].playerData[j].score = data.readInt();
                        this.teamData[0].playerData[j].kills = data.readInt();
                        this.teamData[0].playerData[j].deaths = data.readInt();
                        this.teamData[0].playerData[j].playerClass = PlayerClass.getClass(PacketTeamInfo.readUTF(data));
                    }
                }
            }
        }
        catch (Exception e) {
            FlansMod.Assert(false, "Messed up in teams packet");
            e.printStackTrace();
            this.teamData = new TeamData[]{new TeamData()};
        }
    }

    @Override
    public void handleServerSide(EntityPlayerMP playerEntity) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleClientSide(EntityPlayer clientPlayer) {
        FlansModClient.teamInfo = this;
    }

    public Team getTeam(int spawnerTeamID) {
        switch (spawnerTeamID) {
            case 0: {
                return null;
            }
            case 1: {
                return Team.spectators;
            }
        }
        return this.teamData.length > spawnerTeamID - 2 && this.teamData[spawnerTeamID - 2] != null ? this.teamData[spawnerTeamID - 2].team : null;
    }

    public Team getTeam(EntityPlayer player) {
        for (int i = 0; i < this.teamData.length; ++i) {
            for (int j = 0; j < this.teamData[i].playerData.length; ++j) {
                if (!this.teamData[i].playerData[j].username.equals(player.getDisplayNameString())) continue;
                return this.teamData[i].team;
            }
        }
        return null;
    }

    public boolean roundOver() {
        if (this.timeLeft == 0) {
            return true;
        }
        for (TeamData aTeamData : this.teamData) {
            if (aTeamData.score != this.scoreLimit) continue;
            return true;
        }
        return false;
    }

    public Team getWinner() {
        for (TeamData aTeamData : this.teamData) {
            if (!aTeamData.winner) continue;
            return aTeamData.team;
        }
        return null;
    }

    public static class PlayerScoreData {
        public int level;
        public String username;
        public int score;
        public int kills;
        public int deaths;
        public TeamData team;
        public PlayerClass playerClass;
        public int zombieScore;
    }

    public static class TeamData {
        public Team team;
        public int score;
        public int numPlayers;
        public PlayerScoreData[] playerData;
        public boolean winner;
    }
}

