/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.network;

import com.flansmod.common.FlansMod;
import com.flansmod.common.network.PacketBase;
import com.flansmod.common.teams.ArmourBoxType;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketBuyArmour
extends PacketBase {
    public String boxShortName;
    public String armourShortName;
    public int piece;

    public PacketBuyArmour() {
    }

    public PacketBuyArmour(String box, String armour, int i) {
        this.boxShortName = box;
        this.armourShortName = armour;
        this.piece = i;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf data) {
        PacketBuyArmour.writeUTF(data, this.boxShortName);
        PacketBuyArmour.writeUTF(data, this.armourShortName);
        data.writeByte((int)((byte)this.piece));
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf data) {
        this.boxShortName = PacketBuyArmour.readUTF(data);
        this.armourShortName = PacketBuyArmour.readUTF(data);
        this.piece = data.readByte();
    }

    @Override
    public void handleServerSide(EntityPlayerMP playerEntity) {
        ArmourBoxType box = ArmourBoxType.getBox(this.boxShortName);
        box.block.buyArmour(this.armourShortName, this.piece, playerEntity.field_71071_by);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleClientSide(EntityPlayer clientPlayer) {
        FlansMod.log("Received armour box purchase packet on client. Skipping.");
    }
}

