/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.guns.raytracing;

import com.flansmod.client.debug.EntityDebugDot;
import com.flansmod.common.FlansMod;
import com.flansmod.common.RotatedAxes;
import com.flansmod.common.guns.BulletType;
import com.flansmod.common.guns.EntityBullet;
import com.flansmod.common.guns.GunType;
import com.flansmod.common.guns.ItemGun;
import com.flansmod.common.guns.raytracing.EnumHitboxType;
import com.flansmod.common.guns.raytracing.FlansModRaytracer;
import com.flansmod.common.teams.TeamsManager;
import com.flansmod.common.types.InfoType;
import com.flansmod.common.vector.Vector3f;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PlayerHitbox {
    public EntityPlayer player;
    public RotatedAxes axes;
    public Vector3f rP;
    public Vector3f o;
    public Vector3f d;
    public EnumHitboxType type;

    public PlayerHitbox(EntityPlayer player, RotatedAxes axes, Vector3f rotationPoint, Vector3f origin, Vector3f dimensions, EnumHitboxType type) {
        this.player = player;
        this.axes = axes;
        this.o = origin;
        this.d = dimensions;
        this.type = type;
        this.rP = rotationPoint;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderHitbox(World world, Vector3f pos) {
        if (this.type != EnumHitboxType.RIGHTARM) {
            return;
        }
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                for (int k = 0; k < 3; ++k) {
                    Vector3f point = new Vector3f(this.o.x + this.d.x * (float)i / 2.0f, this.o.y + this.d.y * (float)j / 2.0f, this.o.z + this.d.z * (float)k / 2.0f);
                    point = this.axes.findLocalVectorGlobally(point);
                    if (!FlansMod.DEBUG || !world.field_72995_K) continue;
                    world.func_72838_d((Entity)new EntityDebugDot(world, new Vector3f(pos.x + this.rP.x + point.x, pos.y + this.rP.y + point.y, pos.z + this.rP.z + point.z), 1, 0.0f, 1.0f, 0.0f));
                }
            }
        }
    }

    public FlansModRaytracer.PlayerBulletHit raytrace(Vector3f origin, Vector3f motion) {
        float intersectX;
        float intersectZ;
        float intersectTime;
        origin = Vector3f.sub(origin, this.rP, null);
        origin = this.axes.findGlobalVectorLocally(origin);
        motion = this.axes.findGlobalVectorLocally(motion);
        if (motion.x != 0.0f) {
            float intersectY;
            if (origin.x < this.o.x) {
                intersectTime = (this.o.x - origin.x) / motion.x;
                intersectY = origin.y + motion.y * intersectTime;
                intersectZ = origin.z + motion.z * intersectTime;
                if (intersectY >= this.o.y && intersectY <= this.o.y + this.d.y && intersectZ >= this.o.z && intersectZ <= this.o.z + this.d.z) {
                    return new FlansModRaytracer.PlayerBulletHit(this, intersectTime);
                }
            } else if (origin.x > this.o.x + this.d.x) {
                intersectTime = (this.o.x + this.d.x - origin.x) / motion.x;
                intersectY = origin.y + motion.y * intersectTime;
                intersectZ = origin.z + motion.z * intersectTime;
                if (intersectY >= this.o.y && intersectY <= this.o.y + this.d.y && intersectZ >= this.o.z && intersectZ <= this.o.z + this.d.z) {
                    return new FlansModRaytracer.PlayerBulletHit(this, intersectTime);
                }
            }
        }
        if (motion.z != 0.0f) {
            float intersectY;
            if (origin.z < this.o.z) {
                intersectTime = (this.o.z - origin.z) / motion.z;
                intersectX = origin.x + motion.x * intersectTime;
                intersectY = origin.y + motion.y * intersectTime;
                if (intersectX >= this.o.x && intersectX <= this.o.x + this.d.x && intersectY >= this.o.y && intersectY <= this.o.y + this.d.y) {
                    return new FlansModRaytracer.PlayerBulletHit(this, intersectTime);
                }
            } else if (origin.z > this.o.z + this.d.z) {
                intersectTime = (this.o.z + this.d.z - origin.z) / motion.z;
                intersectX = origin.x + motion.x * intersectTime;
                intersectY = origin.y + motion.y * intersectTime;
                if (intersectX >= this.o.x && intersectX <= this.o.x + this.d.x && intersectY >= this.o.y && intersectY <= this.o.y + this.d.y) {
                    return new FlansModRaytracer.PlayerBulletHit(this, intersectTime);
                }
            }
        }
        if (motion.y != 0.0f) {
            if (origin.y < this.o.y) {
                intersectTime = (this.o.y - origin.y) / motion.y;
                intersectX = origin.x + motion.x * intersectTime;
                intersectZ = origin.z + motion.z * intersectTime;
                if (intersectX >= this.o.x && intersectX <= this.o.x + this.d.x && intersectZ >= this.o.z && intersectZ <= this.o.z + this.d.z) {
                    return new FlansModRaytracer.PlayerBulletHit(this, intersectTime);
                }
            } else if (origin.y > this.o.y + this.d.y) {
                intersectTime = (this.o.y + this.d.y - origin.y) / motion.y;
                intersectX = origin.x + motion.x * intersectTime;
                intersectZ = origin.z + motion.z * intersectTime;
                if (intersectX >= this.o.x && intersectX <= this.o.x + this.d.x && intersectZ >= this.o.z && intersectZ <= this.o.z + this.d.z) {
                    return new FlansModRaytracer.PlayerBulletHit(this, intersectTime);
                }
            }
        }
        return null;
    }

    public float hitByBullet(DamageSource source, Entity damageOwner, InfoType firedFrom, BulletType bulletType, float damage, float penetratingPower) {
        if (bulletType.setEntitiesOnFire) {
            this.player.func_70015_d(20);
        }
        for (PotionEffect effect : bulletType.hitEffects) {
            this.player.func_70690_d(new PotionEffect(effect));
        }
        float damageModifier = bulletType.penetratingPower < 0.1f ? penetratingPower / bulletType.penetratingPower : 1.0f;
        switch (this.type) {
            case BODY: {
                break;
            }
            case HEAD: {
                damageModifier *= 1.6f;
                break;
            }
            case LEFTARM: {
                damageModifier *= 0.6f;
                break;
            }
            case RIGHTARM: {
                damageModifier *= 0.6f;
                break;
            }
            case LEFTITEM: {
                break;
            }
            case RIGHTITEM: {
                break;
            }
        }
        switch (this.type) {
            case BODY: 
            case HEAD: 
            case LEFTARM: 
            case RIGHTARM: {
                DamageSource damagesource;
                float hitDamage = damage * bulletType.damageVsLiving * damageModifier;
                DamageSource damageSource = damageOwner == null ? DamageSource.field_76377_j : (damagesource = EntityBullet.GetBulletDamage(firedFrom, bulletType, damageOwner, this.type == EnumHitboxType.HEAD));
                if (!this.player.field_70170_p.field_72995_K && hitDamage == 0.0f && TeamsManager.getInstance().currentRound != null) {
                    TeamsManager.getInstance().currentRound.gametype.playerAttacked((EntityPlayerMP)this.player, damagesource);
                }
                if (this.player.func_70097_a(damagesource, hitDamage)) {
                    ++this.player.field_70720_be;
                    this.player.field_70172_ad = this.player.field_70771_an / 2;
                }
                return penetratingPower - 1.0f;
            }
            case RIGHTITEM: {
                ItemStack currentStack = this.player.func_184614_ca();
                if (currentStack != null && currentStack.func_77973_b() instanceof ItemGun) {
                    GunType gunType = ((ItemGun)currentStack.func_77973_b()).GetType();
                    return penetratingPower - gunType.shieldDamageAbsorption;
                }
                return penetratingPower;
            }
            case LEFTITEM: {
                ItemStack currentStack = this.player.func_184592_cb();
                if (currentStack != null && currentStack.func_77973_b() instanceof ItemGun) {
                    GunType gunType = ((ItemGun)currentStack.func_77973_b()).GetType();
                    return penetratingPower - gunType.shieldDamageAbsorption;
                }
                return penetratingPower;
            }
        }
        return penetratingPower;
    }
}

