/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.guns.raytracing;

import com.flansmod.common.FlansMod;
import com.flansmod.common.PlayerData;
import com.flansmod.common.PlayerHandler;
import com.flansmod.common.driveables.EntityDriveable;
import com.flansmod.common.driveables.EnumDriveablePart;
import com.flansmod.common.guns.AttachmentType;
import com.flansmod.common.guns.EntityAAGun;
import com.flansmod.common.guns.EntityGrenade;
import com.flansmod.common.guns.GunType;
import com.flansmod.common.guns.ItemGun;
import com.flansmod.common.guns.raytracing.EnumHitboxType;
import com.flansmod.common.guns.raytracing.PlayerHitbox;
import com.flansmod.common.guns.raytracing.PlayerSnapshot;
import com.flansmod.common.teams.Team;
import com.flansmod.common.vector.Vector3f;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;

public class FlansModRaytracer {
    public static List<BulletHit> Raytrace(World world, Entity playerToIgnore, boolean canHitSelf, Entity entityToIgnore, Vector3f origin, Vector3f motion, int pingOfShooter) {
        ArrayList<BulletHit> hits = new ArrayList<BulletHit>();
        float speed = motion.length();
        for (int i = 0; i < world.field_72996_f.size(); ++i) {
            RayTraceResult mop;
            Entity entity;
            Object obj = world.field_72996_f.get(i);
            boolean shouldDoNormalHitDetect = true;
            if (obj instanceof EntityDriveable) {
                EntityDriveable driveable = (EntityDriveable)obj;
                shouldDoNormalHitDetect = false;
                if (driveable.isDead() || driveable.isPartOfThis(playerToIgnore)) continue;
                if (driveable.func_70092_e(origin.x, origin.y, origin.z) <= (double)((driveable.getDriveableType().bulletDetectionRadius + speed) * (driveable.getDriveableType().bulletDetectionRadius + speed))) {
                    ArrayList<BulletHit> driveableHits = driveable.attackFromBullet(origin, motion);
                    hits.addAll(driveableHits);
                }
            } else if (obj instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)obj;
                PlayerData data = PlayerHandler.getPlayerData(player);
                shouldDoNormalHitDetect = false;
                if (data != null) {
                    PlayerSnapshot snapshot;
                    if (player.field_70128_L || data.team == Team.spectators || player == playerToIgnore && !canHitSelf) continue;
                    int snapshotToTry = pingOfShooter / 50;
                    if (snapshotToTry >= data.snapshots.length) {
                        snapshotToTry = data.snapshots.length - 1;
                    }
                    if ((snapshot = data.snapshots[snapshotToTry]) == null) {
                        snapshot = data.snapshots[0];
                    }
                    if (snapshot == null) {
                        shouldDoNormalHitDetect = true;
                    } else {
                        ArrayList<BulletHit> playerHits = snapshot.raytrace(origin, motion);
                        hits.addAll(playerHits);
                    }
                }
            }
            if (!shouldDoNormalHitDetect || (entity = (Entity)obj) == entityToIgnore || entity == playerToIgnore || entity.field_70128_L || !(entity instanceof EntityLivingBase) && !(entity instanceof EntityAAGun) && !(entity instanceof EntityGrenade) || entity.func_174813_aQ() == null || (mop = entity.func_174813_aQ().func_72327_a(origin.toVec3(), new Vec3d((double)(origin.x + motion.x), (double)(origin.y + motion.y), (double)(origin.z + motion.z)))) == null) continue;
            Vector3f hitPoint = new Vector3f(mop.field_72307_f.field_72450_a - (double)origin.x, mop.field_72307_f.field_72448_b - (double)origin.y, mop.field_72307_f.field_72449_c - (double)origin.z);
            float hitLambda = 1.0f;
            if (motion.x != 0.0f) {
                hitLambda = hitPoint.x / motion.x;
            } else if (motion.y != 0.0f) {
                hitLambda = hitPoint.y / motion.y;
            } else if (motion.z != 0.0f) {
                hitLambda = hitPoint.z / motion.z;
            }
            if (hitLambda < 0.0f) {
                hitLambda = -hitLambda;
            }
            hits.add(new EntityHit(entity, hitLambda));
        }
        Vec3d posVec = origin.toVec3();
        Vec3d nextPosVec = motion.toVec3().func_178787_e(posVec);
        RayTraceResult hit = world.func_147447_a(posVec, nextPosVec, false, true, true);
        posVec = origin.toVec3();
        if (hit != null) {
            Vec3d hitVec = posVec.func_178788_d(hit.field_72307_f);
            float lambda = 1.0f;
            if (motion.x != 0.0f) {
                lambda = (float)(hitVec.field_72450_a / (double)motion.x);
            } else if (motion.y != 0.0f) {
                lambda = (float)(hitVec.field_72448_b / (double)motion.y);
            } else if (motion.z != 0.0f) {
                lambda = (float)(hitVec.field_72449_c / (double)motion.z);
            }
            if (lambda < 0.0f) {
                lambda = -lambda;
            }
            hits.add(new BlockHit(hit, lambda));
        }
        if (!hits.isEmpty()) {
            Collections.sort(hits);
        }
        return hits;
    }

    public static Vector3f GetPlayerMuzzlePosition(EntityPlayer player, EnumHand hand) {
        ItemStack itemstack;
        PlayerSnapshot snapshot = new PlayerSnapshot(player);
        PlayerData data = PlayerHandler.getPlayerData(player);
        ItemStack itemStack = itemstack = hand == EnumHand.OFF_HAND ? player.func_184592_cb() : player.func_184614_ca();
        if (itemstack != null && itemstack.func_77973_b() instanceof ItemGun) {
            GunType gunType = ((ItemGun)itemstack.func_77973_b()).GetType();
            AttachmentType barrelType = gunType.getBarrel(itemstack);
            return Vector3f.add(new Vector3f(player.field_70165_t, player.field_70163_u, player.field_70161_v), snapshot.GetMuzzleLocation(gunType, barrelType, hand), null);
        }
        return new Vector3f(player.func_174824_e(0.0f));
    }

    private static byte GetClassType(BulletHit hit) {
        if (hit instanceof BlockHit) {
            return 0;
        }
        if (hit instanceof EntityHit) {
            return 1;
        }
        if (hit instanceof DriveableHit) {
            return 2;
        }
        if (hit instanceof PlayerBulletHit) {
            return 3;
        }
        return -1;
    }

    public static void WriteToBuffer(BulletHit hit, ByteBuf buffer) {
        buffer.writeByte((int)FlansModRaytracer.GetClassType(hit));
        if (hit != null) {
            buffer.writeFloat(hit.intersectTime);
            if (hit instanceof BlockHit) {
                BlockHit blockHit = (BlockHit)hit;
                buffer.writeByte(blockHit.raytraceResult.field_178784_b.ordinal());
                buffer.writeInt(blockHit.raytraceResult.func_178782_a().func_177958_n());
                buffer.writeInt(blockHit.raytraceResult.func_178782_a().func_177956_o());
                buffer.writeInt(blockHit.raytraceResult.func_178782_a().func_177952_p());
            }
            if (hit instanceof EntityHit) {
                EntityHit entityHit = (EntityHit)hit;
                buffer.writeInt(entityHit.entity.func_145782_y());
            }
            if (hit instanceof DriveableHit) {
                DriveableHit driveableHit = (DriveableHit)hit;
                buffer.writeInt(driveableHit.driveable.func_145782_y());
                buffer.writeByte(driveableHit.part.ordinal());
            }
            if (hit instanceof PlayerBulletHit) {
                PlayerBulletHit playerBulletHit = (PlayerBulletHit)hit;
                buffer.writeInt(playerBulletHit.hitbox.player.func_145782_y());
                buffer.writeByte(playerBulletHit.hitbox.type.ordinal());
            }
        }
    }

    public static BulletHit ReadFromBuffer(ByteBuf buffer) {
        byte type = buffer.readByte();
        switch (type) {
            default: {
                return null;
            }
            case 0: {
                float intersectTime = buffer.readFloat();
                EnumFacing facing = EnumFacing.field_82609_l[buffer.readByte()];
                BlockPos blockPos = new BlockPos(buffer.readInt(), buffer.readInt(), buffer.readInt());
                return new BlockHit(new RayTraceResult(new Vec3d(0.0, 0.0, 0.0), facing, blockPos), intersectTime);
            }
            case 1: {
                float intersectTime = buffer.readFloat();
                Entity entity = FlansModRaytracer.GetEntityByID(buffer.readInt());
                return new EntityHit(entity, intersectTime);
            }
            case 2: {
                float intersectTime = buffer.readFloat();
                Entity entity = FlansModRaytracer.GetEntityByID(buffer.readInt());
                if (entity instanceof EntityDriveable) {
                    return new DriveableHit((EntityDriveable)entity, EnumDriveablePart.values()[buffer.readByte()], intersectTime);
                }
                FlansMod.log("Entity was not a driveable");
                return null;
            }
            case 3: 
        }
        float intersectTime = buffer.readFloat();
        Entity entity = FlansModRaytracer.GetEntityByID(buffer.readInt());
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            PlayerSnapshot snapshot = new PlayerSnapshot(player);
            return new PlayerBulletHit(snapshot.GetHitbox(EnumHitboxType.values()[buffer.readByte()]), intersectTime);
        }
        FlansMod.log("Entity was not a player");
        return null;
    }

    public static Entity GetEntityByID(int id) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            for (WorldServer world : FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c) {
                Entity entity = world.func_73045_a(id);
                if (entity == null) continue;
                return entity;
            }
        } else {
            return Minecraft.func_71410_x().field_71441_e.func_73045_a(id);
        }
        return null;
    }

    public static class PlayerBulletHit
    extends BulletHit {
        public PlayerHitbox hitbox;

        public PlayerBulletHit(PlayerHitbox box, float f) {
            super(f);
            this.hitbox = box;
        }

        @Override
        public Entity GetEntity() {
            return this.hitbox.player;
        }
    }

    public static class DriveableHit
    extends BulletHit {
        public EntityDriveable driveable;
        public EnumDriveablePart part;

        public DriveableHit(EntityDriveable d, EnumDriveablePart p, float f) {
            super(f);
            this.part = p;
            this.driveable = d;
        }

        @Override
        public Entity GetEntity() {
            return this.driveable;
        }
    }

    public static class EntityHit
    extends BulletHit {
        public Entity entity;

        public EntityHit(Entity e, float f) {
            super(f);
            this.entity = e;
        }

        @Override
        public Entity GetEntity() {
            return this.entity;
        }
    }

    public static class BlockHit
    extends BulletHit {
        public RayTraceResult raytraceResult;

        public BlockHit(RayTraceResult mop, float f) {
            super(f);
            this.raytraceResult = mop;
        }

        @Override
        public Entity GetEntity() {
            return null;
        }
    }

    public static abstract class BulletHit
    implements Comparable<BulletHit> {
        public float intersectTime;

        public BulletHit(float f) {
            this.intersectTime = f;
        }

        @Override
        public int compareTo(BulletHit other) {
            if (this.intersectTime < other.intersectTime) {
                return -1;
            }
            if (this.intersectTime > other.intersectTime) {
                return 1;
            }
            return 0;
        }

        public abstract Entity GetEntity();
    }
}

