/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.guns;

import com.flansmod.client.FlansModClient;
import com.flansmod.client.FlansModResourceHandler;
import com.flansmod.client.debug.EntityDebugDot;
import com.flansmod.client.debug.EntityDebugVector;
import com.flansmod.client.model.GunAnimations;
import com.flansmod.client.model.InstantBulletRenderer;
import com.flansmod.common.FlansMod;
import com.flansmod.common.PlayerData;
import com.flansmod.common.PlayerHandler;
import com.flansmod.common.guns.AttachmentType;
import com.flansmod.common.guns.BulletType;
import com.flansmod.common.guns.EntityBullet;
import com.flansmod.common.guns.EntityDamageSourceGun;
import com.flansmod.common.guns.EntityGrenade;
import com.flansmod.common.guns.EntityMG;
import com.flansmod.common.guns.EnumFireMode;
import com.flansmod.common.guns.EnumSecondaryFunction;
import com.flansmod.common.guns.GunType;
import com.flansmod.common.guns.InventoryHelper;
import com.flansmod.common.guns.ItemBullet;
import com.flansmod.common.guns.ItemShootable;
import com.flansmod.common.guns.Paintjob;
import com.flansmod.common.guns.ShootableType;
import com.flansmod.common.guns.ShotData;
import com.flansmod.common.guns.raytracing.FlansModRaytracer;
import com.flansmod.common.network.PacketPlaySound;
import com.flansmod.common.network.PacketReload;
import com.flansmod.common.network.PacketShotData;
import com.flansmod.common.teams.EntityFlag;
import com.flansmod.common.teams.EntityFlagpole;
import com.flansmod.common.teams.EntityGunItem;
import com.flansmod.common.teams.Team;
import com.flansmod.common.types.IPaintableItem;
import com.flansmod.common.types.InfoType;
import com.flansmod.common.types.PaintableType;
import com.flansmod.common.vector.Vector3f;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;

public class ItemGun
extends Item
implements IPaintableItem {
    private static final int CLIENT_TO_SERVER_UPDATE_INTERVAL = 1;
    private static final int SERVER_TO_CLIENT_UPDATE_INTERVAL = 2;
    private GunType type;
    private int soundDelay = 0;
    private static boolean rightMouseHeld;
    private static boolean lastRightMouseHeld;
    private static boolean leftMouseHeld;
    private static boolean lastLeftMouseHeld;
    private static List<ShotData> shotsFiredClient;
    private static List<ShotData> shotsFiredServer;
    protected static final UUID KNOCKBACK_RESIST_MODIFIER;
    protected static final UUID MOVEMENT_SPEED_MODIFIER;

    public GunType GetType() {
        return this.type;
    }

    @Override
    public InfoType getInfoType() {
        return this.type;
    }

    @Override
    public PaintableType GetPaintableType() {
        return this.type;
    }

    private static boolean GetMouseHeld(EnumHand hand) {
        if (FlansMod.shootOnRightClick) {
            return hand == EnumHand.MAIN_HAND ? leftMouseHeld : rightMouseHeld;
        }
        return hand == EnumHand.MAIN_HAND ? rightMouseHeld : leftMouseHeld;
    }

    private static boolean GetLastMouseHeld(EnumHand hand) {
        if (FlansMod.shootOnRightClick) {
            return hand == EnumHand.MAIN_HAND ? lastLeftMouseHeld : lastRightMouseHeld;
        }
        return hand == EnumHand.MAIN_HAND ? lastRightMouseHeld : lastLeftMouseHeld;
    }

    public ItemGun(GunType type) {
        this.field_77777_bU = 1;
        this.type = type;
        type.item = this;
        this.func_77656_e(0);
        this.setRegistryName(type.shortName);
        this.func_77637_a(FlansMod.tabFlanGuns);
    }

    public ItemStack getBulletItemStack(ItemStack gun, int id) {
        if (!gun.func_77942_o()) {
            gun.func_77982_d(new NBTTagCompound());
            return null;
        }
        if (!gun.func_77978_p().func_74764_b("ammo")) {
            NBTTagList ammoTagsList = new NBTTagList();
            for (int i = 0; i < this.type.numAmmoItemsInGun; ++i) {
                ammoTagsList.func_74742_a((NBTBase)new NBTTagCompound());
            }
            gun.func_77978_p().func_74782_a("ammo", (NBTBase)ammoTagsList);
            return null;
        }
        NBTTagList ammoTagsList = gun.func_77978_p().func_150295_c("ammo", 10);
        NBTTagCompound ammoTags = ammoTagsList.func_150305_b(id);
        return new ItemStack(ammoTags);
    }

    public void setBulletItemStack(ItemStack gun, ItemStack bullet, int id) {
        NBTTagList ammoTagsList;
        if (!gun.func_77942_o()) {
            gun.func_77982_d(new NBTTagCompound());
        }
        if (!gun.func_77978_p().func_74764_b("ammo")) {
            ammoTagsList = new NBTTagList();
            for (int i = 0; i < this.type.numAmmoItemsInGun; ++i) {
                ammoTagsList.func_74742_a((NBTBase)new NBTTagCompound());
            }
            gun.func_77978_p().func_74782_a("ammo", (NBTBase)ammoTagsList);
        }
        ammoTagsList = gun.func_77978_p().func_150295_c("ammo", 10);
        NBTTagCompound ammoTags = ammoTagsList.func_150305_b(id);
        if (bullet == null) {
            ammoTags = new NBTTagCompound();
        }
        bullet.func_77955_b(ammoTags);
    }

    public static void dropItem(World world, Entity entity, String itemName) {
        if (itemName != null) {
            int damage = 0;
            if (itemName.contains(".")) {
                damage = Integer.parseInt(itemName.split("\\.")[1]);
                itemName = itemName.split("\\.")[0];
            }
            ItemStack dropStack = InfoType.getRecipeElement(itemName, damage);
            entity.func_70099_a(dropStack, 0.5f);
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer entityplayer, EnumHand hand) {
        ItemStack itemstack = entityplayer.func_184586_b(hand);
        if (this.type.deployable) {
            Vec3d lookVec;
            float cosYaw = MathHelper.func_76134_b((float)(-entityplayer.field_70177_z * 0.01745329f - 3.141593f));
            float sinYaw = MathHelper.func_76126_a((float)(-entityplayer.field_70177_z * 0.01745329f - 3.141593f));
            float cosPitch = -MathHelper.func_76134_b((float)(-entityplayer.field_70125_A * 0.01745329f));
            float sinPitch = MathHelper.func_76126_a((float)(-entityplayer.field_70125_A * 0.01745329f));
            double length = 5.0;
            Vec3d posVec = new Vec3d(entityplayer.field_70165_t, entityplayer.field_70163_u + 1.62 - entityplayer.func_70033_W(), entityplayer.field_70161_v);
            RayTraceResult look = world.func_72901_a(posVec, lookVec = posVec.func_72441_c((double)(sinYaw * cosPitch) * length, (double)sinPitch * length, (double)(cosYaw * cosPitch) * length), true);
            if (look != null && look.field_72313_a == RayTraceResult.Type.BLOCK && look.field_178784_b == EnumFacing.UP) {
                int playerDir = MathHelper.func_76128_c((double)((double)(entityplayer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
                int i = look.func_178782_a().func_177958_n();
                int j = look.func_178782_a().func_177956_o();
                int k = look.func_178782_a().func_177952_p();
                if (!world.field_72995_K) {
                    if (world.func_180495_p(new BlockPos(i, j, k)).func_177230_c() == Blocks.field_150433_aE) {
                        --j;
                    }
                    if (!(!this.isSolid(world, i, j, k) || world.func_180495_p(new BlockPos(i, j + 1, k)).func_177230_c() != Blocks.field_150350_a && world.func_180495_p(new BlockPos(i, j + 1, k)).func_177230_c() != Blocks.field_150433_aE || world.func_180495_p(new BlockPos(i + (playerDir == 1 ? 1 : 0) - (playerDir == 3 ? 1 : 0), j + 1, k - (playerDir == 0 ? 1 : 0) + (playerDir == 2 ? 1 : 0))).func_177230_c() != Blocks.field_150350_a || world.func_180495_p(new BlockPos(i + (playerDir == 1 ? 1 : 0) - (playerDir == 3 ? 1 : 0), j, k - (playerDir == 0 ? 1 : 0) + (playerDir == 2 ? 1 : 0))).func_177230_c() != Blocks.field_150350_a && world.func_180495_p(new BlockPos(i + (playerDir == 1 ? 1 : 0) - (playerDir == 3 ? 1 : 0), j, k - (playerDir == 0 ? 1 : 0) + (playerDir == 2 ? 1 : 0))).func_177230_c() != Blocks.field_150433_aE)) {
                        for (EntityMG mg : EntityMG.mgs) {
                            if (mg.blockX != i || mg.blockY != j + 1 || mg.blockZ != k || mg.field_70128_L) continue;
                            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
                        }
                        if (!world.field_72995_K) {
                            EntityMG mg = new EntityMG(world, i, j + 1, k, playerDir, this.type);
                            if (this.getBulletItemStack(itemstack, 0) != null) {
                                mg.ammo = this.getBulletItemStack(itemstack, 0);
                            }
                            world.func_72838_d((Entity)mg);
                        }
                        if (!entityplayer.field_71075_bZ.field_75098_d) {
                            itemstack.func_190920_e(0);
                        }
                    }
                }
            }
        }
        if (world.field_72995_K) {
            for (int i = 0; i < 3; ++i) {
                Minecraft.func_71410_x().field_71460_t.field_78516_c.func_78441_a();
            }
        }
        return new ActionResult(EnumActionResult.PASS, (Object)itemstack);
    }

    /*
     * Unable to fully structure code
     */
    @SideOnly(value=Side.CLIENT)
    public void onUpdateClient(ItemStack gunstack, int gunSlot, World world, Entity entity, EnumHand hand, boolean hasOffHand) {
        block37: {
            if (!(entity instanceof EntityPlayer)) {
                return;
            }
            mc = Minecraft.func_71410_x();
            player = (EntityPlayer)entity;
            data = PlayerHandler.getPlayerData(player, Side.CLIENT);
            if (this.soundDelay <= 0 && this.type.idleSound != null) {
                PacketPlaySound.sendSoundPacket(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 50.0, entity.field_71093_bK, this.type.idleSound, false);
                this.soundDelay = this.type.idleSoundLength;
            }
            if (this.type.deployable) {
                return;
            }
            if (mc.field_71476_x != null && (mc.field_71476_x.field_72308_g instanceof EntityFlagpole || mc.field_71476_x.field_72308_g instanceof EntityFlag || mc.field_71476_x.field_72308_g instanceof EntityGunItem || mc.field_71476_x.field_72308_g instanceof EntityGrenade && ((EntityGrenade)mc.field_71476_x.field_72308_g).type.isDeployableBag)) {
                return;
            }
            if (hasOffHand && !this.type.oneHanded) {
                return;
            }
            secondaryFunctionsEnabled = true;
            if (!this.type.usableByPlayers) break block37;
            needsToReload = this.needsToReload(gunstack);
            shouldShootThisTick = false;
            switch (1.$SwitchMap$com$flansmod$common$guns$EnumFireMode[this.type.getFireMode(gunstack).ordinal()]) {
                case 1: {
                    if (data.GetBurstRoundsRemaining(hand) > 0) {
                        shouldShootThisTick = true;
                    }
                }
                case 2: {
                    if (ItemGun.GetMouseHeld(hand) && !ItemGun.GetLastMouseHeld(hand)) {
                        shouldShootThisTick = true;
                        break;
                    }
                    needsToReload = false;
                    break;
                }
                case 3: {
                    if (needsToReload) {
                        needsToReload = ItemGun.GetMouseHeld(hand);
                        break;
                    }
                    if (!ItemGun.GetMouseHeld(hand)) ** GOTO lbl41
                    data.minigunSpeed += 2.0f;
                    data.minigunSpeed *= 0.9f;
                    if (data.minigunSpeed < this.type.minigunStartSpeed) {
                        if (!this.type.useLoopingSounds) break;
                        data.shouldPlayWarmupSound = true;
                        break;
                    }
                    ** GOTO lbl43
lbl41:
                    // 1 sources

                    if (data.minigunSpeed > 0.0f) {
                        data.shouldPlayCooldownSound = true;
                    }
                }
lbl43:
                // 5 sources

                case 4: {
                    shouldShootThisTick = ItemGun.GetMouseHeld(hand);
                    if (shouldShootThisTick) break;
                    needsToReload = false;
                    break;
                }
                default: {
                    needsToReload = false;
                }
            }
            if (needsToReload) {
                if (this.Reload(gunstack, world, (Entity)player, (IInventory)player.field_71071_by, hand, hasOffHand, false, player.field_71075_bZ.field_75098_d)) {
                    data.shootTimeRight = data.shootTimeLeft = (float)((int)this.type.getReloadTime(gunstack));
                    animations = FlansModClient.getGunAnimations((EntityLivingBase)player, hand);
                    pumpDelay = this.type.model == null ? 0 : this.type.model.pumpDelayAfterReload;
                    pumpTime = this.type.model == null ? 1 : this.type.model.pumpTime;
                    animations.doReload(this.type.reloadTime, pumpDelay, pumpTime);
                    if (hand == EnumHand.OFF_HAND) {
                        data.reloadingLeft = true;
                        data.burstRoundsRemainingLeft = 0;
                    } else {
                        data.reloadingRight = true;
                        data.burstRoundsRemainingRight = 0;
                    }
                    FlansMod.getPacketHandler().sendToServer(new PacketReload(hand, false));
                }
            } else if (shouldShootThisTick) {
                animations = FlansModClient.getGunAnimations((EntityLivingBase)player, hand);
                animations.lookAt = GunAnimations.LookAtState.NONE;
                shootTime = data.GetShootTime(hand);
                while (shootTime <= 0.0f) {
                    shootTime += this.type.GetShootDelay(gunstack);
                    shootableStack = this.getBestNonEmptyShootableStack(gunstack);
                    if (shootableStack == null || shootableStack.func_190926_b()) continue;
                    shootableItem = (ItemShootable)shootableStack.func_77973_b();
                    shootableType = shootableItem.type;
                    if (this.type.bulletSpeed == 0.0f) {
                        for (i = 0; i < this.type.numBullets * shootableType.numBullets; ++i) {
                            rayTraceOrigin = new Vector3f(player.func_174824_e(0.0f));
                            rayTraceDirection = new Vector3f(player.func_70040_Z());
                            spread = 0.0025f * this.type.getSpread(gunstack) * shootableType.bulletSpread;
                            rayTraceDirection.x += (float)world.field_73012_v.nextGaussian() * spread;
                            rayTraceDirection.y += (float)world.field_73012_v.nextGaussian() * spread;
                            rayTraceDirection.z += (float)world.field_73012_v.nextGaussian() * spread;
                            rayTraceDirection.scale(500.0f);
                            hits = FlansModRaytracer.Raytrace(world, (Entity)player, false, null, rayTraceOrigin, rayTraceDirection, 0);
                            victim = null;
                            hitPos = Vector3f.add(rayTraceOrigin, rayTraceDirection, null);
                            firstHit = null;
                            if (!hits.isEmpty()) {
                                firstHit = hits.get(0);
                                hitPos = Vector3f.add(rayTraceOrigin, (Vector3f)rayTraceDirection.scale(firstHit.intersectTime), null);
                                victim = firstHit.GetEntity();
                            }
                            gunOrigin = FlansModRaytracer.GetPlayerMuzzlePosition(player, hand);
                            if (FlansMod.DEBUG) {
                                world.func_72838_d((Entity)new EntityDebugDot(world, gunOrigin, 100, 1.0f, 1.0f, 1.0f));
                            }
                            silenced = this.type.getBarrel(gunstack) != null && this.type.getBarrel((ItemStack)gunstack).silencer != false;
                            shotData = new ShotData.InstantShotData(gunSlot, hand, (InfoType)this.type, shootableType, (Entity)player, gunOrigin, firstHit, hitPos, this.type.getDamage(gunstack), i < this.type.numBullets * shootableType.numBullets - 1, silenced);
                            ItemGun.shotsFiredClient.add(shotData);
                        }
                    } else {
                        shotData = new ShotData.SpawnEntityShotData(gunSlot, hand, (InfoType)this.type, shootableType, (Entity)player, new Vector3f(player.func_70040_Z()));
                        ItemGun.shotsFiredClient.add(shotData);
                    }
                    pumpDelay = this.type.model == null ? 0 : this.type.model.pumpDelay;
                    pumpTime = this.type.model == null ? 1 : this.type.model.pumpTime;
                    animations.doShoot(pumpDelay, pumpTime);
                    FlansModClient.playerRecoil += this.type.getRecoil(gunstack);
                    animations.recoil += this.type.getRecoil(gunstack);
                    if (this.type.consumeGunUponUse) {
                        player.field_71071_by.func_70299_a(gunSlot, ItemStack.field_190927_a.func_77946_l());
                    }
                    if (this.type.getFireMode(gunstack) != EnumFireMode.BURST) continue;
                    burstRoundsRemaining = data.GetBurstRoundsRemaining(hand);
                    burstRoundsRemaining = burstRoundsRemaining > 0 ? --burstRoundsRemaining : this.type.numBurstRounds;
                    data.SetBurstRoundsRemaining(hand, burstRoundsRemaining);
                }
                data.SetShootTime(hand, shootTime);
            }
            gunOrigin = FlansModRaytracer.GetPlayerMuzzlePosition(player, hand);
            if (FlansMod.DEBUG) {
                world.func_72838_d((Entity)new EntityDebugDot(world, gunOrigin, 100, 1.0f, 1.0f, 1.0f));
            }
            if (!ItemGun.shotsFiredClient.isEmpty() && player.field_70173_aa % 1 == 0) {
                FlansMod.getPacketHandler().sendToServer(new PacketShotData(ItemGun.shotsFiredClient));
                ItemGun.shotsFiredClient.clear();
            }
            currentScope = this.type.getCurrentScope(gunstack);
            if (!hasOffHand) {
                switch (1.$SwitchMap$net$minecraft$util$EnumHand[hand.ordinal()]) {
                    case 1: {
                        if (!ItemGun.GetMouseHeld(EnumHand.OFF_HAND) || ItemGun.GetLastMouseHeld(EnumHand.OFF_HAND) || this.type.secondaryFunction != EnumSecondaryFunction.ADS_ZOOM && this.type.secondaryFunction != EnumSecondaryFunction.ZOOM) break;
                        FlansModClient.SetScope(currentScope);
                        break;
                    }
                    case 2: {
                        if (!ItemGun.GetMouseHeld(EnumHand.MAIN_HAND) || ItemGun.GetLastMouseHeld(EnumHand.MAIN_HAND) || this.type.secondaryFunction != EnumSecondaryFunction.ADS_ZOOM && this.type.secondaryFunction != EnumSecondaryFunction.ZOOM) break;
                        FlansModClient.SetScope(currentScope);
                    }
                }
            }
        }
        if (this.soundDelay > 0) {
            --this.soundDelay;
        }
    }

    public void ServerHandleShotData(ItemStack gunstack, int gunSlot, World world, Entity entity, boolean isOffHand, ShotData shotData) {
        int bulletID;
        if (!(entity instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)entity;
        PlayerData data = PlayerHandler.getPlayerData((EntityPlayer)player, Side.SERVER);
        if (data == null) {
            return;
        }
        boolean isExtraBullet = shotData instanceof ShotData.InstantShotData ? ((ShotData.InstantShotData)shotData).isExtraBullet : false;
        ItemStack bulletStack = ItemStack.field_190927_a.func_77946_l();
        for (bulletID = 0; bulletID < this.type.numAmmoItemsInGun; ++bulletID) {
            ItemStack checkingStack = this.getBulletItemStack(gunstack, bulletID);
            if (checkingStack == null || checkingStack.func_77973_b() == null || checkingStack.func_77952_i() >= checkingStack.func_77958_k()) continue;
            bulletStack = checkingStack;
            break;
        }
        if (bulletStack.func_190926_b()) {
            return;
        }
        if (bulletStack.func_77973_b() instanceof ItemShootable) {
            ShootableType bullet = ((ItemShootable)bulletStack.func_77973_b()).type;
            if (!isExtraBullet) {
                if (bullet.dropItemOnShoot != null && !player.field_71075_bZ.field_75098_d) {
                    ItemGun.dropItem(world, (Entity)player, bullet.dropItemOnShoot);
                }
                if (this.type.dropItemOnShoot != null) {
                    ItemGun.dropItem(world, (Entity)player, this.type.dropItemOnShoot);
                }
                if (this.type.knockback > 0.0f) {
                    // empty if block
                }
                bulletStack.func_77964_b(bulletStack.func_77952_i() + 1);
                this.setBulletItemStack(gunstack, bulletStack, bulletID);
                if (this.type.consumeGunUponUse && gunSlot != -1) {
                    player.field_71071_by.func_70299_a(gunSlot, ItemStack.field_190927_a.func_77946_l());
                }
            }
            if (shotData instanceof ShotData.SpawnEntityShotData) {
                if (this.soundDelay <= 0 && this.type.shootSound != null) {
                    AttachmentType barrel = this.type.getBarrel(gunstack);
                    boolean silenced = barrel != null && barrel.silencer;
                    PacketPlaySound.sendSoundPacket(player.field_70165_t, player.field_70163_u, player.field_70161_v, 50.0, player.field_71093_bK, this.type.shootSound, this.type.distortSound, silenced);
                    this.soundDelay = this.type.shootSoundLength;
                }
                for (int k = 0; k < this.type.numBullets * bullet.numBullets; ++k) {
                    ((ItemShootable)bulletStack.func_77973_b()).Shoot(world, new Vector3f(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v), new Vector3f(player.func_70040_Z()), this.type.getDamage(gunstack), (player.func_70093_af() ? 0.7f : 1.0f) * this.type.getSpread(gunstack) * bullet.bulletSpread, this.type.getBulletSpeed(gunstack), this.type, (EntityLivingBase)player);
                }
            } else if (shotData instanceof ShotData.InstantShotData) {
                ShotData.InstantShotData instantData = (ShotData.InstantShotData)shotData;
                AttachmentType barrel = this.type.getBarrel(gunstack);
                boolean silenced = barrel != null && barrel.silencer;
                this.DoInstantShot(world, (Entity)player, this.type, (BulletType)bullet, instantData.origin, instantData.hitPos, instantData.hitData, this.type.getDamage(gunstack), isExtraBullet, silenced);
                shotsFiredServer.add(shotData);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void PlayShotSound(World world, boolean silenced, float x, float y, float z) {
        FMLClientHandler.instance().getClient().func_147118_V().func_147682_a((ISound)new PositionedSoundRecord(FlansModResourceHandler.getSoundEvent(this.type.shootSound), SoundCategory.PLAYERS, silenced ? 5.0f : 10.0f, (this.type.distortSound ? 1.0f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f) : 1.0f) * (silenced ? 2.0f : 1.0f), x, y, z));
    }

    public void DoInstantShot(World world, Entity shooter, InfoType shotFrom, BulletType shotType, Vector3f origin, Vector3f hit, FlansModRaytracer.BulletHit hitData, float damage, boolean isExtraBullet, boolean silenced) {
        if (EntityBullet.OnHit(world, origin, hit, shooter, shotFrom, shotType, null, damage, hitData)) {
            EntityBullet.OnDetonate(world, hit, shooter, null, shotFrom, shotType);
        }
        if (world.field_72995_K) {
            if (!isExtraBullet && this.soundDelay <= 0 && this.type.shootSound != null && shooter != null) {
                this.PlayShotSound(world, silenced, (float)shooter.field_70165_t, (float)shooter.field_70163_u, (float)shooter.field_70161_v);
                this.soundDelay = this.type.shootSoundLength;
            }
            if (FlansMod.DEBUG) {
                world.func_72838_d((Entity)new EntityDebugVector(world, origin, Vector3f.sub(hit, origin, null), 100, 0.5f, 0.5f, 1.0f));
            }
            InstantBulletRenderer.AddTrail(new InstantBulletRenderer.InstantShotTrail(origin, hit, shotType));
            if (hitData instanceof FlansModRaytracer.BlockHit) {
                double motionZ;
                double motionY;
                double motionX;
                FlansModRaytracer.BlockHit blockHit = (FlansModRaytracer.BlockHit)hitData;
                BlockPos blockPos = blockHit.raytraceResult.func_178782_a();
                IBlockState blockState = world.func_180495_p(blockHit.raytraceResult.func_178782_a());
                Vec3i normal = blockHit.raytraceResult.field_178784_b.func_176730_m();
                Vector3f bulletDir = Vector3f.sub(hit, origin, null);
                bulletDir.normalise();
                bulletDir.scale(0.5f);
                if (blockState != null) {
                    for (int i = 0; i < 2; ++i) {
                        float scale = (float)world.field_73012_v.nextGaussian() * 0.1f + 0.5f;
                        motionX = (double)normal.func_177958_n() * (double)scale + world.field_73012_v.nextGaussian() * 0.025;
                        motionY = (double)normal.func_177956_o() * (double)scale + world.field_73012_v.nextGaussian() * 0.025;
                        motionZ = (double)normal.func_177952_p() * (double)scale + world.field_73012_v.nextGaussian() * 0.025;
                        Minecraft.func_71410_x().field_71452_i.func_178927_a(EnumParticleTypes.BLOCK_CRACK.func_179348_c(), (double)hit.x, (double)hit.y, (double)hit.z, motionX += (double)bulletDir.x, motionY += (double)bulletDir.y, motionZ += (double)bulletDir.z, new int[]{Block.func_149682_b((Block)blockState.func_177230_c())});
                    }
                }
                double scale = world.field_73012_v.nextGaussian() * 0.05 + 0.05;
                motionX = (double)normal.func_177958_n() * scale + world.field_73012_v.nextGaussian() * 0.025;
                motionY = (double)normal.func_177956_o() * scale + world.field_73012_v.nextGaussian() * 0.025;
                motionZ = (double)normal.func_177952_p() * scale + world.field_73012_v.nextGaussian() * 0.025;
                Particle particle = Minecraft.func_71410_x().field_71452_i.func_178927_a(EnumParticleTypes.CLOUD.func_179348_c(), (double)hit.x, (double)hit.y, (double)hit.z, motionX, motionY, motionZ, new int[0]);
            }
            if (world.field_72995_K && shooter == Minecraft.func_71410_x().field_71439_g) {
                if (hitData instanceof FlansModRaytracer.EntityHit || hitData instanceof FlansModRaytracer.DriveableHit) {
                    FlansModClient.AddHitMarker();
                } else if (hitData instanceof FlansModRaytracer.PlayerBulletHit) {
                    if (FlansModClient.teamInfo != null) {
                        Team shooterTeam = FlansModClient.teamInfo.getTeam((EntityPlayer)shooter);
                        Team victimTeam = FlansModClient.teamInfo.getTeam(((FlansModRaytracer.PlayerBulletHit)hitData).hitbox.player);
                        if (shooterTeam == null || shooterTeam != victimTeam) {
                            FlansModClient.AddHitMarker();
                        }
                    } else {
                        FlansModClient.AddHitMarker();
                    }
                }
            }
        }
    }

    public void onUpdateServer(ItemStack itemstack, int gunSlot, World world, Entity entity, EnumHand hand, boolean hasOffHand) {
        if (!(entity instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)entity;
        PlayerData data = PlayerHandler.getPlayerData((EntityPlayer)player);
        if (data == null) {
            return;
        }
        if (player.field_71071_by.func_70448_g() != itemstack) {
            if (player.field_71071_by.func_70448_g() == null || player.field_71071_by.func_70448_g().func_77973_b() == null || !(player.field_71071_by.func_70448_g().func_77973_b() instanceof ItemGun)) {
                data.isShootingLeft = false;
                data.isShootingRight = false;
            }
            return;
        }
        if (!shotsFiredServer.isEmpty()) {
            FlansMod.getPacketHandler().sendToDimension(new PacketShotData(shotsFiredServer), player.field_71093_bK);
            shotsFiredServer.clear();
        }
    }

    public void func_77663_a(ItemStack itemstack, World world, Entity entity, int i, boolean flag) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            EnumHand hand = EnumHand.MAIN_HAND;
            if (itemstack == player.func_184614_ca()) {
                hand = EnumHand.MAIN_HAND;
            } else if (itemstack == player.func_184592_cb()) {
                hand = EnumHand.OFF_HAND;
            } else {
                return;
            }
            if (world.field_72995_K && Minecraft.func_71410_x().field_71462_r == null) {
                lastRightMouseHeld = rightMouseHeld;
                lastLeftMouseHeld = leftMouseHeld;
                rightMouseHeld = Mouse.isButtonDown((int)1);
                leftMouseHeld = Mouse.isButtonDown((int)0);
            }
            ItemStack main = player.func_184614_ca();
            ItemStack off = player.func_184592_cb();
            boolean hasOffHand = main != null && !main.func_190926_b() && off != null && !off.func_190926_b();
            this.onUpdateEach(itemstack, i, world, entity, hand, hasOffHand);
        }
    }

    private void onUpdateEach(ItemStack itemstack, int gunSlot, World world, Entity entity, EnumHand hand, boolean hasOffHand) {
        if (world.field_72995_K) {
            this.onUpdateClient(itemstack, gunSlot, world, entity, hand, hasOffHand);
        } else {
            this.onUpdateServer(itemstack, gunSlot, world, entity, hand, hasOffHand);
        }
    }

    public boolean Reload(ItemStack gunstack, World world, Entity entity, IInventory inventory, EnumHand hand, boolean hasOffHand, boolean forceReload, boolean isCreative) {
        if (this.type.deployable) {
            return false;
        }
        if (forceReload && !this.type.canForceReload) {
            return false;
        }
        boolean reloadedSomething = false;
        for (int i = 0; i < this.type.numAmmoItemsInGun; ++i) {
            ItemStack bulletStack = this.getBulletItemStack(gunstack, i);
            if (bulletStack != null && !bulletStack.func_190926_b() && bulletStack.func_77952_i() != bulletStack.func_77958_k() && !forceReload) continue;
            int bestSlot = -1;
            int bulletsInBestSlot = 0;
            for (int j = 0; j < inventory.func_70302_i_(); ++j) {
                int bulletsInThisSlot;
                ItemStack item = inventory.func_70301_a(j);
                if (item == null || !(item.func_77973_b() instanceof ItemShootable) || !this.type.isAmmo(((ItemShootable)item.func_77973_b()).type) || (bulletsInThisSlot = item.func_77958_k() - item.func_77952_i()) <= bulletsInBestSlot) continue;
                bestSlot = j;
                bulletsInBestSlot = bulletsInThisSlot;
            }
            if (bestSlot == -1) continue;
            ItemStack newBulletStack = inventory.func_70301_a(bestSlot);
            ShootableType newBulletType = ((ItemShootable)newBulletStack.func_77973_b()).type;
            if (bulletStack != null && bulletStack.func_77973_b() instanceof ItemShootable && ((ItemShootable)bulletStack.func_77973_b()).type.dropItemOnReload != null && !isCreative && bulletStack.func_77952_i() == bulletStack.func_77958_k() && !world.field_72995_K) {
                ItemGun.dropItem(world, entity, ((ItemShootable)bulletStack.func_77973_b()).type.dropItemOnReload);
            }
            if (!(bulletStack == null || bulletStack.func_190926_b() || bulletStack.func_77952_i() >= bulletStack.func_77958_k() || InventoryHelper.addItemStackToInventory(inventory, bulletStack, isCreative) || world.field_72995_K)) {
                entity.func_70099_a(bulletStack, 0.5f);
            }
            ItemStack stackToLoad = newBulletStack.func_77946_l();
            stackToLoad.func_190920_e(1);
            this.setBulletItemStack(gunstack, stackToLoad, i);
            if (!isCreative) {
                newBulletStack.func_190920_e(newBulletStack.func_190916_E() - 1);
            }
            if (newBulletStack.func_190916_E() <= 0) {
                newBulletStack = ItemStack.field_190927_a.func_77946_l();
            }
            inventory.func_70299_a(bestSlot, newBulletStack);
            reloadedSomething = true;
        }
        return reloadedSomething;
    }

    private boolean needsToReload(ItemStack stack) {
        for (int i = 0; i < this.type.numAmmoItemsInGun; ++i) {
            ItemStack bulletStack = this.getBulletItemStack(stack, i);
            if (bulletStack == null || bulletStack.func_190926_b() || bulletStack.func_77952_i() >= bulletStack.func_77958_k()) continue;
            return false;
        }
        return true;
    }

    public boolean CanReload(ItemStack gunstack, IInventory inventory) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (!this.type.isAmmo(stack)) continue;
            return true;
        }
        return false;
    }

    private ItemStack getBestNonEmptyShootableStack(ItemStack stack) {
        for (int i = 0; i < this.type.numAmmoItemsInGun; ++i) {
            ItemStack shootableStack = this.getBulletItemStack(stack, i);
            if (shootableStack == null || shootableStack.func_190926_b() || shootableStack.func_77952_i() >= shootableStack.func_77958_k()) continue;
            return shootableStack;
        }
        return null;
    }

    public void func_77624_a(ItemStack stack, World world, List<String> lines, ITooltipFlag b) {
        if (this.type.description != null) {
            Collections.addAll(lines, this.type.description.split("_"));
        }
        if (this.type.showDamage) {
            lines.add("\u00a79Damage\u00a77: " + this.type.getDamage(stack));
        }
        if (this.type.showRecoil) {
            lines.add("\u00a79Recoil\u00a77: " + this.type.getRecoil(stack));
        }
        if (this.type.showSpread) {
            lines.add("\u00a79Accuracy\u00a77: " + this.type.getSpread(stack));
        }
        if (this.type.showReloadTime) {
            lines.add("\u00a79Reload Time\u00a77: " + this.type.getReloadTime(stack) / 20.0f + "s");
        }
        for (AttachmentType attachment : this.type.getCurrentAttachments(stack)) {
            if (!this.type.showAttachments) continue;
            String line = attachment.name;
            lines.add(line);
        }
        for (int i = 0; i < this.type.numAmmoItemsInGun; ++i) {
            ItemStack bulletStack = this.getBulletItemStack(stack, i);
            if (bulletStack == null || !(bulletStack.func_77973_b() instanceof ItemBullet)) continue;
            BulletType bulletType = ((ItemBullet)bulletStack.func_77973_b()).type;
            String line = bulletType.name + " " + (bulletStack.func_77958_k() - bulletStack.func_77952_i()) + "/" + bulletStack.func_77958_k();
            lines.add(line);
        }
    }

    public boolean func_77651_p() {
        return true;
    }

    public DamageSource getMeleeDamage(EntityPlayer attacker) {
        return new EntityDamageSourceGun(this.type.shortName, (Entity)attacker, attacker, this.type, false);
    }

    private boolean isSolid(World world, int i, int j, int k) {
        IBlockState state = world.func_180495_p(new BlockPos(i, j, k));
        if (state == null) {
            return false;
        }
        return state.func_185904_a().func_76220_a() && state.func_185914_p();
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        return this.type.secondaryFunction != EnumSecondaryFunction.MELEE;
    }

    public boolean func_77662_d() {
        return true;
    }

    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack stack) {
        if (this.type.meleeSound != null) {
            PacketPlaySound.sendSoundPacket(entityLiving.field_70165_t, entityLiving.field_70163_u, entityLiving.field_70161_v, 50.0, entityLiving.field_71093_bK, this.type.meleeSound, true);
        }
        if (this.type.secondaryFunction == EnumSecondaryFunction.CUSTOM_MELEE) {
            if (entityLiving.field_70170_p.field_72995_K) {
                GunAnimations animations = FlansModClient.getGunAnimations(entityLiving, EnumHand.MAIN_HAND);
                animations.doMelee(this.type.meleeTime);
            }
            if (entityLiving instanceof EntityPlayer) {
                PlayerData data = PlayerHandler.getPlayerData((EntityPlayer)entityLiving);
                data.doMelee((EntityPlayer)entityLiving, this.type.meleeTime, this.type);
            }
        }
        return this.type.secondaryFunction != EnumSecondaryFunction.MELEE;
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, EntityPlayer player) {
        return true;
    }

    public boolean canHarvestBlock(IBlockState state, ItemStack stack) {
        return false;
    }

    public boolean isItemStackDamageable() {
        return true;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (tab != FlansMod.tabFlanGuns && tab != CreativeTabs.field_78027_g) {
            return;
        }
        PaintableType type = this.GetPaintableType();
        if (FlansMod.addAllPaintjobsToCreative) {
            for (Paintjob paintjob : type.paintjobs) {
                this.addPaintjobToList(this, type, paintjob, (List)items);
            }
        } else {
            this.addPaintjobToList(this, type, type.defaultPaintjob, (List)items);
        }
    }

    private void addPaintjobToList(Item item, PaintableType type, Paintjob paintjob, List list) {
        ItemStack paintableStack = new ItemStack(item, 1, paintjob.ID);
        NBTTagCompound tags = new NBTTagCompound();
        paintableStack.func_77982_d(tags);
        list.add(paintableStack);
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 100;
    }

    public EnumAction func_77661_b(ItemStack par1ItemStack) {
        return EnumAction.BOW;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(slot, stack);
        if (slot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111266_c.func_111108_a(), (Object)new AttributeModifier(KNOCKBACK_RESIST_MODIFIER, "KnockbackResist", (double)this.type.knockbackModifier, 0));
            multimap.put((Object)SharedMonsterAttributes.field_111263_d.func_111108_a(), (Object)new AttributeModifier(MOVEMENT_SPEED_MODIFIER, "MovementSpeed", (double)(this.type.moveSpeedModifier - 1.0f), 2));
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.type.meleeDamage, 0));
        }
        return multimap;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    public boolean func_82788_x() {
        return false;
    }

    static {
        shotsFiredClient = new ArrayList<ShotData>();
        shotsFiredServer = new ArrayList<ShotData>();
        KNOCKBACK_RESIST_MODIFIER = UUID.fromString("77777777-645C-4F38-A497-9C13A33DB5CF");
        MOVEMENT_SPEED_MODIFIER = UUID.fromString("99999999-4180-4865-B01B-BCCE9785ACA3");
    }
}

