/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.driveables.mechas;

import com.flansmod.client.debug.EntityDebugVector;
import com.flansmod.client.gui.GuiDriveableController;
import com.flansmod.client.model.GunAnimations;
import com.flansmod.common.FlansMod;
import com.flansmod.common.RotatedAxes;
import com.flansmod.common.driveables.DriveableData;
import com.flansmod.common.driveables.DriveablePart;
import com.flansmod.common.driveables.DriveableType;
import com.flansmod.common.driveables.EntityDriveable;
import com.flansmod.common.driveables.EntitySeat;
import com.flansmod.common.driveables.EnumDriveablePart;
import com.flansmod.common.driveables.mechas.EnumMechaSlotType;
import com.flansmod.common.driveables.mechas.ItemMechaAddon;
import com.flansmod.common.driveables.mechas.MechaInventory;
import com.flansmod.common.driveables.mechas.MechaItemType;
import com.flansmod.common.driveables.mechas.MechaType;
import com.flansmod.common.guns.EnumFireMode;
import com.flansmod.common.guns.GunType;
import com.flansmod.common.guns.InventoryHelper;
import com.flansmod.common.guns.ItemBullet;
import com.flansmod.common.guns.ItemGun;
import com.flansmod.common.guns.ItemShootable;
import com.flansmod.common.guns.ShootableType;
import com.flansmod.common.network.PacketDriveableDamage;
import com.flansmod.common.network.PacketDriveableGUI;
import com.flansmod.common.network.PacketDriveableKey;
import com.flansmod.common.network.PacketMechaControl;
import com.flansmod.common.network.PacketPlaySound;
import com.flansmod.common.teams.TeamsManager;
import com.flansmod.common.tools.ItemTool;
import com.flansmod.common.types.InfoType;
import com.flansmod.common.vector.Vector3f;
import com.flansmod.common.vector.Vector3i;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityMecha
extends EntityDriveable {
    private int ticksSinceUsed;
    public int toggleTimer = 0;
    protected float moveX = 0.0f;
    protected float moveZ = 0.0f;
    public RotatedAxes legAxes;
    public float prevLegsYaw = 0.0f;
    private int jumpDelay = 0;
    public MechaInventory inventory;
    public float legSwing = 0.0f;
    public float shootDelayLeft = 0.0f;
    public float shootDelayRight = 0.0f;
    public int soundDelayLeft = 0;
    public int soundDelayRight = 0;
    public Vector3i breakingBlock = null;
    public float breakingProgress = 0.0f;
    private float rocketTimer = 0.0f;
    private int diamondTimer = 0;
    public GunAnimations leftAnimations = new GunAnimations();
    public GunAnimations rightAnimations = new GunAnimations();
    boolean couldNotFindFuel;
    public EntityPlayer placer;
    public float yOffset;

    public EntityMecha(World world) {
        super(world);
        this.func_70105_a(2.0f, 3.0f);
        this.field_70138_W = 3.0f;
        this.legAxes = new RotatedAxes();
        this.inventory = new MechaInventory(this);
    }

    public EntityMecha(World world, double x, double y, double z, MechaType type, DriveableData data, NBTTagCompound tags) {
        super(world, type, data);
        this.legAxes = new RotatedAxes();
        this.func_70105_a(2.0f, 3.0f);
        this.field_70138_W = 3.0f;
        this.func_70107_b(x, y, z);
        this.initType(type, true, false);
        this.inventory = new MechaInventory(this, tags);
    }

    public EntityMecha(World world, double x, double y, double z, EntityPlayer placer, MechaType type, DriveableData data, NBTTagCompound tags) {
        this(world, x, y, z, type, data, tags);
        this.rotateYaw(placer.field_70177_z + 90.0f);
        this.legAxes.rotateGlobalYaw(placer.field_70177_z + 90.0f);
        this.prevLegsYaw = this.legAxes.getYaw();
        this.placer = placer;
    }

    @Override
    protected void initType(DriveableType type, boolean firstTime, boolean clientSide) {
        super.initType(type, firstTime, clientSide);
        this.func_70105_a(((MechaType)type).width, ((MechaType)type).height);
        this.field_70138_W = ((MechaType)type).stepHeight;
    }

    @Override
    protected void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74776_a("LegsYaw", this.legAxes.getYaw());
        tag.func_74782_a("Inventory", (NBTBase)this.inventory.writeToNBT(new NBTTagCompound()));
    }

    @Override
    protected void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        this.legAxes.setAngles(tag.func_74760_g("LegsYaw"), 0.0f, 0.0f);
        this.inventory.readFromNBT(tag.func_74775_l("Inventory"));
    }

    @Override
    public void writeSpawnData(ByteBuf data) {
        super.writeSpawnData(data);
        ByteBufUtils.writeTag((ByteBuf)data, (NBTTagCompound)this.inventory.writeToNBT(new NBTTagCompound()));
    }

    @Override
    public void readSpawnData(ByteBuf data) {
        super.readSpawnData(data);
        this.legAxes.rotateGlobalYaw(this.axes.getYaw());
        this.prevLegsYaw = this.legAxes.getYaw();
        this.inventory.readFromNBT(ByteBufUtils.readTag((ByteBuf)data));
    }

    @Override
    public double func_70033_W() {
        return this.yOffset;
    }

    @Override
    public void onMouseMoved(int deltaX, int deltaY) {
    }

    public boolean func_184230_a(EntityPlayer entityplayer, EnumHand hand) {
        if (this.field_70128_L) {
            return false;
        }
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        ItemStack currentItem = entityplayer.func_184614_ca();
        if (currentItem != null && currentItem.func_77973_b() instanceof ItemTool && ((ItemTool)currentItem.func_77973_b()).type.healDriveables) {
            return true;
        }
        MechaType type = this.getMechaType();
        for (int i = 0; i <= type.numPassengers; ++i) {
            if (this.getSeat(i) == null || !this.getSeat(i).func_184230_a(entityplayer, hand)) continue;
            return true;
        }
        return false;
    }

    public MechaType getMechaType() {
        return MechaType.getMecha(this.driveableType);
    }

    @Override
    public boolean pressKey(int key, EntityPlayer player) {
        MechaType type = this.getMechaType();
        DriveableData data = this.getDriveableData();
        if (this.field_70170_p.field_72995_K && (key == 6 || key == 8 || key == 9)) {
            FlansMod.getPacketHandler().sendToServer(new PacketDriveableKey(key));
            return true;
        }
        switch (key) {
            case 0: {
                return true;
            }
            case 1: {
                return true;
            }
            case 2: {
                return true;
            }
            case 3: {
                return true;
            }
            case 4: {
                boolean canThrustCreatively;
                boolean bl = canThrustCreatively = this.getSeat(0) != null && this.getSeat(0).func_184179_bs() instanceof EntityPlayer && ((EntityPlayer)this.getSeat((int)0).func_184179_bs()).field_71075_bZ.field_75098_d;
                if (this.field_70122_E && this.jumpDelay == 0 && (canThrustCreatively || data.fuelInTank > data.engine.fuelConsumption) && this.isPartIntact(EnumDriveablePart.hips)) {
                    this.jumpDelay = 20;
                    this.field_70181_x += (double)type.jumpVelocity;
                    if (!canThrustCreatively) {
                        data.fuelInTank -= data.engine.fuelConsumption;
                    }
                }
                return true;
            }
            case 5: {
                return true;
            }
            case 6: {
                this.getSeat(0).func_184226_ay();
                return true;
            }
            case 7: {
                FlansMod.getPacketHandler().sendToServer(new PacketDriveableGUI(4));
                ((EntityPlayer)this.getSeat(0).func_184179_bs()).openGui((Object)FlansMod.INSTANCE, 10, this.field_70170_p, this.field_70176_ah, this.field_70162_ai, this.field_70164_aj);
                return true;
            }
            case 8: {
                return true;
            }
            case 9: {
                return true;
            }
            case 10: {
                return true;
            }
            case 11: {
                return true;
            }
            case 12: {
                return true;
            }
            case 13: {
                return true;
            }
            case 14: {
                return true;
            }
            case 15: {
                return true;
            }
            case 16: {
                return true;
            }
            case 17: {
                return true;
            }
        }
        return false;
    }

    protected boolean creative() {
        return !(this.getSeat(0).func_184179_bs() instanceof EntityPlayer) || ((EntityPlayer)this.getSeat((int)0).func_184179_bs()).field_71075_bZ.field_75098_d;
    }

    protected boolean useItem(boolean left) {
        if (left ? this.isPartIntact(EnumDriveablePart.leftArm) : this.isPartIntact(EnumDriveablePart.rightArm)) {
            ItemStack heldStack;
            ItemStack itemStack = heldStack = left ? this.inventory.getStackInSlot(EnumMechaSlotType.leftTool) : this.inventory.getStackInSlot(EnumMechaSlotType.rightTool);
            if (heldStack == null || heldStack.func_190926_b()) {
                return false;
            }
            Item heldItem = heldStack.func_77973_b();
            MechaType mechaType = this.getMechaType();
            if (heldItem instanceof ItemMechaAddon) {
                MechaItemType toolType = ((ItemMechaAddon)heldItem).type;
                float reach = toolType.reach * mechaType.reach;
                Vector3f lookOrigin = new Vector3f((double)((float)mechaType.seats[0].x / 16.0f), (double)((float)mechaType.seats[0].y / 16.0f) + this.getSeat(0).func_184179_bs().func_70042_X(), (double)((float)mechaType.seats[0].z / 16.0f));
                lookOrigin = this.axes.findLocalVectorGlobally(lookOrigin);
                Vector3f.add(lookOrigin, new Vector3f(this.field_70165_t, this.field_70163_u, this.field_70161_v), lookOrigin);
                Vector3f lookVector = this.axes.findLocalVectorGlobally(this.getSeat((int)0).looking.findLocalVectorGlobally(new Vector3f(reach, 0.0f, 0.0f)));
                if (FlansMod.DEBUG && this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_72838_d((Entity)new EntityDebugVector(this.field_70170_p, lookOrigin, lookVector, 20));
                }
                Vector3f lookTarget = Vector3f.add(lookVector, lookOrigin, null);
                RayTraceResult hit = this.field_70170_p.func_72933_a(lookOrigin.toVec3(), lookTarget.toVec3());
                if (hit != null && hit.field_72313_a == RayTraceResult.Type.BLOCK) {
                    BlockPos pos = hit.func_178782_a();
                    if (this.breakingBlock == null || this.breakingBlock.x != pos.func_177958_n() || this.breakingBlock.y != pos.func_177956_o() || this.breakingBlock.z != pos.func_177952_p()) {
                        this.breakingProgress = 0.0f;
                    }
                    this.breakingBlock = new Vector3i(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
            } else if (heldItem instanceof ItemGun) {
                float delay;
                ItemGun gunItem = (ItemGun)heldItem;
                GunType gunType = gunItem.GetType();
                float f = delay = left ? this.shootDelayLeft : this.shootDelayRight;
                if (delay <= 0.0f) {
                    int bulletID;
                    ItemStack bulletStack = null;
                    for (bulletID = 0; bulletID < gunType.numAmmoItemsInGun; ++bulletID) {
                        ItemStack checkingStack = gunItem.getBulletItemStack(heldStack, bulletID);
                        if (checkingStack == null || checkingStack.func_190926_b() || checkingStack.func_77952_i() >= checkingStack.func_77958_k()) continue;
                        bulletStack = checkingStack;
                        break;
                    }
                    if (bulletStack == null || bulletStack.func_190926_b()) {
                        gunItem.Reload(heldStack, this.field_70170_p, this, this.driveableData, left ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND, true, true, this.infiniteAmmo() || this.creative());
                    } else if (bulletStack.func_77973_b() instanceof ItemBullet) {
                        this.shoot(heldStack, gunType, bulletStack, this.creative(), left);
                        if (this.field_70170_p.field_72995_K) {
                            int pumpTime;
                            int pumpDelay = gunType.model == null ? 0 : gunType.model.pumpDelay;
                            int n = pumpTime = gunType.model == null ? 1 : gunType.model.pumpTime;
                            if (left) {
                                this.leftAnimations.doShoot(pumpDelay, pumpTime);
                            } else {
                                this.rightAnimations.doShoot(pumpDelay, pumpTime);
                            }
                        }
                        bulletStack.func_77964_b(bulletStack.func_77952_i() + 1);
                        gunItem.setBulletItemStack(heldStack, bulletStack, bulletID);
                    }
                }
            }
        }
        return true;
    }

    private void shoot(ItemStack stack, GunType gunType, ItemStack bulletStack, boolean creative, boolean left) {
        MechaType mechaType = this.getMechaType();
        ShootableType bulletType = ((ItemShootable)bulletStack.func_77973_b()).type;
        RotatedAxes a = new RotatedAxes();
        Vector3f armVector = new Vector3f(mechaType.armLength, 0.0f, 0.0f);
        Vector3f gunVector = new Vector3f(mechaType.armLength + 1.2f * mechaType.heldItemScale, 0.5f * mechaType.heldItemScale, 0.0f);
        Vector3f armOrigin = left ? mechaType.leftArmOrigin : mechaType.rightArmOrigin;
        a.rotateGlobalYaw(this.axes.getYaw());
        armOrigin = a.findLocalVectorGlobally(armOrigin);
        a.rotateLocalPitch(-this.getSeat((int)0).looking.getPitch());
        gunVector = a.findLocalVectorGlobally(gunVector);
        armVector = a.findLocalVectorGlobally(armVector);
        Vector3f bulletOrigin = Vector3f.add(armOrigin, gunVector, null);
        bulletOrigin = Vector3f.add(new Vector3f(this.field_70165_t, this.field_70163_u, this.field_70161_v), bulletOrigin, null);
        if (!this.field_70170_p.field_72995_K) {
            for (int k = 0; k < gunType.numBullets * bulletType.numBullets; ++k) {
                float speed = gunType.getBulletSpeed(stack);
                if (speed <= 0.0f) {
                    speed = 5.0f;
                }
                this.field_70170_p.func_72838_d((Entity)((ItemShootable)bulletStack.func_77973_b()).getEntity(this.field_70170_p, bulletOrigin, armVector, (EntityLivingBase)this.getSeat(0).func_184179_bs(), gunType.getSpread(stack) / 2.0f, gunType.getDamage(stack), speed, (InfoType)mechaType));
            }
        }
        if (left) {
            this.shootDelayLeft = gunType.mode == EnumFireMode.SEMIAUTO ? Math.max(gunType.GetShootDelay(stack), 5.0f) : gunType.GetShootDelay(stack);
        } else {
            float f = this.shootDelayRight = gunType.mode == EnumFireMode.SEMIAUTO ? Math.max(gunType.GetShootDelay(stack), 5.0f) : gunType.GetShootDelay(stack);
        }
        if (bulletType.dropItemOnShoot != null && !creative) {
            ItemGun.dropItem(this.field_70170_p, this, bulletType.dropItemOnShoot);
        }
        if ((left ? this.soundDelayLeft : this.soundDelayRight) <= 0 && gunType.shootSound != null) {
            PacketPlaySound.sendSoundPacket(this.field_70165_t, this.field_70163_u, this.field_70161_v, 50.0, this.field_71093_bK, gunType.shootSound, gunType.distortSound);
            if (left) {
                this.soundDelayLeft = gunType.shootSoundLength;
            } else {
                this.soundDelayRight = gunType.shootSoundLength;
            }
        }
    }

    @Override
    public void func_180430_e(float f, float l) {
        this.func_70097_a(DamageSource.field_76379_h, f);
    }

    @Override
    public boolean func_70097_a(DamageSource damagesource, float i) {
        if (this.field_70170_p.field_72995_K || this.field_70128_L) {
            return true;
        }
        MechaType type = this.getMechaType();
        if (damagesource.func_76355_l().equals("fall")) {
            boolean takeFallDamage = type.takeFallDamage && !this.stopFallDamage();
            boolean damageBlocksFromFalling = type.damageBlocksFromFalling || this.breakBlocksUponFalling();
            boolean wouldBeNegativeDamage = !(i * type.fallDamageMultiplier * this.vulnerability() - 2.0f < 0.0f);
            float damageToInflict = takeFallDamage ? i * (type.fallDamageMultiplier * this.vulnerability()) * (float)wouldBeNegativeDamage : 0.0f;
            float blockDamageFromFalling = damageBlocksFromFalling ? i * type.blockDamageFromFalling / 10.0f : 0.0f;
            this.driveableData.parts.get((Object)EnumDriveablePart.hips).attack(damageToInflict, false);
            this.checkParts();
            FlansMod.getPacketHandler().sendToAllAround(new PacketDriveableDamage(this), this.field_70165_t, this.field_70163_u, this.field_70161_v, 200.0f, this.field_71093_bK);
            if (blockDamageFromFalling > 1.0f) {
                this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, blockDamageFromFalling, TeamsManager.explosions);
            }
        } else if (damagesource.field_76373_n.equals("player") && damagesource.func_76346_g().field_70122_E && (this.getSeat(0) == null || this.getSeat(0).func_184179_bs() == null)) {
            ItemStack mechaStack = new ItemStack(type.item, 1, this.driveableData.paintjobID);
            NBTTagCompound tags = new NBTTagCompound();
            mechaStack.func_77982_d(tags);
            this.driveableData.writeToNBT(tags);
            this.inventory.writeToNBT(tags);
            this.func_70099_a(mechaStack, 0.5f);
            this.func_70106_y();
        } else {
            this.driveableData.parts.get((Object)EnumDriveablePart.core).attack(i * this.vulnerability(), damagesource.func_76347_k());
        }
        return true;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.readyForUpdates) {
            return;
        }
        EntitySeat driverSeat = this.getSeat(0);
        if (this.jumpDelay > 0) {
            --this.jumpDelay;
        }
        if (this.shootDelayLeft > 0.0f) {
            this.shootDelayLeft -= 1.0f;
        }
        if (this.shootDelayRight > 0.0f) {
            this.shootDelayRight -= 1.0f;
        }
        if (this.soundDelayLeft > 0) {
            --this.soundDelayLeft;
        }
        if (this.soundDelayRight > 0) {
            --this.soundDelayRight;
        }
        if (!(this.field_70170_p.field_72995_K || driverSeat != null && driverSeat.func_184179_bs() != null)) {
            this.leftMouseHeld = false;
            this.rightMouseHeld = false;
        }
        this.leftAnimations.update();
        this.rightAnimations.update();
        MechaType type = this.getMechaType();
        DriveableData data = this.getDriveableData();
        if (type == null) {
            FlansMod.log("Mecha type null. Not ticking mecha");
            return;
        }
        this.prevLegsYaw = this.legAxes.getYaw();
        if (this.toggleTimer == 0 && this.autoRepair()) {
            for (EnumDriveablePart part : EnumDriveablePart.values()) {
                boolean hasCreativePlayer;
                DriveablePart thisPart = data.parts.get((Object)part);
                boolean bl = hasCreativePlayer = driverSeat != null && driverSeat.func_184179_bs() instanceof EntityPlayer && ((EntityPlayer)driverSeat.func_184179_bs()).field_71075_bZ.field_75098_d;
                if (thisPart == null || thisPart.health == 0 || thisPart.health >= thisPart.maxHealth || !hasCreativePlayer && !(data.fuelInTank >= 10.0f)) continue;
                ++thisPart.health;
                if (hasCreativePlayer) continue;
                data.fuelInTank -= 10.0f;
            }
            this.toggleTimer = 20;
        }
        if (this.diamondDetect() != null && this.diamondTimer == 0 && this.field_70170_p.field_72995_K && driverSeat != null && driverSeat.func_184179_bs() instanceof EntityPlayer && FlansMod.proxy.isThePlayer((EntityPlayer)driverSeat.func_184179_bs())) {
            float sqDistance = 901.0f;
            for (float i = -30.0f; i <= 30.0f; i += 1.0f) {
                for (float j = -30.0f; j <= 30.0f; j += 1.0f) {
                    for (float k = -30.0f; k <= 30.0f; k += 1.0f) {
                        int x = MathHelper.func_76128_c((double)((double)i + this.field_70165_t));
                        int y = MathHelper.func_76128_c((double)((double)j + this.field_70163_u));
                        int z = MathHelper.func_76128_c((double)((double)k + this.field_70161_v));
                        if (!(i * i + j * j + k * k < sqDistance) || this.field_70170_p.func_180495_p(new BlockPos(x, y, z)).func_177230_c() != Blocks.field_150482_ag) continue;
                        sqDistance = i * i + j * j + k * k;
                    }
                }
            }
            if (sqDistance < 901.0f) {
                PacketPlaySound.sendSoundPacket(this.field_70165_t, this.field_70163_u, this.field_70161_v, 50.0, this.field_71093_bK, this.diamondDetect().detectSound, false);
                this.diamondTimer = 1 + 2 * MathHelper.func_76141_d((float)MathHelper.func_76129_c((float)sqDistance));
            }
        }
        if (this.diamondTimer > 0) {
            --this.diamondTimer;
        }
        if (this.isPartIntact(EnumDriveablePart.hips)) {
            this.func_70105_a(type.width, type.height);
            this.yOffset = type.yOffset;
        } else {
            this.func_70105_a(type.width, type.height - type.chassisHeight);
            this.yOffset = type.yOffset - type.chassisHeight;
        }
        boolean thePlayerIsDrivingThis = this.field_70170_p.field_72995_K && driverSeat != null && driverSeat.func_184179_bs() instanceof EntityPlayer && FlansMod.proxy.isThePlayer((EntityPlayer)driverSeat.func_184179_bs());
        boolean driverIsLiving = driverSeat != null && driverSeat.func_184179_bs() instanceof EntityLivingBase;
        ++this.ticksSinceUsed;
        if (!this.field_70170_p.field_72995_K && driverSeat.func_184179_bs() != null) {
            this.ticksSinceUsed = 0;
        }
        if (!this.field_70170_p.field_72995_K && TeamsManager.mechaLove > 0 && this.ticksSinceUsed > TeamsManager.mechaLove * 20) {
            this.func_70106_y();
        }
        if (this.toggleTimer > 0) {
            --this.toggleTimer;
        }
        if (this.field_70170_p.field_72995_K && !thePlayerIsDrivingThis && this.serverPositionTransitionTicker > 0) {
            double x = this.field_70165_t + (this.field_70118_ct - this.field_70165_t) / (double)this.serverPositionTransitionTicker;
            double y = this.field_70163_u + (this.field_70117_cu - this.field_70163_u) / (double)this.serverPositionTransitionTicker;
            double z = this.field_70161_v + (this.field_70116_cv - this.field_70161_v) / (double)this.serverPositionTransitionTicker;
            double dYaw = MathHelper.func_76138_g((double)(this.serverYaw - (double)this.axes.getYaw()));
            double dPitch = MathHelper.func_76138_g((double)(this.serverPitch - (double)this.axes.getPitch()));
            double dRoll = MathHelper.func_76138_g((double)(this.serverRoll - (double)this.axes.getRoll()));
            this.field_70177_z = (float)((double)this.axes.getYaw() + dYaw / (double)this.serverPositionTransitionTicker);
            this.field_70125_A = (float)((double)this.axes.getPitch() + dPitch / (double)this.serverPositionTransitionTicker);
            float rotationRoll = (float)((double)this.axes.getRoll() + dRoll / (double)this.serverPositionTransitionTicker);
            --this.serverPositionTransitionTicker;
            this.func_70107_b(x, y, z);
            this.setRotation(this.field_70177_z, this.field_70125_A, rotationRoll);
        }
        if (driverSeat != null) {
            if (driverSeat.func_184179_bs() instanceof EntityLivingBase && !(driverSeat.func_184179_bs() instanceof EntityPlayer)) {
                this.axes.setAngles(((EntityLivingBase)driverSeat.func_184179_bs()).field_70761_aq + 90.0f, 0.0f, 0.0f);
            } else {
                if (type.limitHeadTurn) {
                    float axesLegs = this.legAxes.getYaw();
                    float axesBody = this.axes.getYaw();
                    double dYaw = axesBody - axesLegs;
                    if (dYaw > 180.0) {
                        axesBody -= 360.0f;
                    }
                    if (dYaw < -180.0) {
                        axesBody += 360.0f;
                    }
                    if (axesLegs + type.limitHeadTurnValue < axesBody) {
                        this.axes.setAngles(axesLegs + type.limitHeadTurnValue, 0.0f, 0.0f);
                    }
                    if (axesLegs - type.limitHeadTurnValue > axesBody) {
                        this.axes.setAngles(axesLegs - type.limitHeadTurnValue, 0.0f, 0.0f);
                    }
                }
                float yaw = driverSeat.looking.getYaw() - driverSeat.prevLooking.getYaw();
                this.axes.rotateGlobalYaw(yaw);
                driverSeat.looking.rotateGlobalYaw(-yaw);
                driverSeat.playerLooking.rotateGlobalYaw(-yaw);
            }
        }
        this.moveX = 0.0f;
        this.moveZ = 0.0f;
        float jetPack = this.jetPackPower();
        if (!this.field_70122_E && thePlayerIsDrivingThis && Minecraft.func_71410_x().field_71462_r instanceof GuiDriveableController && FlansMod.proxy.isKeyDown(4) && this.shouldFly() && (((EntityPlayer)driverSeat.func_184179_bs()).field_71075_bZ.field_75098_d || data.fuelInTank >= 10.0f * jetPack)) {
            this.field_70181_x *= 0.95;
            this.field_70181_x += 0.07 * (double)jetPack;
            this.field_70143_R = 0.0f;
            if (!((EntityPlayer)driverSeat.func_184179_bs()).field_71075_bZ.field_75098_d) {
                data.fuelInTank -= 10.0f * jetPack;
            }
            if (this.rocketTimer <= 0.0f && this.rocketPack().soundEffect != null) {
                PacketPlaySound.sendSoundPacket(this.field_70165_t, this.field_70163_u, this.field_70161_v, 50.0, this.field_71093_bK, this.rocketPack().soundEffect, false);
                this.rocketTimer = this.rocketPack().soundTime;
            }
        } else if (this.func_70090_H() && this.shouldFloat()) {
            this.field_70181_x *= 0.89;
            this.field_70181_x += 0.1;
        }
        if (this.rocketTimer != 0.0f) {
            this.rocketTimer -= 1.0f;
        }
        Vector3f actualMotion = new Vector3f(0.0, this.field_70181_x - (double)0.04f, 0.0);
        if (driverIsLiving) {
            Vector3f intent;
            boolean driverIsCreative;
            EntityLivingBase entity = (EntityLivingBase)driverSeat.func_184179_bs();
            boolean bl = driverIsCreative = entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71075_bZ.field_75098_d;
            if (thePlayerIsDrivingThis && Minecraft.func_71410_x().field_71462_r instanceof GuiDriveableController) {
                if (FlansMod.proxy.isKeyDown(0)) {
                    this.moveX = 1.0f;
                }
                if (FlansMod.proxy.isKeyDown(1)) {
                    this.moveX = -1.0f;
                }
                if (FlansMod.proxy.isKeyDown(2)) {
                    this.moveZ = -1.0f;
                }
                if (FlansMod.proxy.isKeyDown(3)) {
                    this.moveZ = 1.0f;
                }
            } else if (driverSeat.func_184179_bs() instanceof EntityLiving && !(driverSeat.func_184179_bs() instanceof EntityPlayer)) {
                this.moveZ = 1.0f;
            }
            if ((double)Math.abs((intent = new Vector3f(this.moveX, 0.0f, this.moveZ)).lengthSquared()) > 0.1) {
                boolean canThrustCreatively;
                intent.normalise();
                this.legSwing += 1.0f;
                intent = this.axes.findLocalVectorGlobally(intent);
                Vector3f intentOnLegAxes = this.legAxes.findGlobalVectorLocally(intent);
                float intentAngle = (float)Math.atan2(intent.z, intent.x) * 180.0f / (float)Math.PI;
                float angleBetween = intentAngle - this.legAxes.getYaw();
                if (angleBetween > 180.0f) {
                    angleBetween -= 360.0f;
                }
                if (angleBetween < -180.0f) {
                    angleBetween += 360.0f;
                }
                float signBetween = Math.signum(angleBetween);
                if ((double)(angleBetween = Math.abs(angleBetween)) > 0.1) {
                    this.legAxes.rotateGlobalYaw(Math.min(angleBetween, type.rotateSpeed) * signBetween);
                }
                intent.scale(type.moveSpeed * data.engine.engineSpeed * this.speedMultiplier() * 0.215f);
                boolean bl2 = canThrustCreatively = driverSeat != null && driverSeat.func_184179_bs() instanceof EntityPlayer && ((EntityPlayer)driverSeat.func_184179_bs()).field_71075_bZ.field_75098_d;
                if ((canThrustCreatively || data.fuelInTank > data.engine.fuelConsumption) && this.isPartIntact(EnumDriveablePart.hips)) {
                    if (!this.field_70122_E && this.shouldFly() && (canThrustCreatively || data.fuelInTank > 10.0f * jetPack + data.engine.fuelConsumption)) {
                        intent.scale(jetPack);
                        if (!canThrustCreatively) {
                            data.fuelInTank -= 10.0f * jetPack;
                        }
                    }
                    Vector3f.add(actualMotion, intent, actualMotion);
                    if (!canThrustCreatively) {
                        data.fuelInTank -= data.engine.fuelConsumption;
                    }
                }
            }
            if (!this.field_70170_p.field_72995_K) {
                if (this.leftMouseHeld) {
                    this.useItem(true);
                }
                if (this.rightMouseHeld) {
                    this.useItem(false);
                }
                if (this.breakingBlock != null) {
                    boolean breakingBlocks;
                    IBlockState state = this.field_70170_p.func_180495_p(new BlockPos(this.breakingBlock.x, this.breakingBlock.y, this.breakingBlock.z));
                    Block blockHit = state.func_177230_c();
                    Material material = state.func_185904_a();
                    ItemStack leftStack = this.inventory.getStackInSlot(EnumMechaSlotType.leftTool);
                    ItemStack rightStack = this.inventory.getStackInSlot(EnumMechaSlotType.rightTool);
                    boolean leftStackIsTool = leftStack != null && leftStack.func_77973_b() instanceof ItemMechaAddon;
                    boolean rightStackIsTool = rightStack != null && rightStack.func_77973_b() instanceof ItemMechaAddon;
                    boolean bl3 = breakingBlocks = this.leftMouseHeld && leftStackIsTool || this.rightMouseHeld && rightStackIsTool;
                    if (blockHit == null || !breakingBlocks) {
                        this.breakingBlock = null;
                    } else {
                        float blockHardness = state.func_185887_b(this.field_70170_p, new BlockPos(this.breakingBlock.x, this.breakingBlock.y, this.breakingBlock.z));
                        float mineSpeed = 1.0f;
                        boolean atLeastOneEffectiveTool = false;
                        if (leftStackIsTool) {
                            MechaItemType leftType = ((ItemMechaAddon)leftStack.func_77973_b()).type;
                            if (leftType.function.effectiveAgainst(material) && leftType.toolHardness > blockHardness) {
                                mineSpeed *= leftType.speed;
                                atLeastOneEffectiveTool = true;
                            }
                        }
                        if (rightStackIsTool) {
                            MechaItemType rightType = ((ItemMechaAddon)rightStack.func_77973_b()).type;
                            if (rightType.function.effectiveAgainst(material) && rightType.toolHardness > blockHardness) {
                                mineSpeed *= rightType.speed;
                                atLeastOneEffectiveTool = true;
                            }
                        }
                        mineSpeed = blockHardness < -0.01f ? 0.0f : (Math.abs(blockHardness) < 0.01f ? 9001.0f : (mineSpeed /= state.func_185887_b(this.field_70170_p, new BlockPos(this.breakingBlock.x, this.breakingBlock.y, this.breakingBlock.z))));
                        this.breakingProgress += 0.1f * mineSpeed;
                        if (this.breakingProgress >= 1.0f) {
                            boolean cancelled = false;
                            if (entity instanceof EntityPlayerMP) {
                                int eventOutcome = ForgeHooks.onBlockBreakEvent((World)this.field_70170_p, (GameType)(((EntityPlayerMP)entity).field_71075_bZ.field_75098_d ? GameType.CREATIVE : (((EntityPlayerMP)entity).field_71075_bZ.field_75099_e ? GameType.SURVIVAL : GameType.ADVENTURE)), (EntityPlayerMP)((EntityPlayerMP)entity), (BlockPos)new BlockPos(this.breakingBlock.x, this.breakingBlock.y, this.breakingBlock.z));
                                boolean bl4 = cancelled = eventOutcome == -1;
                            }
                            if (!cancelled) {
                                boolean vacuumItems = this.vacuumItems();
                                if (vacuumItems) {
                                    for (ItemStack stack : blockHit.getDrops((IBlockAccess)this.field_70170_p, new BlockPos(this.breakingBlock.x, this.breakingBlock.y, this.breakingBlock.z), state, 0)) {
                                        float multiplier;
                                        boolean fuelCheck;
                                        boolean bl5 = fuelCheck = data.fuelInTank >= 5.0f || ((EntityPlayer)driverSeat.func_184179_bs()).field_71075_bZ.field_75098_d;
                                        if (fuelCheck && this.refineIron() && stack.func_77973_b() instanceof ItemBlock && ((ItemBlock)stack.func_77973_b()).func_179223_d() == Blocks.field_150366_p) {
                                            stack = new ItemStack(Items.field_151042_j, 1, 0);
                                            if (!((EntityPlayer)driverSeat.func_184179_bs()).field_71075_bZ.field_75098_d) {
                                                data.fuelInTank -= 5.0f;
                                            }
                                        }
                                        boolean bl6 = fuelCheck = data.fuelInTank >= 0.1f || ((EntityPlayer)driverSeat.func_184179_bs()).field_71075_bZ.field_75098_d;
                                        if (fuelCheck && this.wasteCompact().booleanValue() && stack.func_77973_b() instanceof ItemBlock && (((ItemBlock)stack.func_77973_b()).func_179223_d() == Blocks.field_150347_e || ((ItemBlock)stack.func_77973_b()).func_179223_d() == Blocks.field_150346_d || ((ItemBlock)stack.func_77973_b()).func_179223_d() == Blocks.field_150354_m)) {
                                            stack.func_190920_e(0);
                                            if (!((EntityPlayer)driverSeat.func_184179_bs()).field_71075_bZ.field_75098_d) {
                                                data.fuelInTank -= 0.1f;
                                            }
                                        }
                                        boolean bl7 = fuelCheck = data.fuelInTank >= 3.0f * this.diamondMultiplier() || ((EntityPlayer)driverSeat.func_184179_bs()).field_71075_bZ.field_75098_d;
                                        if (fuelCheck && stack.func_77973_b() == Items.field_151045_i) {
                                            multiplier = this.diamondMultiplier();
                                            stack.func_190920_e(stack.func_190916_E() * (MathHelper.func_76141_d((float)multiplier) + (this.field_70146_Z.nextFloat() < this.tailFloat(multiplier) ? 1 : 0)));
                                            if (!((EntityPlayer)driverSeat.func_184179_bs()).field_71075_bZ.field_75098_d) {
                                                data.fuelInTank -= 3.0f * this.diamondMultiplier();
                                            }
                                        }
                                        boolean bl8 = fuelCheck = data.fuelInTank >= 2.0f * this.redstoneMultiplier() || ((EntityPlayer)driverSeat.func_184179_bs()).field_71075_bZ.field_75098_d;
                                        if (fuelCheck && stack.func_77973_b() == Items.field_151137_ax) {
                                            multiplier = this.redstoneMultiplier();
                                            stack.func_190920_e(stack.func_190916_E() * (MathHelper.func_76141_d((float)multiplier) + (this.field_70146_Z.nextFloat() < this.tailFloat(multiplier) ? 1 : 0)));
                                            if (!((EntityPlayer)driverSeat.func_184179_bs()).field_71075_bZ.field_75098_d) {
                                                data.fuelInTank -= 2.0f * this.redstoneMultiplier();
                                            }
                                        }
                                        boolean bl9 = fuelCheck = data.fuelInTank >= 2.0f * this.coalMultiplier() || ((EntityPlayer)driverSeat.func_184179_bs()).field_71075_bZ.field_75098_d;
                                        if (fuelCheck && stack.func_77973_b() == Items.field_151044_h) {
                                            multiplier = this.coalMultiplier();
                                            stack.func_190920_e(stack.func_190916_E() * (MathHelper.func_76141_d((float)multiplier) + (this.field_70146_Z.nextFloat() < this.tailFloat(multiplier) ? 1 : 0)));
                                            if (!((EntityPlayer)driverSeat.func_184179_bs()).field_71075_bZ.field_75098_d) {
                                                data.fuelInTank -= 2.0f * this.coalMultiplier();
                                            }
                                        }
                                        boolean bl10 = fuelCheck = data.fuelInTank >= 2.0f * this.emeraldMultiplier() || ((EntityPlayer)driverSeat.func_184179_bs()).field_71075_bZ.field_75098_d;
                                        if (fuelCheck && stack.func_77973_b() == Items.field_151166_bC) {
                                            multiplier = this.emeraldMultiplier();
                                            stack.func_190920_e(stack.func_190916_E() * (MathHelper.func_76141_d((float)multiplier) + (this.field_70146_Z.nextFloat() < this.tailFloat(multiplier) ? 1 : 0)));
                                            if (!((EntityPlayer)driverSeat.func_184179_bs()).field_71075_bZ.field_75098_d) {
                                                data.fuelInTank -= 2.0f * this.emeraldMultiplier();
                                            }
                                        }
                                        boolean bl11 = fuelCheck = data.fuelInTank >= 2.0f * this.ironMultiplier() || ((EntityPlayer)driverSeat.func_184179_bs()).field_71075_bZ.field_75098_d;
                                        if (fuelCheck && stack.func_77973_b() == Items.field_151042_j && this.refineIron()) {
                                            multiplier = this.ironMultiplier();
                                            stack.func_190920_e(stack.func_190916_E() * (MathHelper.func_76141_d((float)multiplier) + (this.field_70146_Z.nextFloat() < this.tailFloat(multiplier) ? 1 : 0)));
                                            if (!((EntityPlayer)driverSeat.func_184179_bs()).field_71075_bZ.field_75098_d) {
                                                data.fuelInTank -= 2.0f * this.ironMultiplier();
                                            }
                                        }
                                        if (this.autoCoal() && stack.func_77973_b() == Items.field_151044_h && data.fuelInTank + 250.0f < (float)type.fuelTankSize) {
                                            data.fuelInTank = Math.min(data.fuelInTank + 1000.0f, (float)type.fuelTankSize);
                                            this.couldNotFindFuel = false;
                                            stack.func_190920_e(0);
                                        }
                                        if (InventoryHelper.addItemStackToInventory(this.driveableData, stack, driverIsCreative) || this.field_70170_p.field_72995_K || !this.field_70170_p.func_82736_K().func_82766_b("doTileDrops")) continue;
                                        this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, (double)((float)this.breakingBlock.x + 0.5f), (double)((float)this.breakingBlock.y + 0.5f), (double)((float)this.breakingBlock.z + 0.5f), stack));
                                    }
                                }
                                this.field_70170_p.func_175655_b(new BlockPos(this.breakingBlock.x, this.breakingBlock.y, this.breakingBlock.z), atLeastOneEffectiveTool && !vacuumItems);
                            }
                        }
                    }
                }
            }
        } else {
            this.moveAI(actualMotion);
        }
        this.field_70181_x = actualMotion.y;
        this.func_70091_d(MoverType.SELF, actualMotion.x, actualMotion.y, actualMotion.z);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        if (thePlayerIsDrivingThis) {
            FlansMod.getPacketHandler().sendToServer(new PacketMechaControl(this));
            this.field_70118_ct = this.field_70165_t;
            this.field_70117_cu = this.field_70163_u;
            this.field_70116_cv = this.field_70161_v;
            this.serverYaw = this.axes.getYaw();
        }
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa % 5 == 0) {
            FlansMod.getPacketHandler().sendToAllAround(new PacketMechaControl(this), this.field_70165_t, this.field_70163_u, this.field_70161_v, 200.0f, this.field_71093_bK);
        }
        for (EntitySeat seat : this.getSeats()) {
            if (seat == null) continue;
            seat.updatePosition();
        }
        if (!driverIsLiving || thePlayerIsDrivingThis) {
            this.legSwing /= type.legSwingLimit;
        }
    }

    protected void moveAI(Vector3f actualMotion) {
    }

    private float tailFloat(float f) {
        return f - (float)MathHelper.func_76141_d((float)f);
    }

    public boolean stopFallDamage() {
        for (MechaItemType type : this.getUpgradeTypes()) {
            if (!type.stopMechaFallDamage) continue;
            return true;
        }
        return false;
    }

    public boolean breakBlocksUponFalling() {
        for (MechaItemType type : this.getUpgradeTypes()) {
            if (!type.forceBlockFallDamage) continue;
            return true;
        }
        return false;
    }

    public boolean vacuumItems() {
        for (MechaItemType type : this.getUpgradeTypes()) {
            if (!type.vacuumItems) continue;
            return true;
        }
        return false;
    }

    public boolean refineIron() {
        for (MechaItemType type : this.getUpgradeTypes()) {
            if (!type.refineIron) continue;
            return true;
        }
        return false;
    }

    public MechaItemType diamondDetect() {
        for (MechaItemType type : this.getUpgradeTypes()) {
            if (!type.diamondDetect) continue;
            return type;
        }
        return null;
    }

    public Boolean wasteCompact() {
        for (MechaItemType type : this.getUpgradeTypes()) {
            if (!type.wasteCompact) continue;
            return true;
        }
        return false;
    }

    public float diamondMultiplier() {
        float multiplier = 1.0f;
        for (MechaItemType type : this.getUpgradeTypes()) {
            multiplier *= type.fortuneDiamond;
        }
        return multiplier;
    }

    public float speedMultiplier() {
        float multiplier = 1.0f;
        for (MechaItemType type : this.getUpgradeTypes()) {
            multiplier *= type.speedMultiplier;
        }
        return multiplier;
    }

    public float coalMultiplier() {
        float multiplier = 1.0f;
        for (MechaItemType type : this.getUpgradeTypes()) {
            multiplier *= type.fortuneCoal;
        }
        return multiplier;
    }

    public float redstoneMultiplier() {
        float multiplier = 1.0f;
        for (MechaItemType type : this.getUpgradeTypes()) {
            multiplier *= type.fortuneRedstone;
        }
        return multiplier;
    }

    public float vulnerability() {
        float multiplier = 1.0f;
        for (MechaItemType type : this.getUpgradeTypes()) {
            multiplier *= 1.0f - type.damageResistance;
        }
        return multiplier;
    }

    public float emeraldMultiplier() {
        float multiplier = 1.0f;
        for (MechaItemType type : this.getUpgradeTypes()) {
            multiplier *= type.fortuneEmerald;
        }
        return multiplier;
    }

    public float ironMultiplier() {
        float multiplier = 1.0f;
        for (MechaItemType type : this.getUpgradeTypes()) {
            multiplier *= type.fortuneIron;
        }
        return multiplier;
    }

    public int lightLevel() {
        int level = 0;
        for (MechaItemType type : this.getUpgradeTypes()) {
            level = Math.max(level, type.lightLevel);
        }
        return level;
    }

    public boolean forceDark() {
        for (MechaItemType type : this.getUpgradeTypes()) {
            if (!type.forceDark) continue;
            return true;
        }
        return false;
    }

    public boolean autoCoal() {
        for (MechaItemType type : this.getUpgradeTypes()) {
            if (!type.autoCoal) continue;
            return true;
        }
        return false;
    }

    public boolean autoRepair() {
        for (MechaItemType type : this.getUpgradeTypes()) {
            if (!type.autoRepair) continue;
            return true;
        }
        return false;
    }

    public boolean shouldFloat() {
        for (MechaItemType type : this.getUpgradeTypes()) {
            if (!type.floater) continue;
            return true;
        }
        return false;
    }

    public boolean infiniteAmmo() {
        for (MechaItemType type : this.getUpgradeTypes()) {
            if (!type.infiniteAmmo) continue;
            return true;
        }
        return false;
    }

    public MechaItemType rocketPack() {
        for (MechaItemType type : this.getUpgradeTypes()) {
            if (!type.rocketPack) continue;
            return type;
        }
        return null;
    }

    public boolean shouldFly() {
        return this.rocketPack() != null;
    }

    public float jetPackPower() {
        float multiplier = 1.0f;
        for (MechaItemType type : this.getUpgradeTypes()) {
            multiplier *= type.rocketPower;
        }
        return multiplier;
    }

    public ArrayList<MechaItemType> getUpgradeTypes() {
        ArrayList<MechaItemType> types = new ArrayList<MechaItemType>();
        for (ItemStack stack : this.inventory.stacks.values()) {
            if (stack == null || !(stack.func_77973_b() instanceof ItemMechaAddon)) continue;
            types.add(((ItemMechaAddon)stack.func_77973_b()).type);
        }
        return types;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean showInventory(int seat) {
        return seat != 0;
    }

    @Override
    protected void dropItemsOnPartDeath(Vector3f midpoint, DriveablePart part) {
        if (part.type == EnumDriveablePart.core) {
            for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
                if (this.inventory.func_70301_a(i) == null) continue;
                this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, this.field_70165_t + (double)midpoint.x, this.field_70163_u + (double)midpoint.y, this.field_70161_v + (double)midpoint.z, this.inventory.func_70301_a(i)));
            }
        }
    }

    @Override
    public boolean hasMouseControlMode() {
        return false;
    }

    @Override
    public String getBombInventoryName() {
        return "";
    }

    @Override
    public String getMissileInventoryName() {
        return "";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public EntityLivingBase getCamera() {
        return null;
    }
}

