/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.driveables;

import com.flansmod.api.IControllable;
import com.flansmod.client.FlansModClient;
import com.flansmod.common.FlansMod;
import com.flansmod.common.RotatedAxes;
import com.flansmod.common.driveables.DriveableType;
import com.flansmod.common.driveables.EntityDriveable;
import com.flansmod.common.driveables.Seat;
import com.flansmod.common.guns.EnumFireMode;
import com.flansmod.common.guns.GunType;
import com.flansmod.common.guns.ItemShootable;
import com.flansmod.common.guns.ShootableType;
import com.flansmod.common.network.PacketDriveableKey;
import com.flansmod.common.network.PacketDriveableKeyHeld;
import com.flansmod.common.network.PacketPlaySound;
import com.flansmod.common.network.PacketSeatUpdates;
import com.flansmod.common.teams.TeamsManager;
import com.flansmod.common.tools.ItemTool;
import com.flansmod.common.types.InfoType;
import com.flansmod.common.vector.Vector3f;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemLead;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntitySeat
extends Entity
implements IControllable,
IEntityAdditionalSpawnData {
    private int driveableID;
    private int seatID;
    public EntityDriveable driveable;
    public float playerRoll;
    public float prevPlayerRoll;
    public Seat seatInfo;
    public boolean driver;
    public RotatedAxes playerLooking;
    public RotatedAxes prevPlayerLooking;
    public RotatedAxes looking;
    public RotatedAxes prevLooking;
    public float gunDelay;
    public float minigunSpeed;
    public float minigunAngle;
    public int soundDelay;
    public int yawSoundDelay = 0;
    public int pitchSoundDelay = 0;
    public boolean playYawSound = false;
    public boolean playPitchSound = false;
    private double playerPosX;
    private double playerPosY;
    private double playerPosZ;
    private float playerYaw;
    private float playerPitch;
    private double prevPlayerPosX;
    private double prevPlayerPosY;
    private double prevPlayerPosZ;
    private float prevPlayerYaw;
    private float prevPlayerPitch;
    private boolean shooting;

    public EntitySeat(World world) {
        super(world);
        this.func_70105_a(1.0f, 1.0f);
        this.prevLooking = new RotatedAxes();
        this.looking = new RotatedAxes();
        this.playerLooking = new RotatedAxes();
        this.prevPlayerLooking = new RotatedAxes();
    }

    public EntitySeat(World world, EntityDriveable d, int id) {
        this(world);
        this.driveable = d;
        this.driveableID = d.func_145782_y();
        this.seatInfo = this.driveable.getDriveableType().seats[id];
        this.seatID = id;
        this.driver = id == 0;
        this.func_70107_b(d.field_70165_t, d.field_70163_u, d.field_70161_v);
        this.playerPosX = this.prevPlayerPosX = this.field_70165_t;
        this.playerPosY = this.prevPlayerPosY = this.field_70163_u;
        this.playerPosZ = this.prevPlayerPosZ = this.field_70161_v;
        this.looking.setAngles((this.seatInfo.minYaw + this.seatInfo.maxYaw) / 2.0f, 0.0f, 0.0f);
        this.prevLooking.setAngles((this.seatInfo.minYaw + this.seatInfo.maxYaw) / 2.0f, 0.0f, 0.0f);
    }

    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int i, boolean b) {
    }

    public void func_70071_h_() {
        Entity entityInThisSeat;
        boolean isThePlayer;
        super.func_70071_h_();
        if (this.driveable == null) {
            return;
        }
        if (this.gunDelay > 0.0f) {
            this.gunDelay -= 1.0f;
        }
        if (this.soundDelay > 0) {
            --this.soundDelay;
        }
        if (this.yawSoundDelay > 0) {
            --this.yawSoundDelay;
        }
        if (this.pitchSoundDelay > 0) {
            --this.pitchSoundDelay;
        }
        if (this.playYawSound && this.yawSoundDelay == 0 && this.seatInfo.traverseSounds) {
            PacketPlaySound.sendSoundPacket(this.field_70165_t, this.field_70163_u, this.field_70161_v, 50.0, this.field_71093_bK, this.seatInfo.yawSound, false);
            this.yawSoundDelay = this.seatInfo.yawSoundLength;
        }
        if (this.playPitchSound && this.pitchSoundDelay == 0 && this.seatInfo.traverseSounds) {
            PacketPlaySound.sendSoundPacket(this.field_70165_t, this.field_70163_u, this.field_70161_v, 50.0, this.field_71093_bK, this.seatInfo.pitchSound, false);
            this.pitchSoundDelay = this.seatInfo.pitchSoundLength;
        }
        boolean bl = isThePlayer = (entityInThisSeat = this.func_184179_bs()) instanceof EntityPlayer && FlansMod.proxy.isThePlayer((EntityPlayer)entityInThisSeat);
        if (isThePlayer) {
            this.playYawSound = false;
            this.playPitchSound = false;
            this.yawSoundDelay = 0;
            this.pitchSoundDelay = 0;
        }
        if (this.field_70170_p.field_72995_K && this.driver && isThePlayer && FlansMod.proxy.mouseControlEnabled() && this.driveable.hasMouseControlMode()) {
            this.looking = new RotatedAxes();
            this.playerLooking = new RotatedAxes();
        }
        if (entityInThisSeat instanceof EntityPlayer && this.shooting) {
            this.pressKey(9, (EntityPlayer)entityInThisSeat);
        }
        this.minigunSpeed *= 0.95f;
        this.minigunAngle += this.minigunSpeed;
    }

    public void updatePosition() {
        if (this.driveable == null) {
            if (this.func_184187_bx() instanceof EntityDriveable) {
                this.driveable = (EntityDriveable)this.func_184187_bx();
            } else {
                return;
            }
        }
        if (this.seatInfo == null) {
            this.seatInfo = this.driveable.getDriveableType().seats[this.seatID];
        }
        this.prevPlayerPosX = this.playerPosX;
        this.prevPlayerPosY = this.playerPosY;
        this.prevPlayerPosZ = this.playerPosZ;
        this.prevPlayerYaw = this.playerYaw;
        this.prevPlayerPitch = this.playerPitch;
        this.prevPlayerRoll = this.playerRoll;
        Vector3f localPosition = new Vector3f((float)this.seatInfo.x / 16.0f, (float)this.seatInfo.y / 16.0f, (float)this.seatInfo.z / 16.0f);
        if (this.driveable != null && this.driveable.getSeat(0) != null && this.driveable.getSeat((int)0).looking != null) {
            RotatedAxes yawOnlyLooking = new RotatedAxes(this.driveable.getSeat((int)0).looking.getYaw(), 0.0f, 0.0f);
            Vector3f rotatedOffset = yawOnlyLooking.findLocalVectorGlobally(this.seatInfo.rotatedOffset);
            Vector3f.add(localPosition, new Vector3f(rotatedOffset.x, 0.0f, rotatedOffset.z), localPosition);
        }
        Vector3f relativePosition = this.driveable.axes.findLocalVectorGlobally(localPosition);
        this.func_70107_b(this.driveable.field_70165_t + (double)relativePosition.x, this.driveable.field_70163_u + (double)relativePosition.y, this.driveable.field_70161_v + (double)relativePosition.z);
        Entity entityInThisSeat = this.func_184179_bs();
        if (entityInThisSeat != null) {
            DriveableType type = this.driveable.getDriveableType();
            Vec3d yOffset = this.driveable.axes.findLocalVectorGlobally(new Vector3f(0.0f, entityInThisSeat.func_70047_e() * 3.0f / 4.0f, 0.0f)).toVec3().func_178786_a(0.0, (double)entityInThisSeat.func_70047_e(), 0.0);
            this.playerPosX = this.field_70165_t + yOffset.field_72450_a;
            this.playerPosY = this.field_70163_u + yOffset.field_72448_b;
            this.playerPosZ = this.field_70161_v + yOffset.field_72449_c;
            entityInThisSeat.field_70142_S = this.func_184179_bs().field_70169_q = this.prevPlayerPosX;
            entityInThisSeat.field_70137_T = this.func_184179_bs().field_70167_r = this.prevPlayerPosY;
            entityInThisSeat.field_70136_U = this.func_184179_bs().field_70166_s = this.prevPlayerPosZ;
            entityInThisSeat.func_70107_b(this.playerPosX, this.playerPosY, this.playerPosZ);
            RotatedAxes globalLookAxes = this.driveable.axes.findLocalAxesGlobally(this.playerLooking);
            this.playerYaw = -90.0f + globalLookAxes.getYaw();
            this.playerPitch = globalLookAxes.getPitch();
            double dYaw = this.playerYaw - this.prevPlayerYaw;
            if (dYaw > 180.0) {
                this.prevPlayerYaw += 360.0f;
            }
            if (dYaw < -180.0) {
                this.prevPlayerYaw -= 360.0f;
            }
            if (entityInThisSeat instanceof EntityPlayer) {
                entityInThisSeat.field_70126_B = this.prevPlayerYaw;
                entityInThisSeat.field_70127_C = this.prevPlayerPitch;
                entityInThisSeat.field_70177_z = this.playerYaw;
                entityInThisSeat.field_70125_A = this.playerPitch;
            }
            if (this.field_70170_p.field_72995_K) {
                this.playerRoll = -globalLookAxes.getRoll();
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public EntityLivingBase getCamera() {
        return this.driveable.getCamera();
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound tags) {
        DriveableType type = DriveableType.getDriveable(tags.func_74779_i("DriveableType"));
        this.seatID = tags.func_74762_e("Index");
        if (type == null) {
            FlansMod.log("Killing seat due to invlaid type tag");
            this.func_70106_y();
            return;
        }
        this.seatInfo = type.seats[this.seatID];
        if (this.func_184187_bx() instanceof EntityDriveable) {
            this.driveable = (EntityDriveable)this.func_184187_bx();
            this.driveable.registerSeat(this);
        }
    }

    protected void func_70014_b(NBTTagCompound tags) {
        tags.func_74778_a("DriveableType", this.driveable == null ? "" : this.driveable.getDriveableType().shortName);
        tags.func_74768_a("Index", this.seatID);
    }

    public boolean func_70039_c(NBTTagCompound tags) {
        return false;
    }

    @Override
    public void onMouseMoved(int deltaX, int deltaY) {
        if (this.driveable == null) {
            return;
        }
        Entity entityInThisSeat = this.func_184179_bs();
        this.prevLooking = this.looking.clone();
        this.prevPlayerLooking = this.playerLooking.clone();
        if (this.driver) {
            this.driveable.onMouseMoved(deltaX, deltaY);
        }
        if (!(this.driver && FlansModClient.controlModeMouse && this.driveable.hasMouseControlMode())) {
            float pitchToMove;
            float yawToMove;
            float lookSpeed = 4.0f;
            float newPlayerPitch = this.playerLooking.getPitch() - (float)deltaY / lookSpeed * Minecraft.func_71410_x().field_71474_y.field_74341_c;
            if (newPlayerPitch > -this.seatInfo.minPitch) {
                newPlayerPitch = -this.seatInfo.minPitch;
            }
            if (newPlayerPitch < -this.seatInfo.maxPitch) {
                newPlayerPitch = -this.seatInfo.maxPitch;
            }
            float newPlayerYaw = this.playerLooking.getYaw() + (float)deltaX / lookSpeed * Minecraft.func_71410_x().field_71474_y.field_74341_c;
            float otherNewPlayerYaw = newPlayerYaw - 360.0f;
            if (newPlayerYaw < 0.0f) {
                otherNewPlayerYaw = newPlayerYaw + 360.0f;
            }
            if (!(newPlayerYaw >= this.seatInfo.minYaw && newPlayerYaw <= this.seatInfo.maxYaw || otherNewPlayerYaw >= this.seatInfo.minYaw && otherNewPlayerYaw <= this.seatInfo.maxYaw)) {
                float otherPlayerNewYawDistFromRange;
                float newPlayerYawDistFromRange = Math.min(Math.abs(newPlayerYaw - this.seatInfo.minYaw), Math.abs(newPlayerYaw - this.seatInfo.maxYaw));
                if (newPlayerYawDistFromRange <= (otherPlayerNewYawDistFromRange = Math.min(Math.abs(otherNewPlayerYaw - this.seatInfo.minYaw), Math.abs(otherNewPlayerYaw - this.seatInfo.maxYaw)))) {
                    if (newPlayerYaw > this.seatInfo.maxYaw) {
                        newPlayerYaw = this.seatInfo.maxYaw;
                    }
                    if (newPlayerYaw < this.seatInfo.minYaw) {
                        newPlayerYaw = this.seatInfo.minYaw;
                    }
                } else {
                    if (otherNewPlayerYaw > this.seatInfo.maxYaw) {
                        otherNewPlayerYaw = this.seatInfo.maxYaw;
                    }
                    if (otherNewPlayerYaw < this.seatInfo.minYaw) {
                        otherNewPlayerYaw = this.seatInfo.minYaw;
                    }
                    newPlayerYaw = newPlayerYaw < 0.0f ? otherNewPlayerYaw - 360.0f : otherNewPlayerYaw + 360.0f;
                }
            }
            this.playerLooking.setAngles(newPlayerYaw, newPlayerPitch, 0.0f);
            float targetX = this.playerLooking.getYaw();
            for (yawToMove = targetX - this.looking.getYaw(); yawToMove > 180.0f; yawToMove -= 360.0f) {
            }
            while (yawToMove <= -180.0f) {
                yawToMove += 360.0f;
            }
            float signDeltaX = 0.0f;
            signDeltaX = yawToMove > this.seatInfo.aimingSpeed.x / 2.0f && !this.seatInfo.legacyAiming ? 1.0f : (yawToMove < -(this.seatInfo.aimingSpeed.x / 2.0f) && !this.seatInfo.legacyAiming ? -1.0f : 0.0f);
            float newYaw = 0.0f;
            newYaw = this.seatInfo.legacyAiming || signDeltaX == 0.0f && deltaX == 0 ? this.playerLooking.getYaw() : this.looking.getYaw() + signDeltaX * this.seatInfo.aimingSpeed.x;
            float otherNewYaw = newYaw - 360.0f;
            if (newYaw < 0.0f) {
                otherNewYaw = newYaw + 360.0f;
            }
            if (!(newYaw >= this.seatInfo.minYaw && newYaw <= this.seatInfo.maxYaw || otherNewYaw >= this.seatInfo.minYaw && otherNewYaw <= this.seatInfo.maxYaw)) {
                float otherNewYawDistFromRange;
                float newYawDistFromRange = Math.min(Math.abs(newYaw - this.seatInfo.minYaw), Math.abs(newYaw - this.seatInfo.maxYaw));
                if (newYawDistFromRange <= (otherNewYawDistFromRange = Math.min(Math.abs(otherNewYaw - this.seatInfo.minYaw), Math.abs(otherNewYaw - this.seatInfo.maxYaw)))) {
                    if (newYaw > this.seatInfo.maxYaw) {
                        newYaw = this.seatInfo.maxYaw;
                    }
                    if (newYaw < this.seatInfo.minYaw) {
                        newYaw = this.seatInfo.minYaw;
                    }
                } else {
                    if (otherNewYaw > this.seatInfo.maxYaw) {
                        otherNewYaw = this.seatInfo.maxYaw;
                    }
                    if (otherNewYaw < this.seatInfo.minYaw) {
                        otherNewYaw = this.seatInfo.minYaw;
                    }
                    newYaw = newYaw < 0.0f ? otherNewYaw - 360.0f : otherNewYaw + 360.0f;
                }
            }
            float targetY = this.playerLooking.getPitch();
            for (pitchToMove = targetY - this.looking.getPitch(); pitchToMove > 180.0f; pitchToMove -= 360.0f) {
            }
            while (pitchToMove <= -180.0f) {
                pitchToMove += 360.0f;
            }
            float signDeltaY = 0.0f;
            signDeltaY = pitchToMove > this.seatInfo.aimingSpeed.y / 2.0f && !this.seatInfo.legacyAiming ? 1.0f : (pitchToMove < -(this.seatInfo.aimingSpeed.y / 2.0f) && !this.seatInfo.legacyAiming ? -1.0f : 0.0f);
            float newPitch = 0.0f;
            float minYawToMove = 0.0f;
            float currentYawToMove = 0.0f;
            minYawToMove = this.seatInfo.latePitch ? (float)Math.sqrt(pitchToMove / this.seatInfo.aimingSpeed.y * (pitchToMove / this.seatInfo.aimingSpeed.y)) * this.seatInfo.aimingSpeed.x : 360.0f;
            currentYawToMove = (float)Math.sqrt(yawToMove * yawToMove);
            newPitch = this.seatInfo.legacyAiming || signDeltaY == 0.0f && deltaY == 0 ? this.playerLooking.getPitch() : (!this.seatInfo.yawBeforePitch && currentYawToMove < minYawToMove ? this.looking.getPitch() + signDeltaY * this.seatInfo.aimingSpeed.y : (this.seatInfo.yawBeforePitch && signDeltaX == 0.0f ? this.looking.getPitch() + signDeltaY * this.seatInfo.aimingSpeed.y : (this.seatInfo.yawBeforePitch && signDeltaX != 0.0f ? this.looking.getPitch() : this.looking.getPitch())));
            if (newPitch > -this.seatInfo.minPitch) {
                newPitch = -this.seatInfo.minPitch;
            }
            if (newPitch < -this.seatInfo.maxPitch) {
                newPitch = -this.seatInfo.maxPitch;
            }
            this.looking.setAngles(newYaw, newPitch, 0.0f);
            FlansMod.getPacketHandler().sendToServer(new PacketSeatUpdates(this));
            this.playYawSound = signDeltaX != 0.0f && this.seatInfo.traverseSounds;
            this.playPitchSound = signDeltaY != 0.0f && !this.seatInfo.yawBeforePitch && currentYawToMove < minYawToMove ? true : signDeltaY != 0.0f && this.seatInfo.yawBeforePitch && signDeltaX == 0.0f;
        }
    }

    @Override
    public void updateKeyHeldState(int key, boolean held) {
        if (this.field_70170_p.field_72995_K && this.driveable != null) {
            FlansMod.getPacketHandler().sendToServer(new PacketDriveableKeyHeld(key, held));
        }
        if (this.driver) {
            this.driveable.updateKeyHeldState(key, held);
        } else if (key == 9) {
            this.shooting = held;
        }
    }

    @Override
    public boolean pressKey(int key, EntityPlayer player) {
        if (this.driver && this.driveable != null) {
            return this.driveable.pressKey(key, player);
        }
        if (this.field_70170_p.field_72995_K && key == 7 && this.driveable != null) {
            FlansMod.proxy.openDriveableMenu(player, this.field_70170_p, this.driveable);
        }
        if (this.field_70170_p.field_72995_K) {
            if (this.driveable != null) {
                FlansMod.getPacketHandler().sendToServer(new PacketDriveableKey(key));
                if (key == 9) {
                    this.minigunSpeed += 0.1f;
                }
            }
            return false;
        }
        if (key == 6 && this.func_184179_bs() != null) {
            this.func_184226_ay();
        }
        if (key == 9) {
            GunType gun = this.seatInfo.gunType;
            this.minigunSpeed += 0.1f;
            if ((gun != null && gun.mode != EnumFireMode.MINIGUN || this.minigunSpeed > 2.0f) && this.gunDelay <= 0.0f && TeamsManager.bulletsEnabled && this.seatInfo.gunnerID < this.driveable.getDriveableData().ammo.length) {
                ShootableType bullet;
                ItemStack bulletItemStack = this.driveable.getDriveableData().ammo[this.seatInfo.gunnerID];
                if (gun != null && bulletItemStack != null && bulletItemStack.func_77973_b() instanceof ItemShootable && gun.isAmmo(bullet = ((ItemShootable)bulletItemStack.func_77973_b()).type)) {
                    Vector3f gunOrigin = Vector3f.add(this.driveable.axes.findLocalVectorGlobally(this.seatInfo.gunOrigin), new Vector3f(this.driveable.field_70165_t, this.driveable.field_70163_u, this.driveable.field_70161_v), null);
                    RotatedAxes globalLookAxes = this.driveable.axes.findLocalAxesGlobally(this.looking);
                    Vector3f shootVec = this.driveable.axes.findLocalVectorGlobally(this.looking.getXAxis());
                    Vector3f yOffset = this.driveable.axes.findLocalVectorGlobally(new Vector3f(0.0f, (float)player.func_70042_X(), 0.0f));
                    this.field_70170_p.func_72838_d((Entity)((ItemShootable)bulletItemStack.func_77973_b()).getEntity(this.field_70170_p, Vector3f.add(yOffset, new Vector3f(gunOrigin.x, gunOrigin.y, gunOrigin.z), null), shootVec, (EntityLivingBase)this.func_184179_bs(), bullet.bulletSpread * gun.bulletSpread, gun.damage, gun.bulletSpeed <= 0.0f ? 5.0f : gun.bulletSpeed, (InfoType)this.driveable.getDriveableType()));
                    if (this.soundDelay <= 0) {
                        PacketPlaySound.sendSoundPacket(this.field_70165_t, this.field_70163_u, this.field_70161_v, 50.0, this.field_71093_bK, gun.shootSound, false);
                        this.soundDelay = gun.shootSoundLength;
                    }
                    int damage = bulletItemStack.func_77952_i();
                    bulletItemStack.func_77964_b(damage + 1);
                    if (damage + 1 == bulletItemStack.func_77958_k()) {
                        bulletItemStack.func_77964_b(0);
                        if (!((EntityPlayer)this.func_184179_bs()).field_71075_bZ.field_75098_d) {
                            this.driveable.getDriveableData().func_70298_a(3 + this.seatID, 1);
                        }
                    }
                    this.gunDelay = gun.shootDelay;
                }
            }
        }
        return false;
    }

    public boolean func_184230_a(EntityPlayer entityplayer, EnumHand hand) {
        if (this.field_70128_L) {
            return false;
        }
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        if (this.driveable == null) {
            return false;
        }
        ItemStack currentItem = entityplayer.func_184614_ca();
        if (currentItem != null && currentItem.func_77973_b() instanceof ItemTool && ((ItemTool)currentItem.func_77973_b()).type.healDriveables) {
            return true;
        }
        if (currentItem != null && currentItem.func_77973_b() instanceof ItemLead) {
            if (this.func_184179_bs() != null && this.func_184179_bs() instanceof EntityLiving && !(this.func_184179_bs() instanceof EntityPlayer)) {
                EntityLiving mob = (EntityLiving)this.func_184179_bs();
                mob.func_184210_p();
                mob.func_110162_b((Entity)entityplayer, true);
                return true;
            }
            double checkRange = 10.0;
            List nearbyMobs = this.field_70170_p.func_72872_a(EntityLiving.class, new AxisAlignedBB(this.field_70165_t - checkRange, this.field_70163_u - checkRange, this.field_70161_v - checkRange, this.field_70165_t + checkRange, this.field_70163_u + checkRange, this.field_70161_v + checkRange));
            for (Object obj : nearbyMobs) {
                EntityLiving entity = (EntityLiving)obj;
                if (!entity.func_110167_bD() || entity.func_110166_bE() != entityplayer) continue;
                if (entity.func_184220_m((Entity)this)) {
                    this.looking.setAngles(-entity.field_70177_z, entity.field_70125_A, 0.0f);
                    entity.func_110160_i(true, !entityplayer.field_71075_bZ.field_75098_d);
                    continue;
                }
                FlansMod.log("Failed to put pet in seat");
            }
            return true;
        }
        if (this.func_184179_bs() == null && !this.driveable.getDriveableData().engine.isAIChip) {
            if (!entityplayer.func_184220_m((Entity)this)) {
                FlansMod.log("Failed to mount seat");
            }
            return true;
        }
        return false;
    }

    @Override
    public Entity getControllingEntity() {
        return this.func_184179_bs();
    }

    public Entity func_184179_bs() {
        return this.func_184188_bt().size() == 0 ? null : (Entity)this.func_184188_bt().get(0);
    }

    @Override
    public boolean isDead() {
        return this.field_70128_L;
    }

    public void func_70106_y() {
    }

    public void reallySetDead() {
        super.func_70106_y();
    }

    @Override
    public EntitySeat getSeat(EntityLivingBase living) {
        return this;
    }

    public boolean func_184220_m(Entity riding) {
        boolean success = super.func_184220_m(riding);
        if (success && riding instanceof EntityDriveable) {
            EntityDriveable driveable = (EntityDriveable)riding;
            driveable.registerSeat(this);
        }
        return success;
    }

    public void func_184232_k(Entity passenger) {
        if (passenger instanceof EntityPlayer) {
            passenger.field_70177_z = this.playerYaw;
            passenger.field_70125_A = this.playerPitch;
            passenger.field_70126_B = this.prevPlayerYaw;
            passenger.field_70127_C = this.prevPlayerPitch;
        }
        passenger.field_70142_S = passenger.field_70169_q = this.prevPlayerPosX;
        passenger.field_70137_T = passenger.field_70167_r = this.prevPlayerPosY;
        passenger.field_70136_U = passenger.field_70166_s = this.prevPlayerPosZ;
        passenger.func_70107_b(this.playerPosX, this.playerPosY, this.playerPosZ);
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        if (this.driveable == null) {
            return ItemStack.field_190927_a.func_77946_l();
        }
        return this.driveable.getPickedResult(target);
    }

    @Override
    public float getPlayerRoll() {
        return this.playerRoll;
    }

    @Override
    public float getPrevPlayerRoll() {
        return this.prevPlayerRoll;
    }

    @Override
    public float getCameraDistance() {
        return this.driveable != null && this.seatID == 0 ? this.driveable.getDriveableType().cameraDistance * 2.0f : 5.0f;
    }

    public boolean func_70097_a(DamageSource source, float f) {
        if (this.driveable == null) {
            return false;
        }
        return this.driveable.func_70097_a(source, f);
    }

    public void writeSpawnData(ByteBuf data) {
        data.writeInt(this.driveableID);
        if (this.seatInfo == null) {
            data.writeInt(-1);
            FlansMod.log("Bad seat data. This is very bad");
        } else {
            data.writeInt(this.seatInfo.id);
        }
    }

    public void readSpawnData(ByteBuf data) {
        this.driveableID = data.readInt();
        if (this.field_70170_p.func_73045_a(this.driveableID) instanceof EntityDriveable) {
            this.driveable = (EntityDriveable)this.field_70170_p.func_73045_a(this.driveableID);
        }
        this.seatID = data.readInt();
        boolean bl = this.driver = this.seatID == 0;
        if (this.seatID >= 0 && this.driveable != null) {
            this.seatInfo = this.driveable.getDriveableType().seats[this.seatID];
            this.looking.setAngles((this.seatInfo.minYaw + this.seatInfo.maxYaw) / 2.0f, 0.0f, 0.0f);
            this.prevPlayerPosX = this.field_70165_t = this.driveable.field_70165_t;
            this.playerPosX = this.field_70165_t;
            this.prevPlayerPosY = this.field_70163_u = this.driveable.field_70163_u;
            this.playerPosY = this.field_70163_u;
            this.prevPlayerPosZ = this.field_70161_v = this.driveable.field_70161_v;
            this.playerPosZ = this.field_70161_v;
        }
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    public int getExpectedSeatID() {
        return this.seatID;
    }

    public float getMinigunSpeed() {
        return this.minigunSpeed;
    }

    public void func_70098_U() {
        Entity entity = this.func_184187_bx();
        if (!this.updateBlocked) {
            this.func_70071_h_();
        }
        if (this.func_184218_aH()) {
            entity.func_184232_k((Entity)this);
        }
    }
}

