/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.driveables;

import com.flansmod.common.FlansMod;
import com.flansmod.common.driveables.DriveableData;
import com.flansmod.common.driveables.DriveablePart;
import com.flansmod.common.driveables.DriveableType;
import com.flansmod.common.driveables.EntityDriveable;
import com.flansmod.common.driveables.EntitySeat;
import com.flansmod.common.driveables.EntityWheel;
import com.flansmod.common.driveables.EnumDriveablePart;
import com.flansmod.common.driveables.EnumPlaneMode;
import com.flansmod.common.driveables.PlaneType;
import com.flansmod.common.driveables.Propeller;
import com.flansmod.common.network.PacketDriveableControl;
import com.flansmod.common.network.PacketDriveableKey;
import com.flansmod.common.network.PacketPlaneControl;
import com.flansmod.common.network.PacketPlaySound;
import com.flansmod.common.teams.TeamsManager;
import com.flansmod.common.tools.ItemTool;
import com.flansmod.common.vector.Matrix4f;
import com.flansmod.common.vector.Vector3f;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class EntityPlane
extends EntityDriveable {
    public float flapsYaw;
    public float flapsPitchLeft;
    public float flapsPitchRight;
    public int soundPosition;
    public float propAngle;
    public int bombDelay;
    public int gunDelay;
    public int ticksSinceUsed = 0;
    public boolean varGear = true;
    public boolean varDoor = false;
    public boolean varWing = false;
    public int toggleTimer = 0;
    public EnumPlaneMode mode;

    public EntityPlane(World world) {
        super(world);
    }

    public EntityPlane(World world, double x, double y, double z, PlaneType type, DriveableData data) {
        super(world, type, data);
        this.func_70107_b(x, y, z);
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
        this.initType(type, true, false);
    }

    public EntityPlane(World world, double x, double y, double z, EntityPlayer placer, PlaneType type, DriveableData data) {
        this(world, x, y, z, type, data);
        this.rotateYaw(placer.field_70177_z + 90.0f);
        this.rotatePitch(type.restingPitch);
    }

    @Override
    public void initType(DriveableType type, boolean firstSpawn, boolean clientSide) {
        super.initType(type, firstSpawn, clientSide);
        this.mode = ((PlaneType)type).mode == EnumPlaneMode.HELI ? EnumPlaneMode.HELI : EnumPlaneMode.PLANE;
    }

    @Override
    protected void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74782_a("Pos", (NBTBase)this.func_70087_a(new double[]{this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v}));
        tag.func_74757_a("VarGear", this.varGear);
        tag.func_74757_a("VarDoor", this.varDoor);
        tag.func_74757_a("VarWing", this.varWing);
    }

    @Override
    protected void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        this.varGear = tag.func_74767_n("VarGear");
        this.varDoor = tag.func_74767_n("VarDoor");
        this.varWing = tag.func_74767_n("VarWing");
    }

    @Override
    public void onMouseMoved(int deltaX, int deltaY) {
        if (!FMLCommonHandler.instance().getSide().isClient()) {
            return;
        }
        if (!FlansMod.proxy.mouseControlEnabled()) {
            return;
        }
        float sensitivity = 0.02f;
        this.flapsPitchLeft -= sensitivity * (float)deltaY;
        this.flapsPitchRight -= sensitivity * (float)deltaY;
        this.flapsPitchLeft -= sensitivity * (float)deltaX;
        this.flapsPitchRight += sensitivity * (float)deltaX;
    }

    @Override
    public void setPositionRotationAndMotion(double x, double y, double z, float yaw, float pitch, float roll, double motX, double motY, double motZ, float velYaw, float velPitch, float velRoll, float throt, float steeringYaw) {
        super.setPositionRotationAndMotion(x, y, z, yaw, pitch, roll, motX, motY, motZ, velYaw, velPitch, velRoll, throt, steeringYaw);
        this.flapsYaw = steeringYaw;
    }

    public boolean func_184230_a(EntityPlayer entityplayer, EnumHand hand) {
        if (this.field_70128_L) {
            return false;
        }
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        ItemStack currentItem = entityplayer.func_184614_ca();
        if (currentItem != null && currentItem.func_77973_b() instanceof ItemTool && ((ItemTool)currentItem.func_77973_b()).type.healDriveables) {
            return true;
        }
        PlaneType type = this.getPlaneType();
        for (int i = 0; i <= type.numPassengers; ++i) {
            if (!this.getSeat(i).func_184230_a(entityplayer, hand)) continue;
            if (i == 0) {
                this.bombDelay = type.planeBombDelay;
                FlansMod.proxy.doTutorialStuff(entityplayer, this);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean pressKey(int key, EntityPlayer player) {
        PlaneType type = this.getPlaneType();
        if (this.field_70170_p.field_72995_K && (key == 6 || key == 8 || key == 9)) {
            FlansMod.getPacketHandler().sendToServer(new PacketDriveableKey(key));
            return true;
        }
        boolean canThrust = (this.getSeat(0) != null && this.getSeat(0).func_184179_bs() instanceof EntityPlayer && ((EntityPlayer)this.getSeat((int)0).func_184179_bs()).field_71075_bZ.field_75098_d || this.getDriveableData().fuelInTank > 0.0f) && this.hasWorkingProp();
        switch (key) {
            case 0: {
                if (canThrust || this.throttle < 0.0f) {
                    this.throttle += 0.002f;
                    if (this.throttle > 1.0f) {
                        this.throttle = 1.0f;
                    }
                }
                return true;
            }
            case 1: {
                if (canThrust || this.throttle > 0.0f) {
                    this.throttle -= 0.005f;
                    if (this.throttle < -1.0f) {
                        this.throttle = -1.0f;
                    }
                    if (this.throttle < 0.0f && type.maxNegativeThrottle == 0.0f) {
                        this.throttle = 0.0f;
                    }
                }
                return true;
            }
            case 2: {
                this.flapsYaw -= 1.0f;
                return true;
            }
            case 3: {
                this.flapsYaw += 1.0f;
                return true;
            }
            case 4: {
                this.flapsPitchLeft += 1.0f;
                this.flapsPitchRight += 1.0f;
                return true;
            }
            case 5: {
                this.flapsPitchLeft -= 1.0f;
                this.flapsPitchRight -= 1.0f;
                return true;
            }
            case 6: {
                if (this.getSeat(0).func_184179_bs() != null) {
                    this.getSeat(0).func_184226_ay();
                }
                return true;
            }
            case 7: {
                if (this.field_70170_p.field_72995_K && (type.invInflight || Math.abs(this.throttle) < 0.1f && this.field_70122_E)) {
                    FlansMod.proxy.openDriveableMenu((EntityPlayer)this.getSeat(0).func_184179_bs(), this.field_70170_p, this);
                }
                return true;
            }
            case 8: 
            case 9: {
                return super.pressKey(key, player);
            }
            case 10: {
                FlansMod.proxy.changeControlMode((EntityPlayer)this.getSeat(0).func_184179_bs());
                return true;
            }
            case 11: {
                this.flapsPitchLeft += 1.0f;
                this.flapsPitchRight -= 1.0f;
                return true;
            }
            case 12: {
                this.flapsPitchLeft -= 1.0f;
                this.flapsPitchRight += 1.0f;
                return true;
            }
            case 13: {
                if (this.toggleTimer <= 0) {
                    this.varGear = !this.varGear;
                    player.func_145747_a((ITextComponent)new TextComponentString("Landing gear " + (this.varGear ? "down" : "up")));
                    this.toggleTimer = 10;
                    FlansMod.getPacketHandler().sendToServer(new PacketDriveableControl(this));
                }
                return true;
            }
            case 14: {
                if (this.toggleTimer <= 0) {
                    boolean bl = this.varDoor = !this.varDoor;
                    if (type.hasDoor) {
                        player.func_145747_a((ITextComponent)new TextComponentString("Doors " + (this.varDoor ? "open" : "closed")));
                    }
                    this.toggleTimer = 10;
                    FlansMod.getPacketHandler().sendToServer(new PacketDriveableControl(this));
                }
                return true;
            }
            case 15: {
                if (this.toggleTimer <= 0) {
                    if (type.hasWing) {
                        this.varWing = !this.varWing;
                        player.func_145747_a((ITextComponent)new TextComponentString("Switching mode"));
                    }
                    if (type.mode == EnumPlaneMode.VTOL) {
                        this.mode = this.mode == EnumPlaneMode.HELI ? EnumPlaneMode.PLANE : EnumPlaneMode.HELI;
                        player.func_145747_a((ITextComponent)new TextComponentString(this.mode == EnumPlaneMode.HELI ? "Entering hover mode" : "Entering plane mode"));
                    }
                    this.toggleTimer = 10;
                    FlansMod.getPacketHandler().sendToServer(new PacketDriveableControl(this));
                }
                return true;
            }
            case 16: {
                this.axes.setAngles(this.axes.getYaw(), 0.0f, 0.0f);
                return true;
            }
        }
        return false;
    }

    @Override
    public void updateKeyHeldState(int key, boolean held) {
        super.updateKeyHeldState(key, held);
        if (!this.field_70170_p.field_72995_K) {
            switch (key) {
                default: 
            }
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.readyForUpdates) {
            return;
        }
        PlaneType type = this.getPlaneType();
        DriveableData data = this.getDriveableData();
        if (type == null) {
            FlansMod.log("Plane type null. Not ticking plane");
            return;
        }
        boolean thePlayerIsDrivingThis = this.field_70170_p.field_72995_K && this.getSeat(0) != null && this.getSeat(0).func_184179_bs() instanceof EntityPlayer && FlansMod.proxy.isThePlayer((EntityPlayer)this.getSeat(0).func_184179_bs());
        ++this.ticksSinceUsed;
        if (!this.field_70170_p.field_72995_K && this.getSeat(0).func_184179_bs() != null) {
            this.ticksSinceUsed = 0;
        }
        if (!this.field_70170_p.field_72995_K && TeamsManager.planeLife > 0 && this.ticksSinceUsed > TeamsManager.planeLife * 20) {
            this.func_70106_y();
        }
        if (this.bombDelay > 0) {
            --this.bombDelay;
        }
        if (this.gunDelay > 0) {
            --this.gunDelay;
        }
        if (this.toggleTimer > 0) {
            --this.toggleTimer;
        }
        if (this.hasEnoughFuel()) {
            this.propAngle = (float)((double)this.propAngle + Math.pow(this.throttle, 0.4) * 1.5);
        }
        this.flapsYaw *= 0.9f;
        this.flapsPitchLeft *= 0.9f;
        this.flapsPitchRight *= 0.9f;
        if (this.flapsYaw > 20.0f) {
            this.flapsYaw = 20.0f;
        }
        if (this.flapsYaw < -20.0f) {
            this.flapsYaw = -20.0f;
        }
        if (this.flapsPitchRight > 20.0f) {
            this.flapsPitchRight = 20.0f;
        }
        if (this.flapsPitchRight < -20.0f) {
            this.flapsPitchRight = -20.0f;
        }
        if (this.flapsPitchLeft > 20.0f) {
            this.flapsPitchLeft = 20.0f;
        }
        if (this.flapsPitchLeft < -20.0f) {
            this.flapsPitchLeft = -20.0f;
        }
        if (this.field_70170_p.field_72995_K && !thePlayerIsDrivingThis && this.serverPositionTransitionTicker > 0) {
            double x = this.field_70165_t + (this.field_70118_ct - this.field_70165_t) / (double)this.serverPositionTransitionTicker;
            double y = this.field_70163_u + (this.field_70117_cu - this.field_70163_u) / (double)this.serverPositionTransitionTicker;
            double z = this.field_70161_v + (this.field_70116_cv - this.field_70161_v) / (double)this.serverPositionTransitionTicker;
            double dYaw = MathHelper.func_76138_g((double)(this.serverYaw - (double)this.axes.getYaw()));
            double dPitch = MathHelper.func_76138_g((double)(this.serverPitch - (double)this.axes.getPitch()));
            double dRoll = MathHelper.func_76138_g((double)(this.serverRoll - (double)this.axes.getRoll()));
            this.field_70177_z = (float)((double)this.axes.getYaw() + dYaw / (double)this.serverPositionTransitionTicker);
            this.field_70125_A = (float)((double)this.axes.getPitch() + dPitch / (double)this.serverPositionTransitionTicker);
            float rotationRoll = (float)((double)this.axes.getRoll() + dRoll / (double)this.serverPositionTransitionTicker);
            --this.serverPositionTransitionTicker;
            this.func_70107_b(x, y, z);
            this.setRotation(this.field_70177_z, this.field_70125_A, rotationRoll);
        }
        float throttlePull = 0.99f;
        if (this.getSeat(0) != null && this.getSeat(0).func_184179_bs() != null && this.mode == EnumPlaneMode.HELI && this.canThrust()) {
            this.throttle = (this.throttle - 0.5f) * throttlePull + 0.5f;
        }
        float lastTickSpeed = (float)this.getSpeedXYZ();
        float sensitivityAdjust = 2.006771f - (float)Math.exp(-2.0f * this.throttle) / (4.5f * (this.throttle + 0.1f));
        sensitivityAdjust = MathHelper.func_76131_a((float)sensitivityAdjust, (float)0.0f, (float)1.0f);
        float yaw = this.flapsYaw * (this.flapsYaw > 0.0f ? type.turnLeftModifier : type.turnRightModifier) * (sensitivityAdjust *= 0.125f);
        float flapsPitch = (this.flapsPitchLeft + this.flapsPitchRight) / 2.0f;
        float pitch = flapsPitch * (flapsPitch > 0.0f ? type.lookUpModifier : type.lookDownModifier) * sensitivityAdjust;
        float flapsRoll = (this.flapsPitchRight - this.flapsPitchLeft) / 2.0f;
        float roll = flapsRoll * (flapsRoll > 0.0f ? type.rollLeftModifier : type.rollRightModifier) * sensitivityAdjust;
        if (this.mode == EnumPlaneMode.PLANE) {
            if (!this.isPartIntact(EnumDriveablePart.tail)) {
                yaw = 0.0f;
                pitch = 0.0f;
                roll = 0.0f;
            }
            if (!this.isPartIntact(EnumDriveablePart.leftWing)) {
                roll = (float)((double)roll - 7.0 * this.getSpeedXZ());
            }
            if (!this.isPartIntact(EnumDriveablePart.rightWing)) {
                roll = (float)((double)roll + 7.0 * this.getSpeedXZ());
            }
        }
        this.axes.rotateLocalYaw(yaw);
        this.axes.rotateLocalPitch(pitch);
        this.axes.rotateLocalRoll(-roll);
        if (!this.field_70170_p.field_72995_K || !FlansMod.proxy.mouseControlEnabled()) {
            // empty if block
        }
        float g = 0.098000005f;
        float drag = 1.0f - 0.05f * type.drag;
        float wobbleFactor = 0.0f;
        float throttleScaled = 0.01f * (type.maxThrottle + (data.engine == null ? 0.0f : data.engine.engineSpeed));
        if (!this.canThrust()) {
            throttleScaled = 0.0f;
        }
        int numPropsWorking = 0;
        int numProps = 0;
        float fuelConsumptionMultiplier = 2.0f;
        switch (this.mode) {
            case HELI: {
                for (Propeller prop : type.heliPropellers) {
                    if (!this.isPartIntact(prop.planePart)) continue;
                    ++numPropsWorking;
                }
                numProps = type.heliPropellers.size();
                Vector3f up = this.axes.getYAxis();
                float upwardsForce = this.throttle * (throttleScaled *= numProps == 0 ? 0.0f : (float)(numPropsWorking / numProps) * 2.0f) + (g - throttleScaled / 2.0f);
                if (this.throttle < 0.5f) {
                    upwardsForce = g * this.throttle * 2.0f;
                }
                if (!this.isPartIntact(EnumDriveablePart.blades)) {
                    upwardsForce = 0.0f;
                }
                this.field_70159_w += (double)(upwardsForce * up.x * 0.5f);
                this.field_70181_x += (double)(upwardsForce * up.y);
                this.field_70179_y += (double)(upwardsForce * up.z * 0.5f);
                this.field_70181_x -= (double)g;
                this.field_70159_w *= (double)drag;
                this.field_70181_x *= (double)drag;
                this.field_70179_y *= (double)drag;
                data.fuelInTank -= upwardsForce * fuelConsumptionMultiplier * data.engine.fuelConsumption;
                break;
            }
            case PLANE: {
                float amountOfLift;
                for (Propeller prop : type.propellers) {
                    if (!this.isPartIntact(prop.planePart)) continue;
                    ++numPropsWorking;
                }
                numProps = type.propellers.size();
                float throttleTemp = this.throttle * (numProps == 0 ? 0.0f : (float)(numPropsWorking / numProps) * 2.0f);
                Vector3f forwards = (Vector3f)this.axes.getXAxis().normalise();
                if (lastTickSpeed > 2.0f) {
                    lastTickSpeed = 2.0f;
                }
                float newSpeed = lastTickSpeed + throttleScaled * 2.0f;
                float proportionOfMotionToCorrect = 2.0f * throttleTemp - 0.5f;
                if (proportionOfMotionToCorrect < this.throttle * 0.25f) {
                    proportionOfMotionToCorrect = this.throttle * 0.25f;
                }
                if (proportionOfMotionToCorrect > 0.6f) {
                    proportionOfMotionToCorrect = 0.6f;
                }
                g = 0.049000002f;
                this.field_70181_x -= (double)g;
                int numWingsIntact = 0;
                if (this.isPartIntact(EnumDriveablePart.rightWing)) {
                    ++numWingsIntact;
                }
                if (this.isPartIntact(EnumDriveablePart.leftWing)) {
                    ++numWingsIntact;
                }
                if ((amountOfLift = 2.0f * g * throttleTemp * (float)numWingsIntact / 2.0f) > g) {
                    amountOfLift = g;
                }
                if (!this.isPartIntact(EnumDriveablePart.tail)) {
                    amountOfLift *= 0.75f;
                }
                this.field_70181_x += (double)amountOfLift;
                this.field_70159_w *= (double)(1.0f - proportionOfMotionToCorrect);
                this.field_70181_x *= (double)(1.0f - proportionOfMotionToCorrect);
                this.field_70179_y *= (double)(1.0f - proportionOfMotionToCorrect);
                this.field_70159_w += (double)(proportionOfMotionToCorrect * newSpeed * forwards.x);
                this.field_70181_x += (double)(proportionOfMotionToCorrect * newSpeed * forwards.y);
                this.field_70179_y += (double)(proportionOfMotionToCorrect * newSpeed * forwards.z);
                this.field_70159_w *= (double)drag;
                this.field_70181_x *= (double)drag;
                this.field_70179_y *= (double)drag;
                data.fuelInTank -= throttleScaled * fuelConsumptionMultiplier * data.engine.fuelConsumption;
                break;
            }
        }
        double motion = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y);
        if (motion > 10.0) {
            this.field_70159_w *= 10.0 / motion;
            this.field_70181_x *= 10.0 / motion;
            this.field_70179_y *= 10.0 / motion;
        }
        for (EntityWheel wheel : this.wheels) {
            if (wheel == null || this.field_70170_p == null) continue;
            wheel.field_70169_q = wheel.field_70165_t;
            wheel.field_70167_r = wheel.field_70163_u;
            wheel.field_70166_s = wheel.field_70161_v;
        }
        for (EntityWheel wheel : this.wheels) {
            if (wheel == null || this.field_70170_p == null || !type.floatOnWater || !this.field_70170_p.func_72953_d(wheel.func_174813_aQ())) continue;
            this.field_70181_x += (double)type.buoyancy;
        }
        for (EntityWheel wheel : this.wheels) {
            if (wheel == null) continue;
            wheel.field_70167_r = wheel.field_70163_u;
            wheel.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        }
        for (int i = 0; i < 2; ++i) {
            Vector3f amountToMoveCar = new Vector3f(this.field_70159_w / 2.0, this.field_70181_x / 2.0, this.field_70179_y / 2.0);
            for (EntityWheel wheel : this.wheels) {
                if (wheel == null) continue;
                this.field_70122_E = true;
                wheel.field_70122_E = true;
                wheel.field_70177_z = this.axes.getYaw();
                Vector3f targetWheelPos = this.axes.findLocalVectorGlobally(this.getPlaneType().wheelPositions[wheel.getExpectedWheelID()].position);
                Vector3f currentWheelPos = new Vector3f(wheel.field_70165_t - this.field_70165_t, wheel.field_70163_u - this.field_70163_u, wheel.field_70161_v - this.field_70161_v);
                float targetWheelLength = targetWheelPos.length();
                float currentWheelLength = currentWheelPos.length();
                float dLength = targetWheelLength - currentWheelLength;
                float dAngle = Vector3f.angle(targetWheelPos, currentWheelPos);
                float newLength = currentWheelLength + dLength * type.wheelSpringStrength;
                Vector3f rotateAround = Vector3f.cross(targetWheelPos, currentWheelPos, null);
                Matrix4f mat = new Matrix4f();
                mat.m00 = currentWheelPos.x;
                mat.m10 = currentWheelPos.y;
                mat.m20 = currentWheelPos.z;
                mat.rotate(dAngle * type.wheelSpringStrength, rotateAround);
                this.axes.rotateGlobal(-dAngle * type.wheelSpringStrength, rotateAround);
                Vector3f newWheelPos = new Vector3f(mat.m00, mat.m10, mat.m20);
                newWheelPos.normalise().scale(newLength);
                float wheelProportion = 0.75f;
                Vector3f amountToMoveWheel = new Vector3f();
                amountToMoveWheel.x = (newWheelPos.x - currentWheelPos.x) * (1.0f - wheelProportion);
                amountToMoveWheel.y = (newWheelPos.y - currentWheelPos.y) * (1.0f - wheelProportion);
                amountToMoveWheel.z = (newWheelPos.z - currentWheelPos.z) * (1.0f - wheelProportion);
                amountToMoveCar.x -= (newWheelPos.x - currentWheelPos.x) * (1.0f - wheelProportion);
                amountToMoveCar.y -= (newWheelPos.y - currentWheelPos.y) * (1.0f - wheelProportion);
                amountToMoveCar.z -= (newWheelPos.z - currentWheelPos.z) * (1.0f - wheelProportion);
                amountToMoveCar.y = (float)((double)amountToMoveCar.y + (wheel.field_70163_u - wheel.field_70167_r - this.field_70181_x) * 0.5 / (double)this.wheels.length);
                wheel.func_70091_d(MoverType.SELF, amountToMoveWheel.x, amountToMoveWheel.y, amountToMoveWheel.z);
            }
            this.func_70091_d(MoverType.SELF, amountToMoveCar.x, amountToMoveCar.y, amountToMoveCar.z);
        }
        this.checkForCollisions();
        if (this.throttle > 0.01f && this.throttle < 0.2f && this.soundPosition == 0 && this.hasEnoughFuel()) {
            PacketPlaySound.sendSoundPacket(this.field_70165_t, this.field_70163_u, this.field_70161_v, 50.0, this.field_71093_bK, type.startSound, false);
            this.soundPosition = type.startSoundLength;
        }
        if (this.throttle > 0.2f && this.soundPosition == 0 && this.hasEnoughFuel()) {
            PacketPlaySound.sendSoundPacket(this.field_70165_t, this.field_70163_u, this.field_70161_v, 50.0, this.field_71093_bK, type.engineSound, false);
            this.soundPosition = type.engineSoundLength;
        }
        if (this.soundPosition > 0) {
            --this.soundPosition;
        }
        for (EntitySeat seat : this.getSeats()) {
            if (seat == null) continue;
            seat.updatePosition();
        }
        if (thePlayerIsDrivingThis) {
            FlansMod.getPacketHandler().sendToServer(new PacketPlaneControl(this));
            this.field_70118_ct = this.field_70165_t;
            this.field_70117_cu = this.field_70163_u;
            this.field_70116_cv = this.field_70161_v;
            this.serverYaw = this.axes.getYaw();
        }
        float updateSpeed = 0.01f;
        if (!this.field_70170_p.field_72995_K) {
            FlansMod.getPacketHandler().sendToAllAround(new PacketPlaneControl(this), this.field_70165_t, this.field_70163_u, this.field_70161_v, 200.0f, this.field_71093_bK);
        }
    }

    public boolean canThrust() {
        return this.getSeat(0) != null && this.getSeat(0).func_184179_bs() instanceof EntityPlayer && ((EntityPlayer)this.getSeat((int)0).func_184179_bs()).field_71075_bZ.field_75098_d || this.driveableData.fuelInTank > 0.0f;
    }

    @Override
    public void func_70106_y() {
        super.func_70106_y();
    }

    @Override
    public boolean gearDown() {
        return this.varGear;
    }

    private boolean hasWorkingProp() {
        PlaneType type = this.getPlaneType();
        if (type.mode == EnumPlaneMode.HELI || type.mode == EnumPlaneMode.VTOL) {
            for (Propeller prop : type.heliPropellers) {
                if (!this.isPartIntact(prop.planePart)) continue;
                return true;
            }
        }
        if (type.mode == EnumPlaneMode.PLANE || type.mode == EnumPlaneMode.VTOL) {
            for (Propeller prop : type.propellers) {
                if (!this.isPartIntact(prop.planePart)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean attackEntityFrom(DamageSource damagesource, float i, boolean doDamage) {
        if (this.field_70170_p.field_72995_K || this.field_70128_L) {
            return true;
        }
        PlaneType type = PlaneType.getPlane(this.driveableType);
        if (damagesource.field_76373_n.equals("player") && damagesource.func_76346_g().field_70122_E && (this.getSeat(0) == null || this.getSeat(0).func_184179_bs() == null)) {
            ItemStack planeStack = new ItemStack(type.item, 1, this.driveableData.paintjobID);
            NBTTagCompound tags = new NBTTagCompound();
            planeStack.func_77982_d(tags);
            this.driveableData.writeToNBT(tags);
            this.func_70099_a(planeStack, 0.5f);
            this.func_70106_y();
        }
        return true;
    }

    @Override
    public boolean canHitPart(EnumDriveablePart part) {
        return this.varGear || part != EnumDriveablePart.coreWheel && part != EnumDriveablePart.leftWingWheel && part != EnumDriveablePart.rightWingWheel && part != EnumDriveablePart.tailWheel;
    }

    @Override
    public boolean func_70097_a(DamageSource damagesource, float i) {
        return this.attackEntityFrom(damagesource, i, true);
    }

    public PlaneType getPlaneType() {
        return PlaneType.getPlane(this.driveableType);
    }

    @Override
    protected void dropItemsOnPartDeath(Vector3f midpoint, DriveablePart part) {
    }

    @Override
    public String getBombInventoryName() {
        return "Bombs";
    }

    @Override
    public String getMissileInventoryName() {
        return "Missiles";
    }

    @Override
    public boolean hasMouseControlMode() {
        return true;
    }
}

