/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.client.teams;

import com.flansmod.client.gui.teams.GuiEditLoadout;
import com.flansmod.client.gui.teams.GuiLandingPage;
import com.flansmod.client.gui.teams.GuiMissionResults;
import com.flansmod.client.gui.teams.GuiOpenRewardBox;
import com.flansmod.client.gui.teams.GuiTeamScores;
import com.flansmod.client.gui.teams.GuiTeamSelect;
import com.flansmod.client.gui.teams.GuiVoting;
import com.flansmod.common.FlansMod;
import com.flansmod.common.guns.Paintjob;
import com.flansmod.common.network.PacketOpenRewardBox;
import com.flansmod.common.teams.LoadoutPool;
import com.flansmod.common.teams.PlayerRankData;
import com.flansmod.common.teams.RewardBoxInstance;
import com.flansmod.common.teams.RoundFinishedData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.fml.client.FMLClientHandler;

public class ClientTeamsData {
    public static PlayerRankData theRankData = null;
    public static LoadoutPool currentPool = null;
    public static RoundFinishedData roundFinishedData;
    public static int timeLeftInStage;
    public static int timeLeftTotal;
    public static RoundFinishedStage stage;
    public static String motd;

    public static void Tick() {
        --timeLeftTotal;
        --timeLeftInStage;
        switch (stage) {
            case NOT_FINISHED: {
                break;
            }
            case RANK_UPDATE: {
                if (!ClientTeamsData.StageFinished()) break;
                if (ClientTeamsData.roundFinishedData.votingEnabled) {
                    timeLeftInStage = ClientTeamsData.roundFinishedData.votingTime;
                    ClientTeamsData.SwitchTo(RoundFinishedStage.VOTING);
                    break;
                }
                ClientTeamsData.SwitchTo(RoundFinishedStage.NOT_FINISHED);
                break;
            }
            case SCORES: {
                if (!ClientTeamsData.StageFinished()) break;
                timeLeftInStage = ClientTeamsData.roundFinishedData.rankUpdateTime;
                ClientTeamsData.SwitchTo(RoundFinishedStage.RANK_UPDATE);
                break;
            }
            case VOTING: {
                if (!ClientTeamsData.StageFinished()) break;
                ClientTeamsData.SwitchTo(RoundFinishedStage.NOT_FINISHED);
                break;
            }
        }
        if (stage != RoundFinishedStage.NOT_FINISHED && Minecraft.func_71410_x().field_71462_r == null) {
            ClientTeamsData.OpenMenu();
        }
    }

    private static boolean StageFinished() {
        return timeLeftInStage <= 0;
    }

    private static void SwitchTo(RoundFinishedStage s) {
        stage = s;
        ClientTeamsData.OpenMenu();
    }

    private static void OpenMenu() {
        switch (stage) {
            case NOT_FINISHED: {
                if (!(Minecraft.func_71410_x().field_71462_r instanceof GuiVoting) && !(Minecraft.func_71410_x().field_71462_r instanceof GuiTeamScores) && !(Minecraft.func_71410_x().field_71462_r instanceof GuiMissionResults)) break;
                Minecraft.func_71410_x().func_147108_a(null);
                break;
            }
            case RANK_UPDATE: {
                Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiMissionResults());
                break;
            }
            case SCORES: {
                Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiTeamScores());
                break;
            }
            case VOTING: {
                Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiVoting());
                break;
            }
        }
    }

    public static void SetRoundFinishedData(RoundFinishedData data) {
        roundFinishedData = data;
        if (theRankData == null) {
            FlansMod.Assert(false, "Rank data null");
            return;
        }
        ClientTeamsData.theRankData.pendingXP = ClientTeamsData.roundFinishedData.pendingXP;
    }

    public static void StartTimers() {
        FlansMod.log("Starting round finished timers. Scores:" + ClientTeamsData.roundFinishedData.scoresTime + " RankUpdate:" + ClientTeamsData.roundFinishedData.rankUpdateTime + " Voting:" + ClientTeamsData.roundFinishedData.votingTime);
        timeLeftInStage = ClientTeamsData.roundFinishedData.scoresTime;
        timeLeftTotal = ClientTeamsData.roundFinishedData.scoresTime + ClientTeamsData.roundFinishedData.rankUpdateTime + ClientTeamsData.roundFinishedData.votingTime;
        ClientTeamsData.SwitchTo(RoundFinishedStage.SCORES);
    }

    public static void UpdateNumVotes(RoundFinishedData data) {
        if (roundFinishedData == null || ClientTeamsData.roundFinishedData.votingOptions == null) {
            return;
        }
        for (int i = 0; i < data.votingOptions.length; ++i) {
            if (i < ClientTeamsData.roundFinishedData.votingOptions.length) {
                ClientTeamsData.roundFinishedData.votingOptions[i].numVotes = data.votingOptions[i].numVotes;
                continue;
            }
            FlansMod.Assert(false, "Voting options mismatch");
        }
    }

    public static void UnlockReward(int boxHash, int unlockHash) {
        Paintjob paintjob = Paintjob.GetPaintjob(unlockHash);
        if (paintjob == null) {
            FlansMod.Assert(false, "Null paintjob unlock!");
            return;
        }
        boolean found = false;
        for (RewardBoxInstance instance : ClientTeamsData.theRankData.rewardBoxData) {
            if (instance.opened || instance.unlockHash != 0 || instance.boxHash != boxHash) continue;
            found = true;
            instance.opened = true;
            instance.unlockHash = unlockHash;
            break;
        }
        if (!found) {
            FlansMod.Assert(false, "Never had this reward box!");
            return;
        }
        if (Minecraft.func_71410_x().field_71462_r instanceof GuiOpenRewardBox) {
            ((GuiOpenRewardBox)Minecraft.func_71410_x().field_71462_r).SetTarget(paintjob);
        }
    }

    public static void OpenLandingPage() {
        FMLClientHandler.instance().getClient().func_147108_a((GuiScreen)new GuiLandingPage());
    }

    public static void OpenEditLoadoutPage(int loadout) {
        FMLClientHandler.instance().getClient().func_147108_a((GuiScreen)new GuiEditLoadout(loadout));
    }

    public static void OpenTeamSelectPage() {
        FMLClientHandler.instance().getClient().func_147108_a((GuiScreen)new GuiTeamSelect());
    }

    public static void OpenRewardBox(int i) {
        FlansMod.getPacketHandler().sendToServer(new PacketOpenRewardBox(ClientTeamsData.currentPool.rewardBoxes[i]));
        FMLClientHandler.instance().getClient().func_147108_a((GuiScreen)new GuiOpenRewardBox(ClientTeamsData.currentPool.rewardBoxes[i]));
    }

    public static void AddRewardBox(int boxHash) {
        theRankData.AddRewardBoxInstance(RewardBoxInstance.CreateClientRewardBoxInstance(boxHash, 0));
    }

    static {
        timeLeftInStage = 0;
        timeLeftTotal = 0;
        stage = RoundFinishedStage.NOT_FINISHED;
        motd = "";
    }

    public static enum RoundFinishedStage {
        NOT_FINISHED,
        SCORES,
        RANK_UPDATE,
        VOTING;

    }
}

