/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.client.model;

import com.flansmod.client.FlansModResourceHandler;
import com.flansmod.client.model.CustomItemRenderType;
import com.flansmod.client.model.CustomItemRenderer;
import com.flansmod.client.model.ModelDriveable;
import com.flansmod.client.model.ModelPlane;
import com.flansmod.common.FlansMod;
import com.flansmod.common.driveables.DriveablePart;
import com.flansmod.common.driveables.DriveablePosition;
import com.flansmod.common.driveables.DriveableType;
import com.flansmod.common.driveables.EntityDriveable;
import com.flansmod.common.driveables.EntityPlane;
import com.flansmod.common.driveables.ItemPlane;
import com.flansmod.common.driveables.PlaneType;
import com.flansmod.common.driveables.Propeller;
import com.flansmod.common.guns.Paintjob;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.opengl.GL11;

public class RenderPlane
extends Render
implements CustomItemRenderer {
    public RenderPlane(RenderManager renderManager) {
        super(renderManager);
        this.field_76989_e = 0.5f;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void render(EntityPlane entityPlane, double d, double d1, double d2, float f, float f1) {
        float dRoll;
        float dPitch;
        float dYaw;
        this.func_180548_c(entityPlane);
        PlaneType type = entityPlane.getPlaneType();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)d), (float)((float)d1), (float)((float)d2));
        for (dYaw = entityPlane.axes.getYaw() - entityPlane.field_70126_B; dYaw > 180.0f; dYaw -= 360.0f) {
        }
        while (dYaw <= -180.0f) {
            dYaw += 360.0f;
        }
        for (dPitch = entityPlane.axes.getPitch() - entityPlane.field_70127_C; dPitch > 180.0f; dPitch -= 360.0f) {
        }
        while (dPitch <= -180.0f) {
            dPitch += 360.0f;
        }
        for (dRoll = entityPlane.axes.getRoll() - entityPlane.prevRotationRoll; dRoll > 180.0f; dRoll -= 360.0f) {
        }
        while (dRoll <= -180.0f) {
            dRoll += 360.0f;
        }
        GL11.glRotatef((float)(180.0f - entityPlane.field_70126_B - dYaw * f1), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(entityPlane.field_70127_C + dPitch * f1), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)(entityPlane.prevRotationRoll + dRoll * f1), (float)1.0f, (float)0.0f, (float)0.0f);
        float modelScale = type.modelScale;
        GL11.glScalef((float)modelScale, (float)modelScale, (float)modelScale);
        ModelPlane model = (ModelPlane)type.model;
        if (model != null) {
            int i;
            model.render(entityPlane, f1);
            for (i = 0; i < model.heliMainRotorModels.length; ++i) {
                GL11.glPushMatrix();
                GL11.glTranslatef((float)model.heliMainRotorOrigins[i].x, (float)model.heliMainRotorOrigins[i].y, (float)model.heliMainRotorOrigins[i].z);
                GL11.glRotatef((float)((entityPlane.propAngle + f1 * entityPlane.throttle / 7.0f) * model.heliRotorSpeeds[i] * 1440.0f / (float)Math.PI), (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glTranslatef((float)(-model.heliMainRotorOrigins[i].x), (float)(-model.heliMainRotorOrigins[i].y), (float)(-model.heliMainRotorOrigins[i].z));
                model.renderRotor(entityPlane, 0.0625f, i);
                GL11.glPopMatrix();
            }
            for (i = 0; i < model.heliTailRotorModels.length; ++i) {
                GL11.glPushMatrix();
                GL11.glTranslatef((float)model.heliTailRotorOrigins[i].x, (float)model.heliTailRotorOrigins[i].y, (float)model.heliTailRotorOrigins[i].z);
                GL11.glRotatef((float)((entityPlane.propAngle + f1 * entityPlane.throttle / 7.0f) * 1440.0f / (float)Math.PI), (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glTranslatef((float)(-model.heliTailRotorOrigins[i].x), (float)(-model.heliTailRotorOrigins[i].y), (float)(-model.heliTailRotorOrigins[i].z));
                model.renderTailRotor(entityPlane, 0.0625f, i);
                GL11.glPopMatrix();
            }
        }
        if (FlansMod.DEBUG) {
            GL11.glDisable((int)3553);
            GL11.glEnable((int)3042);
            GL11.glDisable((int)2929);
            GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)0.3f);
            GL11.glScalef((float)-1.0f, (float)1.0f, (float)-1.0f);
            for (DriveablePart part : entityPlane.getDriveableData().parts.values()) {
                if (part.box == null) continue;
                GL11.glColor4f((float)1.0f, (float)(entityPlane.isPartIntact(part.type) ? 1.0f : 0.0f), (float)0.0f, (float)0.3f);
                RenderPlane.func_76978_a((AxisAlignedBB)new AxisAlignedBB((double)part.box.x, (double)part.box.y, (double)part.box.z, (double)(part.box.x + part.box.w), (double)(part.box.y + part.box.h), (double)(part.box.z + part.box.d)), (double)0.0, (double)0.0, (double)0.0);
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)0.0f, (float)0.3f);
            for (Propeller prop : type.propellers) {
                RenderPlane.func_76978_a((AxisAlignedBB)new AxisAlignedBB((double)((float)prop.x / 16.0f - 0.25f), (double)((float)prop.y / 16.0f - 0.25f), (double)((float)prop.z / 16.0f - 0.25f), (double)((float)prop.x / 16.0f + 0.25f), (double)((float)prop.y / 16.0f + 0.25f), (double)((float)prop.z / 16.0f + 0.25f)), (double)0.0, (double)0.0, (double)0.0);
            }
            GL11.glColor4f((float)1.0f, (float)0.0f, (float)1.0f, (float)0.3f);
            for (DriveablePosition point : type.shootPointsPrimary) {
                RenderPlane.func_76978_a((AxisAlignedBB)new AxisAlignedBB((double)(point.position.x - 0.25f), (double)(point.position.y - 0.25f), (double)(point.position.z - 0.25f), (double)(point.position.x + 0.25f), (double)(point.position.y + 0.25f), (double)(point.position.z + 0.25f)), (double)0.0, (double)0.0, (double)0.0);
            }
            GL11.glColor4f((float)0.0f, (float)1.0f, (float)0.0f, (float)0.3f);
            for (DriveablePosition point : type.shootPointsSecondary) {
                RenderPlane.func_76978_a((AxisAlignedBB)new AxisAlignedBB((double)(point.position.x - 0.25f), (double)(point.position.y - 0.25f), (double)(point.position.z - 0.25f), (double)(point.position.x + 0.25f), (double)(point.position.y + 0.25f), (double)(point.position.z + 0.25f)), (double)0.0, (double)0.0, (double)0.0);
            }
            GL11.glEnable((int)3553);
            GL11.glEnable((int)2929);
            GL11.glDisable((int)3042);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        GL11.glPopMatrix();
    }

    public boolean func_177071_a(Entity entity, ICamera camera, double camX, double camY, double camZ) {
        return true;
    }

    public void func_76986_a(Entity entity, double d, double d1, double d2, float f, float f1) {
    }

    protected ResourceLocation func_110775_a(Entity entity) {
        DriveableType type = ((EntityDriveable)entity).getDriveableType();
        Paintjob paintjob = type.getPaintjob(((EntityDriveable)entity).getDriveableData().paintjobID);
        return FlansModResourceHandler.getPaintjobTexture(paintjob);
    }

    @SubscribeEvent
    public void renderWorld(RenderWorldLastEvent event) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (world == null) {
            return;
        }
        Entity camera = Minecraft.func_71410_x().func_175606_aa();
        double x = camera.field_70142_S + (camera.field_70165_t - camera.field_70142_S) * (double)event.getPartialTicks();
        double y = camera.field_70137_T + (camera.field_70163_u - camera.field_70137_T) * (double)event.getPartialTicks();
        double z = camera.field_70136_U + (camera.field_70161_v - camera.field_70136_U) * (double)event.getPartialTicks();
        GL11.glPushMatrix();
        Minecraft.func_71410_x().field_71460_t.func_180436_i();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
        RenderHelper.func_74519_b();
        GL11.glTranslatef((float)(-((float)x)), (float)(-((float)y)), (float)(-((float)z)));
        for (Object entity : world.field_72996_f) {
            if (!(entity instanceof EntityPlane)) continue;
            EntityPlane plane = (EntityPlane)entity;
            int i = plane.func_70070_b();
            if (plane.func_70027_ad()) {
                i = 0xF000F0;
            }
            int j = i % 65536;
            int k = i / 65536;
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)j / 1.0f), (float)((float)k / 1.0f));
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.render(plane, plane.field_70169_q + (plane.field_70165_t - plane.field_70169_q) * (double)event.getPartialTicks(), plane.field_70167_r + (plane.field_70163_u - plane.field_70167_r) * (double)event.getPartialTicks(), plane.field_70166_s + (plane.field_70161_v - plane.field_70166_s) * (double)event.getPartialTicks(), 0.0f, event.getPartialTicks());
        }
        Minecraft.func_71410_x().field_71460_t.func_175072_h();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        GL11.glPopMatrix();
    }

    @Override
    public void renderItem(CustomItemRenderType type, EnumHand hand, ItemStack item, Object ... data) {
        GL11.glPushMatrix();
        if (item != null && item.func_77973_b() instanceof ItemPlane) {
            PlaneType planeType = ((ItemPlane)item.func_77973_b()).type;
            if (planeType.model != null) {
                float scale = 0.5f;
                switch (type) {
                    case INVENTORY: {
                        GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        scale = 1.0f;
                        break;
                    }
                    case ENTITY: {
                        scale = 1.5f;
                        break;
                    }
                    case EQUIPPED: {
                        GL11.glRotatef((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                        GL11.glRotatef((float)270.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                        GL11.glRotatef((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        GL11.glTranslatef((float)0.0f, (float)0.25f, (float)0.0f);
                        scale = 0.5f;
                        break;
                    }
                    case EQUIPPED_FIRST_PERSON: {
                        if (hand == EnumHand.MAIN_HAND) {
                            GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                            GL11.glTranslatef((float)-0.5f, (float)0.5f, (float)-0.5f);
                            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        } else {
                            GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                            GL11.glTranslatef((float)-0.5f, (float)0.5f, (float)-2.3f);
                            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        }
                        scale = 1.0f;
                        break;
                    }
                }
                GL11.glScalef((float)(scale / planeType.cameraDistance), (float)(scale / planeType.cameraDistance), (float)(scale / planeType.cameraDistance));
                Minecraft.func_71410_x().field_71446_o.func_110577_a(FlansModResourceHandler.getTexture(planeType));
                ModelDriveable model = planeType.model;
                model.render(planeType);
            }
        }
        GL11.glPopMatrix();
    }

    public static class Factory
    implements IRenderFactory {
        public Render createRenderFor(RenderManager manager) {
            return new RenderPlane(manager);
        }
    }
}

