/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.client.model;

import com.flansmod.client.FlansModClient;
import com.flansmod.client.FlansModResourceHandler;
import com.flansmod.client.util.WorldRenderer;
import com.flansmod.common.guns.BulletType;
import com.flansmod.common.vector.Vector3f;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class InstantBulletRenderer {
    private static TextureManager textureManager;
    private static ArrayList<InstantShotTrail> trails;

    public static void AddTrail(InstantShotTrail trail) {
        trails.add(trail);
    }

    public static void RenderAllTrails(float partialTicks) {
        for (InstantShotTrail trail : trails) {
            trail.Render(partialTicks);
        }
    }

    public static void UpdateAllTrails() {
        for (int i = trails.size() - 1; i >= 0; --i) {
            if (!trails.get(i).Update()) continue;
            trails.remove(i);
        }
    }

    static {
        trails = new ArrayList();
    }

    public static class InstantShotTrail {
        private Vector3f origin;
        private Vector3f hitPos;
        private float width;
        private float length;
        private float distanceToTarget;
        private float bulletSpeed = 10.0f;
        private int ticksExisted = 0;
        private ResourceLocation texture;

        public InstantShotTrail(Vector3f origin, Vector3f hitPos, BulletType type) {
            this.origin = origin;
            this.hitPos = hitPos;
            this.width = 0.05f;
            this.length = 10.0f;
            this.texture = FlansModResourceHandler.getTrailTexture(type);
            Vector3f dPos = Vector3f.sub(hitPos, origin, null);
            this.distanceToTarget = dPos.length();
            if (Math.abs(this.distanceToTarget) > 300.0f) {
                this.distanceToTarget = 300.0f;
            }
        }

        public boolean Update() {
            ++this.ticksExisted;
            return (float)this.ticksExisted * this.bulletSpeed >= this.distanceToTarget - this.length;
        }

        public void Render(float partialTicks) {
            if (textureManager == null) {
                textureManager = Minecraft.func_71410_x().field_71446_o;
            }
            textureManager.func_110577_a(this.texture);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179094_E();
            Entity camera = Minecraft.func_71410_x().func_175606_aa();
            double x = camera.field_70142_S + (camera.field_70165_t - camera.field_70142_S) * (double)partialTicks;
            double y = camera.field_70137_T + (camera.field_70163_u - camera.field_70137_T) * (double)partialTicks;
            double z = camera.field_70136_U + (camera.field_70161_v - camera.field_70136_U) * (double)partialTicks;
            GL11.glTranslatef((float)(-((float)x)), (float)(-((float)y)), (float)(-((float)z)));
            float parametric = ((float)this.ticksExisted + partialTicks) * this.bulletSpeed;
            Vector3f dPos = Vector3f.sub(this.hitPos, this.origin, null);
            dPos.normalise();
            float startParametric = parametric - this.length * 0.5f;
            Vector3f startPos = new Vector3f(this.origin.x + dPos.x * startParametric, this.origin.y + dPos.y * startParametric, this.origin.z + dPos.z * startParametric);
            float endParametric = parametric + this.length * 0.5f;
            Vector3f endPos = new Vector3f(this.origin.x + dPos.x * endParametric, this.origin.y + dPos.y * endParametric, this.origin.z + dPos.z * endParametric);
            WorldRenderer worldrenderer = FlansModClient.getWorldRenderer();
            dPos.normalise();
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            Vector3f vectorToPlayer = new Vector3f(player.field_70165_t - (double)this.hitPos.x, player.field_70163_u - (double)this.hitPos.y, player.field_70161_v - (double)this.hitPos.z);
            vectorToPlayer.normalise();
            Vector3f trailTangent = Vector3f.cross(dPos, vectorToPlayer, null);
            trailTangent.normalise();
            trailTangent.scale(-this.width * 0.5f);
            Vector3f normal = Vector3f.cross(trailTangent, dPos, null);
            normal.normalise();
            GlStateManager.func_179091_B();
            GL11.glNormal3f((float)normal.x, (float)normal.y, (float)normal.z);
            worldrenderer.startDrawingQuads();
            worldrenderer.addVertexWithUV(startPos.x + trailTangent.x, startPos.y + trailTangent.y, startPos.z + trailTangent.z, 0.0, 0.0);
            worldrenderer.addVertexWithUV(startPos.x - trailTangent.x, startPos.y - trailTangent.y, startPos.z - trailTangent.z, 0.0, 1.0);
            worldrenderer.addVertexWithUV(endPos.x - trailTangent.x, endPos.y - trailTangent.y, endPos.z - trailTangent.z, 1.0, 1.0);
            worldrenderer.addVertexWithUV(endPos.x + trailTangent.x, endPos.y + trailTangent.y, endPos.z + trailTangent.z, 1.0, 0.0);
            worldrenderer.draw();
            GlStateManager.func_179101_C();
            GlStateManager.func_179121_F();
        }
    }
}

