/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.apocalypse.common.world.buildings;

import com.flansmod.apocalypse.common.FlansModApocalypse;
import com.flansmod.apocalypse.common.world.buildings.MapGenAbandonedVillage;
import com.flansmod.common.FlansMod;
import com.flansmod.common.TileEntityItemHolder;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSandStone;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.BiomeEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.registry.VillagerRegistry;

public class StructureAbandonedVillagePieces {
    private static final String __OBFID = "CL_00000516";

    public static void registerVillagePieces() {
        MapGenStructureIO.func_143031_a(Library.class, (String)"AVBH");
        MapGenStructureIO.func_143031_a(Field1.class, (String)"AVDF");
        MapGenStructureIO.func_143031_a(Field2.class, (String)"AVF");
        MapGenStructureIO.func_143031_a(Torch.class, (String)"AVL");
        MapGenStructureIO.func_143031_a(Hall.class, (String)"AVPH");
        MapGenStructureIO.func_143031_a(House4Garden.class, (String)"AVSH");
        MapGenStructureIO.func_143031_a(WoodHut.class, (String)"AVSmH");
        MapGenStructureIO.func_143031_a(Church.class, (String)"AVST");
        MapGenStructureIO.func_143031_a(Blacksmith.class, (String)"AVS");
        MapGenStructureIO.func_143031_a(Start.class, (String)"AVStart");
        MapGenStructureIO.func_143031_a(Path.class, (String)"AVSR");
        MapGenStructureIO.func_143031_a(House3.class, (String)"AVTRH");
        MapGenStructureIO.func_143031_a(Well.class, (String)"AVW");
        MapGenStructureIO.func_143034_b(MapGenAbandonedVillage.Start.class, (String)"AbandonedVillage");
    }

    public static List getStructureVillageWeightedPieceList(Random p_75084_0_, int p_75084_1_) {
        ArrayList arraylist = Lists.newArrayList();
        arraylist.add(new PieceWeight(House4Garden.class, 4, MathHelper.func_76136_a((Random)p_75084_0_, (int)(2 + p_75084_1_), (int)(4 + p_75084_1_ * 2))));
        arraylist.add(new PieceWeight(Church.class, 20, MathHelper.func_76136_a((Random)p_75084_0_, (int)(0 + p_75084_1_), (int)(1 + p_75084_1_))));
        arraylist.add(new PieceWeight(Library.class, 20, MathHelper.func_76136_a((Random)p_75084_0_, (int)(0 + p_75084_1_), (int)(2 + p_75084_1_))));
        arraylist.add(new PieceWeight(WoodHut.class, 3, MathHelper.func_76136_a((Random)p_75084_0_, (int)(2 + p_75084_1_), (int)(5 + p_75084_1_ * 3))));
        arraylist.add(new PieceWeight(Hall.class, 15, MathHelper.func_76136_a((Random)p_75084_0_, (int)(0 + p_75084_1_), (int)(2 + p_75084_1_))));
        arraylist.add(new PieceWeight(Field1.class, 3, MathHelper.func_76136_a((Random)p_75084_0_, (int)(1 + p_75084_1_), (int)(4 + p_75084_1_))));
        arraylist.add(new PieceWeight(Field2.class, 3, MathHelper.func_76136_a((Random)p_75084_0_, (int)(2 + p_75084_1_), (int)(4 + p_75084_1_ * 2))));
        arraylist.add(new PieceWeight(Blacksmith.class, 15, MathHelper.func_76136_a((Random)p_75084_0_, (int)0, (int)(1 + p_75084_1_))));
        arraylist.add(new PieceWeight(House3.class, 8, MathHelper.func_76136_a((Random)p_75084_0_, (int)(0 + p_75084_1_), (int)(3 + p_75084_1_ * 2))));
        VillagerRegistry.addExtraVillageComponents((List)arraylist, (Random)p_75084_0_, (int)p_75084_1_);
        Iterator iterator = arraylist.iterator();
        while (iterator.hasNext()) {
            if (((PieceWeight)iterator.next()).villagePiecesLimit != 0) continue;
            iterator.remove();
        }
        return arraylist;
    }

    private static int func_75079_a(List p_75079_0_) {
        boolean flag = false;
        int i = 0;
        for (PieceWeight pieceweight : p_75079_0_) {
            if (pieceweight.villagePiecesLimit > 0 && pieceweight.villagePiecesSpawned < pieceweight.villagePiecesLimit) {
                flag = true;
            }
            i += pieceweight.villagePieceWeight;
        }
        return flag ? i : -1;
    }

    private static Village func_176065_a(Start p_176065_0_, PieceWeight p_176065_1_, List p_176065_2_, Random p_176065_3_, int p_176065_4_, int p_176065_5_, int p_176065_6_, EnumFacing p_176065_7_, int p_176065_8_) {
        Class oclass = p_176065_1_.villagePieceClass;
        Village object = null;
        if (oclass == House4Garden.class) {
            object = House4Garden.func_175858_a(p_176065_0_, p_176065_2_, p_176065_3_, p_176065_4_, p_176065_5_, p_176065_6_, p_176065_7_, p_176065_8_);
        } else if (oclass == Church.class) {
            object = Church.func_175854_a(p_176065_0_, p_176065_2_, p_176065_3_, p_176065_4_, p_176065_5_, p_176065_6_, p_176065_7_, p_176065_8_);
        } else if (oclass == Library.class) {
            object = Library.func_175850_a(p_176065_0_, p_176065_2_, p_176065_3_, p_176065_4_, p_176065_5_, p_176065_6_, p_176065_7_, p_176065_8_);
        } else if (oclass == WoodHut.class) {
            object = WoodHut.func_175853_a(p_176065_0_, p_176065_2_, p_176065_3_, p_176065_4_, p_176065_5_, p_176065_6_, p_176065_7_, p_176065_8_);
        } else if (oclass == Hall.class) {
            object = Hall.func_175857_a(p_176065_0_, p_176065_2_, p_176065_3_, p_176065_4_, p_176065_5_, p_176065_6_, p_176065_7_, p_176065_8_);
        } else if (oclass == Field1.class) {
            object = Field1.func_175851_a(p_176065_0_, p_176065_2_, p_176065_3_, p_176065_4_, p_176065_5_, p_176065_6_, p_176065_7_, p_176065_8_);
        } else if (oclass == Field2.class) {
            object = Field2.func_175852_a(p_176065_0_, p_176065_2_, p_176065_3_, p_176065_4_, p_176065_5_, p_176065_6_, p_176065_7_, p_176065_8_);
        } else if (oclass == Blacksmith.class) {
            object = Blacksmith.func_175855_a(p_176065_0_, p_176065_2_, p_176065_3_, p_176065_4_, p_176065_5_, p_176065_6_, p_176065_7_, p_176065_8_);
        } else if (oclass == House3.class) {
            object = House3.func_175849_a(p_176065_0_, p_176065_2_, p_176065_3_, p_176065_4_, p_176065_5_, p_176065_6_, p_176065_7_, p_176065_8_);
        }
        return object;
    }

    private static Village func_176067_c(Start p_176067_0_, List p_176067_1_, Random p_176067_2_, int p_176067_3_, int p_176067_4_, int p_176067_5_, EnumFacing p_176067_6_, int p_176067_7_) {
        int i1 = StructureAbandonedVillagePieces.func_75079_a(p_176067_0_.structureVillageWeightedPieceList);
        if (i1 <= 0) {
            return null;
        }
        int j1 = 0;
        block0: while (j1 < 5) {
            ++j1;
            int k1 = p_176067_2_.nextInt(i1);
            for (PieceWeight pieceweight : p_176067_0_.structureVillageWeightedPieceList) {
                if ((k1 -= pieceweight.villagePieceWeight) >= 0) continue;
                if (!pieceweight.canSpawnMoreVillagePiecesOfType(p_176067_7_) || pieceweight == p_176067_0_.structVillagePieceWeight && p_176067_0_.structureVillageWeightedPieceList.size() > 1) continue block0;
                Village village = StructureAbandonedVillagePieces.func_176065_a(p_176067_0_, pieceweight, p_176067_1_, p_176067_2_, p_176067_3_, p_176067_4_, p_176067_5_, p_176067_6_, p_176067_7_);
                if (village == null) continue;
                ++pieceweight.villagePiecesSpawned;
                p_176067_0_.structVillagePieceWeight = pieceweight;
                if (!pieceweight.canSpawnMoreVillagePieces()) {
                    p_176067_0_.structureVillageWeightedPieceList.remove(pieceweight);
                }
                return village;
            }
        }
        StructureBoundingBox structureboundingbox = Torch.func_175856_a(p_176067_0_, p_176067_1_, p_176067_2_, p_176067_3_, p_176067_4_, p_176067_5_, p_176067_6_);
        if (structureboundingbox != null) {
            return new Torch(p_176067_0_, p_176067_7_, p_176067_2_, structureboundingbox, p_176067_6_);
        }
        return null;
    }

    private static StructureComponent func_176066_d(Start p_176066_0_, List p_176066_1_, Random p_176066_2_, int p_176066_3_, int p_176066_4_, int p_176066_5_, EnumFacing p_176066_6_, int p_176066_7_) {
        if (p_176066_7_ > 50) {
            return null;
        }
        if (Math.abs(p_176066_3_ - p_176066_0_.func_74874_b().field_78897_a) <= 112 && Math.abs(p_176066_5_ - p_176066_0_.func_74874_b().field_78896_c) <= 112) {
            Village village = StructureAbandonedVillagePieces.func_176067_c(p_176066_0_, p_176066_1_, p_176066_2_, p_176066_3_, p_176066_4_, p_176066_5_, p_176066_6_, p_176066_7_ + 1);
            if (village != null) {
                int i2;
                int i1 = (village.func_74874_b().field_78897_a + village.func_74874_b().field_78893_d) / 2;
                int j1 = (village.func_74874_b().field_78896_c + village.func_74874_b().field_78892_f) / 2;
                int k1 = village.func_74874_b().field_78893_d - village.func_74874_b().field_78897_a;
                int l1 = village.func_74874_b().field_78892_f - village.func_74874_b().field_78896_c;
                int n = i2 = k1 > l1 ? k1 : l1;
                if (p_176066_0_.getBiomeProvider().func_76940_a(i1, j1, i2 / 2 + 4, MapGenAbandonedVillage.villageSpawnBiomes)) {
                    p_176066_1_.add(village);
                    p_176066_0_.field_74932_i.add(village);
                    return village;
                }
            }
            return null;
        }
        return null;
    }

    private static StructureComponent func_176069_e(Start p_176069_0_, List p_176069_1_, Random p_176069_2_, int p_176069_3_, int p_176069_4_, int p_176069_5_, EnumFacing p_176069_6_, int p_176069_7_) {
        if (p_176069_7_ > 3 + p_176069_0_.terrainType) {
            return null;
        }
        if (Math.abs(p_176069_3_ - p_176069_0_.func_74874_b().field_78897_a) <= 112 && Math.abs(p_176069_5_ - p_176069_0_.func_74874_b().field_78896_c) <= 112) {
            StructureBoundingBox structureboundingbox = Path.func_175848_a(p_176069_0_, p_176069_1_, p_176069_2_, p_176069_3_, p_176069_4_, p_176069_5_, p_176069_6_);
            if (structureboundingbox != null && structureboundingbox.field_78895_b > 10) {
                int i2;
                Path path = new Path(p_176069_0_, p_176069_7_, p_176069_2_, structureboundingbox, p_176069_6_);
                int i1 = (path.func_74874_b().field_78897_a + path.func_74874_b().field_78893_d) / 2;
                int j1 = (path.func_74874_b().field_78896_c + path.func_74874_b().field_78892_f) / 2;
                int k1 = path.func_74874_b().field_78893_d - path.func_74874_b().field_78897_a;
                int l1 = path.func_74874_b().field_78892_f - path.func_74874_b().field_78896_c;
                int n = i2 = k1 > l1 ? k1 : l1;
                if (p_176069_0_.getBiomeProvider().func_76940_a(i1, j1, i2 / 2 + 4, MapGenAbandonedVillage.villageSpawnBiomes)) {
                    p_176069_1_.add(path);
                    p_176069_0_.field_74930_j.add(path);
                    return path;
                }
            }
            return null;
        }
        return null;
    }

    public static class WoodHut
    extends Village {
        private boolean isTallHouse;
        private int tablePosition;
        private static final String __OBFID = "CL_00000524";

        public WoodHut() {
        }

        public WoodHut(Start p_i45565_1_, int p_i45565_2_, Random p_i45565_3_, StructureBoundingBox p_i45565_4_, EnumFacing p_i45565_5_) {
            super(p_i45565_1_, p_i45565_2_);
            this.func_186164_a(p_i45565_5_);
            this.field_74887_e = p_i45565_4_;
            this.isTallHouse = p_i45565_3_.nextBoolean();
            this.tablePosition = p_i45565_3_.nextInt(3);
        }

        @Override
        protected void func_143012_a(NBTTagCompound p_143012_1_) {
            super.func_143012_a(p_143012_1_);
            p_143012_1_.func_74768_a("T", this.tablePosition);
            p_143012_1_.func_74757_a("C", this.isTallHouse);
        }

        @Override
        protected void func_143011_b(NBTTagCompound p_143011_1_, TemplateManager man) {
            super.func_143011_b(p_143011_1_, man);
            this.tablePosition = p_143011_1_.func_74762_e("T");
            this.isTallHouse = p_143011_1_.func_74767_n("C");
        }

        public static WoodHut func_175853_a(Start p_175853_0_, List p_175853_1_, Random p_175853_2_, int p_175853_3_, int p_175853_4_, int p_175853_5_, EnumFacing p_175853_6_, int p_175853_7_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)p_175853_3_, (int)p_175853_4_, (int)p_175853_5_, (int)0, (int)0, (int)0, (int)4, (int)6, (int)5, (EnumFacing)p_175853_6_);
            return WoodHut.canVillageGoDeeper(structureboundingbox) && StructureComponent.func_74883_a((List)p_175853_1_, (StructureBoundingBox)structureboundingbox) == null ? new WoodHut(p_175853_0_, p_175853_7_, p_175853_2_, structureboundingbox, p_175853_6_) : null;
        }

        public boolean func_74875_a(World worldIn, Random p_74875_2_, StructureBoundingBox p_74875_3_) {
            if (this.field_143015_k < 0) {
                this.field_143015_k = this.getAverageGroundLevel(worldIn, p_74875_3_);
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78894_e + 6 - 1, 0);
            }
            this.func_175804_a(worldIn, p_74875_3_, 1, 1, 1, 3, 5, 4, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 0, 0, 0, 3, 0, 4, Blocks.field_150347_e.func_176223_P(), Blocks.field_150347_e.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 1, 0, 1, 2, 0, 3, Blocks.field_150346_d.func_176223_P(), Blocks.field_150346_d.func_176223_P(), false);
            this.func_175811_a(worldIn, Blocks.field_150364_r.func_176223_P(), 1, 1, 0, p_74875_3_);
            for (int i = 0; i < 5; ++i) {
                for (int j = 0; j < 4; ++j) {
                    this.func_74871_b(worldIn, j, 6, i, p_74875_3_);
                    this.func_175808_b(worldIn, Blocks.field_150347_e.func_176223_P(), j, -1, i, p_74875_3_);
                }
            }
            this.spawnVillagers(worldIn, p_74875_3_, 1, 1, 2, 1);
            return true;
        }
    }

    public static class Well
    extends Village {
        private static final String __OBFID = "CL_00000533";

        public Well() {
        }

        public Well(Start p_i2109_1_, int p_i2109_2_, Random p_i2109_3_, int p_i2109_4_, int p_i2109_5_) {
            super(p_i2109_1_, p_i2109_2_);
            this.func_186164_a(EnumFacing.Plane.HORIZONTAL.func_179518_a(p_i2109_3_));
            switch (this.func_186165_e()) {
                case NORTH: 
                case SOUTH: {
                    this.field_74887_e = new StructureBoundingBox(p_i2109_4_, 64, p_i2109_5_, p_i2109_4_ + 6 - 1, 78, p_i2109_5_ + 6 - 1);
                    break;
                }
                default: {
                    this.field_74887_e = new StructureBoundingBox(p_i2109_4_, 64, p_i2109_5_, p_i2109_4_ + 6 - 1, 78, p_i2109_5_ + 6 - 1);
                }
            }
        }

        public void func_74861_a(StructureComponent p_74861_1_, List p_74861_2_, Random p_74861_3_) {
            StructureAbandonedVillagePieces.func_176069_e((Start)p_74861_1_, p_74861_2_, p_74861_3_, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78894_e - 4, this.field_74887_e.field_78896_c + 1, EnumFacing.WEST, this.func_74877_c());
            StructureAbandonedVillagePieces.func_176069_e((Start)p_74861_1_, p_74861_2_, p_74861_3_, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78894_e - 4, this.field_74887_e.field_78896_c + 1, EnumFacing.EAST, this.func_74877_c());
            StructureAbandonedVillagePieces.func_176069_e((Start)p_74861_1_, p_74861_2_, p_74861_3_, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78894_e - 4, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, this.func_74877_c());
            StructureAbandonedVillagePieces.func_176069_e((Start)p_74861_1_, p_74861_2_, p_74861_3_, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78894_e - 4, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, this.func_74877_c());
        }

        public boolean func_74875_a(World worldIn, Random p_74875_2_, StructureBoundingBox p_74875_3_) {
            if (this.field_143015_k < 0) {
                this.field_143015_k = this.getAverageGroundLevel(worldIn, p_74875_3_);
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78894_e + 3, 0);
            }
            this.func_175804_a(worldIn, p_74875_3_, 1, 0, 1, 4, 12, 4, Blocks.field_150347_e.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175811_a(worldIn, Blocks.field_150358_i.func_176223_P(), 2, 1, 2, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 2, 12, 2, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 3, 12, 2, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 2, 12, 3, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 3, 12, 3, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_180407_aO.func_176223_P(), 1, 13, 1, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_180407_aO.func_176223_P(), 4, 13, 1, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_180407_aO.func_176223_P(), 4, 14, 1, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_180407_aO.func_176223_P(), 4, 13, 4, p_74875_3_);
            for (int i = 0; i <= 5; ++i) {
                for (int j = 0; j <= 5; ++j) {
                    if (j != 0 && j != 5 && i != 0 && i != 5) continue;
                    this.func_175811_a(worldIn, Blocks.field_150351_n.func_176223_P(), j, 11, i, p_74875_3_);
                    this.func_74871_b(worldIn, j, 12, i, p_74875_3_);
                }
            }
            return true;
        }
    }

    public static abstract class Village
    extends StructureComponent {
        protected int field_143015_k = -1;
        private int villagersSpawned;
        private boolean field_143014_b;
        private static final String __OBFID = "CL_00000531";
        private Start startPiece;

        public Village() {
        }

        protected Village(Start p_i2107_1_, int p_i2107_2_) {
            super(p_i2107_2_);
            if (p_i2107_1_ != null) {
                this.field_143014_b = p_i2107_1_.inDesert;
                this.startPiece = p_i2107_1_;
            }
        }

        protected void func_143012_a(NBTTagCompound p_143012_1_) {
            p_143012_1_.func_74768_a("HPos", this.field_143015_k);
            p_143012_1_.func_74768_a("VCount", this.villagersSpawned);
            p_143012_1_.func_74757_a("Desert", this.field_143014_b);
        }

        protected void func_143011_b(NBTTagCompound p_143011_1_, TemplateManager p_143011_2_) {
            this.field_143015_k = p_143011_1_.func_74762_e("HPos");
            this.villagersSpawned = p_143011_1_.func_74762_e("VCount");
            this.field_143014_b = p_143011_1_.func_74767_n("Desert");
        }

        protected StructureComponent getNextComponentNN(Start p_74891_1_, List p_74891_2_, Random p_74891_3_, int p_74891_4_, int p_74891_5_) {
            if (this.func_186165_e() != null) {
                switch (this.func_186165_e()) {
                    case NORTH: {
                        return StructureAbandonedVillagePieces.func_176066_d(p_74891_1_, p_74891_2_, p_74891_3_, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + p_74891_4_, this.field_74887_e.field_78896_c + p_74891_5_, EnumFacing.WEST, this.func_74877_c());
                    }
                    case SOUTH: {
                        return StructureAbandonedVillagePieces.func_176066_d(p_74891_1_, p_74891_2_, p_74891_3_, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + p_74891_4_, this.field_74887_e.field_78896_c + p_74891_5_, EnumFacing.WEST, this.func_74877_c());
                    }
                    case WEST: {
                        return StructureAbandonedVillagePieces.func_176066_d(p_74891_1_, p_74891_2_, p_74891_3_, this.field_74887_e.field_78897_a + p_74891_5_, this.field_74887_e.field_78895_b + p_74891_4_, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, this.func_74877_c());
                    }
                    case EAST: {
                        return StructureAbandonedVillagePieces.func_176066_d(p_74891_1_, p_74891_2_, p_74891_3_, this.field_74887_e.field_78897_a + p_74891_5_, this.field_74887_e.field_78895_b + p_74891_4_, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, this.func_74877_c());
                    }
                }
            }
            return null;
        }

        protected StructureComponent getNextComponentPP(Start p_74894_1_, List p_74894_2_, Random p_74894_3_, int p_74894_4_, int p_74894_5_) {
            if (this.func_186165_e() != null) {
                switch (this.func_186165_e()) {
                    case NORTH: {
                        return StructureAbandonedVillagePieces.func_176066_d(p_74894_1_, p_74894_2_, p_74894_3_, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + p_74894_4_, this.field_74887_e.field_78896_c + p_74894_5_, EnumFacing.EAST, this.func_74877_c());
                    }
                    case SOUTH: {
                        return StructureAbandonedVillagePieces.func_176066_d(p_74894_1_, p_74894_2_, p_74894_3_, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + p_74894_4_, this.field_74887_e.field_78896_c + p_74894_5_, EnumFacing.EAST, this.func_74877_c());
                    }
                    case WEST: {
                        return StructureAbandonedVillagePieces.func_176066_d(p_74894_1_, p_74894_2_, p_74894_3_, this.field_74887_e.field_78897_a + p_74894_5_, this.field_74887_e.field_78895_b + p_74894_4_, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, this.func_74877_c());
                    }
                    case EAST: {
                        return StructureAbandonedVillagePieces.func_176066_d(p_74894_1_, p_74894_2_, p_74894_3_, this.field_74887_e.field_78897_a + p_74894_5_, this.field_74887_e.field_78895_b + p_74894_4_, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, this.func_74877_c());
                    }
                }
            }
            return null;
        }

        protected int getAverageGroundLevel(World worldIn, StructureBoundingBox p_74889_2_) {
            int i = 0;
            int j = 0;
            for (int k = this.field_74887_e.field_78896_c; k <= this.field_74887_e.field_78892_f; ++k) {
                for (int l = this.field_74887_e.field_78897_a; l <= this.field_74887_e.field_78893_d; ++l) {
                    BlockPos blockpos = new BlockPos(l, 64, k);
                    if (!p_74889_2_.func_175898_b((Vec3i)blockpos)) continue;
                    i += Math.max(worldIn.func_175672_r(blockpos).func_177956_o(), worldIn.field_73011_w.func_76557_i());
                    ++j;
                }
            }
            if (j == 0) {
                return -1;
            }
            return i / j;
        }

        protected static boolean canVillageGoDeeper(StructureBoundingBox p_74895_0_) {
            return p_74895_0_ != null && p_74895_0_.field_78895_b > 10;
        }

        protected void spawnVillagers(World worldIn, StructureBoundingBox p_74893_2_, int p_74893_3_, int p_74893_4_, int p_74893_5_, int p_74893_6_) {
        }

        protected int func_180779_c(int p_180779_1_, int p_180779_2_) {
            return p_180779_2_;
        }

        protected IBlockState func_175847_a(IBlockState p_175847_1_) {
            BiomeEvent.GetVillageBlockID event = new BiomeEvent.GetVillageBlockID(this.startPiece == null ? null : this.startPiece.biome, p_175847_1_);
            MinecraftForge.TERRAIN_GEN_BUS.post((Event)event);
            if (event.getResult() == Event.Result.DENY) {
                return event.getReplacement();
            }
            if (this.field_143014_b) {
                if (p_175847_1_.func_177230_c() == Blocks.field_150364_r || p_175847_1_.func_177230_c() == Blocks.field_150363_s) {
                    return Blocks.field_150322_A.func_176223_P();
                }
                if (p_175847_1_.func_177230_c() == Blocks.field_150347_e) {
                    return Blocks.field_150322_A.func_176203_a(BlockSandStone.EnumType.DEFAULT.func_176675_a());
                }
                if (p_175847_1_.func_177230_c() == Blocks.field_150344_f) {
                    return Blocks.field_150322_A.func_176203_a(BlockSandStone.EnumType.SMOOTH.func_176675_a());
                }
                if (p_175847_1_.func_177230_c() == Blocks.field_150476_ad) {
                    return Blocks.field_150372_bz.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, p_175847_1_.func_177229_b((IProperty)BlockStairs.field_176309_a));
                }
                if (p_175847_1_.func_177230_c() == Blocks.field_150446_ar) {
                    return Blocks.field_150372_bz.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, p_175847_1_.func_177229_b((IProperty)BlockStairs.field_176309_a));
                }
                if (p_175847_1_.func_177230_c() == Blocks.field_150351_n) {
                    return Blocks.field_150322_A.func_176223_P();
                }
            }
            return p_175847_1_;
        }

        protected void func_175811_a(World worldIn, IBlockState p_175811_2_, int p_175811_3_, int p_175811_4_, int p_175811_5_, StructureBoundingBox p_175811_6_) {
            IBlockState iblockstate1 = this.func_175847_a(p_175811_2_);
            super.func_175811_a(worldIn, iblockstate1, p_175811_3_, p_175811_4_, p_175811_5_, p_175811_6_);
        }

        protected void func_175804_a(World worldIn, StructureBoundingBox box, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, IBlockState outerBlock, IBlockState innerBlock, boolean doNotReplaceAir) {
            IBlockState outerBlock2 = this.func_175847_a(outerBlock);
            IBlockState innerBlock2 = this.func_175847_a(innerBlock);
            super.func_175804_a(worldIn, box, minX, minY, minZ, maxX, maxY, maxZ, outerBlock2, innerBlock2, doNotReplaceAir);
        }

        protected void func_175808_b(World worldIn, IBlockState p_175808_2_, int p_175808_3_, int p_175808_4_, int p_175808_5_, StructureBoundingBox p_175808_6_) {
            IBlockState iblockstate1 = this.func_175847_a(p_175808_2_);
            super.func_175808_b(worldIn, iblockstate1, p_175808_3_, p_175808_4_, p_175808_5_, p_175808_6_);
        }

        protected void func_175846_a(boolean p_175846_1_) {
            this.field_143014_b = p_175846_1_;
        }

        protected void destroyBuilding(World world, int x, int z, int blocksToDestroy, StructureBoundingBox box) {
            BlockPos blockpos = new BlockPos(this.func_74865_a(z, x), this.field_74887_e.field_78894_e, this.func_74873_b(z, x));
            for (int i = 0; i < blocksToDestroy; ++i) {
                world.func_180501_a(blockpos, Blocks.field_150350_a.func_176223_P(), 2);
                blockpos = blockpos.func_177977_b();
            }
        }

        protected void destroyBuilding(World world, int[][] blocksToDestroy, StructureBoundingBox box) {
            for (int i = 0; i < blocksToDestroy.length; ++i) {
                for (int j = 0; j < blocksToDestroy[i].length; ++j) {
                    this.destroyBuilding(world, i, j, blocksToDestroy[i][j], box);
                }
            }
        }
    }

    public static class Torch
    extends Village {
        private static final String __OBFID = "CL_00000520";

        public Torch() {
        }

        public Torch(Start p_i45568_1_, int p_i45568_2_, Random p_i45568_3_, StructureBoundingBox p_i45568_4_, EnumFacing p_i45568_5_) {
            super(p_i45568_1_, p_i45568_2_);
            this.func_186164_a(p_i45568_5_);
            this.field_74887_e = p_i45568_4_;
        }

        public static StructureBoundingBox func_175856_a(Start p_175856_0_, List p_175856_1_, Random p_175856_2_, int p_175856_3_, int p_175856_4_, int p_175856_5_, EnumFacing p_175856_6_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)p_175856_3_, (int)p_175856_4_, (int)p_175856_5_, (int)0, (int)0, (int)0, (int)3, (int)4, (int)2, (EnumFacing)p_175856_6_);
            return StructureComponent.func_74883_a((List)p_175856_1_, (StructureBoundingBox)structureboundingbox) != null ? null : structureboundingbox;
        }

        public boolean func_74875_a(World worldIn, Random p_74875_2_, StructureBoundingBox p_74875_3_) {
            if (this.field_143015_k < 0) {
                this.field_143015_k = this.getAverageGroundLevel(worldIn, p_74875_3_);
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78894_e + 4 - 1, 0);
            }
            this.func_175804_a(worldIn, p_74875_3_, 0, 0, 0, 2, 3, 1, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175811_a(worldIn, Blocks.field_180407_aO.func_176223_P(), 1, 0, 0, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_180407_aO.func_176223_P(), 1, 1, 0, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_180407_aO.func_176223_P(), 1, 2, 0, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150325_L.func_176203_a(EnumDyeColor.WHITE.func_176767_b()), 1, 3, 0, p_74875_3_);
            boolean flag = this.func_186165_e() == EnumFacing.EAST || this.func_186165_e() == EnumFacing.NORTH;
            this.func_175811_a(worldIn, Blocks.field_150478_aa.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)this.func_186165_e().func_176746_e()), flag ? 2 : 0, 3, 0, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150478_aa.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)this.func_186165_e()), 1, 3, 1, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150478_aa.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)this.func_186165_e().func_176735_f()), flag ? 0 : 2, 3, 0, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150478_aa.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)this.func_186165_e().func_176734_d()), 1, 3, -1, p_74875_3_);
            return true;
        }
    }

    public static class Start
    extends Well {
        public BiomeProvider worldChunkMngr;
        public boolean inDesert;
        public int terrainType;
        public PieceWeight structVillagePieceWeight;
        public List structureVillageWeightedPieceList;
        public List field_74932_i = Lists.newArrayList();
        public List field_74930_j = Lists.newArrayList();
        private static final String __OBFID = "CL_00000527";
        public Biome biome;

        public Start() {
        }

        public Start(BiomeProvider p_i2104_1_, int p_i2104_2_, Random p_i2104_3_, int p_i2104_4_, int p_i2104_5_, List p_i2104_6_, int p_i2104_7_) {
            super(null, 0, p_i2104_3_, p_i2104_4_, p_i2104_5_);
            this.worldChunkMngr = p_i2104_1_;
            this.structureVillageWeightedPieceList = p_i2104_6_;
            this.terrainType = p_i2104_7_;
            Biome biome = p_i2104_1_.func_180300_a(new BlockPos(p_i2104_4_, 0, p_i2104_5_), Biomes.field_180279_ad);
            this.inDesert = biome == Biomes.field_76769_d || biome == Biomes.field_76786_s;
            this.biome = biome;
            this.func_175846_a(this.inDesert);
        }

        public BiomeProvider getBiomeProvider() {
            return this.worldChunkMngr;
        }
    }

    public static abstract class Road
    extends Village {
        private static final String __OBFID = "CL_00000532";

        public Road() {
        }

        protected Road(Start p_i2108_1_, int p_i2108_2_) {
            super(p_i2108_1_, p_i2108_2_);
        }
    }

    public static class PieceWeight {
        public Class villagePieceClass;
        public final int villagePieceWeight;
        public int villagePiecesSpawned;
        public int villagePiecesLimit;
        private static final String __OBFID = "CL_00000521";

        public PieceWeight(Class p_i2098_1_, int p_i2098_2_, int p_i2098_3_) {
            this.villagePieceClass = p_i2098_1_;
            this.villagePieceWeight = p_i2098_2_;
            this.villagePiecesLimit = p_i2098_3_;
        }

        public boolean canSpawnMoreVillagePiecesOfType(int p_75085_1_) {
            return this.villagePiecesLimit == 0 || this.villagePiecesSpawned < this.villagePiecesLimit;
        }

        public boolean canSpawnMoreVillagePieces() {
            return this.villagePiecesLimit == 0 || this.villagePiecesSpawned < this.villagePiecesLimit;
        }
    }

    public static class Path
    extends Road {
        private int averageGroundLevel;
        private static final String __OBFID = "CL_00000528";

        public Path() {
        }

        public Path(Start p_i45562_1_, int p_i45562_2_, Random p_i45562_3_, StructureBoundingBox p_i45562_4_, EnumFacing p_i45562_5_) {
            super(p_i45562_1_, p_i45562_2_);
            this.func_186164_a(p_i45562_5_);
            this.field_74887_e = p_i45562_4_;
            this.averageGroundLevel = Math.max(p_i45562_4_.func_78883_b(), p_i45562_4_.func_78880_d());
        }

        @Override
        protected void func_143012_a(NBTTagCompound p_143012_1_) {
            super.func_143012_a(p_143012_1_);
            p_143012_1_.func_74768_a("Length", this.averageGroundLevel);
        }

        @Override
        protected void func_143011_b(NBTTagCompound p_143011_1_, TemplateManager man) {
            super.func_143011_b(p_143011_1_, man);
            this.averageGroundLevel = p_143011_1_.func_74762_e("Length");
        }

        public void func_74861_a(StructureComponent p_74861_1_, List p_74861_2_, Random p_74861_3_) {
            StructureComponent structurecomponent1;
            int i;
            boolean flag = false;
            for (i = p_74861_3_.nextInt(5); i < this.averageGroundLevel - 8; i += 2 + p_74861_3_.nextInt(5)) {
                structurecomponent1 = this.getNextComponentNN((Start)p_74861_1_, p_74861_2_, p_74861_3_, 0, i);
                if (structurecomponent1 == null) continue;
                i += Math.max(structurecomponent1.func_74874_b().func_78883_b(), structurecomponent1.func_74874_b().func_78880_d());
                flag = true;
            }
            for (i = p_74861_3_.nextInt(5); i < this.averageGroundLevel - 8; i += 2 + p_74861_3_.nextInt(5)) {
                structurecomponent1 = this.getNextComponentPP((Start)p_74861_1_, p_74861_2_, p_74861_3_, 0, i);
                if (structurecomponent1 == null) continue;
                i += Math.max(structurecomponent1.func_74874_b().func_78883_b(), structurecomponent1.func_74874_b().func_78880_d());
                flag = true;
            }
            if (flag && p_74861_3_.nextInt(3) > 0 && this.func_186165_e() != null) {
                switch (SwitchEnumFacing.field_176064_a[this.func_186165_e().ordinal()]) {
                    case 1: {
                        StructureAbandonedVillagePieces.func_176069_e((Start)p_74861_1_, p_74861_2_, p_74861_3_, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, EnumFacing.WEST, this.func_74877_c());
                        break;
                    }
                    case 2: {
                        StructureAbandonedVillagePieces.func_176069_e((Start)p_74861_1_, p_74861_2_, p_74861_3_, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f - 2, EnumFacing.WEST, this.func_74877_c());
                        break;
                    }
                    case 3: {
                        StructureAbandonedVillagePieces.func_176069_e((Start)p_74861_1_, p_74861_2_, p_74861_3_, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, this.func_74877_c());
                        break;
                    }
                    case 4: {
                        StructureAbandonedVillagePieces.func_176069_e((Start)p_74861_1_, p_74861_2_, p_74861_3_, this.field_74887_e.field_78893_d - 2, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, this.func_74877_c());
                    }
                }
            }
            if (flag && p_74861_3_.nextInt(3) > 0 && this.func_186165_e() != null) {
                switch (SwitchEnumFacing.field_176064_a[this.func_186165_e().ordinal()]) {
                    case 1: {
                        StructureAbandonedVillagePieces.func_176069_e((Start)p_74861_1_, p_74861_2_, p_74861_3_, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, EnumFacing.EAST, this.func_74877_c());
                        break;
                    }
                    case 2: {
                        StructureAbandonedVillagePieces.func_176069_e((Start)p_74861_1_, p_74861_2_, p_74861_3_, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f - 2, EnumFacing.EAST, this.func_74877_c());
                        break;
                    }
                    case 3: {
                        StructureAbandonedVillagePieces.func_176069_e((Start)p_74861_1_, p_74861_2_, p_74861_3_, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, this.func_74877_c());
                        break;
                    }
                    case 4: {
                        StructureAbandonedVillagePieces.func_176069_e((Start)p_74861_1_, p_74861_2_, p_74861_3_, this.field_74887_e.field_78893_d - 2, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, this.func_74877_c());
                    }
                }
            }
        }

        public static StructureBoundingBox func_175848_a(Start p_175848_0_, List p_175848_1_, Random p_175848_2_, int p_175848_3_, int p_175848_4_, int p_175848_5_, EnumFacing p_175848_6_) {
            for (int l = 7 * MathHelper.func_76136_a((Random)p_175848_2_, (int)3, (int)5); l >= 7; l -= 7) {
                StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)p_175848_3_, (int)p_175848_4_, (int)p_175848_5_, (int)0, (int)0, (int)0, (int)3, (int)3, (int)l, (EnumFacing)p_175848_6_);
                if (StructureComponent.func_74883_a((List)p_175848_1_, (StructureBoundingBox)structureboundingbox) != null) continue;
                return structureboundingbox;
            }
            return null;
        }

        public boolean func_74875_a(World worldIn, Random p_74875_2_, StructureBoundingBox p_74875_3_) {
            IBlockState iblockstate = this.func_175847_a(Blocks.field_150351_n.func_176223_P());
            IBlockState iblockstate1 = this.func_175847_a(Blocks.field_150347_e.func_176223_P());
            for (int i = this.field_74887_e.field_78897_a; i <= this.field_74887_e.field_78893_d; ++i) {
                for (int j = this.field_74887_e.field_78896_c; j <= this.field_74887_e.field_78892_f; ++j) {
                    BlockPos blockpos = new BlockPos(i, 64, j);
                    if (!p_74875_3_.func_175898_b((Vec3i)blockpos)) continue;
                    blockpos = worldIn.func_175672_r(blockpos).func_177977_b();
                    worldIn.func_180501_a(blockpos, iblockstate, 2);
                    worldIn.func_180501_a(blockpos.func_177977_b(), iblockstate1, 2);
                }
            }
            return true;
        }
    }

    public static class House4Garden
    extends Village {
        private boolean isRoofAccessible;
        private static final String __OBFID = "CL_00000523";

        public House4Garden() {
        }

        public House4Garden(Start p_i45566_1_, int p_i45566_2_, Random p_i45566_3_, StructureBoundingBox p_i45566_4_, EnumFacing p_i45566_5_) {
            super(p_i45566_1_, p_i45566_2_);
            this.func_186164_a(p_i45566_5_);
            this.field_74887_e = p_i45566_4_;
            this.isRoofAccessible = p_i45566_3_.nextBoolean();
        }

        @Override
        protected void func_143012_a(NBTTagCompound p_143012_1_) {
            super.func_143012_a(p_143012_1_);
            p_143012_1_.func_74757_a("Terrace", this.isRoofAccessible);
        }

        @Override
        protected void func_143011_b(NBTTagCompound p_143011_1_, TemplateManager man) {
            super.func_143011_b(p_143011_1_, man);
            this.isRoofAccessible = p_143011_1_.func_74767_n("Terrace");
        }

        public static House4Garden func_175858_a(Start p_175858_0_, List p_175858_1_, Random p_175858_2_, int p_175858_3_, int p_175858_4_, int p_175858_5_, EnumFacing p_175858_6_, int p_175858_7_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)p_175858_3_, (int)p_175858_4_, (int)p_175858_5_, (int)0, (int)0, (int)0, (int)5, (int)6, (int)5, (EnumFacing)p_175858_6_);
            return StructureComponent.func_74883_a((List)p_175858_1_, (StructureBoundingBox)structureboundingbox) != null ? null : new House4Garden(p_175858_0_, p_175858_7_, p_175858_2_, structureboundingbox, p_175858_6_);
        }

        public boolean func_74875_a(World worldIn, Random p_74875_2_, StructureBoundingBox p_74875_3_) {
            if (this.field_143015_k < 0) {
                this.field_143015_k = this.getAverageGroundLevel(worldIn, p_74875_3_);
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78894_e + 6 - 1, 0);
            }
            this.func_175804_a(worldIn, p_74875_3_, 0, 0, 0, 4, 0, 4, Blocks.field_150347_e.func_176223_P(), Blocks.field_150347_e.func_176223_P(), false);
            this.func_175811_a(worldIn, Blocks.field_150347_e.func_176223_P(), 0, 1, 0, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150347_e.func_176223_P(), 0, 2, 0, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150347_e.func_176223_P(), 4, 1, 0, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150347_e.func_176223_P(), 4, 2, 0, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150347_e.func_176223_P(), 4, 3, 0, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150347_e.func_176223_P(), 0, 1, 4, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150347_e.func_176223_P(), 4, 1, 4, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150347_e.func_176223_P(), 4, 2, 4, p_74875_3_);
            this.func_175804_a(worldIn, p_74875_3_, 0, 1, 1, 0, 1, 3, Blocks.field_150344_f.func_176223_P(), Blocks.field_150344_f.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 4, 1, 1, 4, 1, 2, Blocks.field_150344_f.func_176223_P(), Blocks.field_150344_f.func_176223_P(), false);
            if (this.func_175807_a(worldIn, 2, 0, -1, p_74875_3_).func_185904_a() == Material.field_151579_a && this.func_175807_a(worldIn, 2, -1, -1, p_74875_3_).func_185904_a() != Material.field_151579_a) {
                this.func_175811_a(worldIn, Blocks.field_150446_ar.func_176203_a(3), 2, 0, -1, p_74875_3_);
            }
            this.func_175804_a(worldIn, p_74875_3_, 1, 1, 1, 3, 3, 3, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            for (int i = 0; i < 5; ++i) {
                for (int j = 0; j < 5; ++j) {
                    this.func_74871_b(worldIn, j, 6, i, p_74875_3_);
                    this.func_175808_b(worldIn, Blocks.field_150347_e.func_176223_P(), j, -1, i, p_74875_3_);
                }
            }
            this.spawnVillagers(worldIn, p_74875_3_, 1, 1, 2, 1);
            return true;
        }
    }

    public static class House3
    extends Village {
        private static final String __OBFID = "CL_00000530";

        public House3() {
        }

        public House3(Start p_i45561_1_, int p_i45561_2_, Random p_i45561_3_, StructureBoundingBox p_i45561_4_, EnumFacing p_i45561_5_) {
            super(p_i45561_1_, p_i45561_2_);
            this.func_186164_a(p_i45561_5_);
            this.field_74887_e = p_i45561_4_;
        }

        public static House3 func_175849_a(Start p_175849_0_, List p_175849_1_, Random p_175849_2_, int p_175849_3_, int p_175849_4_, int p_175849_5_, EnumFacing p_175849_6_, int p_175849_7_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)p_175849_3_, (int)p_175849_4_, (int)p_175849_5_, (int)0, (int)0, (int)0, (int)9, (int)7, (int)12, (EnumFacing)p_175849_6_);
            return House3.canVillageGoDeeper(structureboundingbox) && StructureComponent.func_74883_a((List)p_175849_1_, (StructureBoundingBox)structureboundingbox) == null ? new House3(p_175849_0_, p_175849_7_, p_175849_2_, structureboundingbox, p_175849_6_) : null;
        }

        public boolean func_74875_a(World worldIn, Random p_74875_2_, StructureBoundingBox p_74875_3_) {
            int j1;
            int i1;
            int l;
            if (this.field_143015_k < 0) {
                this.field_143015_k = this.getAverageGroundLevel(worldIn, p_74875_3_);
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78894_e + 7 - 1, 0);
            }
            this.func_175804_a(worldIn, p_74875_3_, 1, 1, 1, 7, 4, 4, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 2, 1, 6, 8, 4, 10, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 2, 0, 5, 8, 0, 10, Blocks.field_150344_f.func_176223_P(), Blocks.field_150344_f.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 1, 0, 1, 7, 0, 4, Blocks.field_150344_f.func_176223_P(), Blocks.field_150344_f.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 0, 0, 0, 0, 3, 5, Blocks.field_150347_e.func_176223_P(), Blocks.field_150347_e.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 8, 0, 0, 8, 3, 10, Blocks.field_150347_e.func_176223_P(), Blocks.field_150347_e.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 1, 0, 0, 7, 2, 0, Blocks.field_150347_e.func_176223_P(), Blocks.field_150347_e.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 1, 0, 5, 2, 1, 5, Blocks.field_150347_e.func_176223_P(), Blocks.field_150347_e.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 2, 0, 6, 2, 3, 10, Blocks.field_150347_e.func_176223_P(), Blocks.field_150347_e.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 3, 0, 10, 7, 3, 10, Blocks.field_150347_e.func_176223_P(), Blocks.field_150347_e.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 1, 2, 0, 7, 3, 0, Blocks.field_150344_f.func_176223_P(), Blocks.field_150344_f.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 1, 2, 5, 2, 3, 5, Blocks.field_150344_f.func_176223_P(), Blocks.field_150344_f.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 0, 4, 1, 8, 4, 1, Blocks.field_150344_f.func_176223_P(), Blocks.field_150344_f.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 0, 4, 4, 3, 4, 4, Blocks.field_150344_f.func_176223_P(), Blocks.field_150344_f.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 0, 5, 2, 8, 5, 3, Blocks.field_150344_f.func_176223_P(), Blocks.field_150344_f.func_176223_P(), false);
            this.func_175811_a(worldIn, Blocks.field_150344_f.func_176223_P(), 0, 4, 2, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150344_f.func_176223_P(), 0, 4, 3, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150344_f.func_176223_P(), 8, 4, 2, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150344_f.func_176223_P(), 8, 4, 3, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150344_f.func_176223_P(), 8, 4, 4, p_74875_3_);
            for (int k = -1; k <= 2; ++k) {
                for (l = 0; l <= 8; ++l) {
                    this.func_175811_a(worldIn, Blocks.field_150476_ad.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.WEST), l, 4 + k, k, p_74875_3_);
                    if (k <= -1 && l > 1 || k <= 0 && l > 3 || k <= 1 && l > 4 && l < 6) continue;
                    this.func_175811_a(worldIn, Blocks.field_150476_ad.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.SOUTH), l, 4 + k, 5 - k, p_74875_3_);
                }
            }
            this.func_175804_a(worldIn, p_74875_3_, 3, 4, 5, 3, 4, 10, Blocks.field_150344_f.func_176223_P(), Blocks.field_150344_f.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 7, 4, 2, 7, 4, 10, Blocks.field_150344_f.func_176223_P(), Blocks.field_150344_f.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 4, 5, 4, 4, 5, 10, Blocks.field_150344_f.func_176223_P(), Blocks.field_150344_f.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 6, 5, 4, 6, 5, 10, Blocks.field_150344_f.func_176223_P(), Blocks.field_150344_f.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 5, 6, 3, 5, 6, 10, Blocks.field_150344_f.func_176223_P(), Blocks.field_150344_f.func_176223_P(), false);
            for (l = 4; l >= 1; --l) {
                this.func_175811_a(worldIn, Blocks.field_150344_f.func_176223_P(), l, 2 + l, 7 - l, p_74875_3_);
                for (i1 = 8 - l; i1 <= 10; ++i1) {
                    this.func_175811_a(worldIn, Blocks.field_150476_ad.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH), l, 2 + l, i1, p_74875_3_);
                }
            }
            this.func_175811_a(worldIn, Blocks.field_150344_f.func_176223_P(), 6, 6, 3, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150344_f.func_176223_P(), 7, 5, 4, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150476_ad.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.EAST), 6, 6, 4, p_74875_3_);
            for (i1 = 6; i1 <= 8; ++i1) {
                for (j1 = 5; j1 <= 10; ++j1) {
                    this.func_175811_a(worldIn, Blocks.field_150476_ad.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.EAST), i1, 12 - i1, j1, p_74875_3_);
                }
            }
            this.func_175811_a(worldIn, Blocks.field_150364_r.func_176223_P(), 0, 2, 1, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150364_r.func_176223_P(), 0, 2, 4, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 0, 2, 2, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 0, 2, 3, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150364_r.func_176223_P(), 4, 2, 0, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 5, 2, 0, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150364_r.func_176223_P(), 6, 2, 0, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150364_r.func_176223_P(), 8, 2, 1, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 8, 2, 2, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 8, 2, 3, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150364_r.func_176223_P(), 8, 2, 4, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150344_f.func_176223_P(), 8, 2, 5, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150364_r.func_176223_P(), 8, 2, 6, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 8, 2, 7, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 8, 2, 8, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150364_r.func_176223_P(), 8, 2, 9, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150364_r.func_176223_P(), 2, 2, 6, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 2, 2, 7, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 2, 2, 8, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150364_r.func_176223_P(), 2, 2, 9, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150364_r.func_176223_P(), 4, 4, 10, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 5, 4, 10, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150364_r.func_176223_P(), 6, 4, 10, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150344_f.func_176223_P(), 5, 5, 10, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 2, 1, 0, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 2, 2, 0, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150478_aa.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)this.func_186165_e()), 2, 3, 1, p_74875_3_);
            this.func_175804_a(worldIn, p_74875_3_, 1, 0, -1, 3, 2, -1, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            if (this.func_175807_a(worldIn, 2, 0, -1, p_74875_3_).func_185904_a() == Material.field_151579_a && this.func_175807_a(worldIn, 2, -1, -1, p_74875_3_).func_185904_a() != Material.field_151579_a) {
                this.func_175811_a(worldIn, Blocks.field_150446_ar.func_176203_a(3), 2, 0, -1, p_74875_3_);
            }
            for (i1 = 0; i1 < 5; ++i1) {
                for (j1 = 0; j1 < 9; ++j1) {
                    this.func_74871_b(worldIn, j1, 7, i1, p_74875_3_);
                    this.func_175808_b(worldIn, Blocks.field_150347_e.func_176223_P(), j1, -1, i1, p_74875_3_);
                }
            }
            for (i1 = 5; i1 < 11; ++i1) {
                for (j1 = 2; j1 < 9; ++j1) {
                    this.func_74871_b(worldIn, j1, 7, i1, p_74875_3_);
                    this.func_175808_b(worldIn, Blocks.field_150347_e.func_176223_P(), j1, -1, i1, p_74875_3_);
                }
            }
            this.spawnVillagers(worldIn, p_74875_3_, 4, 1, 2, 2);
            return true;
        }
    }

    public static class Blacksmith
    extends Village {
        private boolean hasMadeChest;
        private static final String __OBFID = "CL_00000526";

        public Blacksmith() {
        }

        public Blacksmith(Start p_i45563_1_, int p_i45563_2_, Random p_i45563_3_, StructureBoundingBox p_i45563_4_, EnumFacing p_i45563_5_) {
            super(p_i45563_1_, p_i45563_2_);
            this.func_186164_a(p_i45563_5_);
            this.field_74887_e = p_i45563_4_;
        }

        public static Blacksmith func_175855_a(Start p_175855_0_, List p_175855_1_, Random p_175855_2_, int p_175855_3_, int p_175855_4_, int p_175855_5_, EnumFacing p_175855_6_, int p_175855_7_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)p_175855_3_, (int)p_175855_4_, (int)p_175855_5_, (int)0, (int)0, (int)0, (int)10, (int)6, (int)7, (EnumFacing)p_175855_6_);
            return Blacksmith.canVillageGoDeeper(structureboundingbox) && StructureComponent.func_74883_a((List)p_175855_1_, (StructureBoundingBox)structureboundingbox) == null ? new Blacksmith(p_175855_0_, p_175855_7_, p_175855_2_, structureboundingbox, p_175855_6_) : null;
        }

        @Override
        protected void func_143012_a(NBTTagCompound p_143012_1_) {
            super.func_143012_a(p_143012_1_);
            p_143012_1_.func_74757_a("Chest", this.hasMadeChest);
        }

        @Override
        protected void func_143011_b(NBTTagCompound p_143011_1_, TemplateManager man) {
            super.func_143011_b(p_143011_1_, man);
            this.hasMadeChest = p_143011_1_.func_74767_n("Chest");
        }

        public boolean func_74875_a(World worldIn, Random rand, StructureBoundingBox p_74875_3_) {
            int i;
            if (this.field_143015_k < 0) {
                this.field_143015_k = this.getAverageGroundLevel(worldIn, p_74875_3_);
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78894_e + 6 - 1, 0);
            }
            this.func_175804_a(worldIn, p_74875_3_, 0, 1, 0, 9, 4, 6, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 0, 0, 0, 9, 0, 6, Blocks.field_150347_e.func_176223_P(), Blocks.field_150347_e.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 0, 4, 0, 9, 4, 6, Blocks.field_150347_e.func_176223_P(), Blocks.field_150347_e.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 0, 5, 0, 9, 5, 6, Blocks.field_150333_U.func_176223_P(), Blocks.field_150333_U.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 1, 5, 1, 8, 5, 5, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 1, 1, 0, 2, 3, 0, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 1, 1, 0, 1, 1, 0, Blocks.field_150344_f.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 0, 1, 0, 0, 4, 0, Blocks.field_150364_r.func_176223_P(), Blocks.field_150364_r.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 3, 1, 0, 3, 4, 0, Blocks.field_150364_r.func_176223_P(), Blocks.field_150364_r.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 0, 1, 6, 0, 4, 6, Blocks.field_150364_r.func_176223_P(), Blocks.field_150364_r.func_176223_P(), false);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 3, 3, 1, p_74875_3_);
            this.func_175804_a(worldIn, p_74875_3_, 3, 1, 2, 3, 3, 2, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 4, 1, 3, 5, 3, 3, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 0, 1, 1, 0, 3, 5, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 0, 1, 3, 0, 1, 5, Blocks.field_150344_f.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 0, 2, 5, 0, 2, 5, Blocks.field_150344_f.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 1, 1, 6, 5, 3, 6, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 1, 1, 6, 5, 1, 6, Blocks.field_150344_f.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 1, 2, 6, 3, 2, 6, Blocks.field_150344_f.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 1, 3, 6, 1, 3, 6, Blocks.field_150344_f.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 5, 1, 0, 5, 3, 0, Blocks.field_180407_aO.func_176223_P(), Blocks.field_180407_aO.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 9, 1, 0, 9, 3, 0, Blocks.field_180407_aO.func_176223_P(), Blocks.field_180407_aO.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 6, 1, 4, 9, 4, 6, Blocks.field_150347_e.func_176223_P(), Blocks.field_150347_e.func_176223_P(), false);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 7, 1, 5, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 8, 1, 5, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150411_aY.func_176223_P(), 9, 2, 5, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150411_aY.func_176223_P(), 9, 2, 4, p_74875_3_);
            this.func_175804_a(worldIn, p_74875_3_, 7, 2, 4, 8, 2, 5, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175811_a(worldIn, Blocks.field_150347_e.func_176223_P(), 6, 1, 3, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150460_al.func_176223_P(), 6, 2, 3, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150460_al.func_176223_P(), 6, 3, 3, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150334_T.func_176223_P(), 8, 1, 1, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 0, 2, 2, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 0, 2, 4, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 2, 2, 6, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 4, 2, 6, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_180407_aO.func_176223_P(), 2, 1, 4, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150452_aw.func_176223_P(), 2, 2, 4, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150344_f.func_176223_P(), 1, 1, 5, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150476_ad.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.WEST), 2, 1, 5, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150476_ad.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.EAST), 1, 1, 4, p_74875_3_);
            if (!this.hasMadeChest && p_74875_3_.func_175898_b((Vec3i)new BlockPos(this.func_74865_a(5, 5), this.func_74862_a(1), this.func_74873_b(5, 5)))) {
                this.hasMadeChest = true;
                BlockPos blockpos = new BlockPos(this.func_74865_a(5, 5), this.func_74862_a(1), this.func_74873_b(5, 5));
                if (p_74875_3_.func_175898_b((Vec3i)blockpos) && worldIn.func_180495_p(blockpos).func_177230_c() != Blocks.field_150486_ae) {
                    IBlockState iblockstate = Blocks.field_150486_ae.func_176223_P();
                    worldIn.func_180501_a(blockpos, Blocks.field_150486_ae.func_176458_f(worldIn, blockpos, iblockstate), 2);
                    TileEntity tileentity = worldIn.func_175625_s(blockpos);
                    if (tileentity instanceof TileEntityChest) {
                        FlansModApocalypse.getLootGenerator().fillVillageChest(rand, (TileEntityChest)tileentity);
                    }
                }
            }
            for (i = 6; i <= 8; ++i) {
                if (this.func_175807_a(worldIn, i, 0, -1, p_74875_3_).func_185904_a() != Material.field_151579_a || this.func_175807_a(worldIn, i, -1, -1, p_74875_3_).func_185904_a() == Material.field_151579_a) continue;
                this.func_175811_a(worldIn, Blocks.field_150446_ar.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.WEST), i, 0, -1, p_74875_3_);
            }
            for (i = 0; i < 7; ++i) {
                for (int j = 0; j < 10; ++j) {
                    this.func_74871_b(worldIn, j, 6, i, p_74875_3_);
                    this.func_175808_b(worldIn, Blocks.field_150347_e.func_176223_P(), j, -1, i, p_74875_3_);
                }
            }
            int[][] destruction = new int[][]{{0, 0, 0, 0, 0, 0, 4, 4, 4, 4}, {0, 0, 0, 0, 0, 0, 0, 4, 4, 4}, {0, 0, 0, 0, 0, 0, 0, 0, 4, 4}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
            this.destroyBuilding(worldIn, destruction, p_74875_3_);
            this.spawnVillagers(worldIn, p_74875_3_, 7, 1, 1, 1);
            return true;
        }

        @Override
        protected int func_180779_c(int p_180779_1_, int p_180779_2_) {
            return 3;
        }
    }

    public static class Library
    extends Village {
        private static final String __OBFID = "CL_00000517";
        private boolean hasMadeChest = false;

        public Library() {
        }

        public Library(Start p_i45571_1_, int p_i45571_2_, Random p_i45571_3_, StructureBoundingBox p_i45571_4_, EnumFacing p_i45571_5_) {
            super(p_i45571_1_, p_i45571_2_);
            this.func_186164_a(p_i45571_5_);
            this.field_74887_e = p_i45571_4_;
        }

        public static Library func_175850_a(Start p_175850_0_, List p_175850_1_, Random p_175850_2_, int p_175850_3_, int p_175850_4_, int p_175850_5_, EnumFacing p_175850_6_, int p_175850_7_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)p_175850_3_, (int)p_175850_4_, (int)p_175850_5_, (int)0, (int)0, (int)0, (int)9, (int)9, (int)6, (EnumFacing)p_175850_6_);
            return Library.canVillageGoDeeper(structureboundingbox) && StructureComponent.func_74883_a((List)p_175850_1_, (StructureBoundingBox)structureboundingbox) == null ? new Library(p_175850_0_, p_175850_7_, p_175850_2_, structureboundingbox, p_175850_6_) : null;
        }

        @Override
        protected void func_143012_a(NBTTagCompound p_143012_1_) {
            super.func_143012_a(p_143012_1_);
            p_143012_1_.func_74757_a("Chest", this.hasMadeChest);
        }

        @Override
        protected void func_143011_b(NBTTagCompound p_143011_1_, TemplateManager man) {
            super.func_143011_b(p_143011_1_, man);
            this.hasMadeChest = p_143011_1_.func_74767_n("Chest");
        }

        public boolean func_74875_a(World worldIn, Random p_74875_2_, StructureBoundingBox p_74875_3_) {
            int l;
            if (this.field_143015_k < 0) {
                this.field_143015_k = this.getAverageGroundLevel(worldIn, p_74875_3_);
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78894_e + 9 - 1, 0);
            }
            this.func_175804_a(worldIn, p_74875_3_, 1, 1, 1, 7, 5, 4, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 0, 0, 0, 8, 0, 5, Blocks.field_150347_e.func_176223_P(), Blocks.field_150347_e.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 0, 5, 0, 8, 5, 5, Blocks.field_150347_e.func_176223_P(), Blocks.field_150347_e.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 0, 6, 1, 8, 6, 4, Blocks.field_150347_e.func_176223_P(), Blocks.field_150347_e.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 0, 7, 2, 8, 7, 3, Blocks.field_150347_e.func_176223_P(), Blocks.field_150347_e.func_176223_P(), false);
            for (int k = -1; k <= 2; ++k) {
                for (l = 0; l <= 8; ++l) {
                    this.func_175811_a(worldIn, Blocks.field_150476_ad.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.WEST), l, 6 + k, k, p_74875_3_);
                    this.func_175811_a(worldIn, Blocks.field_150476_ad.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.SOUTH), l, 6 + k, 5 - k, p_74875_3_);
                }
            }
            this.func_175804_a(worldIn, p_74875_3_, 0, 1, 0, 0, 1, 5, Blocks.field_150347_e.func_176223_P(), Blocks.field_150347_e.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 1, 1, 5, 8, 1, 5, Blocks.field_150347_e.func_176223_P(), Blocks.field_150347_e.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 8, 1, 0, 8, 1, 4, Blocks.field_150347_e.func_176223_P(), Blocks.field_150347_e.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 2, 1, 0, 7, 1, 0, Blocks.field_150347_e.func_176223_P(), Blocks.field_150347_e.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 0, 2, 0, 0, 4, 0, Blocks.field_150347_e.func_176223_P(), Blocks.field_150347_e.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 0, 2, 5, 0, 4, 5, Blocks.field_150347_e.func_176223_P(), Blocks.field_150347_e.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 8, 2, 5, 8, 4, 5, Blocks.field_150347_e.func_176223_P(), Blocks.field_150347_e.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 8, 2, 0, 8, 4, 0, Blocks.field_150347_e.func_176223_P(), Blocks.field_150347_e.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 0, 2, 1, 0, 4, 4, Blocks.field_150344_f.func_176223_P(), Blocks.field_150344_f.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 1, 2, 5, 7, 4, 5, Blocks.field_150344_f.func_176223_P(), Blocks.field_150344_f.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 8, 2, 1, 8, 4, 4, Blocks.field_150344_f.func_176223_P(), Blocks.field_150344_f.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 1, 2, 0, 7, 4, 0, Blocks.field_150344_f.func_176223_P(), Blocks.field_150344_f.func_176223_P(), false);
            this.func_175811_a(worldIn, Blocks.field_180407_aO.func_176223_P(), 4, 2, 0, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_180407_aO.func_176223_P(), 5, 2, 0, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_180407_aO.func_176223_P(), 6, 2, 0, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_180407_aO.func_176223_P(), 4, 3, 0, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_180407_aO.func_176223_P(), 5, 3, 0, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_180407_aO.func_176223_P(), 6, 3, 0, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_180407_aO.func_176223_P(), 0, 2, 2, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_180407_aO.func_176223_P(), 0, 2, 3, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_180407_aO.func_176223_P(), 0, 3, 2, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_180407_aO.func_176223_P(), 0, 3, 3, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_180407_aO.func_176223_P(), 8, 2, 2, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_180407_aO.func_176223_P(), 8, 2, 3, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_180407_aO.func_176223_P(), 8, 3, 2, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_180407_aO.func_176223_P(), 8, 3, 3, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_180407_aO.func_176223_P(), 2, 2, 5, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_180407_aO.func_176223_P(), 3, 2, 5, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_180407_aO.func_176223_P(), 5, 2, 5, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_180407_aO.func_176223_P(), 6, 2, 5, p_74875_3_);
            this.func_175804_a(worldIn, p_74875_3_, 1, 4, 1, 7, 4, 1, Blocks.field_150344_f.func_176223_P(), Blocks.field_150344_f.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 1, 4, 4, 7, 4, 4, Blocks.field_150344_f.func_176223_P(), Blocks.field_150344_f.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 1, 3, 4, 2, 3, 4, Blocks.field_150342_X.func_176223_P(), Blocks.field_150342_X.func_176223_P(), false);
            this.func_175811_a(worldIn, Blocks.field_150344_f.func_176223_P(), 7, 1, 4, p_74875_3_);
            this.func_175811_a(worldIn, FlansModApocalypse.getLootGenerator().getRandomWeaponBox(p_74875_2_).func_176223_P(), 1, 1, 4, p_74875_3_);
            this.func_175811_a(worldIn, FlansMod.workbench.func_176203_a(p_74875_2_.nextInt(2)), 7, 1, 3, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150462_ai.func_176223_P(), 7, 1, 1, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150344_f.func_176223_P(), 3, 1, 4, p_74875_3_);
            if (!this.hasMadeChest && p_74875_3_.func_175898_b((Vec3i)new BlockPos(this.func_74865_a(2, 4), this.func_74862_a(1), this.func_74873_b(2, 4)))) {
                this.hasMadeChest = true;
                BlockPos chestPos = new BlockPos(this.func_74865_a(2, 4), this.func_74862_a(1), this.func_74873_b(2, 4));
                IBlockState chestState = Blocks.field_150486_ae.func_176458_f(worldIn, chestPos, Blocks.field_150486_ae.func_176223_P());
                worldIn.func_180501_a(chestPos, Blocks.field_150486_ae.func_176458_f(worldIn, chestPos, chestState), 2);
                TileEntity tileentity = worldIn.func_175625_s(chestPos);
                if (tileentity instanceof TileEntityChest) {
                    FlansModApocalypse.getLootGenerator().fillVillageChest(p_74875_2_, (TileEntityChest)tileentity);
                }
                BlockPos skeletonPos = new BlockPos(this.func_74865_a(5, 4), this.func_74862_a(1), this.func_74873_b(5, 4));
                worldIn.func_180501_a(skeletonPos, FlansModApocalypse.slumpedSkeleton.func_176203_a((4 - Blocks.field_150486_ae.func_176201_c(chestState)) % 4), 2);
                FlansModApocalypse.getLootGenerator().addRandomLoot((TileEntityItemHolder)worldIn.func_175625_s(skeletonPos), p_74875_2_, false);
            }
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 1, 1, 0, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 1, 2, 0, p_74875_3_);
            if (this.func_175807_a(worldIn, 1, 0, -1, p_74875_3_).func_185904_a() == Material.field_151579_a && this.func_175807_a(worldIn, 1, -1, -1, p_74875_3_).func_185904_a() != Material.field_151579_a) {
                this.func_175811_a(worldIn, Blocks.field_150446_ar.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.WEST), 1, 0, -1, p_74875_3_);
            }
            for (l = 0; l < 6; ++l) {
                for (int i1 = 0; i1 < 9; ++i1) {
                    this.func_74871_b(worldIn, i1, 9, l, p_74875_3_);
                    this.func_175808_b(worldIn, Blocks.field_150347_e.func_176223_P(), i1, -1, l, p_74875_3_);
                }
            }
            this.spawnVillagers(worldIn, p_74875_3_, 2, 1, 2, 1);
            return true;
        }

        @Override
        protected int func_180779_c(int p_180779_1_, int p_180779_2_) {
            return 1;
        }
    }

    public static class Hall
    extends Village {
        private static final String __OBFID = "CL_00000522";

        public Hall() {
        }

        public Hall(Start p_i45567_1_, int p_i45567_2_, Random p_i45567_3_, StructureBoundingBox p_i45567_4_, EnumFacing p_i45567_5_) {
            super(p_i45567_1_, p_i45567_2_);
            this.func_186164_a(p_i45567_5_);
            this.field_74887_e = p_i45567_4_;
        }

        public static Hall func_175857_a(Start p_175857_0_, List p_175857_1_, Random p_175857_2_, int p_175857_3_, int p_175857_4_, int p_175857_5_, EnumFacing p_175857_6_, int p_175857_7_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)p_175857_3_, (int)p_175857_4_, (int)p_175857_5_, (int)0, (int)0, (int)0, (int)9, (int)7, (int)11, (EnumFacing)p_175857_6_);
            return Hall.canVillageGoDeeper(structureboundingbox) && StructureComponent.func_74883_a((List)p_175857_1_, (StructureBoundingBox)structureboundingbox) == null ? new Hall(p_175857_0_, p_175857_7_, p_175857_2_, structureboundingbox, p_175857_6_) : null;
        }

        public boolean func_74875_a(World worldIn, Random p_74875_2_, StructureBoundingBox p_74875_3_) {
            int l;
            int k;
            if (this.field_143015_k < 0) {
                this.field_143015_k = this.getAverageGroundLevel(worldIn, p_74875_3_);
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78894_e + 7 - 1, 0);
            }
            this.func_175804_a(worldIn, p_74875_3_, 1, 1, 1, 7, 4, 4, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 2, 1, 6, 8, 4, 10, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 2, 0, 6, 8, 0, 10, Blocks.field_150346_d.func_176223_P(), Blocks.field_150346_d.func_176223_P(), false);
            this.func_175811_a(worldIn, Blocks.field_150347_e.func_176223_P(), 6, 0, 6, p_74875_3_);
            this.func_175804_a(worldIn, p_74875_3_, 2, 1, 6, 2, 1, 10, Blocks.field_180407_aO.func_176223_P(), Blocks.field_180407_aO.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 8, 1, 6, 8, 1, 10, Blocks.field_180407_aO.func_176223_P(), Blocks.field_180407_aO.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 3, 1, 10, 7, 1, 10, Blocks.field_180407_aO.func_176223_P(), Blocks.field_180407_aO.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 1, 0, 1, 7, 0, 4, Blocks.field_150344_f.func_176223_P(), Blocks.field_150344_f.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 0, 0, 0, 0, 3, 5, Blocks.field_150347_e.func_176223_P(), Blocks.field_150347_e.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 8, 0, 0, 8, 3, 5, Blocks.field_150347_e.func_176223_P(), Blocks.field_150347_e.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 1, 0, 0, 7, 1, 0, Blocks.field_150347_e.func_176223_P(), Blocks.field_150347_e.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 1, 0, 5, 7, 1, 5, Blocks.field_150347_e.func_176223_P(), Blocks.field_150347_e.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 1, 2, 0, 7, 3, 0, Blocks.field_150344_f.func_176223_P(), Blocks.field_150344_f.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 1, 2, 5, 7, 3, 5, Blocks.field_150344_f.func_176223_P(), Blocks.field_150344_f.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 0, 4, 1, 8, 4, 1, Blocks.field_150344_f.func_176223_P(), Blocks.field_150344_f.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 0, 4, 4, 8, 4, 4, Blocks.field_150344_f.func_176223_P(), Blocks.field_150344_f.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 0, 5, 2, 8, 5, 3, Blocks.field_150344_f.func_176223_P(), Blocks.field_150344_f.func_176223_P(), false);
            this.func_175811_a(worldIn, Blocks.field_150344_f.func_176223_P(), 0, 4, 2, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150344_f.func_176223_P(), 0, 4, 3, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150344_f.func_176223_P(), 8, 4, 2, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150344_f.func_176223_P(), 8, 4, 3, p_74875_3_);
            for (k = -1; k <= 2; ++k) {
                for (l = 0; l <= 8; ++l) {
                    this.func_175811_a(worldIn, Blocks.field_150476_ad.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.WEST), l, 4 + k, k, p_74875_3_);
                    this.func_175811_a(worldIn, Blocks.field_150476_ad.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.SOUTH), l, 4 + k, 5 - k, p_74875_3_);
                }
            }
            this.func_175811_a(worldIn, Blocks.field_150364_r.func_176223_P(), 0, 2, 1, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150364_r.func_176223_P(), 0, 2, 4, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150364_r.func_176223_P(), 8, 2, 1, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150364_r.func_176223_P(), 8, 2, 4, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 0, 2, 2, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 0, 2, 3, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 8, 2, 2, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 8, 2, 3, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 2, 2, 5, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 3, 2, 5, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 5, 2, 0, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 6, 2, 5, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_180407_aO.func_176223_P(), 2, 1, 3, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150452_aw.func_176223_P(), 2, 2, 3, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150344_f.func_176223_P(), 1, 1, 4, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150476_ad.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.WEST), 2, 1, 4, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150476_ad.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.EAST), 1, 1, 3, p_74875_3_);
            this.func_175804_a(worldIn, p_74875_3_, 5, 0, 1, 7, 0, 3, Blocks.field_150334_T.func_176223_P(), Blocks.field_150334_T.func_176223_P(), false);
            this.func_175811_a(worldIn, Blocks.field_150334_T.func_176223_P(), 6, 1, 1, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150334_T.func_176223_P(), 6, 1, 2, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 2, 1, 0, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 2, 2, 0, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150478_aa.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)this.func_186165_e()), 2, 3, 1, p_74875_3_);
            if (this.func_175807_a(worldIn, 2, 0, -1, p_74875_3_).func_185904_a() == Material.field_151579_a && this.func_175807_a(worldIn, 2, -1, -1, p_74875_3_).func_185904_a() != Material.field_151579_a) {
                this.func_175811_a(worldIn, Blocks.field_150446_ar.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.WEST), 2, 0, -1, p_74875_3_);
            }
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 6, 1, 5, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 6, 2, 5, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150478_aa.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)this.func_186165_e().func_176734_d()), 6, 3, 4, p_74875_3_);
            for (k = 0; k < 5; ++k) {
                for (l = 0; l < 9; ++l) {
                    this.func_74871_b(worldIn, l, 7, k, p_74875_3_);
                    this.func_175808_b(worldIn, Blocks.field_150347_e.func_176223_P(), l, -1, k, p_74875_3_);
                }
            }
            this.spawnVillagers(worldIn, p_74875_3_, 4, 1, 2, 2);
            return true;
        }

        @Override
        protected int func_180779_c(int p_180779_1_, int p_180779_2_) {
            return p_180779_1_ == 0 ? 4 : super.func_180779_c(p_180779_1_, p_180779_2_);
        }
    }

    public static class Field2
    extends Village {
        private Block cropTypeA;
        private Block cropTypeB;
        private static final String __OBFID = "CL_00000519";

        public Field2() {
        }

        public Field2(Start p_i45569_1_, int p_i45569_2_, Random p_i45569_3_, StructureBoundingBox p_i45569_4_, EnumFacing p_i45569_5_) {
            super(p_i45569_1_, p_i45569_2_);
            this.func_186164_a(p_i45569_5_);
            this.field_74887_e = p_i45569_4_;
            this.cropTypeA = this.func_151560_a(p_i45569_3_);
            this.cropTypeB = this.func_151560_a(p_i45569_3_);
        }

        @Override
        protected void func_143012_a(NBTTagCompound p_143012_1_) {
            super.func_143012_a(p_143012_1_);
            p_143012_1_.func_74768_a("CA", Block.field_149771_c.func_148757_b((Object)this.cropTypeA));
            p_143012_1_.func_74768_a("CB", Block.field_149771_c.func_148757_b((Object)this.cropTypeB));
        }

        @Override
        protected void func_143011_b(NBTTagCompound p_143011_1_, TemplateManager man) {
            super.func_143011_b(p_143011_1_, man);
            this.cropTypeA = Block.func_149729_e((int)p_143011_1_.func_74762_e("CA"));
            this.cropTypeB = Block.func_149729_e((int)p_143011_1_.func_74762_e("CB"));
        }

        private Block func_151560_a(Random p_151560_1_) {
            switch (p_151560_1_.nextInt(5)) {
                case 0: {
                    return Blocks.field_150459_bM;
                }
                case 1: {
                    return Blocks.field_150469_bN;
                }
            }
            return Blocks.field_150464_aj;
        }

        public static Field2 func_175852_a(Start p_175852_0_, List p_175852_1_, Random p_175852_2_, int p_175852_3_, int p_175852_4_, int p_175852_5_, EnumFacing p_175852_6_, int p_175852_7_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)p_175852_3_, (int)p_175852_4_, (int)p_175852_5_, (int)0, (int)0, (int)0, (int)7, (int)4, (int)9, (EnumFacing)p_175852_6_);
            return Field2.canVillageGoDeeper(structureboundingbox) && StructureComponent.func_74883_a((List)p_175852_1_, (StructureBoundingBox)structureboundingbox) == null ? new Field2(p_175852_0_, p_175852_7_, p_175852_2_, structureboundingbox, p_175852_6_) : null;
        }

        public boolean func_74875_a(World worldIn, Random p_74875_2_, StructureBoundingBox p_74875_3_) {
            int i;
            if (this.field_143015_k < 0) {
                this.field_143015_k = this.getAverageGroundLevel(worldIn, p_74875_3_);
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78894_e + 4 - 1, 0);
            }
            this.func_175804_a(worldIn, p_74875_3_, 0, 1, 0, 6, 4, 8, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 1, 0, 1, 2, 0, 7, Blocks.field_150458_ak.func_176223_P(), Blocks.field_150458_ak.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 4, 0, 1, 5, 0, 7, Blocks.field_150458_ak.func_176223_P(), Blocks.field_150458_ak.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 0, 0, 0, 0, 0, 8, Blocks.field_150364_r.func_176223_P(), Blocks.field_150364_r.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 6, 0, 0, 6, 0, 8, Blocks.field_150364_r.func_176223_P(), Blocks.field_150364_r.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 1, 0, 0, 5, 0, 0, Blocks.field_150364_r.func_176223_P(), Blocks.field_150364_r.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 1, 0, 8, 5, 0, 8, Blocks.field_150364_r.func_176223_P(), Blocks.field_150364_r.func_176223_P(), false);
            for (i = 1; i <= 7; ++i) {
                int row;
                if (p_74875_2_.nextInt(50) != 0 || (row = p_74875_2_.nextInt(5) + 1) == 3) continue;
                this.func_175811_a(worldIn, this.cropTypeA.func_176203_a(MathHelper.func_76136_a((Random)p_74875_2_, (int)2, (int)7)), row, 1, i, p_74875_3_);
            }
            for (i = 0; i < 9; ++i) {
                for (int j = 0; j < 7; ++j) {
                    this.func_74871_b(worldIn, j, 4, i, p_74875_3_);
                    this.func_175808_b(worldIn, Blocks.field_150346_d.func_176223_P(), j, -1, i, p_74875_3_);
                }
            }
            return true;
        }
    }

    public static class Field1
    extends Village {
        private Block cropTypeA;
        private Block cropTypeB;
        private Block cropTypeC;
        private Block cropTypeD;
        private static final String __OBFID = "CL_00000518";

        public Field1() {
        }

        public Field1(Start p_i45570_1_, int p_i45570_2_, Random p_i45570_3_, StructureBoundingBox p_i45570_4_, EnumFacing p_i45570_5_) {
            super(p_i45570_1_, p_i45570_2_);
            this.func_186164_a(p_i45570_5_);
            this.field_74887_e = p_i45570_4_;
            this.cropTypeA = this.func_151559_a(p_i45570_3_);
            this.cropTypeB = this.func_151559_a(p_i45570_3_);
            this.cropTypeC = this.func_151559_a(p_i45570_3_);
            this.cropTypeD = this.func_151559_a(p_i45570_3_);
        }

        @Override
        protected void func_143012_a(NBTTagCompound p_143012_1_) {
            super.func_143012_a(p_143012_1_);
            p_143012_1_.func_74768_a("CA", Block.field_149771_c.func_148757_b((Object)this.cropTypeA));
            p_143012_1_.func_74768_a("CB", Block.field_149771_c.func_148757_b((Object)this.cropTypeB));
            p_143012_1_.func_74768_a("CC", Block.field_149771_c.func_148757_b((Object)this.cropTypeC));
            p_143012_1_.func_74768_a("CD", Block.field_149771_c.func_148757_b((Object)this.cropTypeD));
        }

        @Override
        protected void func_143011_b(NBTTagCompound p_143011_1_, TemplateManager man) {
            super.func_143011_b(p_143011_1_, man);
            this.cropTypeA = Block.func_149729_e((int)p_143011_1_.func_74762_e("CA"));
            this.cropTypeB = Block.func_149729_e((int)p_143011_1_.func_74762_e("CB"));
            this.cropTypeC = Block.func_149729_e((int)p_143011_1_.func_74762_e("CC"));
            this.cropTypeD = Block.func_149729_e((int)p_143011_1_.func_74762_e("CD"));
        }

        private Block func_151559_a(Random p_151559_1_) {
            switch (p_151559_1_.nextInt(5)) {
                case 0: {
                    return Blocks.field_150459_bM;
                }
                case 1: {
                    return Blocks.field_150469_bN;
                }
            }
            return Blocks.field_150464_aj;
        }

        public static Field1 func_175851_a(Start p_175851_0_, List p_175851_1_, Random p_175851_2_, int p_175851_3_, int p_175851_4_, int p_175851_5_, EnumFacing p_175851_6_, int p_175851_7_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)p_175851_3_, (int)p_175851_4_, (int)p_175851_5_, (int)0, (int)0, (int)0, (int)13, (int)4, (int)9, (EnumFacing)p_175851_6_);
            return Field1.canVillageGoDeeper(structureboundingbox) && StructureComponent.func_74883_a((List)p_175851_1_, (StructureBoundingBox)structureboundingbox) == null ? new Field1(p_175851_0_, p_175851_7_, p_175851_2_, structureboundingbox, p_175851_6_) : null;
        }

        public boolean func_74875_a(World worldIn, Random p_74875_2_, StructureBoundingBox p_74875_3_) {
            int i;
            if (this.field_143015_k < 0) {
                this.field_143015_k = this.getAverageGroundLevel(worldIn, p_74875_3_);
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78894_e + 4 - 1, 0);
            }
            this.func_175804_a(worldIn, p_74875_3_, 0, 1, 0, 12, 4, 8, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 1, 0, 1, 2, 0, 7, Blocks.field_150458_ak.func_176223_P(), Blocks.field_150458_ak.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 4, 0, 1, 5, 0, 7, Blocks.field_150458_ak.func_176223_P(), Blocks.field_150458_ak.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 7, 0, 1, 8, 0, 7, Blocks.field_150458_ak.func_176223_P(), Blocks.field_150458_ak.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 10, 0, 1, 11, 0, 7, Blocks.field_150458_ak.func_176223_P(), Blocks.field_150458_ak.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 0, 0, 0, 0, 0, 8, Blocks.field_150364_r.func_176223_P(), Blocks.field_150364_r.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 6, 0, 0, 6, 0, 8, Blocks.field_150364_r.func_176223_P(), Blocks.field_150364_r.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 12, 0, 0, 12, 0, 8, Blocks.field_150364_r.func_176223_P(), Blocks.field_150364_r.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 1, 0, 0, 11, 0, 0, Blocks.field_150364_r.func_176223_P(), Blocks.field_150364_r.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 1, 0, 8, 11, 0, 8, Blocks.field_150364_r.func_176223_P(), Blocks.field_150364_r.func_176223_P(), false);
            for (i = 1; i <= 7; ++i) {
                int row;
                if (p_74875_2_.nextInt(50) != 0 || (row = p_74875_2_.nextInt(11) + 1) == 3 || row == 6 || row == 9) continue;
                this.func_175811_a(worldIn, this.cropTypeD.func_176203_a(MathHelper.func_76136_a((Random)p_74875_2_, (int)2, (int)7)), row, 1, i, p_74875_3_);
            }
            for (i = 0; i < 9; ++i) {
                for (int j = 0; j < 13; ++j) {
                    this.func_74871_b(worldIn, j, 4, i, p_74875_3_);
                    this.func_175808_b(worldIn, Blocks.field_150346_d.func_176223_P(), j, -1, i, p_74875_3_);
                }
            }
            return true;
        }
    }

    public static class Church
    extends Village {
        private static final String __OBFID = "CL_00000525";

        public Church() {
        }

        public Church(Start p_i45564_1_, int p_i45564_2_, Random p_i45564_3_, StructureBoundingBox p_i45564_4_, EnumFacing p_i45564_5_) {
            super(p_i45564_1_, p_i45564_2_);
            this.func_186164_a(p_i45564_5_);
            this.field_74887_e = p_i45564_4_;
        }

        public static Church func_175854_a(Start p_175854_0_, List p_175854_1_, Random p_175854_2_, int p_175854_3_, int p_175854_4_, int p_175854_5_, EnumFacing p_175854_6_, int p_175854_7_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)p_175854_3_, (int)p_175854_4_, (int)p_175854_5_, (int)0, (int)0, (int)0, (int)5, (int)12, (int)9, (EnumFacing)p_175854_6_);
            return Church.canVillageGoDeeper(structureboundingbox) && StructureComponent.func_74883_a((List)p_175854_1_, (StructureBoundingBox)structureboundingbox) == null ? new Church(p_175854_0_, p_175854_7_, p_175854_2_, structureboundingbox, p_175854_6_) : null;
        }

        public boolean func_74875_a(World worldIn, Random rand, StructureBoundingBox p_74875_3_) {
            if (this.field_143015_k < 0) {
                this.field_143015_k = this.getAverageGroundLevel(worldIn, p_74875_3_);
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78894_e + 12 - 1, 0);
            }
            this.func_175804_a(worldIn, p_74875_3_, 1, 1, 1, 3, 3, 7, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 1, 5, 1, 3, 9, 3, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 1, 0, 0, 3, 0, 8, Blocks.field_150347_e.func_176223_P(), Blocks.field_150347_e.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 1, 1, 0, 3, 10, 0, Blocks.field_150347_e.func_176223_P(), Blocks.field_150347_e.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 0, 1, 1, 0, 10, 3, Blocks.field_150347_e.func_176223_P(), Blocks.field_150347_e.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 4, 1, 1, 4, 10, 3, Blocks.field_150347_e.func_176223_P(), Blocks.field_150347_e.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 0, 0, 4, 0, 4, 7, Blocks.field_150347_e.func_176223_P(), Blocks.field_150347_e.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 4, 0, 4, 4, 4, 7, Blocks.field_150347_e.func_176223_P(), Blocks.field_150347_e.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 1, 1, 8, 3, 4, 8, Blocks.field_150347_e.func_176223_P(), Blocks.field_150347_e.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 1, 5, 4, 3, 10, 4, Blocks.field_150347_e.func_176223_P(), Blocks.field_150347_e.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 1, 5, 5, 3, 5, 7, Blocks.field_150347_e.func_176223_P(), Blocks.field_150347_e.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 0, 9, 0, 4, 9, 4, Blocks.field_150347_e.func_176223_P(), Blocks.field_150347_e.func_176223_P(), false);
            this.func_175804_a(worldIn, p_74875_3_, 0, 4, 0, 4, 4, 4, Blocks.field_150347_e.func_176223_P(), Blocks.field_150347_e.func_176223_P(), false);
            this.func_175811_a(worldIn, Blocks.field_150347_e.func_176223_P(), 0, 11, 2, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150347_e.func_176223_P(), 4, 11, 2, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150347_e.func_176223_P(), 2, 11, 0, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150347_e.func_176223_P(), 2, 11, 4, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150347_e.func_176223_P(), 1, 1, 6, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150347_e.func_176223_P(), 1, 1, 7, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150347_e.func_176223_P(), 2, 1, 7, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150347_e.func_176223_P(), 3, 1, 6, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150347_e.func_176223_P(), 3, 1, 7, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 0, 2, 2, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 0, 3, 2, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 4, 2, 2, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 4, 3, 2, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 0, 6, 2, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 0, 7, 2, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 4, 6, 2, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 4, 7, 2, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 2, 6, 0, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 2, 7, 0, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 2, 6, 4, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 2, 7, 4, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 0, 3, 6, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 4, 3, 6, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 2, 3, 8, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150446_ar.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.WEST), 1, 1, 5, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150446_ar.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.WEST), 2, 1, 6, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150446_ar.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.WEST), 3, 1, 5, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150446_ar.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.EAST), 1, 2, 7, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150446_ar.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH), 3, 2, 7, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 2, 1, 0, p_74875_3_);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 2, 2, 0, p_74875_3_);
            if (this.func_175807_a(worldIn, 2, 0, -1, p_74875_3_).func_185904_a() == Material.field_151579_a && this.func_175807_a(worldIn, 2, -1, -1, p_74875_3_).func_185904_a() != Material.field_151579_a) {
                this.func_175811_a(worldIn, Blocks.field_150446_ar.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.WEST), 2, 0, -1, p_74875_3_);
            }
            for (int j = 0; j < 9; ++j) {
                for (int k = 0; k < 5; ++k) {
                    this.func_74871_b(worldIn, k, 12, j, p_74875_3_);
                    this.func_175808_b(worldIn, Blocks.field_150347_e.func_176223_P(), k, -1, j, p_74875_3_);
                }
            }
            int[][] destruction = new int[][]{{3, 3, 0, 0, 0}, {4, 0, 0, 0, 0}, {6, 3, 0, 0, 0}, {8, 9, 3, 0, 0}, {9, 9, 6, 0, 0}, {10, 9, 0, 0, 0}, {10, 9, 9, 0, 0}, {10, 9, 9, 0, 0}, {10, 9, 9, 0, 0}};
            this.destroyBuilding(worldIn, destruction, p_74875_3_);
            this.spawnVillagers(worldIn, p_74875_3_, 2, 1, 2, 1);
            return true;
        }

        @Override
        protected int func_180779_c(int p_180779_1_, int p_180779_2_) {
            return 2;
        }
    }
}

