/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.apocalypse.common;

import com.flansmod.apocalypse.common.ApocalypseData;
import com.flansmod.apocalypse.common.FlansModApocalypse;
import com.flansmod.apocalypse.common.entity.EntityAIMecha;
import com.flansmod.apocalypse.common.entity.EntityFakePlayer;
import com.flansmod.apocalypse.common.entity.EntityFlyByPlane;
import com.flansmod.apocalypse.common.entity.EntityNukeDrop;
import com.flansmod.apocalypse.common.entity.EntitySurvivor;
import com.flansmod.apocalypse.common.entity.EntityTeleporter;
import com.flansmod.apocalypse.common.network.PacketApocalypseCountdown;
import com.flansmod.apocalypse.common.world.TeleporterApocalypse;
import com.flansmod.apocalypse.common.world.buildings.StructureAbandonedVillagePieces;
import com.flansmod.common.FlansMod;
import com.flansmod.common.driveables.CollisionBox;
import com.flansmod.common.driveables.DriveableData;
import com.flansmod.common.driveables.DriveableType;
import com.flansmod.common.driveables.EnumDriveablePart;
import com.flansmod.common.driveables.PlaneType;
import com.flansmod.common.driveables.mechas.EntityMecha;
import com.flansmod.common.parts.PartType;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.play.server.SPacketPlayerPosLook;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;

public class CommonProxyApocalypse {
    private int apocalypseCountdown = 0;
    private EntityMecha apocalypseMecha = null;
    public ApocalypseData data;
    private static HashMap<EntityPlayer, BlockPos> deathPoints = new HashMap();

    public void preInit(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.data = new ApocalypseData();
        MinecraftForge.EVENT_BUS.register((Object)this.data);
        FMLCommonHandler.instance().bus().register((Object)this);
        StructureAbandonedVillagePieces.registerVillagePieces();
    }

    public void init(FMLInitializationEvent event) {
        FlansMod.getPacketHandler().registerPacket(PacketApocalypseCountdown.class);
    }

    public void postInit(FMLPostInitializationEvent event) {
    }

    @SubscribeEvent
    public void registerEntities(RegistryEvent.Register<EntityEntry> event) {
        event.getRegistry().register(new EntityEntry(EntitySurvivor.class, "Survivor").setRegistryName("Survivor"));
        event.getRegistry().register(new EntityEntry(EntityTeleporter.class, "Teleporter").setRegistryName("Teleporter"));
        event.getRegistry().register(new EntityEntry(EntityAIMecha.class, "AIMecha").setRegistryName("AIMecha"));
        event.getRegistry().register(new EntityEntry(EntityFakePlayer.class, "FakePlayer").setRegistryName("FakePlayer"));
        event.getRegistry().register(new EntityEntry(EntityNukeDrop.class, "NukeDrop").setRegistryName("NukeDrop"));
        event.getRegistry().register(new EntityEntry(EntityFlyByPlane.class, "FlyByPlane").setRegistryName("FlyByPlane"));
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("flansmodapocalypse:Teleporter"), EntityTeleporter.class, (String)"Teleporter", (int)113, (Object)FlansModApocalypse.INSTANCE, (int)100, (int)20, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("flansmodapocalypse:AIMecha"), EntityAIMecha.class, (String)"AIMecha", (int)114, (Object)FlansModApocalypse.INSTANCE, (int)250, (int)20, (boolean)false);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("flansmodapocalypse:FakePlayer"), EntityFakePlayer.class, (String)"FakePlayer", (int)115, (Object)FlansModApocalypse.INSTANCE, (int)250, (int)20, (boolean)false);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("flansmodapocalypse:NukeDrop"), EntityNukeDrop.class, (String)"NukeDrop", (int)116, (Object)FlansModApocalypse.INSTANCE, (int)250, (int)20, (boolean)false);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("flansmodapocalypse:FlyByPlane"), EntityFlyByPlane.class, (String)"FlyByPlane", (int)117, (Object)FlansModApocalypse.INSTANCE, (int)250, (int)20, (boolean)false);
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            WorldServer world;
            if (this.getApocalypseCountdown() > 0) {
                if (this.apocalypseMecha == null || this.apocalypseMecha.isDead()) {
                    this.setApocalypseCountdown(0);
                } else {
                    this.setApocalypseCountdown(this.getApocalypseCountdown() - 1);
                    this.apocalypseMecha.getSeat((int)0).prevLooking = this.apocalypseMecha.getSeat((int)0).looking.clone();
                    this.apocalypseMecha.getSeat((int)0).looking.rotateGlobalYaw(this.apocalypseMecha.field_70170_p.field_73012_v.nextFloat() * 10.0f);
                    this.apocalypseMecha.getSeat((int)0).looking.rotateGlobalPitch((float)this.apocalypseMecha.field_70170_p.field_73012_v.nextGaussian() * 3.0f);
                    if (this.getApocalypseCountdown() % 20 == 0) {
                        world = this.apocalypseMecha.field_70170_p;
                        float range = 150.0f;
                        world.func_72838_d((Entity)new EntityNukeDrop((World)world, this.apocalypseMecha.field_70165_t + world.field_73012_v.nextGaussian() * (double)range, 256.0, this.apocalypseMecha.field_70161_v + world.field_73012_v.nextGaussian() * (double)range));
                    }
                    if (this.getApocalypseCountdown() == 0) {
                        FlansMod.log("The apocalypse has begun!");
                        EntityPlayer placer = this.apocalypseMecha.placer;
                        switch (FlansModApocalypse.OPTION) {
                            case DIM: {
                                for (int i = 0; i < placer.field_70170_p.field_73010_i.size(); ++i) {
                                    if (((Entity)placer.field_70170_p.field_73010_i.get((int)i)).field_71093_bK != 0) continue;
                                    this.sendPlayerToApocalypse((EntityPlayer)placer.field_70170_p.field_73010_i.get(i));
                                }
                                break;
                            }
                            case DIM_OPT_IN: {
                                break;
                            }
                            case NEARBY: {
                                for (Object player : placer.field_70170_p.field_73010_i) {
                                    if (((Entity)player).field_71093_bK != 0 || !(((Entity)player).func_70068_e((Entity)placer) < 2500.0)) continue;
                                    this.sendPlayerToApocalypse((EntityPlayer)player);
                                }
                                break;
                            }
                            case NEARBY_OPT_IN: {
                                break;
                            }
                            case PLACER_ONLY: {
                                this.sendPlayerToApocalypse(placer);
                            }
                        }
                        this.apocalypseMecha.func_70106_y();
                    }
                }
            }
            if ((world = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(FlansModApocalypse.dimensionID)) != null) {
                for (int i = 0; i < world.field_73010_i.size(); ++i) {
                    Object player;
                    player = (EntityPlayer)world.field_73010_i.get(i);
                    if (world.field_73012_v.nextInt(5000) == 0) {
                        double dX = world.field_73012_v.nextFloat() - 0.5f;
                        double dZ = world.field_73012_v.nextFloat() - 0.5f;
                        double mag = Math.sqrt(dX * dX + dZ * dZ);
                        dX /= mag;
                        dZ /= mag;
                        double dist = 200.0;
                        dX *= dist;
                        dZ *= dist;
                        PlaneType type = FlansModApocalypse.getLootGenerator().getRandomPlane(world.field_73012_v);
                        NBTTagCompound tags = new NBTTagCompound();
                        tags.func_74778_a("Engine", FlansModApocalypse.getLootGenerator().getRandomEngine((DriveableType)type, (Random)world.field_73012_v).shortName);
                        tags.func_74778_a("Type", type.shortName);
                        for (EnumDriveablePart part : EnumDriveablePart.values()) {
                            tags.func_74768_a(part.getShortName() + "_Health", type.health.get((Object)part) == null ? 0 : ((CollisionBox)type.health.get((Object)((Object)part))).health);
                            tags.func_74757_a(part.getShortName() + "_Fire", false);
                        }
                        DriveableData data = new DriveableData(tags);
                        EntityFlyByPlane plane = new EntityFlyByPlane((World)world, player.field_70165_t + dX, 120.0, player.field_70161_v + dZ, type, data);
                        plane.throttle = 1.0f;
                        world.func_72838_d((Entity)plane);
                        float yaw = 180.0f + (float)Math.atan2(dZ, dX) * 180.0f / 3.14159f;
                        plane.getSeat((int)0).looking.setAngles(yaw, 0.0f, 0.0f);
                        plane.getSeat((int)0).prevLooking.setAngles(yaw, 0.0f, 0.0f);
                        plane.axes.setAngles(yaw, 0.0f, 0.0f);
                        plane.prevAxes.setAngles(yaw, 0.0f, 0.0f);
                        EntitySkeleton pilot = new EntitySkeleton((World)world);
                        pilot.func_70107_b(plane.field_70165_t, plane.field_70163_u, plane.field_70161_v);
                        world.func_72838_d((Entity)pilot);
                        pilot.func_184220_m((Entity)plane.getSeat(0));
                    }
                    if (world.field_73012_v.nextInt(FlansModApocalypse.WANDERING_SURVIVOR_RARITY) != 0 || world.field_73011_w.isDaytime()) continue;
                    double angle = world.field_73012_v.nextFloat() * 3.14159f * 2.0f;
                    double dist = 50.0;
                    double dX = Math.cos(angle) * dist;
                    double dZ = Math.sin(angle) * dist;
                    EntitySurvivor survivor = new EntitySurvivor((World)world);
                    survivor.func_70107_b(player.field_70165_t + dX, (double)world.func_175672_r(new BlockPos(player.field_70165_t + dX, 0.0, player.field_70161_v + dZ)).func_177956_o() + 1.0, player.field_70161_v + dZ);
                    world.func_72838_d((Entity)survivor);
                }
            }
        }
    }

    private void sendPlayerToApocalypse(EntityPlayer player) {
        EntityFakePlayer fakePlayer = new EntityFakePlayer(player.field_70170_p, player);
        player.field_70170_p.func_72838_d((Entity)fakePlayer);
        player.field_71071_by.func_174888_l();
        player.field_71088_bW = 10;
        this.data.entryPoints.put(player.getPersistentID(), new BlockPos(this.apocalypseMecha.field_70165_t, this.apocalypseMecha.field_70163_u, this.apocalypseMecha.field_70161_v));
        BlockPos exitPoint = new BlockPos(this.apocalypseMecha.field_70165_t, 128.0, this.apocalypseMecha.field_70161_v);
        while (FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(FlansModApocalypse.dimensionID).func_175623_d(exitPoint)) {
            exitPoint = exitPoint.func_177977_b();
        }
        FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().transferPlayerToDimension((EntityPlayerMP)player, FlansModApocalypse.dimensionID, (Teleporter)new TeleporterApocalypse(FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(FlansModApocalypse.dimensionID), exitPoint.func_177982_a(0, 1, 0)));
        this.giveStarterKit(player);
    }

    private void giveStarterKit(EntityPlayer player) {
        player.field_71071_by.func_70441_a(new ItemStack(Items.field_151050_s));
        player.field_71071_by.func_70441_a(new ItemStack(Items.field_151051_r));
        player.field_71071_by.func_70441_a(new ItemStack(Blocks.field_150364_r, 8));
        player.field_71071_by.func_70441_a(new ItemStack(Items.field_151083_be, 4));
    }

    @SubscribeEvent
    public void itemPlaced(EntityJoinWorldEvent event) {
        if (!event.getWorld().field_72995_K && event.getEntity() instanceof EntityMecha && event.getEntity().field_71093_bK == 0) {
            EntityMecha mecha = (EntityMecha)event.getEntity();
            PartType engine = mecha.getDriveableData().engine;
            if (engine.isAIChip) {
                this.setApocalypseCountdown(FlansModApocalypse.apocalypseCountdownLength);
                this.apocalypseMecha = mecha;
                FlansMod.getPacketHandler().sendTo(new PacketApocalypseCountdown(this.getApocalypseCountdown()), (EntityPlayerMP)mecha.placer);
            }
        }
    }

    @SubscribeEvent
    public void playerDied(LivingDeathEvent event) {
        if (event.getEntityLiving().field_71093_bK == FlansModApocalypse.dimensionID && event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            deathPoints.put(player, new BlockPos(player.field_70165_t, player.field_70163_u, player.field_70161_v));
        }
    }

    @SubscribeEvent
    public void playerRespawned(PlayerEvent.PlayerRespawnEvent event) {
        BlockPos pos;
        if (event.player.field_71093_bK == FlansModApocalypse.dimensionID && (pos = deathPoints.get(event.player)) != null) {
            EnumSet<SPacketPlayerPosLook.EnumFlags> enumset = EnumSet.noneOf(SPacketPlayerPosLook.EnumFlags.class);
            float angle = event.player.field_70170_p.field_73012_v.nextFloat() * 2.0f * 3.14159f;
            pos = pos.func_177982_a((int)(Math.cos(angle) * (double)FlansModApocalypse.SPAWN_RADIUS), 128 - pos.func_177956_o(), (int)(Math.sin(angle) * (double)FlansModApocalypse.SPAWN_RADIUS));
            while (event.player.field_70170_p.func_175623_d(pos)) {
                pos = pos.func_177977_b();
            }
            ((EntityPlayerMP)event.player).field_71135_a.func_175089_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.5, (double)pos.func_177952_p() + 0.5, 0.0f, 0.0f, enumset);
            event.player.field_70165_t = event.player.field_70169_q = (double)pos.func_177958_n() + 0.5;
            event.player.field_70163_u = event.player.field_70167_r = (double)pos.func_177956_o() + 0.5;
            event.player.field_70161_v = event.player.field_70166_s = (double)pos.func_177952_p() + 0.5;
        }
    }

    public int getApocalypseCountdown() {
        return this.apocalypseCountdown;
    }

    private void setApocalypseCountdown(int apocalypseCountdown) {
        this.apocalypseCountdown = apocalypseCountdown;
    }
}

