/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.teams;

import com.flansmod.common.PlayerData;
import com.flansmod.common.teams.EntityFlag;
import com.flansmod.common.teams.EntityFlagpole;
import com.flansmod.common.teams.Gametype;
import com.flansmod.common.teams.ITeamBase;
import com.flansmod.common.teams.ITeamObject;
import com.flansmod.common.teams.Team;
import com.flansmod.common.teams.TeamsManager;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class GametypeCTF
extends Gametype {
    public boolean friendlyFire = false;
    public boolean autoBalance = true;
    public int time;
    public int autoBalanceInterval = 1200;
    public int flagReturnTime = 60;

    public GametypeCTF() {
        super("Capture the Flag", "CTF", 2);
    }

    @Override
    public void roundStart() {
    }

    @Override
    public void roundEnd() {
    }

    @Override
    public void roundCleanup() {
    }

    @Override
    public void tick() {
    }

    @Override
    public void playerQuit(EntityPlayerMP player) {
    }

    @Override
    public boolean playerCanAttack(EntityPlayerMP attacker, Team attackerTeam, EntityPlayerMP victim, Team victimTeam) {
        return attackerTeam != victimTeam || this.friendlyFire;
    }

    @Override
    public boolean playerAttacked(EntityPlayerMP player, DamageSource source) {
        if (GametypeCTF.getPlayerData(player) == null || GametypeCTF.getPlayerData((EntityPlayerMP)player).team == null) {
            return false;
        }
        EntityPlayerMP attacker = GametypeCTF.getPlayerFromDamageSource(source);
        if (attacker != null) {
            if (GametypeCTF.getPlayerData(attacker) == null || GametypeCTF.getPlayerData((EntityPlayerMP)attacker).team == null) {
                return false;
            }
            if (GametypeCTF.getPlayerData((EntityPlayerMP)player).team == GametypeCTF.getPlayerData((EntityPlayerMP)attacker).team) {
                return this.friendlyFire;
            }
        }
        return GametypeCTF.getPlayerData((EntityPlayerMP)player).team != Team.spectators;
    }

    @Override
    public void playerKilled(EntityPlayerMP player, DamageSource source) {
        EntityPlayerMP attacker = GametypeCTF.getPlayerFromDamageSource(source);
        if (attacker != null) {
            if (attacker == player) {
                --GametypeCTF.getPlayerData((EntityPlayerMP)player).score;
            } else {
                ++GametypeCTF.getPlayerData((EntityPlayerMP)attacker).score;
                ++GametypeCTF.getPlayerData((EntityPlayerMP)attacker).kills;
            }
        } else {
            --GametypeCTF.getPlayerData((EntityPlayerMP)player).score;
        }
        ++GametypeCTF.getPlayerData((EntityPlayerMP)player).deaths;
        if (player.func_184188_bt().get(0) instanceof EntityFlag) {
            EntityFlag flag = (EntityFlag)player.func_184188_bt().get(0);
            Team flagTeam = teamsManager.getTeam(flag.getBase().getOwnerID());
            flag.func_184210_p();
            TeamsManager.messageAll("\u00a7f" + player.func_70005_c_() + " dropped the \u00a7" + flagTeam.textColour + flagTeam.name + "\u00a7f flag");
        }
    }

    @Override
    public void baseAttacked(ITeamBase base, DamageSource source) {
    }

    @Override
    public void objectAttacked(ITeamObject object, DamageSource source) {
    }

    @Override
    public void baseClickedByPlayer(ITeamBase base, EntityPlayerMP player) {
        if (base instanceof EntityFlagpole && ((EntityFlag)base.getFlag()).isHome) {
            this.objectClickedByPlayer(base.getFlag(), player);
        }
    }

    @Override
    public void objectClickedByPlayer(ITeamObject object, EntityPlayerMP player) {
        EntityFlag flag;
        if (GametypeCTF.teamsManager.currentRound == null) {
            return;
        }
        if (object instanceof EntityFlag && (flag = (EntityFlag)object).getBase().getOwnerID() > 1) {
            Team playerTeam = GametypeCTF.getPlayerData((EntityPlayerMP)player).team;
            PlayerData playerData = GametypeCTF.getPlayerData(player);
            Team flagTeam = teamsManager.getTeam(flag.getBase().getOwnerID());
            if (playerTeam != null && playerTeam != Team.spectators && flag.getBase().getMap() == GametypeCTF.teamsManager.currentRound.map) {
                if (playerTeam == flagTeam) {
                    EntityFlag otherFlag;
                    Team otherFlagTeam;
                    if (flag.func_184187_bx() == null && !flag.isHome) {
                        flag.reset();
                        playerData.score += 2;
                        TeamsManager.messageAll("\u00a7f" + player.func_70005_c_() + " returned the \u00a7" + flagTeam.textColour + flagTeam.name + "\u00a7f flag");
                    } else if (player.func_184188_bt().get(0) instanceof EntityFlag && (otherFlagTeam = teamsManager.getTeam((otherFlag = (EntityFlag)player.func_184188_bt().get(0)).getBase().getOwnerID())) != null && otherFlagTeam != Team.spectators && otherFlagTeam != flagTeam && flag.isHome) {
                        ++playerTeam.score;
                        playerData.score += 10;
                        otherFlag.reset();
                        TeamsManager.messageAll("\u00a7f" + player.func_70005_c_() + " captured the \u00a7" + otherFlagTeam.textColour + otherFlagTeam.name + "\u00a7f flag");
                    }
                } else if (flag.func_184187_bx() == player) {
                    flag.func_184210_p();
                    TeamsManager.messageAll("\u00a7f" + player.func_70005_c_() + " dropped the \u00a7" + flagTeam.textColour + flagTeam.name + "\u00a7f flag");
                } else if (flag.func_184187_bx() == null) {
                    if (flag.isHome) {
                        playerData.score += 3;
                    }
                    flag.func_184220_m((Entity)player);
                    TeamsManager.messageAll("\u00a7f" + player.func_70005_c_() + " picked up the \u00a7" + flagTeam.textColour + flagTeam.name + "\u00a7f flag");
                    flag.isHome = false;
                }
            }
        }
    }

    @Override
    public Vec3d getSpawnPoint(EntityPlayerMP player) {
        if (GametypeCTF.teamsManager.currentRound == null) {
            return null;
        }
        PlayerData data = GametypeCTF.getPlayerData(player);
        ArrayList<BlockPos> validSpawnPoints = new ArrayList<BlockPos>();
        if (data.newTeam == null) {
            return null;
        }
        GametypeCTF.teamsManager.currentRound.map.getValidSpawnPoints(GametypeCTF.teamsManager.currentRound.getTeamID(data.newTeam), validSpawnPoints);
        if (validSpawnPoints.size() > 0) {
            BlockPos spawnPoint = (BlockPos)validSpawnPoints.get(rand.nextInt(validSpawnPoints.size()));
            return new Vec3d((double)spawnPoint.func_177958_n() + 0.5, (double)spawnPoint.func_177956_o(), (double)spawnPoint.func_177952_p() + 0.5);
        }
        return null;
    }

    @Override
    public void playerRespawned(EntityPlayerMP player) {
    }

    @Override
    public boolean setVariable(String variable, String value) {
        if (variable.toLowerCase().equals("friendlyfire")) {
            this.friendlyFire = Boolean.parseBoolean(value);
            return true;
        }
        if (variable.toLowerCase().equals("autobalance")) {
            this.autoBalance = Boolean.parseBoolean(value);
            return true;
        }
        if (variable.toLowerCase().equals("flagtime")) {
            this.flagReturnTime = Integer.parseInt(value);
            return true;
        }
        return false;
    }

    @Override
    public void readFromNBT(NBTTagCompound tags) {
        this.friendlyFire = tags.func_74767_n("CTFFriendlyFire");
        this.autoBalance = tags.func_74767_n("CTFAutoBalance");
        this.flagReturnTime = tags.func_74762_e("CTFFlagTime");
    }

    @Override
    public void saveToNBT(NBTTagCompound tags) {
        tags.func_74757_a("CTFFriendlyFire", this.friendlyFire);
        tags.func_74757_a("CTFAutoBalance", this.autoBalance);
        tags.func_74768_a("CTFFlagTime", this.flagReturnTime);
    }

    @Override
    public boolean sortScoreboardByTeam() {
        return true;
    }

    @Override
    public boolean teamHasWon(Team team) {
        return GametypeCTF.teamsManager.currentRound != null && team.score == GametypeCTF.teamsManager.currentRound.scoreLimit;
    }
}

