/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.network;

import com.flansmod.common.FlansMod;
import com.flansmod.common.guns.BulletType;
import com.flansmod.common.guns.GunType;
import com.flansmod.common.guns.ItemGun;
import com.flansmod.common.guns.ShootableType;
import com.flansmod.common.guns.ShotData;
import com.flansmod.common.guns.raytracing.FlansModRaytracer;
import com.flansmod.common.network.PacketBase;
import com.flansmod.common.types.InfoType;
import com.flansmod.common.vector.Vector3f;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketShotData
extends PacketBase {
    private List<ShotData> shotData;

    public PacketShotData() {
    }

    public PacketShotData(List<ShotData> shotData) {
        this.shotData = shotData;
    }

    public PacketShotData(ShotData shotData) {
        this.shotData = new ArrayList<ShotData>();
        this.shotData.add(shotData);
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf data) {
        data.writeInt(this.shotData.size());
        for (int i = 0; i < this.shotData.size(); ++i) {
            ShotData currentCast;
            ShotData current = this.shotData.get(i);
            data.writeByte((int)((byte)current.slot));
            data.writeInt(current.shotFrom.hashCode());
            data.writeInt(current.shotType.hashCode());
            data.writeBoolean(current.hand == EnumHand.MAIN_HAND);
            if (current instanceof ShotData.SpawnEntityShotData) {
                currentCast = (ShotData.SpawnEntityShotData)current;
                data.writeByte(0);
                data.writeInt(currentCast.shooterID);
                currentCast.direction.writeToBuffer(data);
                continue;
            }
            if (!(current instanceof ShotData.InstantShotData)) continue;
            currentCast = (ShotData.InstantShotData)current;
            data.writeByte(1);
            data.writeInt(((ShotData.InstantShotData)currentCast).shooterID);
            ((ShotData.InstantShotData)currentCast).origin.writeToBuffer(data);
            FlansModRaytracer.WriteToBuffer(((ShotData.InstantShotData)currentCast).hitData, data);
            ((ShotData.InstantShotData)currentCast).hitPos.writeToBuffer(data);
            data.writeFloat(((ShotData.InstantShotData)currentCast).damage);
            data.writeBoolean(((ShotData.InstantShotData)currentCast).isExtraBullet);
            data.writeBoolean(((ShotData.InstantShotData)currentCast).silenced);
        }
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf data) {
        this.shotData = new ArrayList<ShotData>();
        int numEntries = data.readInt();
        block4: for (int i = 0; i < numEntries; ++i) {
            byte slot = data.readByte();
            InfoType shotFrom = InfoType.getType(data.readInt());
            ShootableType shotType = ShootableType.getShootableType(data.readInt());
            EnumHand hand = data.readBoolean() ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND;
            byte dataType = data.readByte();
            switch (dataType) {
                case 0: {
                    int shooterID = data.readInt();
                    Vector3f direction = Vector3f.readFromBuffer(data);
                    this.shotData.add(new ShotData.SpawnEntityShotData((int)slot, hand, shotFrom, shotType, shooterID, direction));
                    continue block4;
                }
                case 1: {
                    int shooterID = data.readInt();
                    Vector3f origin = Vector3f.readFromBuffer(data);
                    FlansModRaytracer.BulletHit hitData = FlansModRaytracer.ReadFromBuffer(data);
                    Vector3f hit = Vector3f.readFromBuffer(data);
                    float damage = data.readFloat();
                    boolean isExtraBullet = data.readBoolean();
                    boolean silenced = data.readBoolean();
                    this.shotData.add(new ShotData.InstantShotData((int)slot, hand, shotFrom, shotType, shooterID, origin, hitData, hit, damage, isExtraBullet, silenced));
                    continue block4;
                }
            }
        }
    }

    @Override
    public void handleServerSide(EntityPlayerMP player) {
        for (ShotData entry : this.shotData) {
            ItemGun gunItem;
            ItemStack gunStack;
            if (entry.slot == -1) {
                if (!(entry.shotFrom instanceof GunType)) continue;
                ((ItemGun)entry.shotFrom.item).ServerHandleShotData(null, entry.slot, player.field_70170_p, (Entity)player, false, entry);
                continue;
            }
            if (entry.hand == EnumHand.OFF_HAND) {
                gunStack = player.func_184592_cb();
                if (gunStack == null || !(gunStack.func_77973_b() instanceof ItemGun)) continue;
                gunItem = (ItemGun)gunStack.func_77973_b();
                gunItem.ServerHandleShotData(gunStack, entry.slot, player.field_70170_p, (Entity)player, true, entry);
                continue;
            }
            gunStack = player.field_71071_by.func_70301_a(entry.slot);
            if (gunStack == null || !(gunStack.func_77973_b() instanceof ItemGun)) continue;
            gunItem = (ItemGun)gunStack.func_77973_b();
            gunItem.ServerHandleShotData(gunStack, entry.slot, player.field_70170_p, (Entity)player, false, entry);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleClientSide(EntityPlayer clientPlayer) {
        for (ShotData entry : this.shotData) {
            if (entry instanceof ShotData.InstantShotData) {
                ShotData.InstantShotData instantData = (ShotData.InstantShotData)entry;
                if (!(entry.shotFrom instanceof GunType)) continue;
                ItemGun gunItem = (ItemGun)entry.shotFrom.getItem();
                gunItem.DoInstantShot(clientPlayer.field_70170_p, FlansModRaytracer.GetEntityByID(instantData.shooterID), instantData.shotFrom, (BulletType)instantData.shotType, instantData.origin, instantData.hitPos, instantData.hitData, instantData.damage, instantData.isExtraBullet, instantData.silenced);
                continue;
            }
            FlansMod.log("Only expect instant shot types on client side.");
        }
    }
}

