/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.network;

import com.flansmod.client.gui.teams.EnumLoadoutSlot;
import com.flansmod.client.gui.teams.GuiTeamSelect;
import com.flansmod.client.teams.ClientTeamsData;
import com.flansmod.common.FlansMod;
import com.flansmod.common.network.PacketBase;
import com.flansmod.common.teams.LoadoutPool;
import com.flansmod.common.teams.PlayerRankData;
import com.flansmod.common.teams.Team;
import com.flansmod.common.teams.TeamsManagerRanked;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketLoadoutData
extends PacketBase {
    public String motd = "";
    public Team[] teamsAvailable = new Team[0];
    public PlayerRankData myRankData = new PlayerRankData();
    public LoadoutPool currentPool = null;

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf data) {
        PacketLoadoutData.writeUTF(data, this.motd);
        data.writeInt(this.teamsAvailable.length);
        for (int i = 0; i < this.teamsAvailable.length; ++i) {
            data.writeInt(this.teamsAvailable[i] == null ? 0 : this.teamsAvailable[i].shortName.hashCode());
        }
        this.myRankData.writeToBuf(data);
        data.writeInt(this.currentPool == null ? 0 : this.currentPool.shortName.hashCode());
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf data) {
        this.motd = PacketLoadoutData.readUTF(data);
        int numTeams = data.readInt();
        this.teamsAvailable = new Team[numTeams];
        for (int i = 0; i < this.teamsAvailable.length; ++i) {
            this.teamsAvailable[i] = Team.getTeam(data.readInt());
        }
        this.myRankData.readFromBuf(data);
        this.currentPool = LoadoutPool.GetPool(data.readInt());
    }

    @Override
    public void handleServerSide(EntityPlayerMP playerEntity) {
        PlayerRankData rankData = TeamsManagerRanked.rankData.get(playerEntity.func_110124_au());
        if (rankData == null) {
            rankData = new PlayerRankData();
            TeamsManagerRanked.rankData.put(playerEntity.func_110124_au(), rankData);
        }
        this.myRankData.currentLevel = rankData.currentLevel;
        if (this.myRankData.VerifyLoadouts()) {
            rankData.loadouts = this.myRankData.loadouts;
        } else {
            FlansMod.Assert(false, "PLAYER " + playerEntity.getDisplayNameString() + " GAVE INCORRECT LOADOUT.");
            LoadoutPool pool = TeamsManagerRanked.GetInstance().currentPool;
            if (pool != null) {
                for (int i = 0; i < 5; ++i) {
                    for (int j = 0; j < EnumLoadoutSlot.values().length; ++j) {
                        rankData.loadouts[i].slots[j] = pool.defaultLoadouts[i].slots[j] != null ? pool.defaultLoadouts[i].slots[j].func_77946_l() : null;
                    }
                }
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleClientSide(EntityPlayer clientPlayer) {
        ClientTeamsData.motd = this.motd;
        ClientTeamsData.theRankData = this.myRankData;
        ClientTeamsData.currentPool = this.currentPool;
        GuiTeamSelect.teamChoices = this.teamsAvailable;
        ClientTeamsData.OpenLandingPage();
    }
}

