/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common;

import com.flansmod.common.BlockFlansWorkbench;
import com.flansmod.common.BlockItemHolder;
import com.flansmod.common.CommonGuiHandler;
import com.flansmod.common.CommonProxy;
import com.flansmod.common.CommonTickHandler;
import com.flansmod.common.CreativeTabFlan;
import com.flansmod.common.EntityItemCustomRender;
import com.flansmod.common.FlansHooks;
import com.flansmod.common.ItemBlockManyNames;
import com.flansmod.common.ItemHolderType;
import com.flansmod.common.PlayerHandler;
import com.flansmod.common.TileEntityItemHolder;
import com.flansmod.common.driveables.EntityPlane;
import com.flansmod.common.driveables.EntitySeat;
import com.flansmod.common.driveables.EntityVehicle;
import com.flansmod.common.driveables.EntityWheel;
import com.flansmod.common.driveables.ItemPlane;
import com.flansmod.common.driveables.ItemVehicle;
import com.flansmod.common.driveables.PlaneType;
import com.flansmod.common.driveables.VehicleType;
import com.flansmod.common.driveables.mechas.EntityMecha;
import com.flansmod.common.driveables.mechas.ItemMecha;
import com.flansmod.common.driveables.mechas.ItemMechaAddon;
import com.flansmod.common.driveables.mechas.MechaItemType;
import com.flansmod.common.driveables.mechas.MechaType;
import com.flansmod.common.eventhandlers.PlayerDeathEventListener;
import com.flansmod.common.guns.AAGunType;
import com.flansmod.common.guns.AttachmentType;
import com.flansmod.common.guns.BulletType;
import com.flansmod.common.guns.EntityAAGun;
import com.flansmod.common.guns.EntityBullet;
import com.flansmod.common.guns.EntityGrenade;
import com.flansmod.common.guns.EntityMG;
import com.flansmod.common.guns.GrenadeType;
import com.flansmod.common.guns.GunType;
import com.flansmod.common.guns.ItemAAGun;
import com.flansmod.common.guns.ItemAttachment;
import com.flansmod.common.guns.ItemBullet;
import com.flansmod.common.guns.ItemGrenade;
import com.flansmod.common.guns.ItemGun;
import com.flansmod.common.guns.boxes.BlockGunBox;
import com.flansmod.common.guns.boxes.GunBoxType;
import com.flansmod.common.network.PacketHandler;
import com.flansmod.common.paintjob.BlockPaintjobTable;
import com.flansmod.common.paintjob.TileEntityPaintjobTable;
import com.flansmod.common.parts.ItemPart;
import com.flansmod.common.parts.PartType;
import com.flansmod.common.teams.ArmourBoxType;
import com.flansmod.common.teams.ArmourType;
import com.flansmod.common.teams.BlockArmourBox;
import com.flansmod.common.teams.BlockSpawner;
import com.flansmod.common.teams.CommandTeams;
import com.flansmod.common.teams.EntityFlag;
import com.flansmod.common.teams.EntityFlagpole;
import com.flansmod.common.teams.EntityGunItem;
import com.flansmod.common.teams.EntityTeamItem;
import com.flansmod.common.teams.ItemFlagpole;
import com.flansmod.common.teams.ItemOpStick;
import com.flansmod.common.teams.ItemRewardBox;
import com.flansmod.common.teams.ItemTeamArmour;
import com.flansmod.common.teams.PlayerClass;
import com.flansmod.common.teams.RewardBox;
import com.flansmod.common.teams.Team;
import com.flansmod.common.teams.TeamsManager;
import com.flansmod.common.teams.TeamsManagerRanked;
import com.flansmod.common.teams.TileEntitySpawner;
import com.flansmod.common.tools.EntityParachute;
import com.flansmod.common.tools.ItemTool;
import com.flansmod.common.tools.ToolType;
import com.flansmod.common.types.EnumType;
import com.flansmod.common.types.InfoType;
import com.flansmod.common.types.TypeFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.command.CommandHandler;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(modid="flansmod", name="Flan's Mod", version="5.5.2", acceptableRemoteVersions="@ALLOWEDVERSIONS@", guiFactory="com.flansmod.client.gui.config.ModGuiFactory", acceptedMinecraftVersions="[1.12.2]")
public class FlansMod {
    public static boolean DEBUG = false;
    public static Configuration configFile;
    public static final String MODID = "flansmod";
    public static final String VERSION = "5.5.2";
    @Mod.Instance(value="flansmod")
    public static FlansMod INSTANCE;
    @SidedProxy(clientSide="com.flansmod.client.ClientProxy", serverSide="com.flansmod.common.CommonProxy")
    public static CommonProxy proxy;
    public static int ticker;
    public static long lastTime;
    public static File flanDir;
    public static final float soundRange = 50.0f;
    public static final float driveableUpdateRange = 200.0f;
    public static final int numPlayerSnapshots = 20;
    public static boolean isApocalypseLoaded;
    public static boolean addAllPaintjobsToCreative;
    public static boolean addGunpowderRecipe;
    public static boolean shootOnRightClick;
    public static boolean forceUpdateJSONs;
    public static float armourSpawnRate;
    public static int dungeonLootChance;
    public static Team spectators;
    public static final PacketHandler packetHandler;
    public static final PlayerHandler playerHandler;
    public static final TeamsManager teamsManager;
    public static final CommonTickHandler tickHandler;
    public static FlansHooks hooks;
    public static BlockFlansWorkbench workbench;
    public static ItemBlockManyNames workbenchItem;
    public static BlockSpawner spawner;
    public static ItemBlockManyNames spawnerItem;
    public static ItemOpStick opStick;
    public static ItemFlagpole flag;
    public static ArrayList<ItemPart> partItems;
    public static ArrayList<ItemMecha> mechaItems;
    public static ArrayList<ItemTool> toolItems;
    public static ArrayList<ItemTeamArmour> armourItems;
    public static CreativeTabFlan tabFlanGuns;
    public static CreativeTabFlan tabFlanDriveables;
    public static CreativeTabFlan tabFlanParts;
    public static CreativeTabFlan tabFlanTeams;
    public static CreativeTabFlan tabFlanMechas;
    public static Item rainbowPaintcan;
    public static BlockPaintjobTable paintjobTable;
    private static Random rewardsRandom;

    public static float Pick(float totalWeight) {
        return rewardsRandom.nextFloat() * totalWeight;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        FlansMod.log("Preinitialising Flan's mod.");
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
        proxy.preInit();
        proxy.registerRenderers();
        configFile = new Configuration(event.getSuggestedConfigurationFile());
        FlansMod.syncConfig();
        try {
            isApocalypseLoaded = true;
            Class.forName("com.flansmod.apocalypse.common.FlansModApocalypse");
        }
        catch (Exception e) {
            isApocalypseLoaded = false;
        }
        flanDir = new File(event.getModConfigurationDirectory().getParentFile(), "/Flan/");
        if (!flanDir.exists()) {
            FlansMod.log("Flan folder not found. Creating empty folder.");
            FlansMod.log("You should get some content packs and put them in the Flan folder.");
            flanDir.mkdirs();
            flanDir.mkdir();
        }
        workbench = (BlockFlansWorkbench)new BlockFlansWorkbench(1, 0).func_149663_c("flansWorkbench");
        opStick = new ItemOpStick();
        flag = (ItemFlagpole)new ItemFlagpole().func_77655_b("flagpole");
        spawner = (BlockSpawner)new BlockSpawner(Material.field_151593_r).func_149663_c("teamsSpawner").func_149722_s().func_149752_b(1000000.0f);
        rainbowPaintcan = ((Item)new Item().func_77655_b("rainbowPaintcan").setRegistryName("rainbowPaintcan")).func_77637_a((CreativeTabs)tabFlanGuns);
        paintjobTable = new BlockPaintjobTable();
        workbenchItem = new ItemBlockManyNames(workbench);
        spawnerItem = new ItemBlockManyNames((Block)spawner);
        GameRegistry.registerTileEntity(TileEntitySpawner.class, (String)"teamsSpawner");
        GameRegistry.registerTileEntity(TileEntityPaintjobTable.class, (String)"paintjobTable");
        GameRegistry.registerTileEntity(TileEntityItemHolder.class, (String)"itemHolder");
        this.readContentPacks(event);
        proxy.forceReload();
        FlansMod.log("Preinitializing complete.");
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        FlansMod.log("Initialising Flan's Mod.");
        proxy.init();
        packetHandler.initialise();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new CommonGuiHandler());
        rewardsRandom = new Random();
        rewardsRandom.setSeed(System.currentTimeMillis() ^ 0x5AB49DE08DE3B1DFL);
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < rewardsRandom.nextInt(10); ++j) {
                rewardsRandom.nextGaussian();
            }
        }
        new PlayerDeathEventListener();
        FlansMod.log("Loading complete.");
    }

    @SubscribeEvent
    public void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        int i;
        NonNullList ingredients;
        FlansMod.log("Registering Recipes.");
        for (InfoType type : InfoType.infoTypes.values()) {
            type.addRecipe((IForgeRegistry<IRecipe>)event.getRegistry());
        }
        if (addGunpowderRecipe) {
            ingredients = NonNullList.func_191196_a();
            ingredients.add((Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(Items.field_151114_aO, 1, 1)}));
            ingredients.add((Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(Items.field_151044_h, 1, 1)}));
            ingredients.add((Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(Items.field_151044_h, 1, 1)}));
            ingredients.add((Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(Items.field_151044_h, 1, 1)}));
            event.getRegistry().register(new ShapelessRecipes("FlansMod", new ItemStack(Items.field_151016_H), ingredients).setRegistryName("FM_Gunpowder"));
        }
        ingredients = NonNullList.func_191196_a();
        ingredients.add((Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(Items.field_151042_j)}));
        ingredients.add((Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(Items.field_151066_bu)}));
        for (i = 0; i < 4; ++i) {
            ingredients.add((Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(Items.field_151042_j)}));
        }
        event.getRegistry().register(new ShapedRecipes("FlansMod", 3, 2, ingredients, new ItemStack((Block)workbench, 1, 1)).setRegistryName("FM_Workbench"));
        ingredients = NonNullList.func_191196_a();
        for (i = 0; i < 3; ++i) {
            ingredients.add((Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(Items.field_151054_z)}));
        }
        for (i = 0; i < 6; ++i) {
            ingredients.add((Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(Items.field_151042_j)}));
        }
        event.getRegistry().register(new ShapedRecipes("FlansMod", 3, 3, ingredients, new ItemStack((Block)workbench, 1, 0)).setRegistryName("FM_Workbench2"));
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        FlansMod.log("Registering Items");
        for (InfoType type : InfoType.infoTypes.values()) {
            type.registerItem((IForgeRegistry<Item>)event.getRegistry());
        }
        event.getRegistry().register((IForgeRegistryEntry)rainbowPaintcan);
        event.getRegistry().register((IForgeRegistryEntry)opStick);
        event.getRegistry().register((IForgeRegistryEntry)flag);
        event.getRegistry().register((IForgeRegistryEntry)workbenchItem);
        event.getRegistry().register((IForgeRegistryEntry)spawnerItem);
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        FlansMod.log("Registering Blocks");
        for (InfoType type : InfoType.infoTypes.values()) {
            type.registerBlock((IForgeRegistry<Block>)event.getRegistry());
        }
        event.getRegistry().register((IForgeRegistryEntry)workbench);
        event.getRegistry().register((IForgeRegistryEntry)spawner);
        event.getRegistry().register((IForgeRegistryEntry)paintjobTable);
    }

    @SubscribeEvent
    public void registerEntities(RegistryEvent.Register<EntityEntry> event) {
        FlansMod.log("Registering Entities");
        event.getRegistry().register(new EntityEntry(EntityFlagpole.class, "Flagpole").setRegistryName("Flagpole"));
        event.getRegistry().register(new EntityEntry(EntityFlag.class, "Flag").setRegistryName("Flag"));
        event.getRegistry().register(new EntityEntry(EntityTeamItem.class, "TeamsItem").setRegistryName("TeamsItem"));
        event.getRegistry().register(new EntityEntry(EntityGunItem.class, "GunItem").setRegistryName("GunItem"));
        event.getRegistry().register(new EntityEntry(EntityItemCustomRender.class, "CustomItem").setRegistryName("CustomItem"));
        event.getRegistry().register(new EntityEntry(EntityPlane.class, "Plane").setRegistryName("Plane"));
        event.getRegistry().register(new EntityEntry(EntityVehicle.class, "Vehicle").setRegistryName("Vehicle"));
        event.getRegistry().register(new EntityEntry(EntitySeat.class, "Seat").setRegistryName("Seat"));
        event.getRegistry().register(new EntityEntry(EntityWheel.class, "Wheel").setRegistryName("Wheel"));
        event.getRegistry().register(new EntityEntry(EntityParachute.class, "Parachute").setRegistryName("Parachute"));
        event.getRegistry().register(new EntityEntry(EntityMecha.class, "Mecha").setRegistryName("Mecha"));
        event.getRegistry().register(new EntityEntry(EntityBullet.class, "Bullet").setRegistryName("Bullet"));
        event.getRegistry().register(new EntityEntry(EntityGrenade.class, "Grenade").setRegistryName("Grenade"));
        event.getRegistry().register(new EntityEntry(EntityMG.class, "MG").setRegistryName("MG"));
        event.getRegistry().register(new EntityEntry(EntityAAGun.class, "AAGun").setRegistryName("AAGun"));
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("flansmod:CustomItem"), EntityItemCustomRender.class, (String)"CustomItem", (int)89, (Object)this, (int)100, (int)20, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("flansmod:Plane"), EntityPlane.class, (String)"Plane", (int)90, (Object)this, (int)250, (int)3, (boolean)false);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("flansmod:MG"), EntityMG.class, (String)"MG", (int)91, (Object)this, (int)40, (int)5, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("flansmod:AAGun"), EntityAAGun.class, (String)"AAGun", (int)92, (Object)this, (int)40, (int)500, (boolean)false);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("flansmod:Flagpole"), EntityFlagpole.class, (String)"Flagpole", (int)93, (Object)this, (int)40, (int)5, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("flansmod:Flag"), EntityFlag.class, (String)"Flag", (int)94, (Object)this, (int)40, (int)5, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("flansmod:Vehicle"), EntityVehicle.class, (String)"Vehicle", (int)95, (Object)this, (int)250, (int)10, (boolean)false);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("flansmod:Bullet"), EntityBullet.class, (String)"Bullet", (int)96, (Object)this, (int)40, (int)100, (boolean)false);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("flansmod:TeamsItem"), EntityTeamItem.class, (String)"TeamsItem", (int)97, (Object)this, (int)100, (int)10000, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("flansmod:GunItem"), EntityGunItem.class, (String)"GunItem", (int)98, (Object)this, (int)100, (int)20, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("flansmod:Seat"), EntitySeat.class, (String)"Seat", (int)99, (Object)this, (int)250, (int)3, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("flansmod:Grenade"), EntityGrenade.class, (String)"Grenade", (int)100, (Object)this, (int)40, (int)100, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("flansmod:Parachute"), EntityParachute.class, (String)"Parachute", (int)101, (Object)this, (int)40, (int)20, (boolean)false);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("flansmod:Mecha"), EntityMecha.class, (String)"Mecha", (int)102, (Object)this, (int)250, (int)20, (boolean)false);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("flansmod:Wheel"), EntityWheel.class, (String)"Wheel", (int)103, (Object)this, (int)250, (int)20, (boolean)false);
    }

    @Mod.EventHandler
    public void registerLoot(LootTableLoadEvent event) {
        for (InfoType type : InfoType.infoTypes.values()) {
            type.addLoot(event);
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        packetHandler.postInitialise();
        hooks.hook();
    }

    @SubscribeEvent
    public void playerDrops(PlayerDropsEvent event) {
        for (int i = event.getDrops().size() - 1; i >= 0; --i) {
            EntityItem ent = (EntityItem)event.getDrops().get(i);
            InfoType type = InfoType.getType(ent.func_92059_d());
            if (type == null || type.canDrop) continue;
            event.getDrops().remove(i);
        }
    }

    @SubscribeEvent
    public void playerDrops(ItemTossEvent event) {
        InfoType type = InfoType.getType(event.getEntityItem().func_92059_d());
        if (type != null && !type.canDrop) {
            event.setCanceled(true);
        }
    }

    @Mod.EventHandler
    public void registerCommand(FMLServerStartedEvent e) {
        CommandHandler handler = (CommandHandler)FMLCommonHandler.instance().getSidedDelegate().getServer().func_71187_D();
        handler.func_71560_a((ICommand)new CommandTeams());
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent eventArgs) {
        if (eventArgs.getModID().equals(MODID)) {
            FlansMod.syncConfig();
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        if (event.getPlayer() != null && event.getPlayer().func_184614_ca() != null && event.getPlayer().func_184614_ca().func_77973_b() instanceof ItemGun) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLivingSpecialSpawn(EntityJoinWorldEvent event) {
        double chance = event.getWorld().field_73012_v.nextDouble();
        if (chance < (double)armourSpawnRate && event.getEntity() instanceof EntityZombie || event.getEntity() instanceof EntitySkeleton) {
            if (event.getWorld().field_73012_v.nextBoolean() && ArmourType.armours.size() > 0) {
                ArmourType armour = ArmourType.armours.get(event.getWorld().field_73012_v.nextInt(ArmourType.armours.size()));
                if (armour != null && armour.type != 2) {
                    event.getEntity().func_184201_a(EntityEquipmentSlot.values()[armour.type + 1], new ItemStack(armour.item));
                }
            } else if (Team.teams.size() > 0) {
                Team team = Team.teams.get(event.getWorld().field_73012_v.nextInt(Team.teams.size()));
                if (team.hat != null) {
                    event.getEntity().func_184201_a(EntityEquipmentSlot.HEAD, team.hat.func_77946_l());
                }
                if (team.chest != null) {
                    event.getEntity().func_184201_a(EntityEquipmentSlot.CHEST, team.chest.func_77946_l());
                }
                if (team.legs != null) {
                    event.getEntity().func_184201_a(EntityEquipmentSlot.LEGS, team.legs.func_77946_l());
                }
                if (team.shoes != null) {
                    event.getEntity().func_184201_a(EntityEquipmentSlot.FEET, team.shoes.func_77946_l());
                }
                if (team.classes.size() > 0) {
                    PlayerClass playerClass = team.classes.get(event.getWorld().field_73012_v.nextInt(team.classes.size()));
                    if (playerClass.hat != null) {
                        event.getEntity().func_184201_a(EntityEquipmentSlot.HEAD, playerClass.hat.func_77946_l());
                    }
                    if (playerClass.chest != null) {
                        event.getEntity().func_184201_a(EntityEquipmentSlot.CHEST, playerClass.chest.func_77946_l());
                    }
                    if (playerClass.legs != null) {
                        event.getEntity().func_184201_a(EntityEquipmentSlot.LEGS, playerClass.legs.func_77946_l());
                    }
                    if (playerClass.shoes != null) {
                        event.getEntity().func_184201_a(EntityEquipmentSlot.FEET, playerClass.shoes.func_77946_l());
                    }
                }
            }
        }
        tickHandler.onEntitySpawn(event);
    }

    @SubscribeEvent
    public void onAttackEntity(AttackEntityEvent event) {
        if (event.getEntity() instanceof EntityGunItem) {
            event.setCanceled(true);
        }
    }

    private void getTypeFiles(List<File> contentPacks) {
        for (File contentPack : contentPacks) {
            int n;
            if (contentPack.isDirectory()) {
                for (EnumType typeToCheckFor : EnumType.values()) {
                    File typesDir = new File(contentPack, "/" + typeToCheckFor.folderName + "/");
                    if (!typesDir.exists()) continue;
                    File[] fileArray = typesDir.listFiles();
                    int n2 = fileArray.length;
                    for (n = 0; n < n2; ++n) {
                        File file = fileArray[n];
                        try {
                            BufferedReader reader = new BufferedReader(new FileReader(file));
                            String[] splitName = file.getName().split("/");
                            TypeFile typeFile = new TypeFile(contentPack.getName(), typeToCheckFor, splitName[splitName.length - 1].split("\\.")[0]);
                            while (true) {
                                String line = null;
                                try {
                                    line = reader.readLine();
                                }
                                catch (Exception e) {
                                    break;
                                }
                                if (line == null) break;
                                typeFile.parseLine(line);
                            }
                            reader.close();
                            continue;
                        }
                        catch (FileNotFoundException e) {
                            e.printStackTrace();
                            continue;
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
                continue;
            }
            try {
                ZipFile zip = new ZipFile(contentPack);
                ZipInputStream zipStream = new ZipInputStream(new FileInputStream(contentPack));
                BufferedReader reader = new BufferedReader(new InputStreamReader(zipStream));
                ZipEntry zipEntry = zipStream.getNextEntry();
                block13: do {
                    if ((zipEntry = zipStream.getNextEntry()) == null) continue;
                    TypeFile typeFile = null;
                    EnumType[] enumTypeArray = EnumType.values();
                    int n3 = enumTypeArray.length;
                    for (n = 0; n < n3; ++n) {
                        EnumType enumType = enumTypeArray[n];
                        if (!zipEntry.getName().startsWith(enumType.folderName + "/") || zipEntry.getName().split(enumType.folderName + "/").length <= 1 || zipEntry.getName().split(enumType.folderName + "/")[1].length() <= 0) continue;
                        String[] splitName = zipEntry.getName().split("/");
                        typeFile = new TypeFile(zip.getName(), enumType, splitName[splitName.length - 1].split("\\.")[0]);
                    }
                    if (typeFile == null) continue;
                    while (true) {
                        String string;
                        Object var9_16 = null;
                        try {
                            string = reader.readLine();
                        }
                        catch (Exception e) {
                            continue block13;
                        }
                        if (string == null) continue block13;
                        typeFile.parseLine(string);
                    }
                } while (zipEntry != null);
                reader.close();
                zip.close();
                zipStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void readContentPacks(FMLPreInitializationEvent event) {
        ClassLoader classloader = MinecraftServer.class.getClassLoader();
        Method method = null;
        try {
            method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
        }
        catch (Exception e) {
            FlansMod.log("Failed to get class loader. All content loading will now fail.");
            e.printStackTrace();
        }
        List<File> contentPacks = proxy.getContentList(method, classloader);
        this.getTypeFiles(contentPacks);
        for (EnumType type : EnumType.values()) {
            Class<? extends InfoType> typeClass = type.getTypeClass();
            for (TypeFile typeFile : TypeFile.files.get((Object)type)) {
                try {
                    InfoType infoType = typeClass.getConstructor(TypeFile.class).newInstance(typeFile);
                    infoType.read(typeFile);
                    switch (type) {
                        case bullet: {
                            new ItemBullet((BulletType)infoType).func_77655_b(infoType.shortName);
                            break;
                        }
                        case attachment: {
                            new ItemAttachment((AttachmentType)infoType).func_77655_b(infoType.shortName);
                            break;
                        }
                        case gun: {
                            new ItemGun((GunType)infoType).func_77655_b(infoType.shortName);
                            break;
                        }
                        case grenade: {
                            new ItemGrenade((GrenadeType)infoType).func_77655_b(infoType.shortName);
                            break;
                        }
                        case part: {
                            partItems.add((ItemPart)new ItemPart((PartType)infoType).func_77655_b(infoType.shortName));
                            break;
                        }
                        case plane: {
                            new ItemPlane((PlaneType)infoType).func_77655_b(infoType.shortName);
                            break;
                        }
                        case vehicle: {
                            new ItemVehicle((VehicleType)infoType).func_77655_b(infoType.shortName);
                            break;
                        }
                        case aa: {
                            new ItemAAGun((AAGunType)infoType).func_77655_b(infoType.shortName);
                            break;
                        }
                        case mechaItem: {
                            new ItemMechaAddon((MechaItemType)infoType).func_77655_b(infoType.shortName);
                            break;
                        }
                        case mecha: {
                            mechaItems.add((ItemMecha)new ItemMecha((MechaType)infoType).func_77655_b(infoType.shortName));
                            break;
                        }
                        case tool: {
                            toolItems.add((ItemTool)new ItemTool((ToolType)infoType).func_77655_b(infoType.shortName));
                            break;
                        }
                        case box: {
                            new BlockGunBox((GunBoxType)infoType).func_149663_c(infoType.shortName);
                            break;
                        }
                        case armour: {
                            armourItems.add((ItemTeamArmour)new ItemTeamArmour((ArmourType)infoType).func_77655_b(infoType.shortName));
                            break;
                        }
                        case armourBox: {
                            new BlockArmourBox((ArmourBoxType)infoType).func_149663_c(infoType.shortName);
                            break;
                        }
                        case playerClass: {
                            break;
                        }
                        case team: {
                            break;
                        }
                        case itemHolder: {
                            new BlockItemHolder((ItemHolderType)infoType);
                            break;
                        }
                        case rewardBox: {
                            new ItemRewardBox((RewardBox)infoType).func_77655_b(infoType.shortName);
                            break;
                        }
                        case loadout: {
                            break;
                        }
                        default: {
                            FlansMod.log("Unrecognised type for " + infoType.shortName);
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    FlansMod.log("Failed to add " + type.name() + " : " + typeFile.name);
                    e.printStackTrace();
                }
            }
            FlansMod.log("Loaded " + type.name() + ".");
        }
        Team.spectators = spectators;
        proxy.addMissingJSONs(InfoType.infoTypes);
    }

    public static PacketHandler getPacketHandler() {
        return packetHandler;
    }

    public static void syncConfig() {
        addGunpowderRecipe = configFile.getBoolean("Gunpowder Recipe", "general", addGunpowderRecipe, "Whether or not to add the extra gunpowder recipe (3 charcoal + 1 lightstone)");
        shootOnRightClick = configFile.getBoolean("ShootOnRightClick", "general", shootOnRightClick, "If true, then shoot will be on right click");
        addAllPaintjobsToCreative = configFile.getBoolean("Add All Paintjobs to Creative", "general", addAllPaintjobsToCreative, "Whether all paintjobs should appear in creative");
        forceUpdateJSONs = configFile.getBoolean("ForceUpdateJSONs", "general", forceUpdateJSONs, "Turn this on to force re-create all JSON files. Should only be used in dev environment");
        if (configFile.hasChanged()) {
            configFile.save();
        }
    }

    public static void log(String string) {
        System.out.println("[Flan's Mod] " + string);
    }

    public static void Assert(boolean b, String string) {
        if (!b) {
            FlansMod.log(string);
        }
    }

    public static EnumParticleTypes getParticleType(String s) {
        if (s.equals("hugeexplosion")) {
            return EnumParticleTypes.EXPLOSION_HUGE;
        }
        if (s.equals("largeexplode")) {
            return EnumParticleTypes.EXPLOSION_LARGE;
        }
        if (s.equals("explode")) {
            return EnumParticleTypes.EXPLOSION_NORMAL;
        }
        if (s.equals("fireworksSpark")) {
            return EnumParticleTypes.FIREWORKS_SPARK;
        }
        if (s.equals("bubble")) {
            return EnumParticleTypes.WATER_BUBBLE;
        }
        if (s.equals("splash")) {
            return EnumParticleTypes.WATER_SPLASH;
        }
        if (s.equals("wake")) {
            return EnumParticleTypes.WATER_WAKE;
        }
        if (s.equals("drop")) {
            return EnumParticleTypes.WATER_DROP;
        }
        if (s.equals("suspended")) {
            return EnumParticleTypes.SUSPENDED;
        }
        if (s.equals("depthsuspend")) {
            return EnumParticleTypes.SUSPENDED_DEPTH;
        }
        if (s.equals("townaura")) {
            return EnumParticleTypes.TOWN_AURA;
        }
        if (s.equals("crit")) {
            return EnumParticleTypes.CRIT;
        }
        if (s.equals("magicCrit")) {
            return EnumParticleTypes.CRIT_MAGIC;
        }
        if (s.equals("smoke")) {
            return EnumParticleTypes.SMOKE_NORMAL;
        }
        if (s.equals("largesmoke")) {
            return EnumParticleTypes.SMOKE_LARGE;
        }
        if (s.equals("spell")) {
            return EnumParticleTypes.SPELL;
        }
        if (s.equals("instantSpell")) {
            return EnumParticleTypes.SPELL_INSTANT;
        }
        if (s.equals("mobSpell")) {
            return EnumParticleTypes.SPELL_MOB;
        }
        if (s.equals("mobSpellAmbient")) {
            return EnumParticleTypes.SPELL_MOB_AMBIENT;
        }
        if (s.equals("witchMagic")) {
            return EnumParticleTypes.SPELL_WITCH;
        }
        if (s.equals("dripWater")) {
            return EnumParticleTypes.DRIP_WATER;
        }
        if (s.equals("dripLava")) {
            return EnumParticleTypes.DRIP_LAVA;
        }
        if (s.equals("angryVillager")) {
            return EnumParticleTypes.VILLAGER_ANGRY;
        }
        if (s.equals("happyVillager")) {
            return EnumParticleTypes.VILLAGER_HAPPY;
        }
        if (s.equals("note")) {
            return EnumParticleTypes.NOTE;
        }
        if (s.equals("portal")) {
            return EnumParticleTypes.PORTAL;
        }
        if (s.equals("enchantmenttable")) {
            return EnumParticleTypes.ENCHANTMENT_TABLE;
        }
        if (s.equals("flame")) {
            return EnumParticleTypes.FLAME;
        }
        if (s.equals("lava")) {
            return EnumParticleTypes.LAVA;
        }
        if (s.equals("footstep")) {
            return EnumParticleTypes.FOOTSTEP;
        }
        if (s.equals("cloud")) {
            return EnumParticleTypes.CLOUD;
        }
        if (s.equals("reddust")) {
            return EnumParticleTypes.REDSTONE;
        }
        if (s.equals("snowballpoof")) {
            return EnumParticleTypes.SNOWBALL;
        }
        if (s.equals("snowshovel")) {
            return EnumParticleTypes.SNOW_SHOVEL;
        }
        if (s.equals("slime")) {
            return EnumParticleTypes.SLIME;
        }
        if (s.equals("heart")) {
            return EnumParticleTypes.HEART;
        }
        if (s.equals("barrier")) {
            return EnumParticleTypes.BARRIER;
        }
        return EnumParticleTypes.WATER_BUBBLE;
    }

    static {
        ticker = 0;
        isApocalypseLoaded = false;
        addAllPaintjobsToCreative = false;
        addGunpowderRecipe = true;
        shootOnRightClick = false;
        forceUpdateJSONs = false;
        armourSpawnRate = 0.25f;
        dungeonLootChance = 500;
        spectators = new Team("spectators", "Spectators", 0x404040, '7');
        packetHandler = new PacketHandler();
        playerHandler = new PlayerHandler();
        teamsManager = new TeamsManagerRanked();
        tickHandler = new CommonTickHandler();
        hooks = new FlansHooks();
        partItems = new ArrayList();
        mechaItems = new ArrayList();
        toolItems = new ArrayList();
        armourItems = new ArrayList();
        tabFlanGuns = new CreativeTabFlan(0);
        tabFlanDriveables = new CreativeTabFlan(1);
        tabFlanParts = new CreativeTabFlan(2);
        tabFlanTeams = new CreativeTabFlan(3);
        tabFlanMechas = new CreativeTabFlan(4);
        rewardsRandom = new Random();
    }
}

