/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.client.model;

import com.flansmod.client.FlansModClient;
import com.flansmod.client.FlansModResourceHandler;
import com.flansmod.client.model.CustomItemRenderType;
import com.flansmod.client.model.CustomItemRenderer;
import com.flansmod.client.model.GunAnimations;
import com.flansmod.client.model.ModelAttachment;
import com.flansmod.client.model.ModelGun;
import com.flansmod.common.guns.AttachmentType;
import com.flansmod.common.guns.EnumFireMode;
import com.flansmod.common.guns.GunType;
import com.flansmod.common.guns.IScope;
import com.flansmod.common.guns.ItemBullet;
import com.flansmod.common.guns.ItemGun;
import com.flansmod.common.guns.Paintjob;
import com.flansmod.common.types.PaintableType;
import com.flansmod.common.vector.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.opengl.GL11;

public class RenderGun
implements CustomItemRenderer {
    private static TextureManager renderEngine;
    public static float smoothing;
    public static boolean bindTextures;

    @Override
    public void renderItem(CustomItemRenderType type, EnumHand hand, ItemStack item, Object ... data) {
        if (!(item.func_77973_b() instanceof ItemGun)) {
            return;
        }
        GunType gunType = ((ItemGun)item.func_77973_b()).GetType();
        if (gunType == null) {
            return;
        }
        ModelGun model = gunType.model;
        if (model == null) {
            return;
        }
        GunAnimations animations = type == CustomItemRenderType.ENTITY || type == CustomItemRenderType.INVENTORY ? new GunAnimations() : FlansModClient.getGunAnimations((EntityLivingBase)data[1], hand);
        this.renderGun(type, item, gunType, animations, hand, data);
    }

    public void renderOffHandGun(EntityPlayer player, ItemStack offHandItemStack) {
        GunAnimations animations = FlansModClient.gunAnimationsLeft.get(player);
        if (animations == null) {
            animations = new GunAnimations();
            FlansModClient.gunAnimationsLeft.put((EntityLivingBase)player, animations);
        }
        GunType offHandGunType = ((ItemGun)offHandItemStack.func_77973_b()).GetType();
        this.renderGun(CustomItemRenderType.INVENTORY, offHandItemStack, offHandGunType, animations, EnumHand.OFF_HAND, player);
    }

    private void renderGun(CustomItemRenderType type, ItemStack item, GunType gunType, GunAnimations animations, EnumHand hand, Object ... data) {
        float f = 0.0625f;
        ModelGun model = gunType.model;
        int flip = hand == EnumHand.OFF_HAND ? -1 : 1;
        GL11.glPushMatrix();
        float reloadRotate = 0.0f;
        block0 : switch (type) {
            case ENTITY: {
                GL11.glTranslatef((float)(-0.45f + model.itemFrameOffset.x), (float)(-0.05f + model.itemFrameOffset.y), (float)model.itemFrameOffset.z);
                break;
            }
            case INVENTORY: {
                GL11.glTranslatef((float)model.itemFrameOffset.x, (float)model.itemFrameOffset.y, (float)model.itemFrameOffset.z);
                break;
            }
            case EQUIPPED: {
                if (hand == EnumHand.OFF_HAND) {
                    GL11.glRotatef((float)-70.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glRotatef((float)48.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glRotatef((float)105.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glTranslatef((float)-0.1f, (float)-0.22f, (float)-0.15f);
                } else {
                    GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glTranslatef((float)0.2f, (float)0.05f, (float)-0.0f);
                    GL11.glScalef((float)1.0f, (float)1.0f, (float)-1.0f);
                }
                GL11.glTranslatef((float)model.thirdPersonOffset.x, (float)model.thirdPersonOffset.y, (float)model.thirdPersonOffset.z);
                break;
            }
            case EQUIPPED_FIRST_PERSON: {
                Vector3f startAngles;
                Vector3f endAngles;
                Vector3f startPos;
                Vector3f endPos;
                IScope scope = gunType.getCurrentScope(item);
                if (FlansModClient.zoomProgress > 0.9f && scope.hasZoomOverlay()) {
                    GL11.glPopMatrix();
                    return;
                }
                float adsSwitch = FlansModClient.lastZoomProgress + (FlansModClient.zoomProgress - FlansModClient.lastZoomProgress) * smoothing;
                if (hand == EnumHand.OFF_HAND) {
                    GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glTranslatef((float)-1.0f, (float)0.675f, (float)-1.8f);
                } else {
                    GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)(0.0f - 5.0f * adsSwitch), (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glTranslatef((float)-1.0f, (float)(0.675f + 0.18f * adsSwitch), (float)(-1.0f - 0.395f * adsSwitch));
                    if (gunType.hasScopeOverlay) {
                        GL11.glTranslatef((float)(-0.7f * adsSwitch), (float)(-0.12f * adsSwitch), (float)(-0.05f * adsSwitch));
                    }
                    GL11.glRotatef((float)(4.5f * adsSwitch), (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glTranslatef((float)0.0f, (float)(-0.03f * adsSwitch), (float)0.0f);
                }
                if (animations.meleeAnimationProgress > 0 && animations.meleeAnimationProgress < gunType.meleePath.size()) {
                    Vector3f meleePos = gunType.meleePath.get(animations.meleeAnimationProgress);
                    Vector3f nextMeleePos = animations.meleeAnimationProgress + 1 < gunType.meleePath.size() ? gunType.meleePath.get(animations.meleeAnimationProgress + 1) : new Vector3f();
                    GL11.glTranslatef((float)(meleePos.x + (nextMeleePos.x - meleePos.x) * smoothing), (float)(meleePos.y + (nextMeleePos.y - meleePos.y) * smoothing), (float)(meleePos.z + (nextMeleePos.z - meleePos.z) * smoothing));
                    Vector3f meleeAngles = gunType.meleePathAngles.get(animations.meleeAnimationProgress);
                    Vector3f nextMeleeAngles = animations.meleeAnimationProgress + 1 < gunType.meleePathAngles.size() ? gunType.meleePathAngles.get(animations.meleeAnimationProgress + 1) : new Vector3f();
                    GL11.glRotatef((float)(meleeAngles.y + (nextMeleeAngles.y - meleeAngles.y) * smoothing), (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)(meleeAngles.z + (nextMeleeAngles.z - meleeAngles.z) * smoothing), (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glRotatef((float)(meleeAngles.x + (nextMeleeAngles.x - meleeAngles.x) * smoothing), (float)1.0f, (float)0.0f, (float)0.0f);
                }
                float interp = animations.lookAtTimer + smoothing;
                interp /= (float)GunAnimations.lookAtTimes[animations.lookAt.ordinal()];
                Vector3f idlePos = new Vector3f(0.0f, 0.0f, 0.0f);
                Vector3f look1Pos = new Vector3f(0.25f, 0.25f, 0.0f);
                Vector3f look2Pos = new Vector3f(0.25f, 0.25f, -0.5f);
                Vector3f idleAngles = new Vector3f(0.0f, 0.0f, 0.0f);
                Vector3f look1Angles = new Vector3f(0.0f, 70.0f, 0.0f);
                Vector3f look2Angles = new Vector3f(0.0f, -60.0f, 60.0f);
                switch (animations.lookAt) {
                    default: {
                        startPos = endPos = idlePos;
                        startAngles = endAngles = idleAngles;
                        break;
                    }
                    case LOOK1: {
                        startPos = endPos = look1Pos;
                        startAngles = endAngles = look1Angles;
                        break;
                    }
                    case LOOK2: {
                        startPos = endPos = look2Pos;
                        startAngles = endAngles = look2Angles;
                        break;
                    }
                    case TILT1: {
                        startPos = idlePos;
                        startAngles = idleAngles;
                        endPos = look1Pos;
                        endAngles = look1Angles;
                        break;
                    }
                    case TILT2: {
                        startPos = look1Pos;
                        startAngles = look1Angles;
                        endPos = look2Pos;
                        endAngles = look2Angles;
                        break;
                    }
                    case UNTILT: {
                        startPos = look2Pos;
                        startAngles = look2Angles;
                        endPos = idlePos;
                        endAngles = idleAngles;
                    }
                }
                GL11.glRotatef((float)(startAngles.y + (endAngles.y - startAngles.y) * interp), (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)(startAngles.z + (endAngles.z - startAngles.z) * interp), (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glTranslatef((float)(startPos.x + (endPos.x - startPos.x) * interp), (float)(startPos.y + (endPos.y - startPos.y) * interp), (float)(startPos.z + (endPos.z - startPos.z) * interp));
                GL11.glRotatef((float)(-animations.recoilAngle * (float)Math.sqrt(gunType.recoil) * 1.5f), (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glTranslatef((float)animations.recoilOffset.x, (float)animations.recoilOffset.y, (float)animations.recoilOffset.z);
                if (model.spinningCocking) {
                    GL11.glTranslatef((float)model.spinPoint.x, (float)model.spinPoint.y, (float)model.spinPoint.z);
                    float pumped = animations.lastPumped + (animations.pumped - animations.lastPumped) * smoothing;
                    GL11.glRotatef((float)(pumped * 180.0f + 180.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glTranslatef((float)(-model.spinPoint.x), (float)(-model.spinPoint.y), (float)(-model.spinPoint.z));
                }
                if (!animations.reloading) break;
                float effectiveReloadAnimationProgress = animations.lastReloadAnimationProgress + (animations.reloadAnimationProgress - animations.lastReloadAnimationProgress) * smoothing;
                reloadRotate = 1.0f;
                if (effectiveReloadAnimationProgress < model.tiltGunTime) {
                    reloadRotate = effectiveReloadAnimationProgress / model.tiltGunTime;
                }
                if (effectiveReloadAnimationProgress > model.tiltGunTime + model.unloadClipTime + model.loadClipTime) {
                    reloadRotate = 1.0f - (effectiveReloadAnimationProgress - (model.tiltGunTime + model.unloadClipTime + model.loadClipTime)) / model.untiltGunTime;
                }
                switch (model.animationType) {
                    case BOTTOM_CLIP: 
                    case PISTOL_CLIP: 
                    case SHOTGUN: 
                    case END_LOADED: {
                        GL11.glRotatef((float)(60.0f * reloadRotate), (float)0.0f, (float)0.0f, (float)1.0f);
                        GL11.glRotatef((float)(30.0f * reloadRotate * (float)flip), (float)1.0f, (float)0.0f, (float)0.0f);
                        GL11.glTranslatef((float)(0.25f * reloadRotate), (float)0.0f, (float)0.0f);
                        break block0;
                    }
                    case BACK_LOADED: {
                        GL11.glRotatef((float)(-75.0f * reloadRotate), (float)0.0f, (float)0.0f, (float)1.0f);
                        GL11.glRotatef((float)(-30.0f * reloadRotate * (float)flip), (float)1.0f, (float)0.0f, (float)0.0f);
                        GL11.glTranslatef((float)(0.5f * reloadRotate), (float)0.0f, (float)0.0f);
                        break block0;
                    }
                    case BULLPUP: {
                        GL11.glRotatef((float)(70.0f * reloadRotate), (float)0.0f, (float)0.0f, (float)1.0f);
                        GL11.glRotatef((float)(10.0f * reloadRotate * (float)flip), (float)1.0f, (float)0.0f, (float)0.0f);
                        GL11.glTranslatef((float)(0.5f * reloadRotate), (float)(-0.2f * reloadRotate), (float)0.0f);
                        break block0;
                    }
                    case RIFLE: {
                        GL11.glRotatef((float)(30.0f * reloadRotate), (float)0.0f, (float)0.0f, (float)1.0f);
                        GL11.glRotatef((float)(-30.0f * reloadRotate * (float)flip), (float)1.0f, (float)0.0f, (float)0.0f);
                        GL11.glTranslatef((float)(0.5f * reloadRotate), (float)0.0f, (float)(-0.5f * reloadRotate));
                        break block0;
                    }
                    case RIFLE_TOP: 
                    case REVOLVER: {
                        GL11.glRotatef((float)(30.0f * reloadRotate), (float)0.0f, (float)0.0f, (float)1.0f);
                        GL11.glRotatef((float)(10.0f * reloadRotate), (float)0.0f, (float)1.0f, (float)0.0f);
                        GL11.glRotatef((float)(-10.0f * reloadRotate * (float)flip), (float)1.0f, (float)0.0f, (float)0.0f);
                        GL11.glTranslatef((float)(0.1f * reloadRotate), (float)(-0.2f * reloadRotate), (float)(-0.1f * reloadRotate));
                        break block0;
                    }
                    case ALT_PISTOL_CLIP: {
                        GL11.glRotatef((float)(60.0f * reloadRotate * (float)flip), (float)0.0f, (float)1.0f, (float)0.0f);
                        GL11.glTranslatef((float)(0.15f * reloadRotate), (float)(0.25f * reloadRotate), (float)0.0f);
                        break block0;
                    }
                    case STRIKER: {
                        GL11.glRotatef((float)(-35.0f * reloadRotate * (float)flip), (float)1.0f, (float)0.0f, (float)0.0f);
                        GL11.glTranslatef((float)(0.2f * reloadRotate), (float)0.0f, (float)(-0.1f * reloadRotate));
                        break block0;
                    }
                    case GENERIC: {
                        GL11.glRotatef((float)(45.0f * reloadRotate), (float)0.0f, (float)0.0f, (float)1.0f);
                        GL11.glTranslatef((float)(-0.2f * reloadRotate), (float)(-0.5f * reloadRotate), (float)0.0f);
                        break block0;
                    }
                    case CUSTOM: {
                        GL11.glRotatef((float)(model.rotateGunVertical * reloadRotate), (float)0.0f, (float)0.0f, (float)1.0f);
                        GL11.glRotatef((float)(model.rotateGunHorizontal * reloadRotate), (float)0.0f, (float)1.0f, (float)0.0f);
                        GL11.glRotatef((float)(model.tiltGun * reloadRotate), (float)1.0f, (float)0.0f, (float)0.0f);
                        GL11.glTranslatef((float)(model.translateGun.x * reloadRotate), (float)(model.translateGun.y * reloadRotate), (float)(model.translateGun.z * reloadRotate));
                        break block0;
                    }
                }
                break;
            }
        }
        this.renderGun(item, gunType, f, model, animations, reloadRotate);
        GL11.glPopMatrix();
    }

    public void renderGun(ItemStack item, GunType type, float f, ModelGun model, GunAnimations animations, float reloadRotate) {
        if (renderEngine == null) {
            renderEngine = Minecraft.func_71410_x().field_71446_o;
        }
        if (animations == null) {
            animations = GunAnimations.defaults;
        }
        AttachmentType scopeAttachment = type.getScope(item);
        AttachmentType barrelAttachment = type.getBarrel(item);
        AttachmentType stockAttachment = type.getStock(item);
        AttachmentType gripAttachment = type.getGrip(item);
        ItemStack scopeItemStack = type.getScopeItemStack(item);
        ItemStack barrelItemStack = type.getBarrelItemStack(item);
        ItemStack stockItemStack = type.getStockItemStack(item);
        ItemStack gripItemStack = type.getGripItemStack(item);
        ItemStack[] bulletStacks = new ItemStack[type.numAmmoItemsInGun];
        boolean empty = true;
        for (int i = 0; i < type.numAmmoItemsInGun; ++i) {
            bulletStacks[i] = ((ItemGun)item.func_77973_b()).getBulletItemStack(item, i);
            if (bulletStacks[i] == null || !(bulletStacks[i].func_77973_b() instanceof ItemBullet) || bulletStacks[i].func_77952_i() >= bulletStacks[i].func_77958_k()) continue;
            empty = false;
        }
        Paintjob paintjob = type.getPaintjob(item.func_77952_i());
        if (bindTextures) {
            if (PaintableType.HasCustomPaintjob(item)) {
                renderEngine.func_110577_a(PaintableType.GetCustomPaintjobSkinResource(item));
            } else {
                renderEngine.func_110577_a(FlansModResourceHandler.getPaintjobTexture(paintjob));
            }
        }
        if (scopeAttachment != null) {
            GL11.glTranslatef((float)0.0f, (float)(-scopeAttachment.model.renderOffset / 16.0f), (float)0.0f);
        }
        GL11.glPushMatrix();
        GL11.glScalef((float)type.modelScale, (float)type.modelScale, (float)type.modelScale);
        model.renderGun(f);
        model.renderCustom(f, animations);
        if (scopeAttachment == null && !model.scopeIsOnSlide && !model.scopeIsOnBreakAction) {
            model.renderDefaultScope(f);
        }
        if (barrelAttachment == null) {
            model.renderDefaultBarrel(f);
        }
        if (stockAttachment == null) {
            model.renderDefaultStock(f);
        }
        if (gripAttachment == null && !model.gripIsOnPump) {
            model.renderDefaultGrip(f);
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(-(animations.lastGunSlide + (animations.gunSlide - animations.lastGunSlide) * smoothing) * model.gunSlideDistance), (float)0.0f, (float)0.0f);
        model.renderSlide(f);
        if (scopeAttachment == null && model.scopeIsOnSlide) {
            model.renderDefaultScope(f);
        }
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)model.barrelBreakPoint.x, (float)model.barrelBreakPoint.y, (float)model.barrelBreakPoint.z);
        GL11.glRotatef((float)(reloadRotate * -model.breakAngle), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslatef((float)(-model.barrelBreakPoint.x), (float)(-model.barrelBreakPoint.y), (float)(-model.barrelBreakPoint.z));
        model.renderBreakAction(f);
        if (scopeAttachment == null && model.scopeIsOnBreakAction) {
            model.renderDefaultScope(f);
        }
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(-(1.0f - Math.abs(animations.lastPumped + (animations.pumped - animations.lastPumped) * smoothing)) * model.pumpHandleDistance), (float)0.0f, (float)0.0f);
        model.renderPump(f);
        if (gripAttachment == null && model.gripIsOnPump) {
            model.renderDefaultGrip(f);
        }
        GL11.glPopMatrix();
        if (type.mode == EnumFireMode.MINIGUN) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)model.minigunBarrelOrigin.x, (float)model.minigunBarrelOrigin.y, (float)model.minigunBarrelOrigin.z);
            GL11.glRotatef((float)animations.minigunBarrelRotation, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glTranslatef((float)(-model.minigunBarrelOrigin.x), (float)(-model.minigunBarrelOrigin.y), (float)(-model.minigunBarrelOrigin.z));
            model.renderMinigunBarrel(f);
            GL11.glPopMatrix();
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)model.revolverFlipPoint.x, (float)model.revolverFlipPoint.y, (float)model.revolverFlipPoint.z);
        GL11.glRotatef((float)(reloadRotate * model.revolverFlipAngle), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glTranslatef((float)(-model.revolverFlipPoint.x), (float)(-model.revolverFlipPoint.y), (float)(-model.revolverFlipPoint.z));
        model.renderRevolverBarrel(f);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        boolean shouldRender = true;
        switch (model.animationType) {
            case END_LOADED: 
            case BACK_LOADED: {
                if (!empty) break;
                shouldRender = false;
                break;
            }
        }
        if (shouldRender && animations.reloading && Minecraft.func_71410_x().field_71474_y.field_74320_O == 0) {
            float effectiveReloadAnimationProgress = animations.lastReloadAnimationProgress + (animations.reloadAnimationProgress - animations.lastReloadAnimationProgress) * smoothing;
            float clipPosition = 0.0f;
            if (effectiveReloadAnimationProgress > model.tiltGunTime && effectiveReloadAnimationProgress < model.tiltGunTime + model.unloadClipTime) {
                clipPosition = (effectiveReloadAnimationProgress - model.tiltGunTime) / model.unloadClipTime;
            }
            if (effectiveReloadAnimationProgress >= model.tiltGunTime + model.unloadClipTime && effectiveReloadAnimationProgress < model.tiltGunTime + model.unloadClipTime + model.loadClipTime) {
                clipPosition = 1.0f - (effectiveReloadAnimationProgress - (model.tiltGunTime + model.unloadClipTime)) / model.loadClipTime;
            }
            float loadOnlyClipPosition = Math.max(0.0f, Math.min(1.0f, 1.0f - (effectiveReloadAnimationProgress - model.tiltGunTime) / (model.unloadClipTime + model.loadClipTime)));
            switch (model.animationType) {
                case BREAK_ACTION: {
                    GL11.glTranslatef((float)model.barrelBreakPoint.x, (float)model.barrelBreakPoint.y, (float)model.barrelBreakPoint.z);
                    GL11.glRotatef((float)(reloadRotate * -model.breakAngle), (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glTranslatef((float)(-model.barrelBreakPoint.x), (float)(-model.barrelBreakPoint.y), (float)(-model.barrelBreakPoint.z));
                    GL11.glTranslatef((float)(-1.0f * clipPosition), (float)0.0f, (float)0.0f);
                    break;
                }
                case REVOLVER: {
                    GL11.glTranslatef((float)model.revolverFlipPoint.x, (float)model.revolverFlipPoint.y, (float)model.revolverFlipPoint.z);
                    GL11.glRotatef((float)(reloadRotate * model.revolverFlipAngle), (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glTranslatef((float)(-model.revolverFlipPoint.x), (float)(-model.revolverFlipPoint.y), (float)(-model.revolverFlipPoint.z));
                    GL11.glTranslatef((float)(-1.0f * clipPosition), (float)0.0f, (float)0.0f);
                    break;
                }
                case BOTTOM_CLIP: {
                    GL11.glRotatef((float)(-180.0f * clipPosition), (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glRotatef((float)(60.0f * clipPosition), (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glTranslatef((float)(0.5f * clipPosition), (float)0.0f, (float)0.0f);
                    break;
                }
                case PISTOL_CLIP: {
                    GL11.glRotatef((float)(-90.0f * clipPosition * clipPosition), (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glTranslatef((float)0.0f, (float)(-1.0f * clipPosition), (float)0.0f);
                    break;
                }
                case ALT_PISTOL_CLIP: {
                    GL11.glRotatef((float)(5.0f * clipPosition), (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glTranslatef((float)0.0f, (float)(-3.0f * clipPosition), (float)0.0f);
                    break;
                }
                case SIDE_CLIP: {
                    GL11.glRotatef((float)(180.0f * clipPosition), (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)(60.0f * clipPosition), (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glTranslatef((float)(0.5f * clipPosition), (float)0.0f, (float)0.0f);
                    break;
                }
                case BULLPUP: {
                    GL11.glRotatef((float)(-150.0f * clipPosition), (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glRotatef((float)(60.0f * clipPosition), (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glTranslatef((float)(1.0f * clipPosition), (float)(-0.5f * clipPosition), (float)0.0f);
                    break;
                }
                case P90: {
                    GL11.glRotatef((float)(-15.0f * reloadRotate * reloadRotate), (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glTranslatef((float)0.0f, (float)(0.075f * reloadRotate), (float)0.0f);
                    GL11.glTranslatef((float)(-2.0f * clipPosition), (float)(-0.3f * clipPosition), (float)(0.5f * clipPosition));
                    break;
                }
                case RIFLE: {
                    float thing = clipPosition * model.numBulletsInReloadAnimation;
                    int bulletNum = MathHelper.func_76141_d((float)thing);
                    float bulletProgress = thing - (float)bulletNum;
                    GL11.glRotatef((float)(bulletProgress * 15.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)(bulletProgress * 15.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glTranslatef((float)(bulletProgress * -1.0f), (float)0.0f, (float)(bulletProgress * 0.5f));
                    break;
                }
                case RIFLE_TOP: {
                    float thing = clipPosition * model.numBulletsInReloadAnimation;
                    int bulletNum = MathHelper.func_76141_d((float)thing);
                    float bulletProgress = thing - (float)bulletNum;
                    GL11.glRotatef((float)(bulletProgress * 55.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)(bulletProgress * 95.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glTranslatef((float)(bulletProgress * -0.1f), (float)(bulletProgress * 1.0f), (float)(bulletProgress * 0.5f));
                    break;
                }
                case SHOTGUN: 
                case STRIKER: {
                    float thing = clipPosition * model.numBulletsInReloadAnimation;
                    int bulletNum = MathHelper.func_76141_d((float)thing);
                    float bulletProgress = thing - (float)bulletNum;
                    GL11.glRotatef((float)(bulletProgress * -30.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glTranslatef((float)(bulletProgress * -0.5f), (float)(bulletProgress * -1.0f), (float)0.0f);
                    break;
                }
                case CUSTOM: {
                    GL11.glRotatef((float)(model.rotateClipVertical * clipPosition), (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glRotatef((float)(model.rotateClipHorizontal * clipPosition), (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)(model.tiltClip * clipPosition), (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glTranslatef((float)(model.translateClip.x * clipPosition), (float)(model.translateClip.y * clipPosition), (float)(model.translateClip.z * clipPosition));
                    break;
                }
                case END_LOADED: {
                    float dYaw = loadOnlyClipPosition > 0.5f ? loadOnlyClipPosition * 2.0f - 1.0f : 0.0f;
                    GL11.glRotatef((float)(-45.0f * dYaw), (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glTranslatef((float)(-model.endLoadedAmmoDistance * dYaw), (float)(-0.5f * dYaw), (float)0.0f);
                    float xDisplacement = loadOnlyClipPosition < 0.5f ? loadOnlyClipPosition * 2.0f : 1.0f;
                    GL11.glTranslatef((float)(model.endLoadedAmmoDistance * xDisplacement), (float)0.0f, (float)0.0f);
                    break;
                }
                case BACK_LOADED: {
                    float dYaw = loadOnlyClipPosition > 0.5f ? loadOnlyClipPosition * 2.0f - 1.0f : 0.0f;
                    GL11.glTranslatef((float)(model.endLoadedAmmoDistance * dYaw), (float)(-0.5f * dYaw), (float)0.0f);
                    float xDisplacement = loadOnlyClipPosition < 0.5f ? loadOnlyClipPosition * 2.0f : 1.0f;
                    GL11.glTranslatef((float)(-model.endLoadedAmmoDistance * xDisplacement), (float)0.0f, (float)0.0f);
                }
            }
        }
        if (shouldRender) {
            model.renderAmmo(f);
        }
        GL11.glPopMatrix();
        GL11.glPopMatrix();
        if (scopeAttachment != null) {
            GL11.glPushMatrix();
            Paintjob scopepaintjob = scopeAttachment.getPaintjob(scopeItemStack.func_77952_i());
            renderEngine.func_110577_a(FlansModResourceHandler.getPaintjobTexture(scopepaintjob));
            if (model.scopeIsOnBreakAction) {
                GL11.glTranslatef((float)model.barrelBreakPoint.x, (float)model.barrelBreakPoint.y, (float)model.barrelBreakPoint.z);
                GL11.glRotatef((float)(reloadRotate * -model.breakAngle), (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glTranslatef((float)(-model.barrelBreakPoint.x), (float)(-model.barrelBreakPoint.y), (float)(-model.barrelBreakPoint.z));
            }
            GL11.glTranslatef((float)(model.scopeAttachPoint.x * type.modelScale), (float)(model.scopeAttachPoint.y * type.modelScale), (float)(model.scopeAttachPoint.z * type.modelScale));
            if (model.scopeIsOnSlide) {
                GL11.glTranslatef((float)(-(animations.lastGunSlide + (animations.gunSlide - animations.lastGunSlide) * smoothing) * model.gunSlideDistance), (float)0.0f, (float)0.0f);
            }
            GL11.glScalef((float)scopeAttachment.modelScale, (float)scopeAttachment.modelScale, (float)scopeAttachment.modelScale);
            ModelAttachment scopeModel = scopeAttachment.model;
            if (scopeModel != null) {
                scopeModel.renderAttachment(f);
            }
            renderEngine.func_110577_a(FlansModResourceHandler.getTexture(type));
            GL11.glPopMatrix();
        }
        if (gripAttachment != null) {
            GL11.glPushMatrix();
            Paintjob grippaintjob = gripAttachment.getPaintjob(gripItemStack.func_77952_i());
            renderEngine.func_110577_a(FlansModResourceHandler.getPaintjobTexture(grippaintjob));
            GL11.glTranslatef((float)(model.gripAttachPoint.x * type.modelScale), (float)(model.gripAttachPoint.y * type.modelScale), (float)(model.gripAttachPoint.z * type.modelScale));
            if (model.gripIsOnPump) {
                GL11.glTranslatef((float)(-(1.0f - Math.abs(animations.lastPumped + (animations.pumped - animations.lastPumped) * smoothing)) * model.pumpHandleDistance), (float)0.0f, (float)0.0f);
            }
            GL11.glScalef((float)gripAttachment.modelScale, (float)gripAttachment.modelScale, (float)gripAttachment.modelScale);
            ModelAttachment gripModel = gripAttachment.model;
            if (gripModel != null) {
                gripModel.renderAttachment(f);
            }
            renderEngine.func_110577_a(FlansModResourceHandler.getTexture(type));
            GL11.glPopMatrix();
        }
        if (barrelAttachment != null) {
            GL11.glPushMatrix();
            Paintjob barrelpaintjob = barrelAttachment.getPaintjob(barrelItemStack.func_77952_i());
            renderEngine.func_110577_a(FlansModResourceHandler.getPaintjobTexture(barrelpaintjob));
            GL11.glTranslatef((float)(model.barrelAttachPoint.x * type.modelScale), (float)(model.barrelAttachPoint.y * type.modelScale), (float)(model.barrelAttachPoint.z * type.modelScale));
            GL11.glScalef((float)barrelAttachment.modelScale, (float)barrelAttachment.modelScale, (float)barrelAttachment.modelScale);
            ModelAttachment barrelModel = barrelAttachment.model;
            if (barrelModel != null) {
                barrelModel.renderAttachment(f);
            }
            renderEngine.func_110577_a(FlansModResourceHandler.getTexture(type));
            GL11.glPopMatrix();
        }
        if (stockAttachment != null) {
            GL11.glPushMatrix();
            Paintjob stockpaintjob = stockAttachment.getPaintjob(stockItemStack.func_77952_i());
            renderEngine.func_110577_a(FlansModResourceHandler.getPaintjobTexture(stockpaintjob));
            GL11.glTranslatef((float)(model.stockAttachPoint.x * type.modelScale), (float)(model.stockAttachPoint.y * type.modelScale), (float)(model.stockAttachPoint.z * type.modelScale));
            GL11.glScalef((float)stockAttachment.modelScale, (float)stockAttachment.modelScale, (float)stockAttachment.modelScale);
            ModelAttachment stockModel = stockAttachment.model;
            if (stockModel != null) {
                stockModel.renderAttachment(f);
            }
            renderEngine.func_110577_a(FlansModResourceHandler.getTexture(type));
            GL11.glPopMatrix();
        }
    }

    static {
        bindTextures = true;
    }
}

