/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.apocalypse.common;

import com.flansmod.apocalypse.common.FlansModApocalypse;
import com.flansmod.common.TileEntityItemHolder;
import com.flansmod.common.driveables.DriveableType;
import com.flansmod.common.driveables.EnumPlaneMode;
import com.flansmod.common.driveables.PlaneType;
import com.flansmod.common.driveables.VehicleType;
import com.flansmod.common.driveables.mechas.MechaItemType;
import com.flansmod.common.driveables.mechas.MechaType;
import com.flansmod.common.guns.AttachmentType;
import com.flansmod.common.guns.GunType;
import com.flansmod.common.guns.ItemGun;
import com.flansmod.common.guns.Paintjob;
import com.flansmod.common.guns.ShootableType;
import com.flansmod.common.guns.boxes.GunBoxType;
import com.flansmod.common.parts.EnumPartCategory;
import com.flansmod.common.parts.PartType;
import com.flansmod.common.teams.ArmourBoxType;
import com.flansmod.common.teams.ArmourType;
import com.flansmod.common.teams.PlayerClass;
import com.flansmod.common.teams.Team;
import com.flansmod.common.tools.ToolType;
import com.flansmod.common.types.EnumType;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntityBrewingStand;
import net.minecraft.tileentity.TileEntityChest;

public class FlansModLootGenerator {
    private static ArrayList<VehicleType> tanks;
    private static ArrayList<VehicleType> cars;
    private static ArrayList<PlaneType> planes;
    private static ArrayList<PlaneType> helicopters;
    private static ArrayList<MechaType> mechas;
    private static ArrayList<MechaType> dungeonMechas;
    private static ArrayList<PartType> vehicleEngines;
    private static ArrayList<PartType> planeEngines;
    private static ArrayList<PartType> mechaEngines;
    private static ArrayList<GunType> validGuns;
    private static int[] potions;

    public FlansModLootGenerator() {
        tanks = new ArrayList();
        cars = new ArrayList();
        planes = new ArrayList();
        helicopters = new ArrayList();
        mechas = new ArrayList();
        dungeonMechas = new ArrayList();
        for (DriveableType driveableType : DriveableType.types) {
            if (driveableType instanceof VehicleType) {
                if (((VehicleType)driveableType).tank) {
                    tanks.add((VehicleType)driveableType);
                    continue;
                }
                if (driveableType.floatOnWater) continue;
                cars.add((VehicleType)driveableType);
                continue;
            }
            if (driveableType instanceof PlaneType) {
                if (((PlaneType)driveableType).mode == EnumPlaneMode.PLANE) {
                    planes.add((PlaneType)driveableType);
                    continue;
                }
                helicopters.add((PlaneType)driveableType);
                continue;
            }
            if (!(driveableType instanceof MechaType)) continue;
            mechas.add((MechaType)driveableType);
            if (!(((MechaType)driveableType).height <= 3.0f)) continue;
            dungeonMechas.add((MechaType)driveableType);
        }
        vehicleEngines = new ArrayList();
        mechaEngines = new ArrayList();
        planeEngines = new ArrayList();
        for (PartType partType : PartType.partsByCategory.get((Object)EnumPartCategory.ENGINE)) {
            if (partType.isAIChip) continue;
            if (partType.worksWith.contains((Object)EnumType.plane)) {
                planeEngines.add(partType);
            }
            if (partType.worksWith.contains((Object)EnumType.vehicle)) {
                vehicleEngines.add(partType);
            }
            if (!partType.worksWith.contains((Object)EnumType.mecha)) continue;
            mechaEngines.add(partType);
        }
        validGuns = new ArrayList();
        for (GunType gunType : GunType.gunList) {
            if (gunType.dungeonChance == 0) continue;
            validGuns.add(gunType);
        }
    }

    public ItemStack getRandomLoadedGun(Random rand, boolean explosivesAllowed) {
        List<ShootableType> ammoList;
        ItemStack stack = this.getRandomUnloadedGun(rand);
        GunType gunType = ((ItemGun)stack.func_77973_b()).GetType();
        List<ShootableType> list = ammoList = explosivesAllowed ? gunType.ammo : gunType.nonExplosiveAmmo;
        if (ammoList.size() > 0) {
            NBTTagList ammoTagsList = new NBTTagList();
            for (int i = 0; i < gunType.numAmmoItemsInGun; ++i) {
                NBTTagCompound ammoTag = new NBTTagCompound();
                ShootableType ammoType = ammoList.get(rand.nextInt(ammoList.size()));
                ItemStack ammoStack = new ItemStack(ammoType.item);
                ammoStack.func_77964_b(rand.nextInt(ammoType.roundsPerItem));
                ammoStack.func_77955_b(ammoTag);
                ammoTagsList.func_74742_a((NBTBase)ammoTag);
            }
            stack.func_77978_p().func_74782_a("ammo", (NBTBase)ammoTagsList);
        }
        if (gunType.paintjobs.size() > 1) {
            stack.func_77964_b(rand.nextInt(gunType.paintjobs.size()));
        }
        return stack;
    }

    public ItemStack getRandomUnloadedGun(Random rand) {
        GunType gun = validGuns.get(rand.nextInt(validGuns.size()));
        ItemStack stack = new ItemStack(gun.item);
        NBTTagCompound tags = new NBTTagCompound();
        tags.func_74778_a("Paint", ((Paintjob)gun.paintjobs.get((int)rand.nextInt((int)gun.paintjobs.size()))).iconName);
        stack.func_77982_d(tags);
        return stack;
    }

    public void addRandomLoot(TileEntityItemHolder holder, Random rand, boolean gunsOnly) {
        if (gunsOnly || rand.nextInt(3) != 0) {
            holder.setStack(this.getRandomLoadedGun(rand, true));
        } else if (rand.nextBoolean()) {
            holder.setStack(this.getSurvivorJournal(rand));
        } else if (rand.nextBoolean()) {
            holder.setStack(new ItemStack(Items.field_151078_bh, 1 + rand.nextInt(3)));
        }
    }

    public void fillVillageChest(Random rand, TileEntityChest chest) {
        int i;
        int i2;
        int numParts = rand.nextInt(6) + 1;
        int numAmmo = rand.nextInt(6) + 1;
        int numFuel = rand.nextInt(3);
        int numFood = rand.nextInt(3);
        for (i2 = 0; i2 < numParts; ++i2) {
            PartType part = PartType.parts.get(rand.nextInt(PartType.parts.size()));
            chest.func_70299_a(rand.nextInt(chest.func_70302_i_()), new ItemStack(part.item, 1));
        }
        for (i2 = 0; i2 < numAmmo; ++i2) {
            ShootableType type = ShootableType.shootables.get(new ArrayList<Integer>(ShootableType.shootables.keySet()).get(rand.nextInt(ShootableType.shootables.size())));
            if (type == null || type.dungeonChance == 0) continue;
            chest.func_70299_a(rand.nextInt(chest.func_70302_i_()), new ItemStack(type.item, 1 + (type.maxStackSize > 1 && rand.nextBoolean() ? 1 : 0)));
        }
        ArrayList<PartType> fuelItems = PartType.partsByCategory.get((Object)EnumPartCategory.FUEL);
        for (i = 0; i < numFuel; ++i) {
            PartType fuel = fuelItems.get(rand.nextInt(fuelItems.size()));
            chest.func_70299_a(rand.nextInt(chest.func_70302_i_()), new ItemStack(fuel.item, rand.nextInt(Math.min(fuel.stackSize - 1, 2)) + 1));
        }
        block9: for (i = 0; i < numFood; ++i) {
            switch (rand.nextInt(4)) {
                case 0: {
                    chest.func_70299_a(rand.nextInt(chest.func_70302_i_()), new ItemStack(Items.field_151076_bf, rand.nextInt(2) + 1));
                    continue block9;
                }
                case 1: {
                    chest.func_70299_a(rand.nextInt(chest.func_70302_i_()), new ItemStack(Items.field_151147_al, rand.nextInt(2) + 1));
                    continue block9;
                }
                case 2: {
                    chest.func_70299_a(rand.nextInt(chest.func_70302_i_()), new ItemStack(Items.field_151082_bd, rand.nextInt(2) + 1));
                    continue block9;
                }
                case 3: {
                    chest.func_70299_a(rand.nextInt(chest.func_70302_i_()), new ItemStack(Items.field_151168_bH, rand.nextInt(3) + 1));
                }
            }
        }
        if (rand.nextBoolean() && rand.nextBoolean()) {
            chest.func_70299_a(rand.nextInt(chest.func_70302_i_()), new ItemStack(MechaItemType.types.get((int)rand.nextInt((int)MechaItemType.types.size())).item));
        }
        if (rand.nextBoolean()) {
            chest.func_70299_a(rand.nextInt(chest.func_70302_i_()), new ItemStack(ToolType.tools.get((Object)new ArrayList<String>(ToolType.tools.keySet()).get((int)rand.nextInt((int)ToolType.tools.size()))).item));
        }
    }

    public PartType getRandomFuel(Random rand) {
        ArrayList<PartType> fuelItems = PartType.partsByCategory.get((Object)EnumPartCategory.FUEL);
        return fuelItems.get(rand.nextInt(fuelItems.size()));
    }

    public ItemStack loadAndPaintGun(GunType gun, Random rand) {
        ItemStack stack = new ItemStack(gun.item);
        NBTTagCompound tags = new NBTTagCompound();
        tags.func_74778_a("Paint", ((Paintjob)gun.paintjobs.get((int)rand.nextInt((int)gun.paintjobs.size()))).iconName);
        if (gun.ammo.size() > 0) {
            NBTTagList ammoTagsList = new NBTTagList();
            for (int i = 0; i < gun.numAmmoItemsInGun; ++i) {
                NBTTagCompound ammoTag = new NBTTagCompound();
                ShootableType ammoType = gun.ammo.get(rand.nextInt(gun.ammo.size()));
                ItemStack ammoStack = new ItemStack(ammoType.item);
                ammoStack.func_77964_b(rand.nextInt(ammoType.roundsPerItem));
                ammoStack.func_77955_b(ammoTag);
                ammoTagsList.func_74742_a((NBTBase)ammoTag);
            }
            tags.func_74782_a("ammo", (NBTBase)ammoTagsList);
        }
        stack.func_77982_d(tags);
        return stack;
    }

    public void dressMeUp(EntityLivingBase entity, Random rand) {
        if (rand.nextBoolean() && ArmourType.armours.size() > 0) {
            ArmourType armour = ArmourType.armours.get(rand.nextInt(ArmourType.armours.size()));
            if (armour != null && armour.type != 2) {
                entity.func_184201_a(EntityEquipmentSlot.values()[armour.type + 2], new ItemStack(armour.item));
            }
        } else if (Team.teams.size() > 0) {
            Team team = Team.teams.get(rand.nextInt(Team.teams.size()));
            if (team.hat != null) {
                entity.func_184201_a(EntityEquipmentSlot.HEAD, team.hat.func_77946_l());
            }
            if (team.chest != null) {
                entity.func_184201_a(EntityEquipmentSlot.CHEST, team.chest.func_77946_l());
            }
            if (team.legs != null) {
                entity.func_184201_a(EntityEquipmentSlot.LEGS, team.legs.func_77946_l());
            }
            if (team.shoes != null) {
                entity.func_184201_a(EntityEquipmentSlot.FEET, team.shoes.func_77946_l());
            }
            if (team.classes.size() > 0) {
                PlayerClass playerClass = team.classes.get(rand.nextInt(team.classes.size()));
                if (playerClass.hat != null) {
                    entity.func_184201_a(EntityEquipmentSlot.HEAD, playerClass.hat.func_77946_l());
                }
                if (playerClass.chest != null) {
                    entity.func_184201_a(EntityEquipmentSlot.CHEST, playerClass.chest.func_77946_l());
                }
                if (playerClass.legs != null) {
                    entity.func_184201_a(EntityEquipmentSlot.LEGS, playerClass.legs.func_77946_l());
                }
                if (playerClass.shoes != null) {
                    entity.func_184201_a(EntityEquipmentSlot.FEET, playerClass.shoes.func_77946_l());
                }
            }
        }
    }

    public Block getRandomWeaponBox(Random rand) {
        if (rand.nextInt(4) == 0) {
            return ArmourBoxType.boxes.get((Object)new ArrayList<String>(ArmourBoxType.boxes.keySet()).get((int)rand.nextInt((int)ArmourBoxType.boxes.size()))).block;
        }
        return GunBoxType.gunBoxMap.get((Object)new ArrayList<String>(GunBoxType.gunBoxMap.keySet()).get((int)rand.nextInt((int)GunBoxType.gunBoxMap.size()))).block;
    }

    public DriveableType getRandomDriveable(Random rand) {
        switch (rand.nextInt(5)) {
            case 0: {
                if (cars.size() > 0) {
                    return cars.get(rand.nextInt(cars.size()));
                }
            }
            case 1: {
                if (tanks.size() > 0) {
                    return tanks.get(rand.nextInt(tanks.size()));
                }
            }
            case 2: {
                if (planes.size() > 0) {
                    return planes.get(rand.nextInt(planes.size()));
                }
            }
            case 3: {
                if (helicopters.size() > 0) {
                    return helicopters.get(rand.nextInt(helicopters.size()));
                }
            }
            case 4: {
                if (mechas.size() <= 0) break;
                return mechas.get(rand.nextInt(mechas.size()));
            }
        }
        return null;
    }

    public PartType getRandomEngine(DriveableType type, Random rand) {
        switch (EnumType.getFromObject(type)) {
            case vehicle: {
                return vehicleEngines.size() > 0 ? vehicleEngines.get(rand.nextInt(vehicleEngines.size())) : null;
            }
            case plane: {
                return planeEngines.size() > 0 ? planeEngines.get(rand.nextInt(planeEngines.size())) : null;
            }
            case mecha: {
                return mechaEngines.size() > 0 ? mechaEngines.get(rand.nextInt(mechaEngines.size())) : null;
            }
        }
        return null;
    }

    public PlaneType getRandomPlane(Random rand) {
        if (planes.size() > 0) {
            return planes.get(rand.nextInt(planes.size()));
        }
        return null;
    }

    public void fillBrewingStand(Random rand, TileEntityBrewingStand tileentity) {
        for (int i = 0; i < 3; ++i) {
            if (!rand.nextBoolean()) continue;
            tileentity.func_70299_a(i, new ItemStack((Item)Items.field_151068_bn, 1, potions[rand.nextInt(9)]));
        }
    }

    public void fillLiquidLabChest(Random rand, TileEntityChest chest) {
        int numItems = 3 + rand.nextInt(4);
        block12: for (int i = 0; i < numItems; ++i) {
            switch (rand.nextInt(10)) {
                case 0: {
                    chest.func_70299_a(rand.nextInt(chest.func_70302_i_()), new ItemStack(Items.field_151054_z, rand.nextInt(5) + 1));
                    continue block12;
                }
                case 1: {
                    chest.func_70299_a(rand.nextInt(chest.func_70302_i_()), new ItemStack(Items.field_151131_as));
                    continue block12;
                }
                case 2: {
                    chest.func_70299_a(rand.nextInt(chest.func_70302_i_()), new ItemStack(Items.field_151133_ar, rand.nextInt(2) + 1));
                    continue block12;
                }
                case 3: {
                    chest.func_70299_a(rand.nextInt(chest.func_70302_i_()), new ItemStack((Item)Items.field_151068_bn));
                    continue block12;
                }
                case 4: {
                    chest.func_70299_a(rand.nextInt(chest.func_70302_i_()), new ItemStack((Item)Items.field_151068_bn));
                    continue block12;
                }
                case 5: {
                    chest.func_70299_a(rand.nextInt(chest.func_70302_i_()), new ItemStack((Item)Items.field_151068_bn));
                    continue block12;
                }
                case 6: {
                    chest.func_70299_a(rand.nextInt(chest.func_70302_i_()), new ItemStack((Item)Items.field_151068_bn, 1, potions[rand.nextInt(9)]));
                    continue block12;
                }
                case 7: {
                    chest.func_70299_a(rand.nextInt(chest.func_70302_i_()), new ItemStack(FlansModApocalypse.sulphur, rand.nextInt(12) + 1));
                    continue block12;
                }
                case 8: {
                    chest.func_70299_a(rand.nextInt(chest.func_70302_i_()), this.getScientistJournal(rand));
                    continue block12;
                }
                case 9: {
                    chest.func_70299_a(rand.nextInt(chest.func_70302_i_()), this.getScientistJournal(rand));
                }
            }
        }
    }

    public void fillWeaponChest(Random rand, TileEntityChest chest) {
        ItemStack stack;
        int i;
        for (i = 0; i < 3 + rand.nextInt(3); ++i) {
            stack = this.getRandomAmmo(rand);
            if (stack == null) continue;
            chest.func_70299_a(rand.nextInt(chest.func_70302_i_()), stack);
        }
        for (i = 0; i < 1 + rand.nextInt(1); ++i) {
            stack = this.getRandomAttachment(rand);
            if (stack == null) continue;
            chest.func_70299_a(rand.nextInt(chest.func_70302_i_()), stack);
        }
    }

    private ItemStack getRandomAmmo(Random rand) {
        GunType randomGun = validGuns.get(rand.nextInt(validGuns.size()));
        if (randomGun.ammo.size() <= 0) {
            return null;
        }
        ShootableType randomBullet = randomGun.ammo.get(rand.nextInt(randomGun.ammo.size()));
        return new ItemStack(randomBullet.item);
    }

    private ItemStack getRandomAttachment(Random rand) {
        AttachmentType type = AttachmentType.attachments.get(rand.nextInt(AttachmentType.attachments.size()));
        return new ItemStack(type.item);
    }

    public MechaType getRandomDungeonMecha(Random rand) {
        if (dungeonMechas.size() > 0) {
            return dungeonMechas.get(rand.nextInt(dungeonMechas.size()));
        }
        return null;
    }

    public void fillDyeFactoryChest(TileEntityChest chest, Random rand) {
        int i;
        int numDyes = rand.nextInt(4);
        int numMisc = rand.nextInt(2);
        for (i = 0; i < numDyes; ++i) {
            chest.func_70299_a(rand.nextInt(chest.func_70302_i_()), new ItemStack(Items.field_151100_aR, rand.nextInt(8) + 1, rand.nextInt(16)));
        }
        block7: for (i = 0; i < numMisc; ++i) {
            switch (rand.nextInt(4)) {
                case 0: {
                    chest.func_70299_a(rand.nextInt(chest.func_70302_i_()), new ItemStack(Items.field_151007_F, rand.nextInt(5) + 1));
                    continue block7;
                }
                case 1: {
                    chest.func_70299_a(rand.nextInt(chest.func_70302_i_()), new ItemStack(Items.field_151008_G, rand.nextInt(5) + 1));
                    continue block7;
                }
                case 2: {
                    chest.func_70299_a(rand.nextInt(chest.func_70302_i_()), new ItemStack(Items.field_151116_aA, rand.nextInt(8) + 1));
                    continue block7;
                }
                case 3: {
                    chest.func_70299_a(rand.nextInt(chest.func_70302_i_()), new ItemStack(Items.field_151119_aD, rand.nextInt(32) + 1));
                }
            }
        }
    }

    public ItemStack getScientistJournal(Random rand) {
        ItemStack stack = new ItemStack(Items.field_151164_bB);
        stack.func_77983_a("author", (NBTBase)new NBTTagString("Dr. Brazier"));
        NBTTagList pages = new NBTTagList();
        switch (rand.nextInt(8)) {
            case 0: {
                stack.func_77983_a("title", (NBTBase)new NBTTagString("Research Journal: Entry 1"));
                pages.func_74742_a((NBTBase)new NBTTagString("We are trying to find ways to disable the AI mechas. Unfortunately, this involves bringing specimens into our lab for testing. I protested to management, but they wouldn't listen, as ever. This will be the death of us, I know it."));
                break;
            }
            case 1: {
                stack.func_77983_a("title", (NBTBase)new NBTTagString("Research Journal: Entry 2"));
                pages.func_74742_a((NBTBase)new NBTTagString("The Mechas are almost... evolving... We try something new (today it was EMPs), boot them back up for another test and they've become resistant. Just like that. And I fear that the mechas we have here may be contacting others on the outside."));
                break;
            }
            case 2: {
                stack.func_77983_a("title", (NBTBase)new NBTTagString("Research Journal: Entry 3"));
                pages.func_74742_a((NBTBase)new NBTTagString("I lose hope with every passing day. There is no clever way to destroy these Mechas or shut them down. Their programming forms a vast, global, interconnected web. You shut down one and already every other Mecha knows what you did and how to become immune to it"));
                break;
            }
            case 3: {
                stack.func_77983_a("title", (NBTBase)new NBTTagString("Research Journal: Entry 4"));
                pages.func_74742_a((NBTBase)new NBTTagString("Finally, we are looking into other approaches, though I must say, I am quite surprised. Management must have gone a bit mad, they've got us looking for a way to travel back in time... back in time! To destroy the first AI Mecha! How absurd!"));
                break;
            }
            case 4: {
                stack.func_77983_a("title", (NBTBase)new NBTTagString("Research Journal: Entry 5"));
                pages.func_74742_a((NBTBase)new NBTTagString("The time travel research is slow, but having heard some of the ideas from the others, I think we may actually have a shot. Not that this helps, though. I've been trying to explain stable time loops to management, but they either don't understand, or are just too desperate."));
                break;
            }
            case 5: {
                stack.func_77983_a("title", (NBTBase)new NBTTagString("Research Journal: Entry 6"));
                pages.func_74742_a((NBTBase)new NBTTagString("We actually did it! I cannot believe it, but we sent someone back in time! Admittedly, they ended up walking with Creepersauruses, but nonetheless, we did it!"));
                break;
            }
            case 6: {
                stack.func_77983_a("title", (NBTBase)new NBTTagString("Research Journal: Entry 7"));
                pages.func_74742_a((NBTBase)new NBTTagString("They're here! The mechas are here! If you read this, please, go back in time, destroy the creator, stop th..."));
                break;
            }
            case 7: {
                stack.func_77983_a("title", (NBTBase)new NBTTagString("Time Portal: Instruction Manual"));
                pages.func_74742_a((NBTBase)new NBTTagString("The Time Portal uses the portal properties of obsidian combined with our state-of-the-art power cubes. Place one in each corner of the obsidian grid to activate the portal."));
            }
        }
        stack.func_77983_a("pages", (NBTBase)pages);
        return stack;
    }

    public ItemStack getSurvivorJournal(Random rand) {
        ItemStack stack = new ItemStack(Items.field_151164_bB);
        switch (rand.nextInt(1)) {
            case 0: {
                stack.func_77983_a("author", (NBTBase)new NBTTagString("Flan"));
            }
        }
        NBTTagList pages = new NBTTagList();
        switch (rand.nextInt(8)) {
            case 0: {
                stack.func_77983_a("title", (NBTBase)new NBTTagString("Help me!"));
                pages.func_74742_a((NBTBase)new NBTTagString("I have no food. My child has no food. We are going to die. Why did this have to happen?"));
                break;
            }
            case 1: {
                stack.func_77983_a("title", (NBTBase)new NBTTagString("The Endtimes"));
                pages.func_74742_a((NBTBase)new NBTTagString("It's amazing how fast your world can be torn down around you. Just three days ago, I was happily trading emeralds at the village market. Now all that is gone. I am left to wander this wasteland alone. I don't know how long I'll last, or how long I'll stay sane..."));
                break;
            }
            case 2: {
                stack.func_77983_a("title", (NBTBase)new NBTTagString("Day 5"));
                pages.func_74742_a((NBTBase)new NBTTagString("We found water today! At the bottom of a village well. We drank and bathed and filled our bottles and left. But for reference, the village was at- *bloodstains*"));
                break;
            }
            case 3: {
                stack.func_77983_a("title", (NBTBase)new NBTTagString("Day 7"));
                pages.func_74742_a((NBTBase)new NBTTagString("They got my brother! Just after we left the village, he was snatched by some sort of... robot... Also, I think the water may have been contaminated. I've been sweating an awful lot, and it's not just the heat."));
                break;
            }
            case 4: {
                stack.func_77983_a("title", (NBTBase)new NBTTagString("Day 10"));
                pages.func_74742_a((NBTBase)new NBTTagString("I have been violently ill, but have not found a new water source yet. I may have to drink more contaminated water to stay alive. I couldn't get worse, could I?"));
                break;
            }
            case 5: {
                stack.func_77983_a("title", (NBTBase)new NBTTagString("The Wasteland"));
                pages.func_74742_a((NBTBase)new NBTTagString("This world is harsh and unforgiving. I've had to make difficult choices, but they are necessary in order to survive. If I hadn't pulled the trigger, they would have done so instead. I'm sure of it."));
                break;
            }
            case 6: {
                stack.func_77983_a("title", (NBTBase)new NBTTagString(""));
                pages.func_74742_a((NBTBase)new NBTTagString("We spotted an airstrip in the distance! We're going to head over there under cover of darkness and see if we can acquire ourselves a plane. Let's get out of this terrible place."));
                break;
            }
            case 7: {
                stack.func_77983_a("title", (NBTBase)new NBTTagString("Time Portal: Instruction Manual"));
                stack.func_77983_a("generation", (NBTBase)new NBTTagInt(3));
                pages.func_74742_a((NBTBase)new NBTTagString("The Time Portal uses the portal properties of obsidian combined with-"));
                pages.func_74742_a((NBTBase)new NBTTagString("Beware! The mechas are coming! The time portal is of great importance! You must-"));
            }
        }
        stack.func_77983_a("pages", (NBTBase)pages);
        return stack;
    }

    static {
        potions = new int[]{8193, 8194, 8195, 8197, 8198, 8201, 8203, 8205, 8206};
    }
}

