/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.apocalypse.client;

import com.flansmod.apocalypse.client.model.RenderFakePlayer;
import com.flansmod.apocalypse.client.model.RenderNukeDrop;
import com.flansmod.apocalypse.client.model.RenderPowerCube;
import com.flansmod.apocalypse.client.model.RenderSurvivor;
import com.flansmod.apocalypse.client.model.RenderTeleporter;
import com.flansmod.apocalypse.common.CommonProxyApocalypse;
import com.flansmod.apocalypse.common.FlansModApocalypse;
import com.flansmod.apocalypse.common.blocks.BlockSulphuricAcid;
import com.flansmod.apocalypse.common.blocks.TileEntityPowerCube;
import com.flansmod.apocalypse.common.entity.EntityAIMecha;
import com.flansmod.apocalypse.common.entity.EntityFakePlayer;
import com.flansmod.apocalypse.common.entity.EntityNukeDrop;
import com.flansmod.apocalypse.common.entity.EntitySurvivor;
import com.flansmod.apocalypse.common.entity.EntityTeleporter;
import com.flansmod.client.FlansModClient;
import com.flansmod.client.model.RenderMecha;
import com.flansmod.client.util.WorldRenderer;
import com.flansmod.common.FlansMod;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.lwjgl.opengl.GL11;

public class ClientProxyApocalypse
extends CommonProxyApocalypse {
    private static final String FLUID_MODEL_PATH = "flansmodapocalypse:fluid";
    public static int apocalypseCountdown = 0;

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        MinecraftForge.EVENT_BUS.register((Object)this);
        ((BlockSulphuricAcid)FlansModApocalypse.blockSulphuricAcid).registerRenderer();
    }

    @Override
    public void init(FMLInitializationEvent event) {
        super.init(event);
        this.registerVanillaItemModel(FlansModApocalypse.sulphur, Item.func_150898_a((Block)FlansModApocalypse.blockSulphur), Item.func_150898_a((Block)FlansModApocalypse.blockSulphuricAcid), Item.func_150898_a((Block)FlansModApocalypse.blockLabStone), Item.func_150898_a((Block)FlansModApocalypse.blockPowerCube));
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityPowerCube.class, (TileEntitySpecialRenderer)new RenderPowerCube());
        RenderingRegistry.registerEntityRenderingHandler(EntitySurvivor.class, (Render)new RenderSurvivor(Minecraft.func_71410_x().func_175598_ae(), new ModelBiped(), 0.0f));
        RenderingRegistry.registerEntityRenderingHandler(EntityFakePlayer.class, (Render)new RenderFakePlayer(Minecraft.func_71410_x().func_175598_ae(), new ModelBiped(), 0.0f));
        RenderingRegistry.registerEntityRenderingHandler(EntityTeleporter.class, (Render)new RenderTeleporter(Minecraft.func_71410_x().func_175598_ae()));
        RenderingRegistry.registerEntityRenderingHandler(EntityAIMecha.class, (Render)new RenderMecha(Minecraft.func_71410_x().func_175598_ae()));
        RenderingRegistry.registerEntityRenderingHandler(EntityNukeDrop.class, (Render)new RenderNukeDrop(Minecraft.func_71410_x().func_175598_ae()));
    }

    private void registerVanillaItemModel(Item ... items) {
        for (Item item : items) {
            Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a(item, 0, new ModelResourceLocation("flansmodapocalypse:" + item.func_77658_a().split("\\.")[1], "inventory"));
        }
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
    }

    public static void updateApocalypseCountdownTimer(int i) {
        apocalypseCountdown = i;
    }

    @SubscribeEvent
    public void registerModels(ModelRegistryEvent event) {
        ModelLoader.setCustomModelResourceLocation((Item)FlansModApocalypse.itemBlockLabStone, (int)0, (ModelResourceLocation)new ModelResourceLocation("flansmodapocalypse:itemblocklabstone", "inventory"));
        ModelLoader.registerItemVariants((Item)FlansModApocalypse.itemBlockLabStone, (ResourceLocation[])new ResourceLocation[]{new ResourceLocation("flansmodapocalypse:itemblocklabstone")});
    }

    @SubscribeEvent
    public void tick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START && apocalypseCountdown > 0) {
            --apocalypseCountdown;
        }
    }

    @SubscribeEvent
    public void tick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            // empty if block
        }
    }

    @SubscribeEvent
    public void eventHandler(RenderGameOverlayEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (apocalypseCountdown > 0 && FlansMod.DEBUG) {
            mc.field_71466_p.func_78276_b("Seconds to the apocalypse: " + apocalypseCountdown / 20, 2, 2, 0xFFFFFF);
        }
        ScaledResolution scaledresolution = new ScaledResolution(FlansModClient.minecraft);
        int i = scaledresolution.func_78326_a();
        int j = scaledresolution.func_78328_b();
        Tessellator tessellator = Tessellator.func_178181_a();
        if (!event.isCancelable() && event.getType() == RenderGameOverlayEvent.ElementType.HELMET) {
            boolean playerIsInExplosion = false;
            for (Object obj : mc.field_71441_e.field_72996_f) {
                if (!(obj instanceof EntityNukeDrop)) continue;
                EntityNukeDrop nuke = (EntityNukeDrop)((Object)obj);
                float scale = 1.0f - 1.0f / ((float)nuke.timeSinceExplosion / 5.0f + 1.0f);
                scale *= 100.0f * scale;
                float alpha = (float)nuke.timeSinceExplosion / 500.0f;
                alpha = 1.0f - alpha * alpha;
                alpha *= 0.5f;
                if (!(mc.field_71439_g.func_70068_e((Entity)nuke) < (double)(scale * scale))) continue;
                FlansModClient.minecraft.field_71460_t.func_78478_c();
                GL11.glEnable((int)3042);
                GL11.glDisable((int)2929);
                GL11.glDisable((int)3553);
                GL11.glDepthMask((boolean)false);
                GL11.glBlendFunc((int)770, (int)771);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                GL11.glDisable((int)3008);
                WorldRenderer worldrenderer = FlansModClient.getWorldRenderer();
                worldrenderer.startDrawingQuads();
                worldrenderer.addVertexWithUV(i / 2 - 2 * j, j, -90.0, 0.0, 1.0);
                worldrenderer.addVertexWithUV(i / 2 + 2 * j, j, -90.0, 1.0, 1.0);
                worldrenderer.addVertexWithUV(i / 2 + 2 * j, 0.0, -90.0, 1.0, 0.0);
                worldrenderer.addVertexWithUV(i / 2 - 2 * j, 0.0, -90.0, 0.0, 0.0);
                worldrenderer.draw();
                GL11.glDepthMask((boolean)true);
                GL11.glEnable((int)2929);
                GL11.glEnable((int)3008);
                GL11.glEnable((int)3553);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
    }
}

